<?php

include_once includes('config.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Perform input validation and ensure the user is authorized to save a card
// Get form data
    $amount = $_POST['amount'];
    $cardNumber = $_POST['cardNumber'];
    $expirationMonth = $_POST['expirationMonth'];
    $expirationYear = $_POST['expirationYear'];
    $cvv = $_POST['cvv'];
    $TransactionType = $_POST['TransactionType'];
    $cardHolderName = $_POST['cardHolder'];
    $installmentCount = $_POST['installmentCount'];
    if ($cardNumber) {
        // Format the expiration date to "YYMM" format
        $exp_date = substr($expirationYear, -2) . $expirationMonth;
        error_log($amount.$cardNumber.$expirationMonth.$expirationYear.$cvv.$cardHolderName.$installmentCount.$exp_date);

        // Store the retrieved card data in the array
        $cardData = [
            'card_number' => $cardNumber,
            'cvv' => $cvv,
            'expiration_date' => $exp_date, // Updated expiration date
            'cardholder_name' => $cardHolderName,
        ];
        // Calculate the total amount
        $totalAmount = $amount;
        // Create a row for the invoice with the order numbers

        // Process the payment using the card data and send details to the payment gateway
        $paymentResult = processPaymentRequest($cardData, $installmentCount, $TransactionType, $totalAmount, $conn, $lang);

        // Return the payment result
// Assuming $paymentResult is an array with keys 'success', 'message', and 'icon'
        $response = [
            'success' => isset($paymentResult['success']) ? $paymentResult['success'] : false,
            'message' => isset($paymentResult['message']) ? $paymentResult['message'] : 'An error occurred',
            'icon' => isset($paymentResult['icon']) ? $paymentResult['icon'] : 'error',
            'iframe' => isset($paymentResult['iframe']) ? $paymentResult['iframe'] : '',
        ];

    } else {
        $response = [
            'success' => false,
            'message' => $lang['check-out-card-not-found'],
            'icon' => 'error',
        ];
    }

    echo json_encode($response);
}

function getCardBrandCode($cardNumber)
{
    // Define card number prefixes and their corresponding brand codes
    $cardBrandCodes = array(
        '4' => '100', // VISA
        '5' => '200', // MasterCard
        '34' => '400', // American Express
        '37' => '400', // American Express
        '51' => '200', // MasterCard
        '52' => '200', // MasterCard
        '53' => '200', // MasterCard
        '54' => '200', // MasterCard
        '55' => '200', // MasterCard
        '9792' => '300', // Troy
    );

    // Extract the prefix from the card number
    $prefix = substr($cardNumber, 0, 2);

    // Check if the prefix is in the mapping array
    if (isset($cardBrandCodes[$prefix])) {
        return $cardBrandCodes[$prefix];
    }

    // Default to a generic brand code if not found
    return '000'; // Unknown
}

function processPaymentRequest($cardData, $installmentCount, $TransactionType, $totalAmount, $conn, $lang) {
    $url = 'https://3dsecure.vakifbank.com.tr:4443/MPIAPI/MPI_Enrollment.aspx';
    $Pan = $cardData['card_number'];
    $ExpiryDate = $cardData['expiration_date'];
    $cccvv = $cardData['cvv'];
    $PurchaseAmount = $totalAmount;
    $Currency = '949';

    $BrandName = getCardBrandCode(substr($Pan, 0, 2)); // Get the card brand code
    $VerifyEnrollmentRequestId = date('YmdHis');
    $SessionInfo = $Pan . '--' . $cccvv . '--' . $PurchaseAmount; // Optional
    $MerchantId = "000000005720628";
    $TerminalId = "VP744648";
    $MerchantPassword = "q0D7Taf4";
    $SuccessUrl = "https://datanito.com/linkpay-callback";
    $FailureUrl = "https://datanito.com/linkpay-callback";
    $InstallmentCount = $installmentCount;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/x-www-form-urlencoded"));
    curl_setopt($ch, CURLOPT_POSTFIELDS, "Pan=" . $Pan . "&ExpiryDate=" . $ExpiryDate . "&cccvv=" . $cccvv . "&PurchaseAmount=" . $PurchaseAmount . "&Currency=" . $Currency . "&BrandName=" . $BrandName . "&VerifyEnrollmentRequestId=" . $VerifyEnrollmentRequestId . "&SessionInfo=" . $SessionInfo . "&MerchantId=" . $MerchantId . "&TerminalId=" . $TerminalId . "&MerchantPassword=" . $MerchantPassword . "&SuccessUrl=" . $SuccessUrl . "&FailureUrl=" . $FailureUrl . "&InstallmentCount=" . $InstallmentCount . "&TransactionType=" . $TransactionType );
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    $result = curl_exec($ch);
    curl_close($ch);

    $response = SonucuOku($result);

    if ($response["Status"] == "Y") {
        // Return the success response with the ACSUrl for the iframe
        return [
            'success' => true,
            'message' => $lang['modal-pay-success-connect'],
            'icon' => 'success',
            'iframe' => '
                <div id="loading">Loading...</div>
                <iframe id="iframe" name="iframe" style="width: 100%; height: 400px; border: none;"></iframe>
                <form id="form" method="post" target="iframe" action="' . $response["ACSUrl"] . '">
                    <input type="hidden" name="PaReq" value="' . $response["PaReq"] . '">
                    <input type="hidden" name="TermUrl" value="' . $response["TermUrl"] . '">
                    <input type="hidden" name="MD" value="' . $response["MerchantData"] . '">
                    <input type="button" id="submitBtn" value="'.$lang['modal-pay-3d-secure-cta'].'">
                </form>
                <script>
                    document.getElementById("submitBtn").addEventListener("click", function() {
                        document.getElementById("submitBtn").style.display = "none";
                        document.getElementById("loading").style.display = "none";
                    });
                    setTimeout(function(){
                        document.getElementById("submitBtn").style.display = "none";
                        document.getElementById("loading").style.display = "none";
                        document.getElementById("form").submit();
                    }, 1000);
                </script>
            ',
        ];
    } else {
        // Return the failure response
        return [
            'success' => false,
            'message' => $lang['modal-pay-fail-connect'],
            'icon' => 'error',
            'iframe' => '',
        ];
    }
}

function SonucuOku($result)
{
    $resultDocument = new DOMDocument();
    $resultDocument->loadXML($result);
    //Status Bilgisi okunuyor
    $statusNode = $resultDocument->getElementsByTagName("Status")->item(0);
    $status = "";
    if ($statusNode != null) {
        $status = $statusNode->nodeValue;
    }
    //PAReq Bilgisi okunuyor
    $PAReqNode = $resultDocument->getElementsByTagName("PaReq")->item(0);
    $PaReq = "";
    if ($PAReqNode != null) {
        $PaReq = $PAReqNode->nodeValue;
    }
    //ACSUrl Bilgisi okunuyor
    $ACSUrlNode = $resultDocument->getElementsByTagName("ACSUrl")->item(0);
    $ACSUrl = "";
    if ($ACSUrlNode != null) {
        $ACSUrl = $ACSUrlNode->nodeValue;
    }
    //Term Url Bilgisi okunuyor
    $TermUrlNode = $resultDocument->getElementsByTagName("TermUrl")->item(0);
    $TermUrl = "";
    if ($TermUrlNode != null) {
        $TermUrl = $TermUrlNode->nodeValue;
    }
    //MD Bilgisi okunuyor
    $MDNode = $resultDocument->getElementsByTagName("MD")->item(0);
    $MD = "";
    if ($MDNode != null) {
        $MD = $MDNode->nodeValue;
    }
    //MessageErrorCode Bilgisi okunuyor
    $messageErrorCodeNode = $resultDocument->getElementsByTagName("MessageErrorCode")->item(0);
    $messageErrorCode = "";
    if ($messageErrorCodeNode != null) {
        $messageErrorCode = $messageErrorCodeNode->nodeValue;
    }
    // Sonu dizisi oluturuluyor
    $result = array("Status" => $status, "PaReq" => $PaReq, "ACSUrl" => $ACSUrl, "TermUrl" => $TermUrl, "MerchantData" => $MD, "MessageErrorCode" => $messageErrorCode);
    return $result;
}

