<?php
include_once includes('config.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Perform input validation and ensure the user is authorized to save a card
    // Get user ID from a secure source, e.g., a validated session
    $user_id = $_SESSION['user']['id'];
    $CardNumber = $_POST['cardNumber'];
    $productsData = $_POST['products'];
    $getCurrency = isset($_SESSION['currency']) ? strtolower($_SESSION['currency']) : 'usd'; // Ensure currency code is in lowercase
    $taxPercent = 20; // 20% tax rate
    // Define an array to store card data
    $cardData = [];

    // Prepare and execute the SQL statement to retrieve card data
    $sql = "SELECT card_number, cvv, expiration_date, cardholder_name FROM credit_cards WHERE user_id = ? AND card_number = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("is", $user_id, $CardNumber);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();

        // Explode the date into month and year
        list($month, $year) = explode('/', $row['expiration_date']);

        // Format the expiration date to "YYMM" format
        $exp_date = substr($year, -2) . $month;

        // Store the retrieved card data in the array
        $cardData = [
            'card_number' => $row['card_number'],
            'cvv' => $row['cvv'],
            'expiration_date' => $exp_date, // Updated expiration date
            'cardholder_name' => $row['cardholder_name'],
        ];

        // Create separate rows for each product ordered
        $orderNumbers = [];
        foreach ($productsData as $product) {
            $orderNumber = createOrder($user_id, $product, $conn, $getCurrency);
            $orderNumbers[] = $orderNumber;
        }

        // Calculate the total amount
        $totalAmount = calculateTotalAmount($orderNumbers, $conn);

        // Create a row for the invoice with the order numbers
        $invoiceNumber = createInvoice($user_id, $orderNumbers, $totalAmount, $conn, $getCurrency, $taxPercent);

        // Process the payment using the card data and send details to the payment gateway
        $paymentResult = processPaymentRequest($cardData, $invoiceNumber, $totalAmount, $getCurrency, $conn, $lang);

        // Return the payment result
        $response = [
            'success' => isset($paymentResult['success']) ? $paymentResult['success'] : false,
            'message' => isset($paymentResult['message']) ? $paymentResult['message'] : 'An error occurred',
            'icon' => isset($paymentResult['icon']) ? $paymentResult['icon'] : 'error',
            'iframe' => isset($paymentResult['iframe']) ? $paymentResult['iframe'] : '',
        ];
    } else {
        $response = [
            'success' => false,
            'message' => 'Card not found' . $stmt->error,
            'icon' => 'error',
        ];
    }

    echo json_encode($response);
    $stmt->close();
    $conn->close();
}

function createOrder($user_id, $productData, $conn, $getCurrency) {
    $orderNumber = generateOrderNumber();
    $orderStatus = 'Pending';
    $orderTimestamp = date('Y-m-d H:i:s');
    $renewal_date = NULL;
    $duration = $productData['duration'] ?? 1;

    // Extract the product data
    $product_id = $productData['product_id'];
    $price = 0; // Default price value
    $quantity = $productData['quantity'] ?? 1; // Ensure quantity is always set

    if ($product_id == 16) {
        $domain = $productData['domain'];
        $tld = $productData['tld'];

        // Calculate yearly price with discounts if duration is 12
        if ($duration == 12) {
            $yearlyPriceOriginal = floatval(str_replace(',', '', $productData['price'] ?? 0)) * 12 * 0.9; // Normal price x12 - 10% discount
            $yearlyPriceOffer = floatval(str_replace(',', '', $productData['offerprice'] ?? $productData['price'] ?? 0)) * 12 * 0.6; // Offer price x12 - 40% discount

            $price = $productData['offerprice']
                ? number_format($yearlyPriceOffer, 2, '.', '')
                : number_format($yearlyPriceOriginal, 2, '.', '');
        } else {
            $price = floatval(str_replace(',', '', $productData['offerprice'] ?? $productData['price'] ?? 0)); // Ensure numeric
        }

        $currency = $getCurrency;
    } else {
        // Retrieve the product information from the database
        $productInfo = getProductInfo($conn, $product_id, $getCurrency);

        $domain = $productData['domain'] ?? '';
        $tld = $productData['tld'] ?? '';

        if ($productInfo) {
            if ($duration == 12) {
                $yearlyPriceOriginal = floatval($productInfo['price'] ?? 0) * 12 * 0.9; // Normal price x12 - 10% discount
                $yearlyPriceOffer = floatval($productInfo['offerprice'] ?? $productInfo['price'] ?? 0) * 12 * 0.6; // Offer price x12 - 40% discount

                $price = $productInfo['offerprice']
                    ? number_format($yearlyPriceOffer, 2, '.', '')
                    : number_format($yearlyPriceOriginal, 2, '.', '');
            } else {
                $price = floatval($productInfo['offerprice'] ?? $productInfo['price'] ?? 0); // Ensure numeric
            }

            $currency = $getCurrency;
        } else {
            return null; // Return null if product info is not found
        }
    }

    // Sanitize price and calculate total amount
    $price = floatval(str_replace(',', '', $price)); // Ensure numeric value
    $totalAmount = $price * intval($quantity); // Ensure quantity is an integer

    // Debug values for troubleshooting
    error_log("Price after calculation: $price");
    error_log("Quantity: $quantity");
    error_log("Total amount: $totalAmount");

    // Convert domain name and TLD to JSON format
    $name = array(
        'domain' => $domain,
        'tld' => $tld
    );
    $nameJsonString = json_encode($name);

    // Insert order data into the database
    $sql = "INSERT INTO orders (order_number, name, user_id, product_id, quantity, total_amount, currency, status, order_date, renewal_date, duration)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssiiisssssi", $orderNumber, $nameJsonString, $user_id, $product_id, $quantity, $totalAmount, $currency, $orderStatus, $orderTimestamp, $renewal_date, $duration);

    if ($stmt->execute()) {
        error_log("Order created successfully: $orderNumber");
    } else {
        error_log("Order creation failed: " . $stmt->error);
    }

    return $orderNumber;
}

function getProductInfo($conn, $product_id, $getCurrency) {
    $priceColumn = 'price_' . $getCurrency; // Ensure currency code is in lowercase
    $offerPriceColumn = 'offer_price_' . $getCurrency; // Offer price column

    $getProduct = "SELECT product_id, $priceColumn AS price, $offerPriceColumn AS offerprice FROM products WHERE product_id = ?";
    $stmt = mysqli_prepare($conn, $getProduct);

    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "i", $product_id);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        mysqli_stmt_close($stmt);

        if ($result && $result->num_rows > 0) {
            $productInfo = $result->fetch_assoc();
            // If offer price exists and is not null or empty, return it
            if (!empty($productInfo['offerprice'])) {
                return $productInfo;
            } else {
                return $productInfo['price']; // Otherwise, return regular price
            }
        }
    }

    return null; // Return null if the product information cannot be retrieved
}


function calculateTotalAmount($orderNumbers, $conn) {
    // Calculate the total amount based on the order numbers and their prices
    $totalAmount = 0;

    foreach ($orderNumbers as $orderNumber) {
        $sql = "SELECT total_amount FROM orders WHERE order_number = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $orderNumber);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $totalAmount += $row['total_amount'];
        }
    }

    return $totalAmount;
}

function createInvoice($user_id, $orderNumbers, $totalAmount, $conn, $getCurrency, $taxPercent) {
    $invoiceNumber = generateOrderNumber();
    $invoiceDate = date('Y-m-d H:i:s');
    $currency = $getCurrency;

    // Calculate tax amount based on the total amount and tax percent
    $taxAmount = ($totalAmount * $taxPercent) / 100;
    $amount = $totalAmount;
    $totalAmount = $amount + $taxAmount; // Add tax to the total amount

    // Store the order numbers as a JSON-encoded array
    $orderNumbersJson = json_encode($orderNumbers);

    $sql = "INSERT INTO invoices (invoice_number, user_id, order_numbers, total_amount, currency, tax_percent, tax_amount, invoice_date, amount)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssssssss", $invoiceNumber, $user_id, $orderNumbersJson, $totalAmount, $currency, $taxPercent, $taxAmount, $invoiceDate, $amount);
    if ($stmt->execute()) {
        // Log success or debugging information
    } else {
        // Log the error message for debugging
    }
    return $invoiceNumber;
}

function getCardBrandCode($cardNumber)
{
    // Define card number prefixes and their corresponding brand codes
    $cardBrandCodes = array(
        '4' => '100', // VISA
        '5' => '200', // MasterCard
        '34' => '400', // American Express
        '37' => '400', // American Express
        '51' => '200', // MasterCard
        '52' => '200', // MasterCard
        '53' => '200', // MasterCard
        '54' => '200', // MasterCard
        '55' => '200', // MasterCard
        '9792' => '300', // TROY
    );

    // Determine the card brand based on the prefixes
    foreach ($cardBrandCodes as $prefix => $brandCode) {
        if (substr($cardNumber, 0, strlen($prefix)) === $prefix) {
            return $brandCode;
        }
    }

    // Return '000' if the card brand is not recognized
    return '000';
}
function processPaymentRequest($cardData, $invoiceNumber, $totalAmount, $getCurrency, $conn, $lang) {
    $url = 'https://3dsecure.vakifbank.com.tr:4443/MPIAPI/MPI_Enrollment.aspx';
    $Pan = $cardData['card_number'];
    $ExpiryDate = $cardData['expiration_date'];
    $cccvv = $cardData['cvv'];

    if ($totalAmount !== false) {
        // Calculate tax amount (20% of the total amount)
        $taxPercent = 20;
        $taxAmount = ($totalAmount * $taxPercent) / 100;

        // Add tax to the total amount
        $PurchaseAmount = $totalAmount + $taxAmount;

        // Format amounts to two decimal places
        $taxAmount = number_format($taxAmount, 2, '.', '');
        $PurchaseAmount = number_format($PurchaseAmount, 2, '.', '');

        // Map numeric currency codes to their respective currency codes
        $currencyCodeMap = [
            'try' => 949, // Turkish Lira
            'usd' => 840, // U.S. Dollar
            'eur' => 978, // Euro
            'gbp' => 826, // British Pound
            'gpy' => 392, // British Pound
        ];

        // Set the Currency based on the mapping, default to 'usd' if not found
        $Currency = isset($currencyCodeMap[$getCurrency]) ? $currencyCodeMap[$getCurrency] : '840';
    } else {
        // Handle the case where there was an error retrieving the total amount and currency
        // You might want to set default values or display an error message
        $PurchaseAmount = number_format(0, 2, '.', ''); // Set a default value or handle the error accordingly
        $Currency = '949'; // Set a default currency or handle the error accordingly
    }
    $BrandCode = getCardBrandCode($cardData['card_number']);
    $VerifyEnrollmentRequestId = $invoiceNumber. date('YmdHis');
    $SessionInfo = $Pan . '--' . $cccvv . '--' . $PurchaseAmount; // Optional
    $MerchantId = "000000005720628";
    $TerminalId = "VP744648";
    $MerchantPassword = "q0D7Taf4";
    $SuccessUrl = "https://datanito.com/payment-callback";
    $FailureUrl = "https://datanito.com/payment-callback";
    $InstallmentCount = "";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/x-www-form-urlencoded"));
    curl_setopt($ch, CURLOPT_POSTFIELDS, "Pan=" . $Pan . "&ExpiryDate=" . $ExpiryDate . "&cccvv=" . $cccvv . "&PurchaseAmount=" . $PurchaseAmount . "&Currency=" . $Currency . "&BrandName=" . $BrandName . "&VerifyEnrollmentRequestId=" . $VerifyEnrollmentRequestId . "&SessionInfo=" . $SessionInfo . "&MerchantId=" . $MerchantId . "&TerminalId=" . $TerminalId . "&MerchantPassword=" . $MerchantPassword . "&SuccessUrl=" . $SuccessUrl . "&FailureUrl=" . $FailureUrl . "&InstallmentCount=" . $InstallmentCount);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    $result = curl_exec($ch);
    curl_close($ch);

    $response = SonucuOku($result);

    if ($response["Status"] == "Y") {
        // Return the success response with the ACSUrl for the iframe
        return [
            'success' => true,
            'message' => $lang['modal-pay-success-connect'],
            'icon' => 'success',
            'invoice-id' => $invoiceNumber,
            'iframe' => '
                <div id="loading">Loading...</div>
                <iframe id="iframe" name="iframe" style="width: 100%; height: 400px; border: none;"></iframe>
                <form id="form" method="post" target="iframe" action="' . $response["ACSUrl"] . '">
                    <input type="hidden" name="PaReq" value="' . $response["PaReq"] . '">
                    <input type="hidden" name="TermUrl" value="' . $response["TermUrl"] . '">
                    <input type="hidden" name="MD" value="' . $response["MerchantData"] . '">
                    <input type="button" id="submitBtn" value="'.$lang['modal-pay-3d-secure-cta'].'">
                </form>
                <script>
                    document.getElementById("submitBtn").addEventListener("click", function() {
                        document.getElementById("submitBtn").style.display = "none";
                        document.getElementById("loading").style.display = "none";
                    });
                    setTimeout(function(){
                        document.getElementById("submitBtn").style.display = "none";
                        document.getElementById("loading").style.display = "none";
                        document.getElementById("form").submit();
                    }, 1000);
                </script>
            ',
        ];
    } else {
        // Return the failure response
        return [
            'success' => false,
            'message' => $lang['modal-pay-fail-connect'],
            'icon' => 'error',
            'iframe' => '',
        ];
    }
}


function SonucuOku($result)
{
    $resultDocument = new DOMDocument();
    $resultDocument->loadXML($result);
    //Status Bilgisi okunuyor
    $statusNode = $resultDocument->getElementsByTagName("Status")->item(0);
    $status = "";
    if ($statusNode != null) {
        $status = $statusNode->nodeValue;
    }
    //PAReq Bilgisi okunuyor
    $PAReqNode = $resultDocument->getElementsByTagName("PaReq")->item(0);
    $PaReq = "";
    if ($PAReqNode != null) {
        $PaReq = $PAReqNode->nodeValue;
    }
    //ACSUrl Bilgisi okunuyor
    $ACSUrlNode = $resultDocument->getElementsByTagName("ACSUrl")->item(0);
    $ACSUrl = "";
    if ($ACSUrlNode != null) {
        $ACSUrl = $ACSUrlNode->nodeValue;
    }
    //Term Url Bilgisi okunuyor
    $TermUrlNode = $resultDocument->getElementsByTagName("TermUrl")->item(0);
    $TermUrl = "";
    if ($TermUrlNode != null) {
        $TermUrl = $TermUrlNode->nodeValue;
    }
    //MD Bilgisi okunuyor
    $MDNode = $resultDocument->getElementsByTagName("MD")->item(0);
    $MD = "";
    if ($MDNode != null) {
        $MD = $MDNode->nodeValue;
    }
    //MessageErrorCode Bilgisi okunuyor
    $messageErrorCodeNode = $resultDocument->getElementsByTagName("MessageErrorCode")->item(0);
    $messageErrorCode = "";
    if ($messageErrorCodeNode != null) {
        $messageErrorCode = $messageErrorCodeNode->nodeValue;
    }
    // Sonu dizisi oluturuluyor
    $result = array("Status" => $status, "PaReq" => $PaReq, "ACSUrl" => $ACSUrl, "TermUrl" => $TermUrl, "MerchantData" => $MD, "MessageErrorCode" => $messageErrorCode);
    return $result;
}


// Rest of the code for generating a unique order number is the same
// Generate a unique 20-letter order number
function generateOrderNumber($length = 20) {
    $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $orderNumber = '';

    // Add a timestamp (optional)
    $orderNumber .= date('YmdHis');

    // Add random characters to reach the desired length
    while (strlen($orderNumber) < $length) {
        $orderNumber .= $characters[rand(0, strlen($characters) - 1)];
    }

    return $orderNumber;
}
