<?php
$xmlDoc = new DOMDocument();
$xmlFile = __DIR__ . '/links.xml';
if (file_exists($xmlFile)) {
    $xmlDoc->load($xmlFile);
} else {
    echo 'XML file not found.';
}

$x = $xmlDoc->getElementsByTagName('link');

// Get the q parameter from URL
$q = $_GET["q"];

// Lookup all links from the xml file if length of q > 0
if (strlen($q) > 0) {
    $hint = "";
    for ($i = 0; $i < $x->length; $i++) {
        $y = $x->item($i)->getElementsByTagName('title');
        $z = $x->item($i)->getElementsByTagName('url');
        if ($y->item(0)->nodeType == 1) {
            // Find a link matching the search text in title or class
            $title = $y->item(0)->nodeValue;
            $classes = $y->item(0)->getAttribute('class');
            if (stristr($title, $q) || stristr($classes, $q)) {
                $highlightedTitle = preg_replace("/(" . preg_quote($q, '/') . ")/i", "<span class='font-medium !text-gray-500 dark:!text-gray-300'>$1</span>", $title);
                $hint .= "<li class='p-2 hover:bg-gray-200 dark:hover:bg-dark-600 rounded mb-1'><a class='flex items-center text-sm font-medium' href='" .
                    $z->item(0)->nodeValue .
                    "' target='_blank'><span class='material-symbols-outlined text-[15px] mr-1'>search</span><span class='font-medium text-gray-400 dark:text-gray-400'>" .
                    $highlightedTitle . "</span></a></li>";
            }
        }
    }
}

// Set output to "no suggestion" if no hint was found
// or to the correct values
if ($hint == "") {
    $response = "<h4 class='text-gray-500 dark:text-gray-300'>no suggestion</h4>";
} else {
    $hintList = "<ul class='fadein'>";
    $hintItems = explode("<li", $hint);
    $count = min(5, count($hintItems));
    for ($i = 0; $i < $count; $i++) {
        $hintList .= "<li" . $hintItems[$i + 1];
    }
    $hintList .= "</ul>";
    $response = $hintList;
}

// Output the response
echo $response;
?>
