<?php
// Your PHP logic to determine whether to index or not
$shouldIndex = true; // Set this based on your logic

// Set the X-Robots-Tag header
if ($shouldIndex) {
    header('X-Robots-Tag: index, follow');
} else {
    header('X-Robots-Tag: noindex, nofollow');
}

// Enable CORS for a specific domain
$allowed_origin = 'https://datanito.com';
$current_origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
if ($current_origin === $allowed_origin) {
    header('Access-Control-Allow-Origin: ' . $allowed_origin);
    header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type');
}

// Additional security headers
header('Content-Security-Policy: default-src \'self\'');
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');
header('X-Content-Type-Options: nosniff');
header('Referrer-Policy: same-origin');
?>
