<?php
$status = '0';
$error_message = '';

// Check if oid parameter is present in the URL
if (isset($_GET['oid'])) {
    // Check if necessary POST parameters are set
    if (isset($_POST['Status'], $_POST['VerifyEnrollmentRequestId'], $_POST['Xid'], $_POST['Eci'], $_POST['Cavv'], $_POST['Pan'], $_POST['Expiry'], $_POST['PurchAmount'], $_POST['SessionInfo'])) {
        // Extract necessary parameters from POST data
        $Status = $_POST['Status'];
        $VerifyEnrollmentRequestId = $_POST['VerifyEnrollmentRequestId'];
        $Xid = $_POST['Xid'];
        $Eci = $_POST['Eci'];
        $Cavv = $_POST['Cavv'];
        $Pan = $_POST['Pan'];
        $Expiry = $_POST['Expiry'];
        $PurchAmount = $_POST['PurchAmount'];
        $SessionInfo = $_POST['SessionInfo']; // kartno cvv yi buradan alıyoruz.

        // Parse SessionInfo to extract Pan, cvv, and fatura_amount
        list($Pan, $cvv, $fatura_amount) = explode('--', $SessionInfo);

        // Clear SessionInfo
        $_POST['SessionInfo'] = '';

        if ($Status == 'Y' && $VerifyEnrollmentRequestId != '' && $Xid != '') {
            // 3D secure işlemi başarılı
            $PurchAmount /= 100; // Convert the amount to the appropriate currency

            if ($PurchAmount == $fatura_amount) {
                // Otorizasyon tamamlanıyor
                $url = 'https://3dsecure.vakifbank.com.tr:4443/MPIAPI/MPI_Enrollment.aspx';
                $MerchantId = "000000005720628";
                $TerminalId = "VP744648";
                $MerchantPassword = "q0D7Taf4";
                $KartNo = $Pan;
                $KartAy = substr($Expiry, -2);
                $KartYil = '20' . substr($Expiry, 0, 2);
                $KartCvv = $cvv;
                $SiparID = $VerifyEnrollmentRequestId;
                $IslemTipi = 'Sale';
                $TutarKodu = 949;

                // Prepare VposRequest XML
                $PosXML = '<?xml version="1.0" encoding="utf-8"?>
                <VposRequest>
                    <MerchantId>' . $MerchantId . '</MerchantId>
                    <Password>' . $MerchantPassword . '</Password>
                    <TerminalNo>' . $TerminalId . '</TerminalNo>
                    <TransactionType>' . $IslemTipi . '</TransactionType>
                    <TransactionId>' . $SiparID . '</TransactionId>
                    <MpiTransactionId>' . $VerifyEnrollmentRequestId . '</MpiTransactionId>
                    <CurrencyAmount>' . $PurchAmount . '</CurrencyAmount>
                    <CurrencyCode>' . $TutarKodu . '</CurrencyCode>
                    <Pan>' . $KartNo . '</Pan>
                    <Cvv>' . $KartCvv . '</Cvv>
                    <Expiry>' . $KartYil . $KartAy . '</Expiry>
                    <ClientIp>' . $_SERVER['REMOTE_ADDR'] . '</ClientIp>
                    <ECI>' . $Eci . '</ECI>
                    <CAVV>' . $Cavv . '</CAVV>
                    <TransactionDeviceSource>0</TransactionDeviceSource>
                </VposRequest>';

                // Initialize cURL session
                $ch = curl_init();
                curl_setopt_array($ch, [
                    CURLOPT_URL => $url,
                    CURLOPT_POST => true,
                    CURLOPT_POSTFIELDS => "prmstr=" . urlencode($PosXML),
                    CURLOPT_RETURNTRANSFER => true
                ]);

                // Execute cURL request
                $result = curl_exec($ch);

                // Check for cURL errors
                if ($result === false || empty($result)) {
                    // cURL error occurred or empty response
                    $error_message = 'Empty or invalid response received from the server';
                    $status = '2';
                } else {
                    // Parse XML response
                    $xml = simplexml_load_string($result);
                    if ($xml !== false) {
                        // Convert SimpleXMLElement object to array
                        $XmlResponse = json_decode(json_encode($xml), TRUE);

                        // Check if the expected keys exist in the array
                        if (isset($XmlResponse['Message'], $XmlResponse['Message']['VERes'], $XmlResponse['Message']['VERes']['Status'])) {
                            $Status = $XmlResponse['Message']['VERes']['Status'];

                            if ($Status == 'E') {
                                // Payment failed due to system error
                                $status = '2';
                                $error_message = isset($XmlResponse['ErrorMessage']) ? $XmlResponse['ErrorMessage'] : 'System error occurred.';
                            } else {
                                // Payment was successful
                                $status = '1';
                            }
                        } else {
                            // Handle case where expected keys are missing
                            $status = '2';
                            $error_message = 'Invalid XML response format';
                        }
                    } else {
                        // Failed to parse XML response
                        $status = '2';
                        $error_message = 'Failed to parse XML response';
                    }
                }

                // Close cURL session
                curl_close($ch);
            } else {
                $error_message = 'PurchAmount does not match fatura_amount';
                $status = '2';
            }
        } else {
            $error_message = 'Status, VerifyEnrollmentRequestId, or Xid is missing or invalid';
            $status = '2';
        }
    } else {
        $error_message = 'Required POST parameters are missing';
        $status = '2';
    }
} else {
    $error_message = 'oid parameter is missing in the URL';
    $status = '2';
}

// Output result based on status
if ($status == '1') {
    echo "Payment Successful";
} else {
    echo "Payment Error: $error_message";
}

// Log error message
file_put_contents('error_log.txt', date('Y-m-d H:i:s') . " - Error: $error_message\n", FILE_APPEND);
?>

