<?php

function readResponse($result)
{
    $resultDocument = new DOMDocument();
    $resultDocument->loadXML($result);

    $status = $resultDocument->getElementsByTagName("Status")->item(0)->nodeValue ?? "";
    $PaReq = $resultDocument->getElementsByTagName("PaReq")->item(0)->nodeValue ?? "";
    $ACSUrl = $resultDocument->getElementsByTagName("ACSUrl")->item(0)->nodeValue ?? "";
    $TermUrl = $resultDocument->getElementsByTagName("TermUrl")->item(0)->nodeValue ?? "";
    $MD = $resultDocument->getElementsByTagName("MD")->item(0)->nodeValue ?? "";
    $messageErrorCode = $resultDocument->getElementsByTagName("MessageErrorCode")->item(0)->nodeValue ?? "";

    return [
        "Status" => $status,
        "PaReq" => $PaReq,
        "ACSUrl" => $ACSUrl,
        "TermUrl" => $TermUrl,
        "MerchantData" => $MD,
        "MessageErrorCode" => $messageErrorCode
    ];
}

$url = 'https://3dsecure.vakifbank.com.tr:4443/MPIAPI/MPI_Enrollment.aspx';
$Pan = "4543600345485679";
$ExpiryDate = "2803";
$cccvv = "101";
$PurchaseAmount = "1.00";
$Currency = "949";
$BrandName = "100";
$VerifyEnrollmentRequestId = "test123_" . date('YmdHis');
$SessionInfo = $Pan . '--' . $cccvv . '--' . $PurchaseAmount; // Optional
$MerchantId = "000000005720628";
$TerminalId = "VP744648";
$MerchantPassword = "q0D7Taf4";
$SuccessUrl = "https://datanito.com/online-pay/payment-callback.php?oid=" . $VerifyEnrollmentRequestId;
$FailureUrl = "https://datanito.com/online-pay/payment-callback.php?oid=" . $VerifyEnrollmentRequestId;
$InstallmentCount = "";

$PostUrl = $url;
$PosXML = http_build_query([
    "Pan" => $Pan,
    "ExpiryDate" => $ExpiryDate,
    "cccvv" => $cccvv,
    "PurchaseAmount" => $PurchaseAmount,
    "Currency" => $Currency,
    "BrandName" => $BrandName,
    "VerifyEnrollmentRequestId" => $VerifyEnrollmentRequestId,
    "SessionInfo" => $SessionInfo,
    "MerchantId" => $MerchantId,
    "TerminalId" => $TerminalId,
    "MerchantPassword" => $MerchantPassword,
    "SuccessUrl" => $SuccessUrl,
    "FailureUrl" => $FailureUrl,
    "InstallmentCount" => $InstallmentCount
]);

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $PostUrl,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $PosXML,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 59,
    CURLOPT_SSLVERSION => CURL_SSLVERSION_TLSv1_1,
    CURLOPT_SSL_VERIFYPEER => false // Not recommended for production
]);
$result = curl_exec($ch);

$response = readResponse($result);

// Check if response status is Y
if ($response["Status"] == "Y") {
    echo '<div id="loading">Loading...</div>';
    echo '<iframe id="iframe" name="iframe" style="width: 100%; height: 400px; border: none;"></iframe>';
    echo '<form id="form" method="post" target="iframe" action="' . $response["ACSUrl"] . '">
              <input type="hidden" name="PaReq" value="' . $response["PaReq"] . '">
              <input type="hidden" name="TermUrl" value="' . $response["TermUrl"] . '">
              <input type="hidden" name="MD" value="' . $response["MerchantData"] . '">
              <input type="button" id="submitBtn" value="3D Secure Onay">
          </form>';
    echo '<script>
              document.getElementById("submitBtn").addEventListener("click", function() {
                  document.getElementById("submitBtn").style.display = "none";
                  document.getElementById("loading").style.display = "none";
              });
              setTimeout(function(){
                  document.getElementById("submitBtn").style.display = "none";
                  document.getElementById("loading").style.display = "none";
                  document.getElementById("form").submit();
              }, 1000);
          </script>';
} else {
    echo "İşlem başarısız. Hata kodu: " . $response["MessageErrorCode"];
}

curl_close($ch);

?>
