<?php

require_once __DIR__.'/router.php';



// Set the base URL for your assets
$base_url = '/assets/';
function asset($path) {
    return  '/assets/' . $path;
}
function includes($path) {
    return  'includes/' . $path;
}

function getCurrentUrl() {
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
    $host = $_SERVER['HTTP_HOST'];
    $path = rtrim($_SERVER['REQUEST_URI'], '/');

    // Remove "www" from the beginning of the host name
    $host = preg_replace('/^www\./', '', $host);

    // Redirect to the non-www version
    if (preg_match('/^www\./', $host)) {
        header("Location: $protocol://" . preg_replace('/^www\./', '', $host) . $path, true, 301);
        exit;
    }

    // Redirect to the non-trailing slash version
    if (substr($path, -1) === '/') {
        header("Location: $protocol://" . $host . substr($path, 0, -1), true, 301);
        exit;
    }

    return $protocol . "://" . $host . $path;
}

function url($path) {
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
    $host = $_SERVER['HTTP_HOST'];

    // Remove "www" from the beginning of the host name
    $host = preg_replace('/^www\./', '', $host);

    // Check if the session is set to "tr"
    if (isset($_SESSION['country']) && $_SESSION['country'] === 'tr') {
        // Check if the path matches the pattern "/account/" or "/account/*"
        $path = "/tr" . $path;
    }

    // Redirect to the non-www version
    if (preg_match('/^www\./', $host)) {
        header("Location: $protocol://" . preg_replace('/^www\./', '', $host) . $path, true, 301);
        exit;
    }

    // Redirect to the non-trailing slash version
    if (substr($path, -1) === '/') {
        // Check if the path is not "/account/"
        if ($path !== "/account/") {
            header("Location: $protocol://" . $host . substr($path, 0, -1), true, 301);
            exit;
        }
    }

    return $protocol . "://" . $host . $path;
}


// Define a new route to serve your assets
get('/assets/.*', function() use ($base_url) {
    // Get the requested asset file path from the URL
    $file_path = preg_replace('/\/assets\//', '', $_SERVER['REQUEST_URI']);

    // Set the full path to the requested file
    $file = __DIR__ . $base_url . $file_path;

    // Check if the file exists
    if (file_exists($file)) {
        // Set the correct content type header
        $content_type = mime_content_type($file);
        header("Content-Type: $content_type");

        // Serve the file contents
        readfile($file);
    } else {
        // Return a 404 error
        header("HTTP/1.0 404 Not Found");
        echo 'File not found.';
    }
});

// Static GET
// In the URL -> http://localhost
// The output -> Index
get('/', 'views/index.php');
get('/dino', 'views/dino/dino');
get('/contact', 'views/contact');
get('/pay', 'views/pay/pay');
get('/pay/links', 'views/pay/links');
get('/payment-callback', 'views/payment-callback');
get('/email', 'views/update-password.php');
get('/cloud', 'views/cloud/cloud');
get('/cloud/web-hosting', 'views/cloud/web-hosting');
get('/cloud/business-hosting', 'views/cloud/business-hosting');
get('/solutions/web-design', 'views/solutions/web-design');
get('/solutions/seo', 'views/solutions/seo');
get('/solutions/mobile-app-development', 'views/solutions/mobile-app-development');
get('/solutions/digital-advertising', 'views/solutions/digital-advertising');
get('/solutions/wordpress-premium-support', 'views/solutions/wordpress-premium-support');
get('/domain/register', 'views/domain/register');
get('/domain/register/$domain', 'views/domain/register');
get('/domain/transfer', 'views/domain/transfer');
get('/checkout', 'views/checkout');
get('/about', 'views/about.php');
get('/blog', 'views/blog/archive');
get('/blog/$id', 'views/blog/single');
get('/blog/category/$id', 'views/blog/category');
get('/legal/terms', 'views/legal/terms');
get('/legal/privacy', 'views/legal/privacy');
get('/studio/storfy', 'views/studio/storfy');

get('/linkpay', 'views/linkpay/index');


get('/tr', 'views/index.php');
get('/tr/dino', 'views/dino/dino');
get('/tr/contact', 'views/contact');
get('/tr/pay', 'views/pay/pay');
get('/tr/pay/links', 'views/pay/links');
get('/tr/payment-callback', 'views/payment-callback');
get('/tr/email', 'views/update-password.php');
get('/tr/cloud', 'views/cloud/cloud');
get('/tr/cloud/web-hosting', 'views/cloud/web-hosting');
get('/tr/cloud/business-hosting', 'views/cloud/business-hosting');
get('/tr/solutions/web-design', 'views/solutions/web-design');
get('/tr/solutions/seo', 'views/solutions/seo');
get('/tr/solutions/mobile-app-development', 'views/solutions/mobile-app-development');
get('/tr/solutions/digital-advertising', 'views/solutions/digital-advertising');
get('/tr/solutions/wordpress-premium-support', 'views/solutions/wordpress-premium-support');
get('/tr/domain/register', 'views/domain/register');
get('/tr/domain/register/$domain', 'views/domain/register');
get('/tr/domain/transfer', 'views/domain/transfer');
get('/tr/checkout', 'views/checkout');
get('/tr/about', 'views/about.php');
get('/tr/blog', 'views/blog/archive');
get('/tr/blog/$id', 'views/blog/single');
get('/tr/blog/category/$id', 'views/blog/category');
get('/tr/legal/terms', 'views/legal/terms');
get('/tr/legal/privacy', 'views/legal/privacy');
get('/tr/studio/storfy', 'views/studio/storfy');


get('/user/$username', 'views/user');
get('/admin', 'views/admin/overview');
get('/admin/products', 'views/admin/products');
get('/admin/users', 'views/admin/users/users.php');
get('/admin/support/requests', 'views/admin/support/requests');
get('/admin/support/new', 'views/admin/support/response');
get('/admin/leads', 'views/admin/leads/leads.php');
get('/admin/blog', 'views/admin/blog/archive');
get('/admin/blog/p/$id', 'views/admin/blog/single');
get('/admin/blog/new', 'views/admin/blog/new');
get('/admin/blog/category', 'views/admin/blog/category');
get('/admin/email/send', 'views/admin/email/send');
get('/admin/sms/send', 'views/admin/sms/send');
get('/account/overview', 'views/account/pages/overview');
get('/account/solutions', 'views/account/pages/solutions');
get('/account/cloud', 'views/account/pages/cloud');
get('/account/domains', 'views/account/pages/domains');
get('/account/pay', 'views/account/pages/pay');
get('/account/analytics', 'views/account/pages/analytics');
get('/account/dino', 'views/account/pages/dino');
get('/account/billing/invoices', 'views/account/billing/invoices');
get('/account/billing/generate-invoice', 'includes/account/billing/generate-invoice');
get('/account/billing/invoice-template', 'includes/account/billing/invoice-template');
get('/account/docs', 'views/account/pages/docs');
get('/account/support/requests', 'views/account/pages/support/requests');
get('/account/support/new', 'views/account/pages/support/new');
get('/account/products', 'views/account/pages/products');
get('/account/profile/update', 'views/account/pages/profile');
get('/account/login', 'views/account/auth/login.php');
get('/account/reset-password', 'views/account/auth/reset-password.php');
get('/account/create', 'views/account/auth/sign-up.php');
get('/account/dino/c/$id', 'views/account/pages/dino');
get('/account/cloud/$id', 'views/account/pages/cloud-view');
get('/account/domain/$id', 'views/account/pages/domain-view');


get('/tr/admin', 'views/admin/overview');
get('/tr/admin/products', 'views/admin/products');
get('/tr/admin/users', 'views/admin/users/users.php');
get('/tr/admin/support/requests', 'views/admin/support/requests');
get('/tr/admin/support/new', 'views/admin/support/response');
get('/tr/admin/leads', 'views/admin/leads/leads.php');
get('/tr/admin/blog', 'views/admin/blog/archive');
get('/tr/admin/blog/p/$id', 'views/admin/blog/single');
get('/tr/admin/blog/new', 'views/admin/blog/new');
get('/tr/admin/blog/category', 'views/admin/blog/category');
get('/tr/admin/email/send', 'views/admin/email/send');
get('/tr/admin/sms/send', 'views/admin/sms/send');
get('/tr/account/overview', 'views/account/pages/overview');
get('/tr/account/solutions', 'views/account/pages/solutions');
get('/tr/account/cloud', 'views/account/pages/cloud');
get('/tr/account/domains', 'views/account/pages/domains');
get('/tr/account/pay', 'views/account/pages/pay');
get('/tr/account/analytics', 'views/account/pages/analytics');
get('/tr/account/dino', 'views/account/pages/dino');
get('/tr/account/billing/invoices', 'views/account/billing/invoices');
get('/tr/account/billing/generate-invoice', 'includes/account/billing/generate-invoice');
get('/tr/account/billing/invoice-template', 'includes/account/billing/invoice-template');
get('/tr/account/docs', 'views/account/pages/docs');
get('/tr/account/support/requests', 'views/account/pages/support/requests');
get('/tr/account/support/new', 'views/account/pages/support/new');
get('/tr/account/products', 'views/account/pages/products');
get('/tr/account/profile/update', 'views/account/pages/profile');
get('/tr/account/login', 'views/account/auth/login.php');
get('/tr/account/reset-password', 'views/account/auth/reset-password.php');
get('/tr/account/create', 'views/account/auth/sign-up.php');
get('/tr/account/dino/c/$id', 'views/account/pages/dino');
get('/tr/account/cloud/$id', 'views/account/pages/cloud-view');
get('/tr/account/domain/$id', 'views/account/pages/domain-view');


// Dynamic GET. Example with 1 variable
// The $id will be available in user.php
get('/user/$username', 'views/user');
get('/products/$id', 'views/products.php');


// Dynamic GET. Example with 2 variables
// The $name will be available in full_name.php
// The $last_name will be available in full_name.php
// In the browser point to: localhost/user/X/Y
get('/user/$name/$last_name', 'views/full_name.php');

// Dynamic GET. Example with 2 variables with static
// In the URL -> http://localhost/product/shoes/color/blue
// The $type will be available in product.php
// The $color will be available in product.php
get('/product/$type/color/$color', 'product.php');

// A route with a callback
get('/callback', function(){
    echo 'Callback executed';
});

// A route with a callback passing a variable
// To run this route, in the browser type:
// http://localhost/user/A
get('/callback/$name', function($name){
    echo "Callback executed. The name is $name";
});

// A route with a callback passing 2 variables
// To run this route, in the browser type:
// http://localhost/callback/A/B
get('/callback/$name/$last_name', function($name, $last_name){
    echo "Callback executed. The full name is $name $last_name";
});

// ##################################################
// ##################################################
// ##################################################
// any can be used for GETs or POSTs
// GET
get('/account/update-password/$token', 'views/account/auth/update-password.php');
get('/tr/account/update-password/$token', 'views/account/auth/update-password.php');
get('/account/verify/$token_verify', 'views/account/auth/verify.php');
get('/tr/account/verify/$token_verify', 'views/account/auth/verify.php');
get('/admin/support/$id', 'views/admin/support/view');
get('/account/support/requests/$id', 'views/account/pages/support/view');
get('/tr/account/support/requests/$id', 'views/account/pages/support/view');
get('/account/billing/invoices/$id', 'views/account/billing/view-invoices');
get('/tr/account/billing/invoices/$id', 'views/account/billing/view-invoices');
get('/account/cloud/$id', 'views/account/products/view-cloud');
get('/admin/support/requests/$id', 'views/admin/support/view');
// POST
post('/linkpay_process', 'includes/linkpay/process.php');
post('/linkpay_auth', 'includes/linkpay/auth.php');
post('/linkpay-callback', 'views/linkpay/callback.php');


post('/account/sms/get_recent', 'includes/admin/sms/fetch-recent.php');
post('/account/sms/send', 'includes/admin/sms/send.php');

post('/submit', 'views/products.php');
post('/payment-callback', 'views/payment-callback');
post('/process-callback', 'includes/payments/process-callback.php');
post('/add-to-cart', 'includes/add-to-cart.php');
post('/auth-login', 'includes/auth/login.php');
post('/auth-reset-password', 'includes/auth/reset-password.php');
post('/auth-update-password', 'includes/auth/update-password.php');
post('/auth-verify-email', 'includes/auth/verify.php');
post('/mailer', 'includes/mailer/send.php');
post('/add_product', 'includes/admin/products/add-product.php');
post('/fetch_users', 'includes/admin/users/fetch-users.php');
post('/fetch_leads', 'includes/admin/leads/fetch-leads.php');
post('/analytics_add_new_website', 'includes/account/analytics/add-new.php');
post('/analytics_get_websites', 'includes/account/analytics/get-websites.php');
post('/analytics_get_website_data', 'includes/account/analytics/get-data.php');
post('/analytics_get_summary', 'includes/account/analytics/summary.php');
post('/admin_get_products', 'includes/admin/products/get-products.php');
post('/admin/fetch-overview', 'includes/admin/fetch-overview.php');
post('/get_products', 'includes/get-products.php');
post('/get_user_products', 'includes/account/products/get-products.php');
post('/fetch_product', 'includes/account/products/fetch-product.php');
post('/save_card', 'includes/save-card.php');
post('/get_cards', 'includes/get-cards.php');
post('/get_invoices', 'includes/account/billing/get-invoices.php');
post('/view_invoices', 'includes/account/billing/view-invoices.php');
post('/process_checkout', 'includes/payments/process-checkout.php');
post('/process_payment', 'includes/payments/process-payment.php');
post('/view_profile', 'includes/account/profile/view');
post('/update_profile', 'includes/account/profile/update');
post('/support_requests', 'includes/account/support/requests');
post('/admin_support_requests', 'includes/admin/support/requests');
post('/support_requests_view', 'includes/account/support/view');
post('/admin_support_requests_view', 'includes/admin/support/view');
post('/support_reply', 'includes/account/support/reply');
post('/admin_support_reply', 'includes/admin/support/reply');
post('/change_support_status', 'includes/admin/support/change-status');
post('/open_help_request', 'includes/account/support/new');
post('/respond_help_request', 'includes/admin/support/respond');
post('/get_help_history', 'includes/admin/support/view');
post('/get_help_requests', 'includes/admin/support/support');
get('/website-search', 'includes/search/search.php');
post('/auth-sign-up', 'includes/auth/sign-up.php');
post('/auth-resend-email-confirmation', 'includes/auth/resend-email-confirmation.php');
post('/logout', 'includes/auth/logout.php');
post('/auth/google', 'includes/auth/google/save-user.php');
post('/dino-core', 'includes/dino.php');
post('/dino-assistant', 'includes/dino/assistant');
get('/admin/dino-assistant', 'views/admin/assistant_chat');
post('/dino/send_message', 'includes/admin/send_message');
get('/dino/get_chat_history', 'includes/admin/get_chat_history');
get('/dino/get_user_list', 'includes/admin/get_user_list');
post('/dino/send_message_to_admin', 'includes/admin/send_message_to_admin.php');
post('/dino/domain_suggestion', 'includes/dino/domain_suggestion');
post('/domain/check-availability', 'includes/domain/check_availability');
post('/submit_application', 'includes/forms/submit-application.php');
post('/dino/fetch_conversations', 'includes/dino/fetch_conversations');
post('/dino/fetch_messages', 'includes/dino/fetch_messages');
post('/settings', 'includes/settings.php');
post('/set-location', 'includes/set-location.php');
post('/blog-submit-post', 'includes/admin/blog/post.php');
post('/admin/blog-fetch-post', 'includes/admin/blog/single.php');
post('/admin/blog-fetch-archive', 'includes/admin/blog/archive.php');
post('/admin/add-blog-category', 'includes/admin/blog/add-category.php');
post('/admin/blog/fetch-categories', 'includes/admin/blog/fetch-categories.php');
post('/blog-fetch-post', 'includes/blog/single.php');
post('/blog-fetch-archive', 'includes/blog/archive.php');
post('/blog-fetch-archive', 'includes/blog/archive.php');
post('/get-domain-tips', 'includes/domain/get-domain-tips.php');
post('/email/send', 'includes/admin/email/send.php');
post('/host/login', 'includes/cpanel/login.php');
post('/host/stats', 'includes/cpanel/hosting_stats.php');
post('/host/activity', 'includes/cpanel/activity.php');
post('/host/analytics', 'includes/cpanel/analytics.php');
post('/host/notifications', 'includes/cpanel/notifications.php');
get('/automations/renew', 'includes/automations/renew.php');
get('/api/themes/verify_purchase_code/$code', 'includes/api/themes/verify.php');
get('/api/apps/vpc/$code', 'includes/api/scripts/verify.php');
// For GET or POST
// The 404.php which is inside the views folder will be called
// The 404.php has access to $_GET and $_POST
any('/404','views/404.php');
