<?php
$meta = array(
    'us' => array(
        'title' => 'About Us - Datanito - Pioneering Software and Technology',
        'description' => 'Learn about Datanito Ltd, a leading software and technology company. Discover our mission, values, and vision for the future.',
        'og:title' => 'About Us - Datanito Ltd - Pioneering Software and Technology',
        'og:description' => 'Explore the world of Datanito Ltd, where innovation knows no bounds. We\'re redefining the future of software and technology.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Hakkımızda - Datanito Ltd - Yazılım ve Teknolojinin Öncüsü',
        'description' => 'Datanito Ltd hakkında bilgi edinin, önde gelen bir yazılım ve teknoloji şirketi. Misyonumuzu, değerlerimizi ve geleceğe dair vizyonumuzu keşfedin.',
        'og:title' => 'Hakkımızda - Datanito - Yazılım ve Teknolojinin Öncüsü',
        'og:description' => 'Datanito Ltd\'nin dünyasını keşfedin, burada yeniliklerin sınırları yok. Yazılım ve teknolojinin geleceğini yeniden şekillendiriyoruz.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/header.php');
?>

    <style>
        /* iOS 26 Design System */
        :root {
            --glass-bg: rgba(255, 255, 255, 0.08);
            --glass-border: rgba(255, 255, 255, 0.12);
            --glass-shadow: 0 8px 32px rgba(0, 0, 0, 0.12);
            --dynamic-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --glow-effect: 0 0 40px rgba(102, 126, 234, 0.15);
        }

        .dark {
            --glass-bg: rgba(17, 25, 40, 0.75);
            --glass-border: rgba(255, 255, 255, 0.08);
        }

        .glass-card {
            background: var(--glass-bg);
            backdrop-filter: blur(20px);
            border: 1px solid var(--glass-border);
            box-shadow: var(--glass-shadow);
        }

        .dynamic-gradient {
            background: linear-gradient(-45deg, #ee7752, #e73c7e, #23a6d5, #23d5ab);
            background-size: 400% 400%;
            animation: gradient 15s ease infinite;
        }

        @keyframes gradient {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        .floating-element {
            animation: float 6s ease-in-out infinite;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-20px); }
        }

        .text-glow {
            text-shadow: 0 0 40px rgba(102, 126, 234, 0.3);
        }

        .hover-lift {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .hover-lift:hover {
            transform: translateY(-8px);
            box-shadow: var(--glow-effect);
        }

        .ios-button {
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: all 0.3s ease;
        }

        .ios-button:hover {
            background: rgba(255, 255, 255, 0.25);
            transform: scale(1.05);
        }
    </style>

    <div id="content" class="min-h-screen">
        <!-- Hero Section - iOS 26 Style -->
        <section class="relative min-h-screen flex items-center justify-center overflow-hidden dynamic-gradient">
            <!-- Animated Background Elements -->
            <div class="absolute inset-0">
                <div class="absolute top-1/4 left-1/4 w-72 h-72 bg-purple-300 rounded-full mix-blend-multiply filter blur-xl opacity-30 floating-element"></div>
                <div class="absolute top-1/3 right-1/4 w-96 h-96 bg-blue-300 rounded-full mix-blend-multiply filter blur-xl opacity-30 floating-element" style="animation-delay: -2s;"></div>
                <div class="absolute bottom-1/4 left-1/3 w-80 h-80 bg-pink-300 rounded-full mix-blend-multiply filter blur-xl opacity-30 floating-element" style="animation-delay: -4s;"></div>
            </div>

            <div class="relative z-10 text-center px-6 lg:px-8 max-w-7xl mx-auto">
                <div class="mb-8">
                <span class="inline-flex items-center px-6 py-3 rounded-full text-base font-medium glass-card text-white border border-white/20">
                    <?php echo $lang['about-us-superior'] ?>
                </span>
                </div>

                <h1 class="text-6xl md:text-8xl lg:text-9xl font-black text-white mb-8 leading-none text-glow">
                    <?php echo str_replace('<span class="text-transparent bg-clip-text bg-gradient-to-r to-cyan-600 from-purple-400">', '<span class="text-transparent bg-clip-text bg-gradient-to-r from-cyan-200 to-purple-200">', $lang['about-us-headline']); ?>
                </h1>

                <p class="text-2xl md:text-3xl text-white/90 max-w-4xl mx-auto mb-12 leading-relaxed font-light">
                    <?php echo $lang['about-us-subheading']; ?>
                </p>

                <div class="flex flex-col sm:flex-row gap-6 justify-center items-center">
                    <button data-scroll-target="our-story" class="scroll-link ios-button inline-flex items-center justify-center px-12 py-5 text-lg font-semibold rounded-2xl text-white border border-white/30 hover-lift">
                        <?php echo $lang['about-us-cta']; ?>
                        <svg class="ml-3 w-6 h-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" d="M10.293 5.293a1 1 0 011.414 0l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414-1.414L12.586 11H5a1 1 0 110-2h7.586l-2.293-2.293a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                        </svg>
                    </button>
                    <button data-scroll-target="leadership" class="scroll-link ios-button inline-flex items-center justify-center px-12 py-5 text-lg font-semibold rounded-2xl text-white border border-white/30 hover-lift">
                        <?php echo $lang['meet-leadership']; ?>
                    </button>
                </div>
            </div>

            <!-- Scroll Indicator -->
            <div class="absolute bottom-12 left-1/2 transform -translate-x-1/2">
                <div class="animate-bounce">
                    <div class="w-8 h-14 rounded-full border-2 border-white/50 flex justify-center">
                        <div class="w-1 h-3 bg-white/70 rounded-full mt-2 animate-pulse"></div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Stats Section - Glass Morphism -->
        <section class="py-24 bg-white/5 backdrop-blur-sm">
            <div class="container mx-auto px-6 lg:px-8">
                <div class="grid grid-cols-2 lg:grid-cols-4 gap-8">
                    <div class="glass-card rounded-3xl p-8 text-center hover-lift">
                        <div class="text-5xl lg:text-6xl font-black text-gray-700 dark:text-white mb-4">
                            <span class="counter" data-target="7">0</span>+
                        </div>
                        <div class="text-gray-500 dark:text-white/70 text-lg font-medium"><?php echo $lang['years-business']; ?></div>
                    </div>

                    <div class="glass-card rounded-3xl p-8 text-center hover-lift">
                        <div class="text-5xl lg:text-6xl font-black text-gray-700 dark:text-white mb-4">
                            <span class="counter" data-target="500">0</span>K+
                        </div>
                        <div class="text-gray-500 dark:text-white/70 text-lg font-medium"><?php echo $lang['global-clients']; ?></div>
                    </div>

                    <div class="glass-card rounded-3xl p-8 text-center hover-lift">
                        <div class="text-5xl lg:text-6xl font-black text-gray-700 dark:text-white mb-4">
                            <span class="counter" data-target="150">0</span>+
                        </div>
                        <div class="text-gray-500 dark:text-white/70 text-lg font-medium"><?php echo $lang['team-members']; ?></div>
                    </div>

                    <div class="glass-card rounded-3xl p-8 text-center hover-lift">
                        <div class="text-5xl lg:text-6xl font-black text-gray-700 dark:text-white mb-4">
                            <span class="counter" data-target="380">0</span>K+
                        </div>
                        <div class="text-gray-500 dark:text-white/70 text-lg font-medium"><?php echo $lang['projects-delivered']; ?></div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Leadership Section - Modern Cards -->
        <section id="leadership" class="py-24 bg-gradient-to-b from-gray-50 to-white dark:from-dark-800 dark:to-dark-900">
            <div class="container mx-auto px-6 lg:px-8">
                <div class="text-center mb-20">
                    <h2 class="text-6xl md:text-7xl font-black text-gray-900 dark:text-white mb-8">
                        <span class="text-transparent bg-clip-text bg-gradient-to-r from-blue-600 via-purple-600 to-cyan-600"><?php echo $lang['executive-leadership']; ?></span>
                    </h2>
                    <p class="text-2xl text-gray-600 dark:text-gray-300 max-w-3xl mx-auto font-light">
                        <?php echo $lang['leadership-subtitle']; ?>
                    </p>
                </div>

                <div class="grid lg:grid-cols-2 gap-12 max-w-6xl mx-auto">
                    <!-- CEO Card -->
                    <div class="group relative">
                        <div class="glass-card rounded-3xl p-10 hover-lift border border-gray-200/50 dark:border-dark-600/50">
                            <div class="flex flex-col items-center text-center">
                                <div class="relative mb-8">
                                    <div class="w-48 h-48 rounded-3xl overflow-hidden border-4 border-white dark:border-dark-700 shadow-2xl">
                                        <img class="w-full h-full object-cover" src="<?php echo asset('images/content/team/milad-saraf.png')?>" alt="Milad Saraf">
                                    </div>
                                    <div class="absolute -bottom-4 -right-4 bg-gradient-to-r from-blue-500 to-purple-600 text-white px-6 py-2 rounded-2xl text-sm font-bold shadow-lg">
                                        CEO
                                    </div>
                                </div>

                                <div class="space-y-4">
                                    <div class="text-blue-600 dark:text-blue-400 text-sm font-semibold tracking-wider"><?php echo $lang['founder-ceo']; ?></div>
                                    <h3 class="text-3xl font-bold text-gray-900 dark:text-white">Milad Saraf</h3>
                                    <p class="text-gray-600 dark:text-gray-300 text-lg leading-relaxed">
                                        <?php echo $lang['about-ceo-description']; ?>
                                    </p>

                                    <div class="flex justify-center space-x-5 pt-4">
                                        <a href="https://instagram.com/miladsarraf" target="_blank" class="w-12 h-12 flex items-center justify-center rounded-2xl bg-gray-100 dark:bg-dark-700 hover:bg-blue-50 dark:hover:bg-blue-900/20 transition-all duration-300">
                                            <svg class="w-6 h-6" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                                                <path fill="currentColor" fill-rule="evenodd" d="M3 8a5 5 0 0 1 5-5h8a5 5 0 0 1 5 5v8a5 5 0 0 1-5 5H8a5 5 0 0 1-5-5V8Zm5-3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V8a3 3 0 0 0-3-3H8Zm7.597 2.214a1 1 0 0 1 1-1h.01a1 1 0 1 1 0 2h-.01a1 1 0 0 1-1-1ZM12 9a3 3 0 1 0 0 6 3 3 0 0 0 0-6Zm-5 3a5 5 0 1 1 10 0 5 5 0 0 1-10 0Z" clip-rule="evenodd"/>
                                            </svg>
                                        </a>
                                        <a href="https://linkedin.com/in/miladsaraf" target="_blank" class="w-12 h-12 flex items-center justify-center rounded-2xl bg-gray-100 dark:bg-dark-700 hover:bg-blue-50 dark:hover:bg-blue-900/20 transition-all duration-300">
                                            <svg class="w-7 h-7" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                                <path fill-rule="evenodd" d="M12.51 8.796v1.697a3.738 3.738 0 0 1 3.288-1.684c3.455 0 4.202 2.16 4.202 4.97V19.5h-3.2v-5.072c0-1.21-.244-2.766-2.128-2.766-1.827 0-2.139 1.317-2.139 2.676V19.5h-3.19V8.796h3.168ZM7.2 6.106a1.61 1.61 0 0 1-.988 1.483 1.595 1.595 0 0 1-1.743-.348A1.607 1.607 0 0 1 5.6 4.5a1.601 1.601 0 0 1 1.6 1.606Z" clip-rule="evenodd"/>
                                                <path d="M7.2 8.809H4V19.5h3.2V8.809Z"/>
                                            </svg>
                                        </a>
                                        <a href="https://x.com/miladsaraf" target="_blank" class="w-12 h-12 flex items-center justify-center rounded-2xl bg-gray-100 dark:bg-dark-700 hover:bg-blue-50 dark:hover:bg-blue-900/20 transition-all duration-300">
                                            <svg class="w-5 h-5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                                <path d="M13.795 10.533 20.68 2h-3.073l-5.255 6.517L7.69 2H1l7.806 10.91L1.47 22h3.074l5.705-7.07L15.31 22H22l-8.205-11.467Zm-2.38 2.95L9.97 11.464 4.36 3.627h2.31l4.528 6.317 1.443 2.02 6.018 8.409h-2.31l-4.934-6.89Z"/>
                                            </svg>
                                        </a>
                                        <a href="https://github.com/miladsaraf" target="_blank" class="w-12 h-12 flex items-center justify-center rounded-2xl bg-gray-100 dark:bg-dark-700 hover:bg-blue-50 dark:hover:bg-blue-900/20 transition-all duration-300">
                                            <svg class="w-6 h-6" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                                <path fill-rule="evenodd" d="M12.006 2a9.847 9.847 0 0 0-6.484 2.44 10.32 10.32 0 0 0-3.393 6.17 10.48 10.48 0 0 0 1.317 6.955 10.045 10.045 0 0 0 5.4 4.418c.504.095.683-.223.683-.494 0-.245-.01-1.052-.014-1.908-2.78.62-3.366-1.21-3.366-1.21a2.711 2.711 0 0 0-1.11-1.5c-.907-.637.07-.621.07-.621.317.044.62.163.885.346.266.183.487.426.647.71.135.253.318.476.538.655a2.079 2.079 0 0 0 2.37.196c.045-.52.27-1.006.635-1.37-2.219-.259-4.554-1.138-4.554-5.07a4.022 4.022 0 0 1 1.031-2.75 3.77 3.77 0 0 1 .096-2.713s.839-.275 2.749 1.05a9.26 9.26 0 0 1 5.004 0c1.906-1.325 2.74-1.05 2.74-1.05.37.858.406 1.828.101 2.713a4.017 4.017 0 0 1 1.029 2.75c0 3.939-2.339 4.805-4.564 5.058a2.471 2.471 0 0 1 .679 1.897c0 1.372-.012 2.477-.012 2.814 0 .272.18.592.687.492a10.05 10.05 0 0 0 5.388-4.421 10.473 10.473 0 0 0 1.313-6.948 10.32 10.32 0 0 0-3.39-6.165A9.847 9.847 0 0 0 12.007 2Z" clip-rule="evenodd"/>
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- CTO Card -->
                    <div class="group relative">
                        <div class="glass-card rounded-3xl p-10 hover-lift border border-gray-200/50 dark:border-dark-600/50">
                            <div class="flex flex-col items-center text-center">
                                <div class="relative mb-8">
                                    <div class="w-48 h-48 rounded-3xl overflow-hidden border-4 border-white dark:border-dark-700 shadow-2xl">
                                        <img class="w-full h-full object-cover" src="<?php echo asset('images/content/team/arshia.jpeg')?>" alt="Arshia Valizadeh">
                                    </div>
                                    <div class="absolute -bottom-4 -right-4 bg-gradient-to-r from-green-500 to-teal-600 text-white px-6 py-2 rounded-2xl text-sm font-bold shadow-lg">
                                        CTO
                                    </div>
                                </div>

                                <div class="space-y-4">
                                    <div class="text-green-600 dark:text-green-400 text-sm font-semibold tracking-wider">Chief Technology Officer</div>
                                    <h3 class="text-3xl font-bold text-gray-900 dark:text-white">Arshia Valizadeh</h3>
                                    <p class="text-gray-600 dark:text-gray-300 text-lg leading-relaxed">
                                        Technology leader specializing in AI, software architecture, and scalable systems. Driving innovation and technical excellence across our platforms.
                                    </p>

                                    <div class="flex justify-center space-x-5 pt-4 hidden">
                                        <a href="https://linkedin.com/in/arshiavalizadeh" target="_blank" class="p-3 rounded-2xl bg-gray-100 dark:bg-dark-700 hover:bg-blue-50 dark:hover:bg-blue-900/20 transition-all duration-300">
                                            <svg class="w-6 h-6 text-gray-600 dark:text-gray-400" fill="currentColor" viewBox="0 0 24 24">
                                                <path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/>
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Mission & Vision - Modern Layout -->
        <section class="py-24 bg-gradient-to-br from-blue-50 via-white to-purple-50 dark:from-dark-800 dark:via-dark-900 dark:to-dark-800">
            <div class="container mx-auto px-6 lg:px-8">
                <div class="grid lg:grid-cols-2 gap-16 max-w-7xl mx-auto">
                    <!-- Mission -->
                    <div class="glass-card rounded-3xl p-12 hover-lift">
                        <div class="flex items-center mb-10">
                            <div class="flex-shrink-0 bg-gradient-to-br from-blue-500 to-blue-600 p-4 rounded-2xl shadow-xl">
                                <span class="material-symbols-outlined text-white text-4xl">target</span>
                            </div>
                            <h3 class="ml-6 text-4xl font-black text-gray-900 dark:text-white"><?php echo $lang['our-mission']; ?></h3>
                        </div>
                        <p class="text-xl text-gray-600 dark:text-gray-300 mb-10 leading-relaxed font-light">
                            <?php echo $lang['mission-content']; ?>
                        </p>
                        <div class="space-y-4">
                            <div class="flex items-center p-4 rounded-2xl bg-blue-50/50 dark:bg-blue-900/20 border border-blue-100 dark:border-blue-800/30">
                                <span class="material-symbols-outlined text-green-500 mr-4 text-2xl">check_circle</span>
                                <span class="text-gray-700 dark:text-gray-300 text-lg font-medium"><?php echo $lang['mission-item1']; ?></span>
                            </div>
                            <div class="flex items-center p-4 rounded-2xl bg-blue-50/50 dark:bg-blue-900/20 border border-blue-100 dark:border-blue-800/30">
                                <span class="material-symbols-outlined text-green-500 mr-4 text-2xl">check_circle</span>
                                <span class="text-gray-700 dark:text-gray-300 text-lg font-medium"><?php echo $lang['mission-item2']; ?></span>
                            </div>
                            <div class="flex items-center p-4 rounded-2xl bg-blue-50/50 dark:bg-blue-900/20 border border-blue-100 dark:border-blue-800/30">
                                <span class="material-symbols-outlined text-green-500 mr-4 text-2xl">check_circle</span>
                                <span class="text-gray-700 dark:text-gray-300 text-lg font-medium"><?php echo $lang['mission-item3']; ?></span>
                            </div>
                        </div>
                    </div>

                    <!-- Vision -->
                    <div class="glass-card rounded-3xl p-12 hover-lift">
                        <div class="flex items-center mb-10">
                            <div class="flex-shrink-0 bg-gradient-to-br from-purple-500 to-purple-600 p-4 rounded-2xl shadow-xl">
                                <span class="material-symbols-outlined text-white text-4xl">visibility</span>
                            </div>
                            <h3 class="ml-6 text-4xl font-black text-gray-900 dark:text-white"><?php echo $lang['our-vision']; ?></h3>
                        </div>
                        <p class="text-xl text-gray-600 dark:text-gray-300 mb-10 leading-relaxed font-light">
                            <?php echo $lang['vision-content']; ?>
                        </p>
                        <div class="bg-gradient-to-br from-purple-50 to-pink-50 dark:from-purple-900/20 dark:to-pink-900/20 rounded-2xl p-8 border border-purple-100 dark:border-purple-800/30">
                            <blockquote class="text-xl italic text-gray-700 dark:text-gray-300 mb-6 leading-relaxed">
                                "<?php echo $lang['ceo-quote']; ?>"
                            </blockquote>
                            <div class="flex items-center">
                                <img class="w-14 h-14 rounded-2xl mr-4 shadow-lg" src="<?php echo asset('images/content/team/Milad_Saraf_Life.png')?>" alt="Milad Saraf">
                                <div>
                                    <div class="font-bold text-gray-900 dark:text-white text-lg">Milad Saraf</div>
                                    <div class="text-purple-600 dark:text-purple-400 font-medium"><?php echo $lang['founder-ceo-title']; ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- CTA Section - Modern -->
        <section class="py-24 bg-gradient-to-r from-blue-600 via-purple-600 to-cyan-600">
            <div class="container mx-auto px-6 lg:px-8 text-center">
                <h2 class="text-5xl md:text-7xl font-black text-white mb-8 text-glow">
                    <?php echo $lang['cta-headline']; ?>
                </h2>
                <p class="text-2xl text-blue-100 max-w-3xl mx-auto mb-12 font-light">
                    <?php echo $lang['cta-subheading']; ?>
                </p>
                <div class="flex flex-col sm:flex-row gap-6 justify-center items-center">
                    <a href="<?php echo url('/contact'); ?>" class="ios-button inline-flex items-center justify-center px-12 py-5 text-lg font-semibold rounded-2xl text-white border border-white/30 hover-lift">
                        <?php echo $lang['cta-contact']; ?>
                    </a>
                    <a href="<?php echo url('/careers'); ?>" class="ios-button inline-flex items-center justify-center px-12 py-5 text-lg font-semibold rounded-2xl text-white border border-white/30 hover-lift">
                        <?php echo $lang['cta-careers']; ?>
                    </a>
                </div>
            </div>
        </section>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>

    <script>
        // Enhanced counter animation
        const counters = document.querySelectorAll('.counter');

        counters.forEach(counter => {
            const target = +counter.getAttribute('data-target');
            const duration = 2000;
            const step = target / (duration / 16);
            let current = 0;

            const updateCount = () => {
                current += step;
                if (current < target) {
                    counter.textContent = Math.ceil(current) + (counter.textContent.includes('+') ? '+' : '');
                    requestAnimationFrame(updateCount);
                } else {
                    counter.textContent = target + (counter.textContent.includes('+') ? '+' : '');
                }
            };

            const observer = new IntersectionObserver((entries) => {
                if (entries[0].isIntersecting) {
                    updateCount();
                    observer.unobserve(counter);
                }
            });

            observer.observe(counter);
        });

        // Smooth scrolling
        document.querySelectorAll('.scroll-link').forEach(link => {
            link.addEventListener('click', function(e) {
                e.preventDefault();
                const targetId = this.getAttribute('data-scroll-target');
                const targetElement = document.getElementById(targetId);
                if (targetElement) {
                    targetElement.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // GSAP Animations
        gsap.registerPlugin(ScrollTrigger);

        // Animate elements on scroll
        gsap.utils.toArray('.hover-lift').forEach(element => {
            gsap.from(element, {
                scrollTrigger: {
                    trigger: element,
                    start: "top 85%",
                    toggleActions: "play none none reverse"
                },
                y: 60,
                opacity: 0,
                duration: 1.2,
                ease: "power3.out"
            });
        });
    </script>

<?php
include_once includes('layouts/footer.php');
?>