<?php
$meta = array(
    'us' => array(
        'title' => 'Login - Datanito',
        'description' => 'Log in to your Datanito account. Unlock the power of web design, app development, and SEO with Datanito.',
        'og:title' => 'Login - Datanito',
        'og:description' => 'Log in to your Datanito account. Unlock the power of web design, app development, and SEO with Datanito.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Giriş - Datanito (Türkiye)',
        'description' => 'Datanito hesabınıza giriş yapın. Web tasarımı, uygulama geliştirme ve SEO\'nun gücünü Datanito ile keşfedin.',
        'og:title' => 'Giriş - Datanito (Türkiye)',
        'og:description' => 'Datanito hesabınıza giriş yapın. Web tasarımı, uygulama geliştirme ve SEO\'nun gücünü Datanito ile keşfedin.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('head.php');
?>
<script src="https://apis.google.com/js/platform.js" async defer></script>
<script>
    var googleUser = {};

    function startApp() {
        gapi.load('auth2', function(){
            // Retrieve the singleton for the GoogleAuth library and set up the client.
            auth2 = gapi.auth2.init({
                client_id: '785956734396-8lt31khafnrts92kjs755n71obneq0dn.apps.googleusercontent.com',
                cookie_policy: 'single_host_origin',
            });
            attachSignin(document.getElementById('googleAuth'));
        });
    }

    function attachSignin(element) {
        console.log(element.id);
        auth2.attachClickHandler(element, {},
            function(googleUser) {
                $("#toast-success").css("display", "flex");
                $("#toast-success").removeClass("hidden");
                $(".toast-message").text(googleUser.getBasicProfile().getName());
                $("#toast-success").removeClass("notification-closed");
                $("#toast-success svg").addClass("notification-checkmark");
                $("#toast-success").addClass("notification-opened");
                handleCredentialResponse(googleUser);
            }, function(error) {
                alert(JSON.stringify(error, undefined, 2));
            });
    }

    function handleCredentialResponse(googleUser) {
        console.log(googleUser);
        var redirectURL = '<?php echo $_SESSION['intended_destination']; ?>'
        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function() {
            if (this.readyState == 4 && this.status == 200) {
                if('success' == this.responseText) {
                    // redirect to profile page
                    setTimeout(function () {
                        $("#toast-success").addClass("notification-closed");
                        $("#toast-success").removeClass("notification-opened");
                        $("#toast-success svg").removeClass("notification-checkmark");
                        if (redirectURL) {
                            window.location.href = redirectURL;
                        } else {
                            window.location.href = "/account/overview";
                        }
                    }, 2000);
                }
            }
        };
        xhttp.open("POST", "<?php echo url('/auth/google')?>", true);
        xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        xhttp.send("response=" + googleUser.getAuthResponse().id_token);
    }

    window.onload = function () {
        google.accounts.id.initialize({
            client_id: "785956734396-8lt31khafnrts92kjs755n71obneq0dn.apps.googleusercontent.com",
        });
        google.accounts.id.prompt(); // display the One Tap dialog
    }

    window.onload = startApp; // Ensure startApp is called after the page loads
</script>

    <div id="content">
        <section class="bg-gray-50 dark:bg-dark-900 h-full">
            <div class="flex flex-col items-center justify-center px-6 py-8 mx-auto !h-screen h-full lg:py-0">
                <header class="absolute top-[20px]">
                    <a href="<?php echo url(''); ?>" class="flex items-center mb-6 text-2xl font-semibold text-dark-900 dark:text-white">
                        <svg class="w-9 h-9" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="151px" height="150px" viewBox="0 0 639 636" version="1.1">
                            <g id="surface1">
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/>
                            </g>
                        </svg>
                    </a>
                </header>
                <div id="step-1" class="w-full bg-white rounded-3xl border border-gray-200 md:mt-0 sm:max-w-md xl:p-0 dark:bg-dark-800 dark:border-dark-700 skeleton">
                    <div class="p-6 space-y-4 md:space-y-6 sm:p-8">
                        <h1 class="text-xl font-bold leading-tight tracking-tight text-dark-900 md:text-2xl dark:text-white text-center">
                            <?php echo $lang['user-login-headline'];?>
                        </h1>
                        <form id="auth-email" class="my-3" method="post" novalidate>
                            <?php set_csrf(); ?>
                            <div>
                                <div class="relative mt-4">
                                    <input type="email" id="email-input" class="block px-2.5 pb-2.5 pt-4 w-full text-sm text-dark-900 bg-transparent rounded-xl border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required/>
                                    <label for="email-input" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-white dark:bg-dark-800 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1"><?php echo $lang['user-login-email-label'];?></label>
                                </div>
                                <p id="error_step1" class="flex items-center mt-2 text-xs text-red-600 dark:text-red-400 hidden"><span class="material-symbols-outlined mx-1 font-medium">info</span><span class="font-medium response-text"></span></p>
                            </div>

                            <button type="submit" id="continue-button" class="w-full text-white hover:text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-2xl px-5 py-2.5 text-center inline-flex items-center justify-center text-[16px] py-[15px] mt-5 flex justify-between animated_btn">
                                <svg aria-hidden="true" role="status" class="inline w-4 h-4 mr-3 text-white animate-spin opacity-0" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="#E5E7EB"/>
                                    <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentColor"/>
                                </svg>
                                <?php echo $lang['user-login-continue'];?>
                                <svg aria-hidden="true" class="w-5 h-5 ml-2 -mr-1 animated_btn_arrow" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-4.293-4.293a1 1 0 010-1.414z" clip-rule="evenodd"></path></svg>
                            </button>
                            <div class="text-center mt-7">
                                <p class="text-sm font-light text-gray-500 dark:text-gray-400">
                                    <?php echo $lang['user-dont-have-account'];?> <a href="<?php echo url('/account/create'); ?>" class="font-medium text-blue-600 hover:underline dark:text-blue-500"><?php echo $lang['user-dont-have-account-signup'];?></a>
                                </p>
                            </div>
                            <div class="inline-flex items-center justify-center w-full">
                                <hr class="w-64 h-px my-6 bg-gray-200 border-0 dark:bg-gray-700">
                                <span class="absolute px-3 font-medium text-gray-800 -translate-x-1/2 bg-white left-1/2 dark:text-white dark:bg-dark-800"><?php echo $lang['user-signup-or'];?></span>
                            </div>
                            <div id="googleAuth" class="w-full text-white bg-[#050708] hover:bg-[#050708]/90 focus:ring-4 focus:outline-none focus:ring-[#050708]/50 font-medium rounded-2xl text-[16px] py-[15px] px-5 py-2.5 text-center inline-flex items-center justify-center dark:focus:ring-[#050708]/50 dark:hover:bg-[#050708]/30 mr-2 mb-2 flex justify-between animated_btn">
                                <svg width="20" xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 48 48'><defs><path id='a' d='M44.5 20H24v8.5h11.8C34.7 33.9 30.1 37 24 37c-7.2 0-13-5.8-13-13s5.8-13 13-13c3.1 0 5.9 1.1 8.1 2.9l6.4-6.4C34.6 4.1 29.6 2 24 2 11.8 2 2 11.8 2 24s9.8 22 22 22c11 0 21-8 21-22 0-1.3-.2-2.7-.5-4z'/></defs><clipPath id='b'><use xlink:href='#a' overflow='visible'/></clipPath><path clip-path='url(#b)' fill='#FBBC05' d='M0 37V11l17 13z'/><path clip-path='url(#b)' fill='#EA4335' d='M0 11l17 13 7-6.1L48 14V0H0z'/><path clip-path='url(#b)' fill='#34A853' d='M0 37l30-23 7.9 1L48 0v48H0z'/><path clip-path='url(#b)' fill='#4285F4' d='M48 48L17 24l-4-3 35-10z'/></svg></span>
                                <?php echo $lang['user-continue-google'];?>
                                <svg aria-hidden="true" class="w-5 h-5 ml-2 -mr-1 animated_btn_arrow" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-4.293-4.293a1 1 0 010-1.414z" clip-rule="evenodd"></path></svg>
                            </div>
                            <div id="name" class="font-medium text-sm ml-4"></div>
                            <script>startApp();</script>
                            <button id="google-auth" class="hidden"></button>
<!--                            <button type="button" class="w-full text-white bg-[#050708] hover:bg-[#050708]/90 focus:ring-4 focus:outline-none focus:ring-[#050708]/50 font-medium rounded-2xl text-[16px] py-[15px] px-5 py-2.5 text-center inline-flex items-center justify-center dark:focus:ring-[#050708]/50 dark:hover:bg-[#050708]/30 mr-2 mb-2 flex justify-between animated_btn">-->
<!--                                <svg class="w-5 h-5 mr-2 -ml-1" aria-hidden="true" focusable="false" data-prefix="fab" data-icon="apple" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path fill="currentColor" d="M318.7 268.7c-.2-36.7 16.4-64.4 50-84.8-18.8-26.9-47.2-41.7-84.7-44.6-35.5-2.8-74.3 20.7-88.5 20.7-15 0-49.4-19.7-76.4-19.7C63.3 141.2 4 184.8 4 273.5q0 39.3 14.4 81.2c12.8 36.7 59 126.7 107.2 125.2 25.2-.6 43-17.9 75.8-17.9 31.8 0 48.3 17.9 76.4 17.9 48.6-.7 90.4-82.5 102.6-119.3-65.2-30.7-61.7-90-61.7-91.9zm-56.6-164.2c27.3-32.4 24.8-61.9 24-72.5-24.1 1.4-52 16.4-67.9 34.9-17.5 19.8-27.8 44.3-25.6 71.9 26.1 2 49.9-11.4 69.5-34.3z"></path></svg>-->
<!--                                --><?php //echo $lang['user-continue-apple'];?>
<!--                                <svg aria-hidden="true" class="w-5 h-5 ml-2 -mr-1 animated_btn_arrow" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-4.293-4.293a1 1 0 010-1.414z" clip-rule="evenodd"></path></svg>-->
<!--                            </button>-->

                        </form>
                    </div>
                </div>
                <div id="step-2" class="w-full bg-white rounded-3xl border border-gray-200 md:mt-0 sm:max-w-md xl:p-0 dark:bg-dark-800 dark:border-dark-700" style="display: none">
                    <div class="p-6 space-y-4 md:space-y-6 sm:p-8">
                        <h1 class="text-xl font-bold leading-tight tracking-tight text-dark-900 md:text-2xl dark:text-white text-center">
                            <?php echo $lang['user-enter-password-headline'];?>
                        </h1>
                        <form id="auth-login" class="my-3" method="post" novalidate>
                            <?php set_csrf(); ?>
                            <div class="relative">
                                <input  type="text" id="email-display" class="block px-2.5 pb-2.5 pt-4 w-full text-sm text-dark-900 bg-transparent rounded-xl border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer opacity-50" disabled />
                                <label for="email-display" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-white dark:bg-dark-800 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1"><?php echo $lang['user-login-email-label'];?></label>
                                <button type="button" id="edit-button" class="text-gray-500 dark:text-gray-400"><?php echo $lang['edit']; ?></button>
                            </div>
                            <div>
                                <div class="relative mt-4">
                                    <input  type="password" id="password-input" class="block px-2.5 pb-2.5 pt-4 w-full text-sm text-dark-900 bg-transparent rounded-xl border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required/>
                                    <label for="password-input" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-white dark:bg-dark-800 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1"><?php echo $lang['user-login-password-label'];?></label>
                                    <div class="input-group-append">
                                    <span class="input-group-text password-toggle">
                                         <span class="material-symbols-outlined text-gray-500 dark:text-gray-400">
                                             visibility
                                         </span>
                                    </span>
                                    </div>
                                </div>
                                <p id="error_password" class="flex items-center mt-2 text-xs text-red-600 dark:text-red-400 hidden"><span class="material-symbols-outlined mx-1 font-medium error_icon"></span><span class="error_message font-medium"></span></p>
                            </div>

                            <div class="my-2 text-center">
                                <a href="<?php echo url('/account/reset-password'); ?>" class="text-sm font-medium text-blue-600 hover:underline dark:text-blue-500"><?php echo $lang['user-forgot-password'];?></a>
                            </div>

                            <button type="submit" id="submit-button" class="w-full text-white hover:text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-2xl px-5 py-2.5 text-center inline-flex items-center justify-center text-[16px] py-[15px] mt-5 flex justify-between animated_btn">
                                <svg aria-hidden="true" role="status" class="inline w-4 h-4 mr-3 text-white animate-spin opacity-0" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="#E5E7EB"/>
                                    <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentColor"/>
                                </svg>
                                <?php echo $lang['user-login-cta'];?>
                                <svg aria-hidden="true" class="w-5 h-5 ml-2 -mr-1 animated_btn_arrow" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-4.293-4.293a1 1 0 010-1.414z" clip-rule="evenodd"></path></svg>
                            </button>
                        </form>
                    </div>
                </div>
                <footer class="absolute bottom-[20px]">
                    <a href="<?php echo url('/legal/terms'); ?>" target="_blank" class="text-gray-500 dark:text-gray-400"><?php echo $lang['terms-of-use'];?></a> <span class="mx-1 text-gray-500 dark:text-gray-400">|</span> <a href="<?php echo url('/legal/privacy'); ?>" target="_blank" class="text-gray-500 dark:text-gray-400"><?php echo $lang['privacy-policy'];?></a>
                </footer>
            </div>
        </section>
    </div>
<?php
include_once includes('scripts.php');
?>
