<?php
$meta = array(
    'us' => array(
        'title' => 'View and Pay Invoice - Datanito',
        'description' => 'On our View and Pay Invoice page, you can review all your invoice details and make payments swiftly.',
        'og:title' => 'View and Pay Invoice - Datanito',
        'og:description' => 'On our View and Pay Invoice page, you can review all your invoice details and make payments swiftly.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Fatura Görüntüle ve Öde - Datanito (Türkiye)',
        'description' => 'Fatura Görüntüle ve Öde sayfamızda, tüm fatura detaylarınızı inceleyebilir ve hızlı bir şekilde ödeme yapabilirsiniz.',
        'og:title' => 'Fatura Görüntüle ve Öde - Datanito (Türkiye)',
        'og:description' => 'Fatura Görüntüle ve Öde sayfamızda, tüm fatura detaylarınızı inceleyebilir ve hızlı bir şekilde ödeme yapabilirsiniz.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/dashboard.php');
?>
<main class="p-4 md:pl-64 md:ml-8 md:mr-4 h-full pt-20 min-h-[70em] !overflow-hidden">
    <div class="h-full">
        <div>
            <div class="my-6 ml-5">
                <h3 class="text-2xl tracking-tight font-semibold text-gray-900 dark:text-white"><?php echo $lang['invoice-view-headline']; ?></h3>
                <h3 class="text-lg mt-2 tracking-tight font-normal text-gray-900 dark:text-white"><?php echo $lang['invoice-view-subheading']; ?></h3>
            </div>
            <div class="text-center mx-auto">
                <div role="status" class="spinner hidden my-6">
                    <svg aria-hidden="true" class="inline w-20 h-20 mr-2 text-gray-200 animate-spin dark:text-gray-600 fill-green-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                    </svg>
                    <span class="sr-only">Loading...</span>
                </div>
            </div>
            <div class="flex items-center justify-between mb-4 px-7 py-6 sm:py-4 space-y-4 md:space-y-0 rounded-3xl border border-gray-200 bg-gray-50 dark:bg-dark-700 dark:border-gray-600 skeleton">
                <span class="flex md:space-x-12 justify-between items-center">
                    <span class="text-left font-medium text-gray-900 whitespace-nowrap dark:text-white w-20 max-w-56 md:w-96">
                        <span class="font-semibold text-lg invoice_status"></span>
                    </span>
                </span>
                <span class="flex !mt-0 space-x-4 md:space-x-12 justify-between items-center">
                    <span class="flex items-center">
                        <span class="material-symbols-outlined cursor-pointer" id="download-button">download</span>
                    </span>
                    <span class="flex items-center">
                        <button type="button" data-modal-target="process-payment-modal" data-modal-toggle="process-payment-modal" class="pay-invoice text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ribg-blue-300 font-medium rounded-3xl text-sm px-5 py-2.5 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ribg-blue-800"><?php echo $lang['invoice-pay-cta']; ?></button>
                    </span>
                </span>
            </div>

        </div>
        <div class="relative overflow-x-auto skeleton block md:hidden mt-12 p-1 rounded-lg">
            <table class="w-full text-sm text-left rtl:text-right text-gray-500 dark:text-gray-400">
                <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-dark-700 dark:text-gray-400">
                <tr>
                    <td class="px-6 py-3">#</td>
                    <td class="px-6 py-3"><?php echo $lang['invoice-product-details']; ?></td>
                    <td class="px-6 py-3"><?php echo $lang['invoice-subtotal-vat']; ?></td>
                </tr>
                </thead>
                <tbody class="orders">
                </tbody>
            </table>
            <div class="flex justify-between space-x-4 p-2 py-3 bg-gray-50 dark:bg-dark-700">
                <div class="whitespace-nowrap text-black dark:text-white"><?php echo $lang['invoice-total']; ?></div>
                <div class="whitespace-nowrap font-bold text-gray-600 dark:text-gray-300 total_amount"></div>
            </div>
        </div>

        <div class="border border-gray-300 hidden md:block">
            <div id="invoice" class="show-invoice bg-white hidden overflow-x-auto">
                <div class="px-6 md:px-14 py-6">
                    <table class="w-full border-collapse border-spacing-0">
                        <tbody>
                        <tr>
                            <td class="w-full align-top">
                                <div>
                                    <svg class="h-12 w-12" xmlns="http://www.w3.org/2000/svg"
                                         xmlns:xlink="http://www.w3.org/1999/xlink" width="151px" height="150px"
                                         viewBox="0 0 639 636">
                                        <g id="surface1">
                                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                                  class="fill-dark-950"
                                                  d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/>
                                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                                  class="fill-dark-950"
                                                  d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/>
                                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                                  class="fill-dark-950"
                                                  d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/>
                                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                                  class="fill-dark-950"
                                                  d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/>
                                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                                  class="fill-dark-950"
                                                  d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/>
                                        </g>
                                    </svg>                                </div>
                            </td>

                            <td class="align-top">
                                <div class="text-sm">
                                    <table class="border-collapse border-spacing-0">
                                        <tbody>
                                        <tr>
                                            <td class="border-r pr-4">
                                                <div>
                                                    <p class="whitespace-nowrap text-slate-400 text-right"><?php echo $lang['invoice-date']; ?></p>
                                                    <p class="whitespace-nowrap text-black font-bold text-main text-right invoice_date">
                                                    </p>
                                                </div>
                                            </td>
                                            <td class="pl-4">
                                                <div>
                                                    <p class="whitespace-nowrap text-slate-400 text-right"><?php echo $lang['invoice-number']; ?></p>
                                                    <p class="whitespace-nowrap text-black font-bold text-main text-right invoice_number"></p>
                                                </div>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>

                <div class="bg-slate-100 px-14 py-6 text-sm h-36">
                    <table class="w-full border-collapse border-spacing-0">
                        <tbody>
                        <tr>
                            <td class="w-1/2 align-top">
                                <div class="text-sm text-neutral-600">

                                    <p class="font-bold"><?php echo $lang['invoice-billed-to']; ?></p>
                                    <p class="customer-name"></p>

                                    <p><?php echo $lang['invoice-datanito-id']; ?>: #<span class="profile-id"></span></p>

                                    <p class="customer-vat-on hidden"><?php echo $lang['invoice-vat']; ?>: <span class="customer-vat"></span></p>

                                    <p class="customer-address"></p>

                                    <p class="customer-address-2"></p>

                                    <p><span class="customer-city"></span><span class="customer-postcode"></span></p>

                                    <p class="customer-country"></p>
                                </div>
                                <!--                                    <p class="font-bold">DATANİTO YAZILIM TEKNOLOJİ LİMİTED ŞİRKETİ</p>-->
                                <!--                                    <p>YAKUPLU MAH. HÜRRİYET BLV. SKYPORT Skyport Residence</p>-->
                                <!--                                    <p>No:1  Kapı No:62 </p>-->
                                <!--                                    <p>BEYLİKDÜZÜ/ İstanbul / Türkiye</p>-->
                                <!--                                    <p>VKN: 2711841702</p>-->
                            </td>
                            <td class="w-1/2 align-top text-right">
                                <div class="text-sm text-neutral-600 text-right flex justify-end">
                                    <span class="font-semibold text-lg invoice_status"></span>
                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>

                <div class="px-4 md:px-14 py-10 text-sm text-neutral-700 min-h-[670px]">
                    <table class="w-full border-collapse border-spacing-0 overflow-x-scroll">
                        <thead>
                        <tr>
                            <td class="border-b-2 border-main pb-3 pl-3 font-bold">#</td>
                            <td class="border-b-2 border-main pb-3 pl-2 font-bold"><?php echo $lang['invoice-product-details']; ?></td>
                            <td class="border-b-2 border-main pb-3 pl-2 text-right font-bold"><?php echo $lang['invoice-price']; ?></td>
                            <td class="border-b-2 border-main pb-3 pl-2 text-center font-bold"><?php echo $lang['invoice-qty']; ?></td>
                            <td class="border-b-2 border-main pb-3 pl-2 text-center font-bold"><?php echo $lang['invoice-vat']; ?></td>
                            <td class="border-b-2 border-main pb-3 pl-2 text-right font-bold"><?php echo $lang['invoice-subtotal']; ?></td>
                            <td class="border-b-2 border-main pb-3 pl-2 pr-3 text-right font-bold"><?php echo $lang['invoice-subtotal-vat']; ?></td>
                        </tr>
                        </thead>
                        <tbody class="order_table">
                        </tbody>
                        <tr>
                            <td colspan="7">
                                <table class="w-full border-collapse border-spacing-0">
                                    <tbody>
                                    <tr>
                                        <td class="w-full"></td>
                                        <td>
                                            <table class="w-full border-collapse border-spacing-0">
                                                <tbody>
                                                <tr>
                                                    <td class="border-b p-3">
                                                        <div class="whitespace-nowrap text-slate-400"><?php echo $lang['invoice-net-total']; ?></div>
                                                    </td>
                                                    <td class="border-b p-3 text-right">
                                                        <div class="whitespace-nowrap font-bold text-main amount"></div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="border-b p-3">
                                                        <div class="whitespace-nowrap text-slate-400"><?php echo $lang['invoice-vat-total']; ?></div>
                                                    </td>
                                                    <td class="border-b p-3 text-right">
                                                        <div class="whitespace-nowrap font-bold text-main tax_amount"></div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="border-b p-3">
                                                        <div class="whitespace-nowrap text-slate-400"><?php echo $lang['invoice-total']; ?></div>
                                                    </td>
                                                    <td class="border-b p-3 text-right">
                                                        <div class="whitespace-nowrap font-bold text-main total_amount"></div>
                                                    </td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>

                    </table>
                </div>

                <div class="flex w-full justify-between">
                    <div class="px-14 text-sm text-neutral-700">
                        <!--                        <p class="text-main font-bold">PAYMENT DETAILS</p>-->
                        <!--                        <p>Banks of Banks</p>-->
                        <!--                        <p>Bank/Sort Code: 1234567</p>-->
                        <!--                        <p>Account Number: 123456678</p>-->
                        <!--                        <p>Payment Reference: BRA-00335</p>-->
                    </div>
                    <div class="px-14 text-sm text-neutral-700">
                        <div id="qrcode"></div>
                    </div>
                </div>

                <div class="relative px-14 py-10 text-sm text-neutral-700">
                    <!--                    <p class="text-main font-bold">Notes</p>-->
                    <!--                    <p class="italic">Lorem ipsum is placeholder text commonly used in the graphic, print, and publishing industries-->
                    <!--                        for previewing layouts and visual mockups.</p>-->
                    <!--                    </div>-->

                    <footer class="absolute right-0 bottom-0 bg-slate-100 w-full text-neutral-600 text-center text-xs py-3">
                        Datanito
                        <span class="text-slate-300 px-2">|</span>
                        info@datanito.com
                        <span class="text-slate-300 px-2">|</span>
                        datanito.com
                    </footer>
                </div>
            </div>
        </div>
        <?php set_csrf(); ?>
    </div>
    <div id="process-payment-modal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full overflow-x-hidden overflow-y-auto md:inset-0 h-[100%] max-h-full cssanimation fadeInBottom dark:!bg-dark-800/25">
        <div class="sm:relative sm:w-full sm:max-w-md sm:max-h-full fixed bottom-0 w-full">
            <!-- Modal content -->
            <div class="relative bg-white sm:rounded-3xl shadow dark:bg-dark-700 rounded-t-[2rem]">
                <button type="button" class="absolute top-3 right-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-full text-sm w-8 h-8 ml-auto inline-flex justify-center items-center dark:hover:bg-dark-600 dark:hover:text-white" data-modal-hide="process-payment-modal">
                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                    </svg>
                    <span class="sr-only">Close modal</span>
                </button>
                <!-- Modal header -->
                <div class="px-6 pt-4 pb-0 rounded-t">
                    <h3 class="flex items-center text-base font-semibold text-gray-900 lg:text-xl dark:text-white space-x-2">
                        <svg class="w-5 h-5 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 16 20">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.5 8V4.5a3.5 3.5 0 1 0-7 0V8M8 12v3M2 8h12a1 1 0 0 1 1 1v9a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V9a1 1 0 0 1 1-1Z"/>
                        </svg>
                        <span><?php echo $lang['modal-pay-headline'] ?></span>
                    </h3>
                    <span class="!flex items-center text-sm"><?php echo $lang['modal-pay-by-datanito-pay'] ?></span>
                </div>
                <!-- Modal body -->
                <div class="modal-body sm:rounded-3xl bg-gray-100 dark:bg-dark-500">
                    <div id="pay-step1">
                        <div class="block bg-white dark:bg-dark-700 p-2 space-y-2 mb-2">
                            <div class="flex justify-between space-x-4 p-2">
                                <div class="whitespace-nowrap text-black dark:text-white"><?php echo $lang['invoice-total']; ?></div>
                                <div class="whitespace-nowrap text-black dark:text-white cart-total-tax"></div>
                            </div>

                        </div>
                        <div class="bg-white dark:bg-dark-700 border-b border-gray-200 dark:border-gray-700 px-2">
                            <ul class="flex flex-wrap -mb-px text-sm font-medium text-center" id="checkoutTabs" data-tabs-toggle="#checkoutTabsContent" role="tablist">
                                <li class="mr-2" role="presentation">
                                    <button class="inline-block p-4 border-b-2 rounded-t-lg" id="saved-card-tab" data-tabs-target="#saved-card" type="button" role="tab" aria-controls="saved-card" aria-selected="false"><?php echo $lang['check-out-saved-cards'] ?></button>
                                </li>
                                <li class="mr-2" role="presentation">
                                    <button class="inline-block p-4 border-b-2 rounded-t-lg" id="add-card-tab" data-tabs-target="#add-card" type="button" role="tab" aria-controls="add-card" aria-selected="false"><?php echo $lang['check-out-add-new-card'] ?></button>
                                </li>
                            </ul>
                        </div>
                        <div class="block bg-white dark:bg-dark-700 p-2 space-y-2 h-72 md:h-96 overflow-y-auto">

                            <div id="checkoutTabsContent">
                                <div class="hidden p-1 md:p-4 rounded-lg" id="saved-card" role="tabpanel" aria-labelledby="saved-card-tab">
                                    <div role="status" class="spinner hidden my-6">
                                        <svg aria-hidden="true" class="inline w-20 h-20 mr-2 text-gray-200 animate-spin dark:text-gray-600 fill-green-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                                            <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                                        </svg>
                                        <span class="sr-only">Loading...</span>
                                    </div>
                                    <h3 class='mb-5 text-base font-semibold text-gray-600 dark:text-gray-300 px-2 pt-2'><?php echo $lang['check-out-select-card'];?></h3>
                                    <div id="saved-cards-list" class="w-full"></div>
                                </div>
                                <div class="hidden p-1 md:p-4 rounded-lg" id="add-card" role="tabpanel" aria-labelledby="add-card-tab">
                                    <h3 class='mb-5 text-base font-semibold text-gray-600 dark:text-gray-300 px-2 pt-2'><?php echo $lang['check-out-save-card-headline'] ?></h3>
                                    <form class="save-card-form space-y-2 lg:space-y-6 w-full" method="POST">
                                        <?php set_csrf(); ?>
                                        <div class="relative">
                                            <input type="text" id="card-number" name="card-number" class="block rounded-t-lg px-2.5 pb-2.5 pt-5 w-full text-sm text-gray-900 bg-gray-50 dark:bg-dark-700 border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required />
                                            <label for="card-number" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-4 z-10 origin-[0] left-2.5 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-4"><?php echo $lang['check-out-card-number'] ?></label>
                                        </div>
                                        <div class="relative grid grid-cols-2 space-y-0 space-x-3 mb-5 w-full sm:w-[70%]">
                                            <div class="relative">
                                                <select id="expiration-month" name="expiration-month" class="block rounded-t-lg w-full px-2.5 pb-2.5 pt-5 w-1/2 text-sm text-gray-900 bg-gray-50 dark:bg-dark-700 border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" required>
                                                    <option value="" disabled selected hidden>Month</option>
                                                    <?php
                                                    for ($month = 1; $month <= 12; $month++) {
                                                        $monthStr = str_pad($month, 2, '0', STR_PAD_LEFT);
                                                        echo "<option value='$monthStr'>$monthStr</option>";
                                                    }
                                                    ?>
                                                </select>
                                                <label for="expiration-month" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-4 z-10 origin-[0] left-2.5 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-4"><?php echo $lang['check-out-expiration-month'] ?></label>
                                            </div>
                                            <div class="relative">
                                                <select id="expiration-year" name="expiration-year" class="block rounded-t-lg w-full px-2.5 pb-2.5 pt-5 w-1/2 text-sm text-gray-900 bg-gray-50 dark:bg-dark-700 border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" required>
                                                    <option value="" disabled selected hidden>Year</option>
                                                    <?php
                                                    $currentYear = date('Y');
                                                    $futureYears = range($currentYear, $currentYear + 10);
                                                    foreach ($futureYears as $year) {
                                                        echo "<option value='$year'>$year</option>";
                                                    }
                                                    ?>
                                                </select>
                                                <label for="expiration-year" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-4 z-10 origin-[0] left-2.5 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-4"><?php echo $lang['check-out-expiration-year'] ?></label>
                                            </div>
                                        </div>
                                        <div class="relative">
                                            <input type="text" id="CVV" name="cvv" maxlength="3" class="block rounded-t-lg px-2.5 pb-2.5 pt-5 w-full text-sm text-gray-900 bg-gray-50 dark:bg-dark-700 border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required />
                                            <label for="CVV" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-4 z-10 origin-[0] left-2.5 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-4"><?php echo $lang['check-out-cvv'] ?></label>
                                        </div>
                                        <div class="relative">
                                            <input type="text" id="name" name="name" class="block rounded-t-lg px-2.5 pb-2.5 pt-5 w-full text-sm text-gray-900 bg-gray-50 dark:bg-dark-700 border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required />
                                            <label for="name" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-4 z-10 origin-[0] left-2.5 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-4"><?php echo $lang['check-out-holder-name'] ?></label>
                                        </div>
                                        <div class="relative hidden">
                                            <input type="text" id="honeypot" name="honeypot" value="">
                                        </div>

                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="block bg-white dark:bg-dark-700 p-2 border-t border-gray-200 dark:border-dark-500 sm:rounded-3xl !rounded-t-none">
                            <div class="pay-now">

                            </div>
                            <div>
                                <button type="submit" class="hidden save-card-info-btn flex items-center justify-center w-full h-10 text-neutral-800 bg-primary-500 hover:bg-primary-600 focus:outline-none focus:ring-4 focus:ring-primary-300 font-medium rounded-full text-sm px-5 py-2.5 text-center dark:bg-primary-500 dark:hover:bg-parimary-600 dark:focus:ring-primary-800">
                                    <span><?php echo $lang['modal-save-card-cta']?></span>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div id="pay-step2">
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php
include_once includes('layouts/dashboard-end.php');
?>
<script src="https://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js" integrity="sha512-GsLlZN/3F2ErC5ifS5QtgpiJtWd43JWSuIgh7mbzZ8zBps+dvLusV+eNQATqgA/HdeKFVgA5v3S/cIrLF7QnIg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
    $(document).ready(function () {
        getInvoice();
// Listen for the custom event triggered by the iframe
        $('body').on('tryAgainClicked', function() {
            // Perform the action you want when the "Try Again" button is clicked
            $('#process-payment-modal .modal-body #pay-step2').addClass("hidden");
            $("#process-payment-modal .modal-body #pay-step1").removeClass("hidden");
        });
        $('body').on('callbackReload', function() {
            // Perform the action you want when the "Try Again" button is clicked
            console.log('Callback Reload event received.');
            getInvoice();
        });
        $('.spinner').show();
        const invoiceStatus = $('.invoice_status');
        function getInvoice(){
            $.ajax({
                type: 'POST',
                data: {invoice_number: '<?php echo $id;?>',},
                url: '/view_invoices', // Replace with your server-side script URL
                success: function (response) {
                    $('.spinner').hide();
                    $('.show-invoice').removeClass('hidden');
                    console.log(response);
                    $('.invoice_number').text(response.invoice_number);
                    const formattedCreatedAt = formatCreatedAt(response.invoice_date);
                    $('.invoice_date').text(formattedCreatedAt);
                    $('.currency').text(response.currency);
                    $('.tax_percent').text(response.tax_percent);
                    // Check the currency and set text alignment accordingly
                    if (response.currency === ' TL') {
                        // If currency is 'TL', align the text to the right
                        $('.tax_amount').text(response.tax_amount + ' ' + response.currency);
                        $('.amount').text(response.amount + ' ' + response.currency);
                        $('.total_amount').text(response.total_amount + ' ' + response.currency);
                        var total_amount_to_pay = response.total_amount + ' ' + response.currency;
                    } else {
                        // For other currencies, align the text to the left
                        $('.tax_amount').text(response.currency + response.tax_amount);
                        $('.amount').text(response.currency + response.amount);
                        $('.total_amount').text(response.currency + response.total_amount);
                        var total_amount_to_pay = response.currency + response.total_amount;

                    }

                    let statusIndicator = '';
                    let statusColorClass = '';
                    let statusTitle = '';

                    if (response.invoice_status === 'Paid') {
                        statusIndicator = '<div class="h-2.5 w-2.5 rounded-full bg-green-500 mr-2"></div>';
                        statusColorClass = 'text-green-500 dark:text-green-400';
                        statusTitle = '<?php echo $lang['invoice-status-paid']?>';
                        $('.pay-invoice').prop('disabled', true);
                        $('.pay-invoice').addClass('cursor-not-allowed opacity-50');
                    } else if (response.invoice_status === 'Unpaid') {
                        statusIndicator = '<div class="h-2.5 w-2.5 rounded-full bg-red-500 mr-2"></div>';
                        statusColorClass = 'text-red-500 dark:text-red-400';
                        statusTitle = '<?php echo $lang['invoice-status-unpaid']?>';
                    }
                    function formatCreatedAt(created_at) {
                        const date = new Date(created_at);
                        const options = { year: 'numeric', month: 'long', day: 'numeric' };

                        <?php
                        $websiteLanguage = $_SESSION["country"];
                        if ($websiteLanguage === 'tr') {
                            echo "const formattedDate = date.toLocaleDateString('tr-TR', options);";
                        } else {
                            echo "const formattedDate = date.toLocaleDateString(undefined, options);";
                        }
                        ?>

                        return formattedDate;
                    }

                    // Display ticket details
                    invoiceStatus.html(`
                        <span class="flex items-center ${statusColorClass}">${statusIndicator} ${statusTitle}</span>
                        `);

                    const orderTable = $('.order_table');
                    const orders = $('.orders');
                    const currencySymbol = response.currency;
                    const amountToPay = '<?php echo str_replace('%d', '\' + total_amount_to_pay + \'', $lang['modal-pay-cta']); ?>';
                    $('.cart-total-tax').text(total_amount_to_pay);

                    $(".pay-now").html(`<button type="button" class="pay-now-btn flex items-center justify-between w-full h-10 text-neutral-800 bg-primary-500 hover:bg-primary-600 focus:outline-none focus:ring-4 focus:ring-primary-300 font-medium rounded-full text-sm px-5 py-2.5 text-center dark:bg-primary-500 dark:hover:bg-parimary-600 dark:focus:ring-primary-800">
                            <span>
                                <svg aria-hidden="true" class="w-6 h-6 text-gray-400 animate-spin dark:text-gray-500 fill-neutral-800 spinner-status opacity-0" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                                    <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                                </svg>
                                <span class="sr-only">Loading...</span>
                            </span>
                    <span>${amountToPay}</span>
                    <span class="w-6 h-6 opacity-0"></span>
                </button>`);
                    response.orders.forEach((order, index) => {
// Assuming 'currencySymbol' is correctly set
                        const { domain, tld } = JSON.parse(order.name);

                        orderTable.append(
                            `<tr>
        <td class="border-b py-3 pl-3">${index + 1}.</td>
        <td class="border-b py-3 pl-2">${order.product_name} ${order.order_name !== undefined ? '(' + domain + '.' + tld + ')' : ''}</td>
        <td class="border-b py-3 pl-2 text-right">${order.price}</td>
        <td class="border-b py-3 pl-2 text-center">${order.quantity}</td>
        <td class="border-b py-3 pl-2 text-center">${order.vat}%</td>
        <td class="border-b py-3 pl-2 text-right">${order.total_amount}</td>
        <td class="border-b py-3 pl-2 pr-3 text-right">${order.vat_total_amount}</td>
    </tr>`
                        );

                    });
                    response.orders.forEach((order, index) => {
                        // Assuming 'currencySymbol' is correctly set

                        // Extracting and displaying domain and tld
                        const { domain, tld } = JSON.parse(order.name);
                        orders.append(
                            `<tr class="bg-white dark:bg-dark-800">
            <td class="border-b px-6 py-4">${index + 1}.</td>
            <td class="border-b px-6 py-4">${order.product_name} (${domain}.${tld})</td>
            <td class="border-b px-6 py-4 text-right">${order.vat_total_amount}</td>
        </tr>`
                        );
                    });

                },
                error: function (error) {
                    // Handle error if needed
                    console.error(error);
                }
            });

        }
            // Generate a QR code
            var qrCode = new QRCode(document.getElementById('qrcode'), {
                text: '<?php echo url('/account/billing/invoices/'.$id);?>', // Replace with your invoice link
                width: 128,
                height: 128,
            });

            // Add the QR code to the PDF
            var qrCodeCanvas = document.getElementById('qrcode').firstChild;
        const button = document.getElementById('download-button');

        function generatePDF() {
            var invoiceToSave = document.getElementById('invoice');
            var opt = {
                margin:       0,
                filename:     '<?php echo $lang['invoice-file']; ?>-<?php echo $id?>.pdf',
                image:        { type: 'jpeg', quality: 0.98 },
                html2canvas:  { scale: 2 },
                jsPDF:        { unit: 'in', format: 'a4', orientation: 'portrait' }
            };

// New Promise-based usage:
            html2pdf().set(opt).from(invoiceToSave).save();
        }


        button.addEventListener('click', generatePDF);
        var csrf = $('input[name="csrf"]').val();

        function loadProfile() {
            $.ajax({
                type: 'POST',
                url: '/view_profile',
                dataType: 'json',
                data: {
                    csrf: csrf, // Make sure you have the 'csrf' variable defined
                },
                success: function (data) {
                    $('.spinner').hide();
                    if (data.user_username) {
                        // Populate user information into HTML elements
                        $('.customer-name').text(data.user_name);
                        $('.customer-username').text('@'+data.user_username);
                        $('.customer-email').text(data.user_email);
                        $('.profile-id').text(data.user_id);
                    } else {
                        // Handle the case where there is an error or the user is not logged in
                        $('.user-profile').html('<p>Error fetching user profile.</p>');
                    }
                },
                error: function (error) {
                    // Handle error if needed
                    $('#user-profile').html('<p>An error occurred while fetching user profile.</p>');
                }
            });
        }

        // Initial load of user profile
        loadProfile();
        $(document).ready(function () {
            function switchButton(selectedTabId) {
                if (selectedTabId === 'add-card') {
                    // Show save bank card info button
                    $('.save-card-info-btn').removeClass('hidden');
                    $('.pay-now-btn').addClass('hidden');
                } else if (selectedTabId === 'saved-card') {
                    // Show pay-now button
                    $('.pay-now-btn').removeClass('hidden');
                    $('.save-card-info-btn').addClass('hidden');
                }
            }

            // Event listener for clicking on add-card-tab
            $('#add-card-tab').on('click', function() {
                switchButton('add-card');
            });

            // Event listener for clicking on saved-card-tab
            $('#saved-card-tab').on('click', function() {
                switchButton('saved-card');
            });
            getCards();
            const loadingSpinner = $('.spinner');
            loadingSpinner.removeClass('hidden');

            // Handle form submission to save a card
            $('.save-card-info-btn').click(function () {
                // Serialize the form data, including the CSRF token
                var formData = $('.save-card-form').serialize();

                $.ajax({
                    type: 'POST',
                    url: '/save_card', // Replace with your server-side script URL
                    data: formData,
                    success: function (response) {
                        console.log(response);
                        var result = JSON.parse(response);
                        // Handle the response from the server (e.g., show success message)
                        getCards();
                        $('#saved-card-tab').trigger('click');
                        // Show a success message (you can customize this part)
                        $("#toast-success").css("display", "flex");
                        $("#toast-success").removeClass("hidden");
                        $(".toast-message").text(result.message);
                        if (result.icon === 'error') {
                            $(".notification-success").addClass("hidden");
                            $(".notification-error").removeClass("hidden");
                        }
                        $("#toast-success").addClass("notification-opened");
                        $("#toast-success svg").addClass("notification-checkmark");
                        $("#toast-success").removeClass("notification-closed");

                        // Hide the success message after 2 seconds
                        setTimeout(function () {
                            $("#toast-success").addClass("notification-closed");
                            $("#toast-success").removeClass("notification-opened");
                            $("#toast-success svg").removeClass("notification-checkmark");
                        }, 2000);
                    },
                    error: function (xhr, status, error) {
                        // Handle any errors that occur during the AJAX request
                        console.error(error);
                    }
                });
            });

            // Fetch the list of saved cards on page load
            function getCards() {
                $.ajax({
                    type: 'POST',
                    dataType: "json",
                    url: '/get_cards', // Replace with your server-side script URL
                    success: function (response) {
                        loadingSpinner.addClass('hidden');
                        const cardsContainer = $("#saved-cards-list"); // Specify the container for product cards
                        // Clear existing content in the container
                        cardsContainer.empty();

                        if (response.message) {
                            // Display the message if no cards are found
                            const message = $("<div class='text-center text-gray-700 dark:text-gray-300 mt-4'>");
                            message.text(response.message);
                            cardsContainer.append(message);
                            $('.pay-now-btn').addClass('hidden');
                        } else {
                            $.each(response, function (index, card) {
                                // Create a product card
                                const showCard = $("<div>");
                                showCard.html(`
                            <div>
                                <input type='radio' id='card-${card.cardNumber}' name='selected_card' value='${card.cardNumber}' class='hidden peer' required>
                                <label for='card-${card.cardNumber}' class='inline-flex items-center justify-between w-full p-3 md:p-5 text-gray-500 mb-4 space-y-4 space-x-4 md:space-x-5 md:space-y-0 bg-gray-50 border-2 border-gray-200 rounded-3xl dark:bg-dark-700 dark:border-dark-500 hover:bg-gray-100 dark:hover:bg-dark-600 peer-checked:border-2 peer-checked:shadow-blue-500 peer-checked:border-blue-500'>
                                    <div class='flex'>
                                        <img class='w-12 h-12 mr-4' src='${card.cardType}'>
                                        <div class='block'>
                                            <div class='w-full text-lg font-semibold text-gray-700 dark:text-gray-300'>**** **** **** ${card.lastFourDigits}</div>
                                            <div class='w-full text-gray-700 dark:text-gray-300'>${card.cardholderName}</div>
                                        </div>
                                    </div>
                                    <span class='md:flex md:space-x-12 justify-between items-center'>
                                        <p class='text-gray-700 dark:text-gray-300'>${card.expirationDate}</p>
                                    </span>
                                </label>
                            </div>
                        `);

                                cardsContainer.append(showCard);
                            });

                            // Auto-select the first card
                            const firstCardRadio = $("input[name='selected_card']:first");
                            if (firstCardRadio.length > 0) {
                                firstCardRadio.prop('checked', true).trigger('click');
                            }
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error(error);
                        loadingSpinner.addClass('hidden');
                        const cardsContainer = $("#saved-cards-list");
                        cardsContainer.empty();
                        const errorMessage = $("<div class='text-center text-red-700 dark:text-red-300 mt-4'>");
                        errorMessage.text('An error occurred while fetching your cards. Please try again.');
                        cardsContainer.append(errorMessage);
                    }
                });
            }


        });

        $(document).on('click', '.pay-now-btn', function () {
            // Collect payment data from the form
            var cardNumber = $('[name="selected_card"]:checked').val();
            var invoiceNumber = '<?php echo $id?>';
            var $button = $(this);
            var $spinner = $button.find('.spinner-status');
            $spinner.removeClass('opacity-0');
            // Create a JSON object with the payment data
            var paymentData = {
                cardNumber: cardNumber,
                invoiceNumber: invoiceNumber
            };

            // Send the payment data to the server via AJAX
            $.ajax({
                type: 'POST',
                url: '/process_payment', // Replace with the correct URL
                data: paymentData,
                success: function (response) {
                    $spinner.addClass('opacity-0');
                    console.log(response);
                    var result = JSON.parse(response);
                    $("#toast-success").css("display", "flex");
                    $("#toast-success").removeClass("hidden");
                    $(".toast-message").text(result.message);

                    if (result.icon === 'error') {
                        $(".notification-success").addClass("hidden");
                        $(".notification-error").removeClass("hidden");
                    } else {
                        // If success, show the modal with the iframe content
                        $(".notification-success").removeClass("hidden");
                        $(".notification-error").addClass("hidden");
                        $("#process-payment-modal .modal-body #pay-step1").addClass("hidden");
                        $("#process-payment-modal .modal-body #pay-step2").removeClass("hidden");
                        $('#process-payment-modal .modal-body #pay-step2').html(result.iframe);
                        localStorage.removeItem('cartItems');
                    }

                    $("#toast-success").addClass("notification-opened");
                    $("#toast-success svg").addClass("notification-checkmark");
                    $("#toast-success").removeClass("notification-closed");

                    // Hide the success message after 2 seconds
                    setTimeout(function () {
                        $("#toast-success").addClass("notification-closed");
                        $("#toast-success").removeClass("notification-opened");
                        $("#toast-success svg").removeClass("notification-checkmark");
                    }, 2000);
                },
                error: function (xhr, status, error) {
                    // Handle any errors that occur during the AJAX request
                    console.error(error);
                }
            });
        });

    });
</script>
