<?php
$meta = array(
    'us' => array(
        'title' => 'Datanito Cloud Management - Control Your Hosting Services',
        'description' => 'Effortlessly oversee web hosting and business hosting with Datanito Cloud. Discover control and flexibility for your online presence.',
        'og:title' => 'Datanito Cloud Management - Control Web Hosting and Business Hosting',
        'og:description' => 'Effortlessly oversee web hosting and business hosting with Datanito Cloud. Discover control and flexibility for your online presence.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Datanito Cloud Yönetimi - Datanito (Türkiye)',
        'description' => 'Datanito Cloud ile web hosting ve işletme hosting hizmetlerinizi kolayca yönetin. Çevrimiçi varlığınız için kontrol ve esnekliği keşfedin.',
        'og:title' => 'Datanito Cloud Yönetimi - Web Hosting ve İşletme Hosting Kontrolü',
        'og:description' => 'Datanito Cloud ile web hosting ve işletme hosting hizmetlerinizi kolayca yönetin. Çevrimiçi varlığınız için kontrol ve esnekliği keşfedin.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/dashboard.php');
?>

<main class="p-4 md:pl-64 md:ml-8 md:mr-4 h-full pt-20 min-h-[70em] !overflow-hidden">
    <!-- Premium Header with Gradient -->
    <div class="mb-8 bg-gradient-to-r from-blue-600 to-indigo-700 rounded-2xl p-6 text-white shadow-lg">
        <div class="block space-y-3 md:space-y-0 md:flex justify-between items-center">
            <div>
                <h1 class="text-3xl font-bold">Datanito Cloud Dashboard</h1>
                <p class="text-blue-100">Welcome back. Everything is running smoothly.</p>
            </div>
            <div class="flex items-center space-x-4">
                <span class="bg-white/20 p-2 rounded-full">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                    </svg>
                </span>
                <span class="text-sm font-medium">Performance: <span class="font-bold" id="serverStatus">Excellent</span></span>
            </div>
        </div>
    </div>

    <!-- Main Grid Layout -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8">
        <!-- Service Overview Card -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-sm border border-gray-100 dark:border-gray-700 p-6 transition-all hover:shadow-md">
            <div class="flex items-start justify-between">
                <div>
                    <h2 class="text-lg font-semibold text-gray-900 dark:text-white">Hosting Service</h2>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mb-4">Your current hosting plan</p>
                </div>
                <span class="material-symbols-outlined text-blue-500 bg-blue-50 dark:bg-blue-900/30 p-2 rounded-lg">dns</span>
            </div>

            <div class="space-y-4">
                <div class="flex justify-between items-center">
                    <span class="text-gray-600 dark:text-gray-300">Plan</span>
                    <span class="font-medium productName">Loading...</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-gray-600 dark:text-gray-300">Status</span>
                    <span class="productStatus">Loading...</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-gray-600 dark:text-gray-300">Domain</span>
                    <span class="font-medium text-blue-600 dark:text-blue-400 domainName">Loading...</span>
                </div>
            </div>

            <div class="mt-6 pt-4 border-t border-gray-100 dark:border-gray-700">
                <div class="flex justify-between items-center">
                    <span class="text-gray-600 dark:text-gray-300">Renewal Date</span>
                    <span class="renewDate">Loading...</span>
                </div>
                <div class="mt-2">
                    <div class="flex justify-between text-sm mb-1">
                        <span class="text-gray-600 dark:text-gray-300">Time remaining</span>
                        <span class="renewDay">Loading...</span>
                    </div>
                    <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-2">
                        <div id="renewalProgress" class="bg-blue-600 h-2 rounded-full" style="width: 75%"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Resource Usage Card -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-sm border border-gray-100 dark:border-gray-700 p-6 transition-all hover:shadow-md">
            <div class="flex items-start justify-between">
                <div>
                    <h2 class="text-lg font-semibold text-gray-900 dark:text-white">Resource Usage</h2>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mb-4">Current utilization</p>
                </div>
                <span class="material-symbols-outlined text-green-500 bg-green-50 dark:bg-green-900/30 p-2 rounded-lg">monitoring</span>
            </div>

            <div class="space-y-5">
                <!-- Disk Usage -->
                <div>
                    <div class="flex justify-between text-sm mb-1">
                        <span class="text-gray-600 dark:text-gray-300">Storage</span>
                        <span class="productStorage">Loading...</span>
                    </div>
                    <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-2">
                        <div class="bg-blue-500 h-2 rounded-full disk-usage-bar" style="width: 0%"></div>
                    </div>
                </div>

                <!-- Bandwidth -->
                <div>
                    <div class="flex justify-between text-sm mb-1">
                        <span class="text-gray-600 dark:text-gray-300">Bandwidth</span>
                        <span class="productBandwidth">Loading...</span>
                    </div>
                    <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-2">
                        <div class="bg-green-500 h-2 rounded-full bandwidth-usage-bar" style="width: 0%"></div>
                    </div>
                </div>

                <!-- CPU Load -->
                <div>
                    <div class="flex justify-between text-sm mb-1">
                        <span class="text-gray-600 dark:text-gray-300">CPU Load</span>
                        <span id="cpuLoad">Loading...</span>
                    </div>
                    <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-2">
                        <div class="bg-purple-500 h-2 rounded-full cpu-usage-bar" style="width: 0%"></div>
                    </div>
                </div>

                <!-- Memory -->
                <div>
                    <div class="flex justify-between text-sm mb-1">
                        <span class="text-gray-600 dark:text-gray-300">Memory</span>
                        <span id="memoryUsage">Loading...</span>
                    </div>
                    <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-2">
                        <div class="bg-yellow-500 h-2 rounded-full memory-usage-bar" style="width: 0%"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions Card -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-sm border border-gray-100 dark:border-gray-700 p-6 transition-all hover:shadow-md">
            <div class="flex items-start justify-between">
                <div>
                    <h2 class="text-lg font-semibold text-gray-900 dark:text-white">Quick Actions</h2>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mb-4">Manage your hosting</p>
                </div>
                <span class="material-symbols-outlined text-purple-500 bg-purple-50 dark:bg-purple-900/30 p-2 rounded-lg">bolt</span>
            </div>

            <div class="grid grid-cols-2 gap-4">
                <a id="loginBtn" class="flex flex-col items-center justify-center p-4 bg-gray-50 dark:bg-gray-700 hover:bg-gray-100 dark:hover:bg-gray-600 rounded-xl transition cursor-pointer">
                    <span class="material-symbols-outlined text-blue-500 text-3xl mb-2">folder</span>
                    <span class="text-sm font-medium text-center">cPanel</span>
                </a>

                <a href="<?php echo url('/account/billing/invoices')?>" class="flex flex-col items-center justify-center p-4 bg-gray-50 dark:bg-gray-700 hover:bg-gray-100 dark:hover:bg-gray-600 rounded-xl transition">
                    <span class="material-symbols-outlined text-green-500 text-3xl mb-2">receipt</span>
                    <span class="text-sm font-medium text-center">Invoices</span>
                </a>

                <a href="<?php echo url('/account/support/requests')?>" class="flex flex-col items-center justify-center p-4 bg-gray-50 dark:bg-gray-700 hover:bg-gray-100 dark:hover:bg-gray-600 rounded-xl transition">
                    <span class="material-symbols-outlined text-orange-500 text-3xl mb-2">support</span>
                    <span class="text-sm font-medium text-center">Support</span>
                </a>

                <a href="#" class="flex flex-col items-center justify-center p-4 bg-gray-50 dark:bg-gray-700 hover:bg-gray-100 dark:hover:bg-gray-600 rounded-xl transition">
                    <span class="material-symbols-outlined text-purple-500 text-3xl mb-2">settings</span>
                    <span class="text-sm font-medium text-center">Settings</span>
                </a>
            </div>
        </div>
    </div>

    <!-- Detailed Stats Section -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
        <!-- Website Analytics -->
        <!-- Replace the analyticsChart div with this canvas element -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-sm border border-gray-100 dark:border-gray-700 p-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white">Website Analytics</h2>
                <div class="flex items-center space-x-2">
                    <span class="material-symbols-outlined text-gray-500">query_stats</span>
                    <select class="text-sm bg-transparent border-0 focus:ring-0 text-gray-500" id="analyticsTimeRange">
                        <option value="7">Last 7 days</option>
                        <option value="30">Last 30 days</option>
                        <option value="90">Last 90 days</option>
                    </select>
                </div>
            </div>

            <!-- This is the correct canvas element for Chart.js -->
            <div class="relative h-64">
                <canvas id="analyticsChart"></canvas>
            </div>

            <div class="grid grid-cols-3 gap-4 mt-6 text-center">
                <div>
                    <p class="text-sm text-gray-500 dark:text-gray-400">Visitors</p>
                    <p class="text-xl font-semibold" id="visitorCount">0</p>
                </div>
                <div>
                    <p class="text-sm text-gray-500 dark:text-gray-400">Pageviews</p>
                    <p class="text-xl font-semibold" id="pageviewCount">0</p>
                </div>
                <div>
                    <p class="text-sm text-gray-500 dark:text-gray-400">Bandwidth</p>
                    <p class="text-xl font-semibold" id="analyticsBandwidth">0 MB</p>
                </div>
            </div>
        </div>

        <!-- Server Health -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-sm border border-gray-100 dark:border-gray-700 p-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white">Server Health</h2>
                <span class="material-symbols-outlined text-green-500 bg-green-50 dark:bg-green-900/30 p-2 rounded-lg">health_and_safety</span>
            </div>

            <div class="space-y-4">
                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-3">
                        <div class="p-2 rounded-lg bg-blue-50 dark:bg-blue-900/20">
                            <span class="material-symbols-outlined text-blue-500">dns</span>
                        </div>
                        <div>
                            <p class="font-medium">Disk Usage</p>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Space used on server</p>
                        </div>
                    </div>
                    <p class="font-mono" id="diskUsage">Loading...</p>
                </div>

                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-3">
                        <div class="p-2 rounded-lg bg-purple-50 dark:bg-purple-900/20">
                            <span class="material-symbols-outlined text-purple-500">memory</span>
                        </div>
                        <div>
                            <p class="font-medium">Inodes Used</p>
                            <p class="text-sm text-gray-500 dark:text-gray-400">File system objects</p>
                        </div>
                    </div>
                    <p class="font-mono" id="inodesUsed">Loading...</p>
                </div>

                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-3">
                        <div class="p-2 rounded-lg bg-green-50 dark:bg-green-900/20">
                            <span class="material-symbols-outlined text-green-500">database</span>
                        </div>
                        <div>
                            <p class="font-medium">Account Status</p>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Current state</p>
                        </div>
                    </div>
                    <p class="font-mono" id="accountStatus">Loading...</p>
                </div>

                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-3">
                        <div class="p-2 rounded-lg bg-yellow-50 dark:bg-yellow-900/20">
                            <span class="material-symbols-outlined text-yellow-500">mail</span>
                        </div>
                        <div>
                            <p class="font-medium">Email Accounts</p>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Configured accounts</p>
                        </div>
                    </div>
                    <p class="font-mono" id="emailAccountCount">Loading...</p>
                </div>
            </div>

            <div class="mt-6 pt-4 border-t border-gray-100 dark:border-gray-700">
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-500 dark:text-gray-400">Last updated</span>
                    <span class="text-sm" id="lastUpdatedTime">Just now</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Activity & Notifications -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Recent Activity -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-sm border border-gray-100 dark:border-gray-700 p-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white">Recent Activity</h2>
                <span class="material-symbols-outlined text-gray-500">history</span>
            </div>

            <div class="space-y-4" id="recentActivity">
                <div class="animate-pulse space-y-4">
                    <div class="flex space-x-3">
                        <div class="flex-1 space-y-2 py-1">
                            <div class="h-4 bg-gray-200 dark:bg-gray-700 rounded w-3/4"></div>
                            <div class="h-3 bg-gray-200 dark:bg-gray-700 rounded"></div>
                        </div>
                    </div>
                    <div class="flex space-x-3">
                        <div class="flex-1 space-y-2 py-1">
                            <div class="h-4 bg-gray-200 dark:bg-gray-700 rounded w-2/3"></div>
                            <div class="h-3 bg-gray-200 dark:bg-gray-700 rounded"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- System Notifications -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-sm border border-gray-100 dark:border-gray-700 p-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white">System Notifications</h2>
                <span class="material-symbols-outlined text-gray-500">notifications</span>
            </div>

            <div class="space-y-4" id="systemNotifications">
                <div class="animate-pulse space-y-4">
                    <div class="flex space-x-3">
                        <div class="flex-1 space-y-2 py-1">
                            <div class="h-4 bg-gray-200 dark:bg-gray-700 rounded w-3/4"></div>
                            <div class="h-3 bg-gray-200 dark:bg-gray-700 rounded"></div>
                        </div>
                    </div>
                    <div class="flex space-x-3">
                        <div class="flex-1 space-y-2 py-1">
                            <div class="h-4 bg-gray-200 dark:bg-gray-700 rounded w-2/3"></div>
                            <div class="h-3 bg-gray-200 dark:bg-gray-700 rounded"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Hidden result div for cPanel login -->
    <div id="result" class="hidden"></div>
</main>

<?php
include_once includes('layouts/dashboard-end.php');
?>

<!-- Include Chart.js for analytics -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
    $(document).ready(function() {
        var orderNumber = '<?php echo $id;?>';
        var cpanelUsername = 'datanito'; // Hardcoded based on your API response
        var analyticsChart = null;

        // cPanel Login Handler
        $("#loginBtn").click(function() {
            // Show loading state
            $(this).html('<span class="material-symbols-outlined text-blue-500 text-3xl mb-2 animate-spin">autorenew</span><span class="text-sm font-medium text-center">Connecting...</span>');

            $.ajax({
                url: "/host/login",
                type: "POST",
                dataType: "json",
                data: { orderNumber: orderNumber },
                success: function(response) {
                    if (response.url) {
                        window.open(response.url, '_blank');
                    } else {
                        console.error("No URL returned for cPanel login");
                    }
                    // Restore button state
                    $("#loginBtn").html('<span class="material-symbols-outlined text-blue-500 text-3xl mb-2">folder</span><span class="text-sm font-medium text-center">cPanel</span>');
                },
                error: function(xhr, status, error) {
                    console.error("Error:", error);
                    $("#result").html("An error occurred while processing your request.");
                    // Restore button state
                    $("#loginBtn").html('<span class="material-symbols-outlined text-blue-500 text-3xl mb-2">folder</span><span class="text-sm font-medium text-center">cPanel</span>');
                }
            });
        });

        // Load Product Data
        function loadProducts() {
            $.ajax({
                type: 'POST',
                url: '/fetch_product',
                dataType: 'json',
                data: { order_numbers: orderNumber },
                success: function(response) {
                    console.log('Product Data:', response);

                    if (response.length > 0) {
                        // Basic Product Info
                        $('.productName').text(response[0].name);
                        $('.domainName').text(response[0].order_name);

                        // Status with colored badge
                        let statusColorClass = '';
                        let statusTitle = '';

                        if (response[0].status === 'Active') {
                            statusColorClass = 'bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-300';
                            statusTitle = 'Active';
                        } else if (response[0].status === 'Overdue') {
                            statusColorClass = 'bg-red-100 text-red-800 dark:bg-red-900/30 dark:text-red-300';
                            statusTitle = 'Overdue';
                        } else if (response[0].status === 'Pending') {
                            statusColorClass = 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-300';
                            statusTitle = 'Pending';
                        }

                        $('.productStatus').html(`<span class="text-xs font-medium px-2.5 py-0.5 rounded-full ${statusColorClass}">${statusTitle}</span>`);

                        // Renewal information
                        function formatCreatedAt(created_at) {
                            const date = new Date(created_at);
                            const options = { year: 'numeric', month: 'long', day: 'numeric' };
                            <?php
                            $websiteLanguage = $_SESSION["country"];
                            if ($websiteLanguage === 'tr') {
                                echo "const formattedDate = date.toLocaleDateString('tr-TR', options);";
                            } else {
                                echo "const formattedDate = date.toLocaleDateString(undefined, options);";
                            }
                            ?>
                            return formattedDate;
                        }

                        const formattedCreatedAt = formatCreatedAt(response[0].renewal_date);
                        $('.renewDate').text(formattedCreatedAt);

                        // Renewal progress
                        let renewDaysText = '';
                        let renewDaysColorClass = '';
                        let progressWidth = 0;

                        if (response[0].renewal_date !== null) {
                            if (response[0].days_left > 30) {
                                progressWidth = 100 - ((response[0].days_left / 365) * 100);
                                renewDaysText = `${response[0].days_left} days remaining`;
                                renewDaysColorClass = 'text-green-600 dark:text-green-400';
                            } else if (response[0].days_left <= 30 && response[0].days_left > 7) {
                                progressWidth = 100 - ((response[0].days_left / 30) * 100);
                                renewDaysText = `${response[0].days_left} days remaining`;
                                renewDaysColorClass = 'text-blue-600 dark:text-blue-400';
                            } else if (response[0].days_left <= 7 && response[0].days_left > 3) {
                                progressWidth = 100 - ((response[0].days_left / 7) * 100);
                                renewDaysText = `${response[0].days_left} days remaining`;
                                renewDaysColorClass = 'text-yellow-600 dark:text-yellow-400';
                            } else if (response[0].days_left <= 3) {
                                progressWidth = 100 - ((response[0].days_left / 3) * 100);
                                renewDaysText = `${response[0].days_left} days remaining - Renew soon!`;
                                renewDaysColorClass = 'text-red-600 dark:text-red-400';
                            }

                            // Update progress bar
                            $('#renewalProgress').css('width', `${progressWidth}%`);
                            $('.renewDay').html(`<span class="${renewDaysColorClass} font-medium">${renewDaysText}</span>`);
                        }

                        // Now fetch server stats
                        fetchServerStats();
                        fetchRecentActivity();
                        fetchSystemNotifications();
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Product AJAX Error:", error);
                }
            });
        }

        // Fetch Server Statistics
        function fetchServerStats() {
            $.ajax({
                url: '/host/stats',
                type: 'POST',
                dataType: 'json',
                data: { orderNumber: orderNumber },
                success: function(stats) {
                    console.log('Server Stats:', stats);

                    // Update disk usage
                    if (stats.disk_used && stats.disk_limit) {
                        // For unlimited disk space, show just the used amount
                        if (stats.disk_limit === 'unlimited') {
                            $('.productStorage').text(`${stats.disk_used} GB used (Unlimited)`);
                            $('.disk-usage-bar').css('width', '10%'); // Small indicator for unlimited
                        } else {
                            const diskUsedPercent = (stats.disk_used / stats.disk_limit) * 100;
                            $('.disk-usage-bar').css('width', `${diskUsedPercent}%`);
                            $('.productStorage').text(`${stats.disk_used.toFixed(2)} GB of ${stats.disk_limit} GB used (${diskUsedPercent.toFixed(1)}%)`);

                            // Change color if over 80%
                            if (diskUsedPercent > 80) {
                                $('.disk-usage-bar').removeClass('bg-blue-500').addClass('bg-red-500');
                            }
                        }

                        $('#diskUsage').text(`${stats.disk_used} GB`);
                    }

                    // Update bandwidth
                    if (stats.bandwidth_used && stats.bandwidth_limit) {
                        if (stats.bandwidth_limit === 'unlimited') {
                            $('.productBandwidth').text(`${stats.bandwidth_used} GB used (Unlimited)`);
                            $('.bandwidth-usage-bar').css('width', '10%'); // Small indicator for unlimited
                        } else {
                            const bandwidthUsedPercent = (stats.bandwidth_used / stats.bandwidth_limit) * 100;
                            $('.bandwidth-usage-bar').css('width', `${bandwidthUsedPercent}%`);
                            $('.productBandwidth').text(`${stats.bandwidth_used.toFixed(2)} GB of ${stats.bandwidth_limit} GB used (${bandwidthUsedPercent.toFixed(1)}%)`);

                            // Change color if over 80%
                            if (bandwidthUsedPercent > 80) {
                                $('.bandwidth-usage-bar').removeClass('bg-green-500').addClass('bg-red-500');
                            }
                        }
                    }

                    // Update server health metrics from raw_data
                    if (stats.raw_data) {
                        const account = stats.raw_data;

                        // Update inodes
                        if (account.inodesused) {
                            $('#inodesUsed').text(account.inodesused);
                        }

                        // Update account status
                        if (account.suspended === 0) {
                            $('#accountStatus').html('<span class="text-green-600">Active</span>');
                        } else {
                            $('#accountStatus').html(`<span class="text-red-600">Suspended: ${account.suspendreason || 'Unknown reason'}</span>`);
                        }

                        // Update email accounts (you'll need to fetch this separately)
                        $('#emailAccountCount').text('N/A');
                    }

                    // Update last updated time
                    $('#lastUpdatedTime').text(new Date().toLocaleTimeString());

                    // Initialize analytics chart with dummy data
                    initAnalyticsChart();
                },
                error: function(xhr, status, error) {
                    console.error("Stats AJAX Error:", error);
                }
            });
        }

        // Fetch Recent Activity
        function fetchRecentActivity() {
            $.ajax({
                url: '/host/activity',
                type: 'POST',
                dataType: 'json',
                data: { username: cpanelUsername },
                success: function(activities) {
                    let activityHtml = '';

                    if (activities.length > 0) {
                        activities.forEach(activity => {
                            activityHtml += `
                        <div class="flex space-x-3">
                            <div class="flex-shrink-0">
                                <span class="material-symbols-outlined text-gray-500">${activity.icon || 'event'}</span>
                            </div>
                            <div class="min-w-0 flex-1">
                                <p class="text-sm font-medium text-gray-900 dark:text-white">${activity.title}</p>
                                <p class="text-sm text-gray-500 dark:text-gray-400">${activity.description}</p>
                                <p class="text-xs text-gray-400 dark:text-gray-500 mt-1">${activity.time}</p>
                            </div>
                        </div>
                    `;
                        });
                    } else {
                        activityHtml = '<p class="text-sm text-gray-500 dark:text-gray-400">No recent activity found</p>';
                    }

                    $('#recentActivity').html(activityHtml);
                },
                error: function(xhr, status, error) {
                    console.error("Activity AJAX Error:", error);
                    $('#recentActivity').html('<p class="text-sm text-gray-500 dark:text-gray-400">Unable to load recent activity</p>');
                }
            });
        }

        // Fetch System Notifications
        function fetchSystemNotifications() {
            $.ajax({
                url: '/host/notifications',
                type: 'POST',
                dataType: 'json',
                data: { username: cpanelUsername },
                success: function(notifications) {
                    let notificationsHtml = '';

                    if (notifications.length > 0) {
                        notifications.forEach(notification => {
                            let notificationColor = 'blue';
                            if (notification.type === 'warning') notificationColor = 'yellow';
                            if (notification.type === 'error') notificationColor = 'red';
                            if (notification.type === 'success') notificationColor = 'green';

                            notificationsHtml += `
                        <div class="flex space-x-3">
                            <div class="flex-shrink-0">
                                <span class="material-symbols-outlined text-${notificationColor}-500">${notification.icon || 'notification_important'}</span>
                            </div>
                            <div class="min-w-0 flex-1">
                                <p class="text-sm font-medium text-gray-900 dark:text-white">${notification.title}</p>
                                <p class="text-sm text-gray-500 dark:text-gray-400">${notification.message}</p>
                                <p class="text-xs text-gray-400 dark:text-gray-500 mt-1">${notification.time}</p>
                            </div>
                        </div>
                    `;
                        });
                    } else {
                        notificationsHtml = '<p class="text-sm text-gray-500 dark:text-gray-400">No new notifications</p>';
                    }

                    $('#systemNotifications').html(notificationsHtml);
                },
                error: function(xhr, status, error) {
                    console.error("Notifications AJAX Error:", error);
                    $('#systemNotifications').html('<p class="text-sm text-gray-500 dark:text-gray-400">Unable to load notifications</p>');
                }
            });
        }

// Initialize Analytics Chart
        function initAnalyticsChart() {
            const ctx = document.getElementById('analyticsChart');

            // Check if the element exists and is a canvas
            if (!ctx || !(ctx instanceof HTMLCanvasElement)) {
                console.error('Analytics chart canvas not found');
                return;
            }

            // Destroy previous chart if it exists
            if (analyticsChart) {
                analyticsChart.destroy();
            }

            // Sample data - replace with real data from your analytics API
            const labels = [];
            const visitorsData = [];
            const pageviewsData = [];

            // Generate sample data for last 7 days
            for (let i = 6; i >= 0; i--) {
                const date = new Date();
                date.setDate(date.getDate() - i);
                labels.push(date.toLocaleDateString('en-US', { weekday: 'short' }));

                visitorsData.push(Math.floor(Math.random() * 100) + 50);
                pageviewsData.push(Math.floor(Math.random() * 300) + 100);
            }

            // Calculate totals for display
            const totalVisitors = visitorsData.reduce((a, b) => a + b, 0);
            const totalPageviews = pageviewsData.reduce((a, b) => a + b, 0);
            const totalBandwidth = (totalPageviews * 0.5).toFixed(1); // Assuming 0.5MB avg page size

            $('#visitorCount').text(totalVisitors);
            $('#pageviewCount').text(totalPageviews);
            $('#analyticsBandwidth').text(`${totalBandwidth} MB`);

            // Create the chart
            analyticsChart = new Chart(ctx.getContext('2d'), {
                type: 'line',
                data: {
                    labels: labels,
                    datasets: [
                        {
                            label: 'Visitors',
                            data: visitorsData,
                            borderColor: 'rgba(59, 130, 246, 1)',
                            backgroundColor: 'rgba(59, 130, 246, 0.05)',
                            tension: 0.3,
                            fill: true,
                            borderWidth: 2,
                            pointRadius: 3,
                            pointBackgroundColor: 'rgba(59, 130, 246, 1)'
                        },
                        {
                            label: 'Pageviews',
                            data: pageviewsData,
                            borderColor: 'rgba(16, 185, 129, 1)',
                            backgroundColor: 'rgba(16, 185, 129, 0.05)',
                            tension: 0.3,
                            fill: true,
                            borderWidth: 2,
                            pointRadius: 3,
                            pointBackgroundColor: 'rgba(16, 185, 129, 1)'
                        }
                    ]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'top',
                            labels: {
                                color: '#6B7280',
                                usePointStyle: true,
                                padding: 20
                            }
                        },
                        tooltip: {
                            mode: 'index',
                            intersect: false,
                            backgroundColor: 'rgba(0, 0, 0, 0.7)',
                            titleFont: {
                                size: 14,
                                weight: 'bold'
                            },
                            bodyFont: {
                                size: 12
                            },
                            padding: 12,
                            cornerRadius: 8
                        }
                    },
                    scales: {
                        x: {
                            grid: {
                                display: false,
                                drawBorder: false
                            },
                            ticks: {
                                color: '#6B7280'
                            }
                        },
                        y: {
                            grid: {
                                color: 'rgba(229, 231, 235, 0.2)',
                                drawBorder: false
                            },
                            ticks: {
                                color: '#6B7280',
                                callback: function(value) {
                                    return value;
                                }
                            }
                        }
                    },
                    interaction: {
                        mode: 'nearest',
                        axis: 'x',
                        intersect: false
                    },
                    elements: {
                        line: {
                            tension: 0.4
                        }
                    }
                }
            });

            // Add event listener for time range changes
            $('#analyticsTimeRange').change(function() {
                updateChartData(parseInt($(this).val()));
            });
        }

        function updateChartData(days) {
            if (!analyticsChart) return;

            // Generate new data for the selected time range
            const labels = [];
            const visitorsData = [];
            const pageviewsData = [];

            for (let i = days - 1; i >= 0; i--) {
                const date = new Date();
                date.setDate(date.getDate() - i);
                labels.push(date.toLocaleDateString('en-US', { month: 'short', day: 'numeric' }));

                visitorsData.push(Math.floor(Math.random() * 100) + 50);
                pageviewsData.push(Math.floor(Math.random() * 300) + 100);
            }

            // Update chart data
            analyticsChart.data.labels = labels;
            analyticsChart.data.datasets[0].data = visitorsData;
            analyticsChart.data.datasets[1].data = pageviewsData;
            analyticsChart.update();

            // Update summary numbers
            const totalVisitors = visitorsData.reduce((a, b) => a + b, 0);
            const totalPageviews = pageviewsData.reduce((a, b) => a + b, 0);
            const totalBandwidth = (totalPageviews * 0.5).toFixed(1);

            $('#visitorCount').text(totalVisitors);
            $('#pageviewCount').text(totalPageviews);
            $('#analyticsBandwidth').text(`${totalBandwidth} MB`);
        }

        // Initial load
        loadProducts();

        // Refresh data every 5 minutes
        setInterval(function() {
            fetchServerStats();
        }, 300000);
    });
</script>