<?php
$meta = array(
    'us' => array(
        'title' => 'Dino - AI-Powered Business Automation for Growth',
        'description' => 'Meet Dino, your AI assistant, and harness the power of AI automation to grow your business. Discover how Dino can streamline your operations.',
        'og:title' => 'Dino - AI-Powered Business Automation for Growth',
        'og:description' => 'Meet Dino, your AI assistant, and harness the power of AI automation to grow your business. Discover how Dino can streamline your operations.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Dino (Türkiye) - İşletme Büyümesi İçin AI Destekli Otomasyon',
        'description' => 'Dino ile tanışın, AI asistanınız, ve işletmenizi büyütmek için AI otomasyonunun gücünü kullanın. Dino\'nun işletme operasyonlarınızı nasıl optimize edebileceğini keşfedin.',
        'og:title' => 'Dino (Türkiye) - İşletme Büyümesi İçin AI Destekli Otomasyon',
        'og:description' => 'Dino ile tanışın, AI asistanınız, ve işletmenizi büyütmek için AI otomasyonunun gücünü kullanın. Dino\'nun işletme operasyonlarınızı nasıl optimize edebileceğini keşfedin.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/dashboard.php');
?>
<link rel="stylesheet" href="<?php echo asset('css/prism.css'); ?>"/>
<style>
    .predefined-message {
        opacity: 0;
        transform: translateY(30px);
        animation: slideFromTop 0.7s ease forwards;
        animation-delay: 500ms; /* Start animation after 2 seconds */
    }

    @keyframes slideFromTop {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    .dino-ai-assistant-btn{
        display: none!important;
    }
</style>
<main class="dino-ai-conversation absolute bottom-0 right-0 w-full md:pl-64 h-full pt-14 overflow-hidden">
    <div class="relative bg-white dark:bg-dark-900 overflow-hidden pb-24 md:pb-36 !h-full !min-h-full !max-h-full">
        <div class="mx-auto max-w-screen-lg h-full p-6 pt-8 md:p-0 overflow-y-auto" id="chat-log">
            <div class="flex items-center justify-center">
                <div role="status" class="spinner hidden my-6 p-4 bg-gray-50 dark:bg-dark-700 rounded-3xl">
                    <svg aria-hidden="true" class="inline w-20 h-20 text-gray-200 animate-spin dark:text-gray-600 fill-blue-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                    </svg>
                    <span class="sr-only">Loading...</span>
                </div>
            </div>
            <div class="absolute z-10 top-4 right-2 grid grid-cols-2 flex justify-between w-full">
                <div>
                </div>
                <div class="flex justify-end">

                    <button type='button' data-modal-target='conversation-history-modal' data-modal-toggle='conversation-history-modal' class="btn-open-modal flex items-center p-2 mr-1 text-gray-500 rounded-full bg-gray-100 dark:bg-dark-500 hover:bg-gray-200 dark:text-gray-200 dark:hover:bg-dark-600">
                        <span class="material-symbols-outlined">history</span>
                    </button>
                    <a href="<?php echo url('/account/dino')?>" class="flex items-center p-2 mr-1 text-gray-500 rounded-full bg-gray-100 dark:bg-dark-500 hover:bg-gray-200 dark:text-gray-200 dark:hover:bg-dark-600">
                        <span class="material-symbols-outlined">add</span>
                    </a>
                </div>
            </div>
            <div class="w-full overflow-hidden mb-12 mx-auto max-w-screen-lg mt-4 md:mt-8 md:mt-36" id="dino-introduction">
                <h1 class="text-4xl md:text-6xl tracking-tight font-medium text-gray-900 dark:text-white magic-container">
                    <span class="magic">
                        <span class="magic-text">
                            <?php
                            $name_parts = explode(" ", $this_name);
                            $firstName = $name_parts[0];
                            echo sprintf($lang['account-dino-headline'], $firstName);
                            ?>
                        </span>
                    </span>
                </h1>
                <p class="text-4xl md:text-6xl tracking-tight font-medium text-gray-400 dark:text-gray-400 mt-1 md:mt-2 mb-8 sm:mb-12"><?php echo $lang['account-dino-subheading']; ?></p>

                <div id="dino-prompt-carousel" class="relative w-full block md:hidden my-6 z-[5]" data-carousel="slide">
                    <!-- Carousel wrapper -->
                    <div class="relative h-56 overflow-hidden rounded-3xl md:h-96">
                        <?php
                        // Shuffle the suggestions array to get random suggestions each time
                        shuffle($dinoSuggestion);

                        // Get the first four suggestions
                        $selectedSuggestions = array_slice($dinoSuggestion, 0, 4);

                        foreach ($selectedSuggestions as $item) {
                            echo '<div class="predefined-message border border-gray-200 dark:border-dark-600 dark:bg-dark-900 hover:border-gray-400 dark:hover:border-dark-500 rounded-3xl h-56 mx-auto w-[70%] p-6 cursor-pointer skeleton" data-carousel-item>';
                            echo '<p class="text-gray-800 dark:text-gray-200">' . $item['messages'] . '</p>';
                            echo '<span class="absolute bottom-2 right-2 flex items-center justify-center w-12 h-12 p-2 bg-white rounded-full bg-gray-50 dark:bg-dark-700"><span class="material-symbols-outlined text-2xl text-gray-600 dark:text-gray-400">' . $item['icon'] . '</span></span>';
                            echo '</div>';
                        }
                        ?>
                    </div>
                    <!-- Slider controls -->
                    <button type="button" class="absolute top-0 start-0 z-30 flex items-center justify-center h-full px-1 cursor-pointer group focus:outline-none" data-carousel-prev>
                            <span class="inline-flex items-center justify-center w-10 h-10 rounded-full bg-gray-200/30 dark:bg-dark-500/30 group-hover:bg-gray-200/50 dark:group-hover:bg-dark-600/60 group-focus:ring-4 group-focus:ring-white dark:group-focus:ring-gray-800/70 group-focus:outline-none">
                                <svg class="w-4 h-4 text-gray-400/50 hover:text-gray-200 dark:text-gray-400/50 hover:text-gray-400 rtl:rotate-180" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 1 1 5l4 4"/>
                                </svg>
                                <span class="sr-only">Previous</span>
                            </span>
                    </button>
                    <button type="button" class="absolute top-0 end-0 z-30 flex items-center justify-center h-full px-1 cursor-pointer group focus:outline-none" data-carousel-next>
                            <span class="inline-flex items-center justify-center w-10 h-10 rounded-full bg-gray-200/30 dark:bg-dark-500/30 group-hover:bg-gray-200/50 dark:group-hover:bg-dark-600/60 group-focus:ring-4 group-focus:ring-white dark:group-focus:ring-gray-800/70 group-focus:outline-none">
                                <svg class="w-4 h-4 text-gray-400/50 hover:text-gray-200 dark:text-gray-400/50 hover:text-gray-400 rtl:rotate-180" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 9 4-4-4-4"/>
                                </svg>
                                <span class="sr-only">Next</span>
                            </span>
                    </button>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-4 space-y-4 md:space-y-0 md:space-x-8 mt-8 w-full mx-auto max-w-screen-lg overflow-hidden hidden md:flex">
                    <?php
                    // Shuffle the suggestions array to get random suggestions each time
                    shuffle($dinoSuggestion);

                    // Get the first four suggestions
                    $selectedSuggestions = array_slice($dinoSuggestion, 0, 4);

                    foreach ($selectedSuggestions as $item) {
                        echo '<div class="predefined-message relative border border-gray-200 dark:border-dark-600 dark:bg-dark-900 hover:border-gray-400 dark:hover:border-dark-500 rounded-3xl h-56 p-6 cursor-pointer skeleton">';
                        echo '<p class="text-gray-800 dark:text-gray-200">' . $item['messages'] . '</p>';
                        echo '<span class="absolute bottom-2 right-2 flex items-center justify-center w-12 h-12 p-2 bg-white rounded-full bg-gray-50 dark:bg-dark-700"><span class="material-symbols-outlined text-2xl text-gray-600 dark:text-gray-400">' . $item['icon'] . '</span></span>';
                        echo '</div>';
                    }
                    ?>
                </div>
            </div>
        </div>

        <div class="absolute z-10 left-[50%] bottom-0 translate-x-[-50%] w-full flex items-center justify-center">
            <div class="w-full text-center">
                <div class="w-full flex justify-center items-center">
                        <div class="relative mx-auto max-w-screen-lg w-[90%] md:w-full justify-center">
                            <textarea id="prompt-textarea" tabindex="0" rows="1" class="block w-full p-4 md:p-6 pl-8 !pr-28 border-0 text-sm text-gray-900 rounded-full !text-[16px] bg-gray-100 dark:bg-dark-600 placeholder-gray-800 dark:placeholder-gray-200 dark:text-white overflow-hidden resize-none max-h-56" placeholder="<?php echo $lang['account-dino-prompt-placeholder']; ?>" required></textarea>
                            <textarea id="DinoVision" class="hidden"></textarea>
                            <div class="absolute right-2.5 bottom-1.5 md:bottom-2.5 flex items-center space-x-1 mt-0.5">
                                <div class="w-7 h-7 md:w-12 md:h-12 rounded-lg md:rounded-xl" id="imgPreview">
                                    <canvas id="canvas" class="w-7 h-7 md:w-12 md:h-12 rounded-lg md:rounded-xl hidden"></canvas>
                                    <div class="flex items-center justify-center w-7 h-7 md:w-12 md:h-12 bg-gray-300 dark:bg-dark-500 rounded-lg md:rounded-xl hidden">
                                        <div role="status" class="spinner">
                                            <svg aria-hidden="true" class="w-3 h-3 md:w-7 md:h-7 text-gray-200 animate-spin dark:text-gray-600 fill-blue-600" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                                                <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                                            </svg>
                                            <span class="sr-only">Loading...</span>
                                        </div>
                                    </div>
                                    <button id="deleteImageBtn" class="absolute top-0 left-2 md:left-8 flex items-center justify-center cursor-pointer bg-gray-300 dark:bg-dark-800 w-5 h-5 rounded-full hidden"><span class="material-symbols-outlined text-sm">close</span></button> <!-- Delete button -->
                                </div>
                            <button type="button" data-tooltip-target="tooltip-upload-image" class="flex items-center justify-center w-10 h-10 md:w-12 md:h-12 p-3 bg-transparent hover:bg-gray-200 dark:hover:bg-dark-700 rounded-full cursor-pointer">
                              <label for="DinoVisionInput" class="flex flex-col items-center justify-center w-full cursor-pointer">
                                <div class="flex flex-col items-center justify-center pt-5 pb-6">
                                  <span class="material-symbols-outlined">add_photo_alternate</span>
                                </div>
                                <input type="file" id="DinoVisionInput" accept="image/*" class="hidden" onchange="handleFiles(this.files)">
                              </label>
                            </button>
                            <div class="hidden">
                              <div id="progress" class="hidden"></div>
                              <meter max="100" id="meter" class="hidden"></meter>
                            </div>
                            <button type="submit" id="send-button" data-tooltip-target="tooltip-send-button" class="flex items-center justify-center w-10 h-10 md:w-12 md:h-12 p-3 bg-transparent hover:bg-gray-200 dark:hover:bg-dark-700 rounded-full hidden">
                              <svg class="w-5 h-5 rotate-90" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 18 20">
                                <path d="m17.914 18.594-8-18a1 1 0 0 0-1.828 0l-8 18a1 1 0 0 0 1.157 1.376L8 18.281V9a1 1 0 0 1 2 0v9.281l6.758 1.689a1 1 0 0 0 1.156-1.376Z"/>
                              </svg>
                              <span class="sr-only">Send message</span>
                            </button>
                          </div>
                        </div>
                    </div>
                <p class="text-[10px] md:text-xs font-normal text-gray-600 dark:text-gray-300 my-3"><?php echo $lang['account-dino-footer']; ?></p>
            </div>
        </div>
        <div id="tooltip-send-button" role="tooltip" class="absolute z-10 invisible inline-block px-3 py-2 text-sm font-medium text-white transition-opacity duration-300 bg-gray-900 rounded-lg shadow-sm opacity-0 tooltip dark:bg-dark-500">
            <?php echo $lang['account-dino-cta-tooltip']; ?>
            <div class="tooltip-arrow" data-popper-arrow></div>
        </div>
        <div id="tooltip-upload-image" role="tooltip" class="absolute z-10 invisible inline-block px-3 py-2 text-sm font-medium text-white transition-opacity duration-300 bg-gray-900 rounded-lg shadow-sm opacity-0 tooltip dark:bg-dark-500">
            <?php echo $lang['account-dino-upload-tooltip']; ?>
            <div class="tooltip-arrow" data-popper-arrow></div>
        </div>
    </div>
    <!-- Main modal -->
    <div id="conversation-history-modal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full overflow-x-hidden overflow-y-auto md:inset-0 h-[100%] max-h-full cssanimation fadeInBottom dark:!bg-dark-800/25">
        <div class="sm:relative sm:w-full sm:max-w-md sm:max-h-full fixed bottom-0 w-full">
            <!-- Modal content -->
            <div class="relative bg-white sm:rounded-3xl shadow dark:bg-dark-700 rounded-t-[2rem]">
                <button type="button" class="close-modal-btn absolute top-3 right-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ml-auto inline-flex justify-center items-center dark:hover:bg-dark-600 dark:hover:text-white" data-modal-hide="conversation-history-modal">
                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                    </svg>
                    <span class="sr-only">Close modal</span>
                </button>
                <!-- Modal header -->
                <div class="px-6 py-4 rounded-t sm:border-b dark:border-gray-600">
                    <h3 class="text-base font-medium text-gray-700 lg:text-lg dark:text-gray-200">
                        <?php echo $lang['account-dino-c-modal-headline']; ?>
                    </h3>
                </div>
                <!-- Modal body -->
                <div class="p-3 md:px-2 py-0.5 md:py-1">
                    <div class="p-2 my-2 md:my-4">
                        <label for="input-group-search" class="sr-only">Search</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m19 19-4-4m0-7A7 7 0 1 1 1 8a7 7 0 0 1 14 0Z"/>
                                </svg>
                            </div>
                            <input type="text" id="input-group-search" class="block w-full p-3 pl-10 text-sm text-gray-900 border border-gray-300 rounded-3xl bg-gray-50 focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-600 dark:border-dark-500 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="<?php echo $lang['account-dino-c-modal-search-placeholder']; ?>">
                        </div>
                    </div>
                    <ul id="conversationList" class="h-56 md:h-80 px-3 pb-3 overflow-y-auto text-sm text-gray-700 dark:text-gray-200 space-y-2" aria-labelledby="dropdownSelectChatButton">
                        <!-- Conversation items will be dynamically added here -->
                    </ul>
                </div>
            </div>
        </div>
    </div>
</main>
<?php
include_once includes('layouts/dashboard-end.php');
?>
<script src="<?php echo asset('js/prism.js'); ?>"></script>
<script>
    $(document).ready(function() {
        $('#prompt-textarea').on('input', function() {
            if ($(this).val().trim() !== '') {
                $('#send-button').removeClass('hidden'); // Apply the animation class
            } else {
                $('#send-button').addClass('hidden'); // Apply the animation class
            }
        });
    });
    // Assuming you have already defined src and other variables
    $('#deleteImageBtn').on('click', function() {
        $('#imgPreview').addClass('hidden'); // Remove the image preview
        $('#imgPreview canvas').addClass('hidden');
        $('#DinoVision').empty(); // Empty the DinoVision content
        $('#deleteImageBtn').addClass('hidden');
    });
</script>
<script>
    document.querySelector('input[type="file"]').onchange = function () {
        let img = this.files[0];
        let reader = new FileReader();
        reader.readAsDataURL(img);

        reader.onload = function () {
            drawImage(reader.result);
            $('#imgPreview').removeClass('hidden');
            $('#imgPreview div').removeClass('hidden');
        }
    }

    function drawImage(url) {
        let ctx = canvas.getContext('2d');
        let image = new Image();
        image.src = url;
        image.crossOrigin = "Anonymous";
        image.onload = () => {
            canvas.width = image.width;
            canvas.height = image.height;
            ctx.drawImage(image, 0, 0);

            let src = ctx.getImageData(0, 0, canvas.width, canvas.height);

            Tesseract.recognize(src).progress((p) => {
                progress.innerHTML = p.status;
                if (p.status === 'recognizing text') {
                    meter.value = p.progress * 100;
                    $('#imgPreview').removeClass('hidden');
                    $('#imgPreview div').removeClass('hidden');
                    $('#send-button').prop('disabled', true); // Disable send button during recognition
                    $('#send-button').addClass('opacity-50');
                }
            }).then((r) => {
                DinoVision.innerHTML = r.text;
                $('#imgPreview canvas').removeClass('hidden');
                $('#imgPreview div').addClass('hidden');
                $('#send-button').prop('disabled', false); // Re-enable send button after recognition completes
                $('#send-button').removeClass('opacity-50');
                $('#deleteImageBtn').removeClass('hidden');
            });
        }
    }
</script>
<script>
    (function (f) {
        if (typeof exports === "object" && typeof module !== "undefined") {
            module.exports = f()
        } else if (typeof define === "function" && define.amd) {
            define([], f)
        } else {
            var g;
            if (typeof window !== "undefined") {
                g = window
            } else if (typeof global !== "undefined") {
                g = global
            } else if (typeof self !== "undefined") {
                g = self
            } else {
                g = this
            }
            g.Tesseract = f()
        }
    })(function () {
        var define, module, exports;
        return (function e(t, n, r) {
            function s(o, u) {
                if (!n[o]) {
                    if (!t[o]) {
                        var a = typeof require == "function" && require;
                        if (!u && a) return a(o, !0);
                        if (i) return i(o, !0);
                        var f = new Error("Cannot find module '" + o + "'");
                        throw f.code = "MODULE_NOT_FOUND", f
                    }
                    var l = n[o] = {
                        exports: {}
                    };
                    t[o][0].call(l.exports, function (e) {
                        var n = t[o][1][e];
                        return s(n ? n : e)
                    }, l, l.exports, e, t, n, r)
                }
                return n[o].exports
            }
            var i = typeof require == "function" && require;
            for (var o = 0; o < r.length; o++) s(r[o]);
            return s
        })({
            1: [function (require, module, exports) {
                'use strict';
                /* eslint-disable no-unused-vars */
                var hasOwnProperty = Object.prototype.hasOwnProperty;
                var propIsEnumerable = Object.prototype.propertyIsEnumerable;

                function toObject(val) {
                    if (val === null || val === undefined) {
                        throw new TypeError('Object.assign cannot be called with null or undefined');
                    }

                    return Object(val);
                }

                function shouldUseNative() {
                    try {
                        if (!Object.assign) {
                            return false;
                        }

                        // Detect buggy property enumeration order in older V8 versions.

                        // https://bugs.chromium.org/p/v8/issues/detail?id=4118
                        var test1 = new String('abc'); // eslint-disable-line
                        test1[5] = 'de';
                        if (Object.getOwnPropertyNames(test1)[0] === '5') {
                            return false;
                        }

                        // https://bugs.chromium.org/p/v8/issues/detail?id=3056
                        var test2 = {};
                        for (var i = 0; i < 10; i++) {
                            test2['_' + String.fromCharCode(i)] = i;
                        }
                        var order2 = Object.getOwnPropertyNames(test2).map(function (n) {
                            return test2[n];
                        });
                        if (order2.join('') !== '0123456789') {
                            return false;
                        }

                        // https://bugs.chromium.org/p/v8/issues/detail?id=3056
                        var test3 = {};
                        'abcdefghijklmnopqrst'.split('').forEach(function (letter) {
                            test3[letter] = letter;
                        });
                        if (Object.keys(Object.assign({}, test3)).join('') !==
                            'abcdefghijklmnopqrst') {
                            return false;
                        }

                        return true;
                    } catch (e) {
                        // We don't expect any of the above to throw, but better to be safe.
                        return false;
                    }
                }

                module.exports = shouldUseNative() ? Object.assign : function (target, source) {
                    var from;
                    var to = toObject(target);
                    var symbols;

                    for (var s = 1; s < arguments.length; s++) {
                        from = Object(arguments[s]);

                        for (var key in from) {
                            if (hasOwnProperty.call(from, key)) {
                                to[key] = from[key];
                            }
                        }

                        if (Object.getOwnPropertySymbols) {
                            symbols = Object.getOwnPropertySymbols(from);
                            for (var i = 0; i < symbols.length; i++) {
                                if (propIsEnumerable.call(from, symbols[i])) {
                                    to[symbols[i]] = from[symbols[i]];
                                }
                            }
                        }
                    }

                    return to;
                };

            }, {}],
            2: [function (require, module, exports) {
                // shim for using process in browser
                var process = module.exports = {};

                // cached from whatever global is present so that test runners that stub it
                // don't break things.  But we need to wrap it in a try catch in case it is
                // wrapped in strict mode code which doesn't define any globals.  It's inside a
                // function because try/catches deoptimize in certain engines.

                var cachedSetTimeout;
                var cachedClearTimeout;

                function defaultSetTimout() {
                    throw new Error('setTimeout has not been defined');
                }

                function defaultClearTimeout() {
                    throw new Error('clearTimeout has not been defined');
                }
                (function () {
                    try {
                        if (typeof setTimeout === 'function') {
                            cachedSetTimeout = setTimeout;
                        } else {
                            cachedSetTimeout = defaultSetTimout;
                        }
                    } catch (e) {
                        cachedSetTimeout = defaultSetTimout;
                    }
                    try {
                        if (typeof clearTimeout === 'function') {
                            cachedClearTimeout = clearTimeout;
                        } else {
                            cachedClearTimeout = defaultClearTimeout;
                        }
                    } catch (e) {
                        cachedClearTimeout = defaultClearTimeout;
                    }
                }())

                function runTimeout(fun) {
                    if (cachedSetTimeout === setTimeout) {
                        //normal enviroments in sane situations
                        return setTimeout(fun, 0);
                    }
                    // if setTimeout wasn't available but was latter defined
                    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
                        cachedSetTimeout = setTimeout;
                        return setTimeout(fun, 0);
                    }
                    try {
                        // when when somebody has screwed with setTimeout but no I.E. maddness
                        return cachedSetTimeout(fun, 0);
                    } catch (e) {
                        try {
                            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
                            return cachedSetTimeout.call(null, fun, 0);
                        } catch (e) {
                            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
                            return cachedSetTimeout.call(this, fun, 0);
                        }
                    }


                }

                function runClearTimeout(marker) {
                    if (cachedClearTimeout === clearTimeout) {
                        //normal enviroments in sane situations
                        return clearTimeout(marker);
                    }
                    // if clearTimeout wasn't available but was latter defined
                    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
                        cachedClearTimeout = clearTimeout;
                        return clearTimeout(marker);
                    }
                    try {
                        // when when somebody has screwed with setTimeout but no I.E. maddness
                        return cachedClearTimeout(marker);
                    } catch (e) {
                        try {
                            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
                            return cachedClearTimeout.call(null, marker);
                        } catch (e) {
                            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
                            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
                            return cachedClearTimeout.call(this, marker);
                        }
                    }



                }
                var queue = [];
                var draining = false;
                var currentQueue;
                var queueIndex = -1;

                function cleanUpNextTick() {
                    if (!draining || !currentQueue) {
                        return;
                    }
                    draining = false;
                    if (currentQueue.length) {
                        queue = currentQueue.concat(queue);
                    } else {
                        queueIndex = -1;
                    }
                    if (queue.length) {
                        drainQueue();
                    }
                }

                function drainQueue() {
                    if (draining) {
                        return;
                    }
                    var timeout = runTimeout(cleanUpNextTick);
                    draining = true;

                    var len = queue.length;
                    while (len) {
                        currentQueue = queue;
                        queue = [];
                        while (++queueIndex < len) {
                            if (currentQueue) {
                                currentQueue[queueIndex].run();
                            }
                        }
                        queueIndex = -1;
                        len = queue.length;
                    }
                    currentQueue = null;
                    draining = false;
                    runClearTimeout(timeout);
                }

                process.nextTick = function (fun) {
                    var args = new Array(arguments.length - 1);
                    if (arguments.length > 1) {
                        for (var i = 1; i < arguments.length; i++) {
                            args[i - 1] = arguments[i];
                        }
                    }
                    queue.push(new Item(fun, args));
                    if (queue.length === 1 && !draining) {
                        runTimeout(drainQueue);
                    }
                };

                // v8 likes predictible objects
                function Item(fun, array) {
                    this.fun = fun;
                    this.array = array;
                }
                Item.prototype.run = function () {
                    this.fun.apply(null, this.array);
                };
                process.title = 'browser';
                process.browser = true;
                process.env = {};
                process.argv = [];
                process.version = ''; // empty string to avoid regexp issues
                process.versions = {};

                function noop() {}

                process.on = noop;
                process.addListener = noop;
                process.once = noop;
                process.off = noop;
                process.removeListener = noop;
                process.removeAllListeners = noop;
                process.emit = noop;

                process.binding = function (name) {
                    throw new Error('process.binding is not supported');
                };

                process.cwd = function () {
                    return '/'
                };
                process.chdir = function (dir) {
                    throw new Error('process.chdir is not supported');
                };
                process.umask = function () {
                    return 0;
                };

            }, {}],
            3: [function (require, module, exports) {
                module.exports = {
                    "name": "tesseract.js",
                    "version": "1.0.10",
                    "description": "Pure Javascript Multilingual OCR",
                    "main": "src/index.js",
                    "scripts": {
                        "test": "echo \"Error: no test specified\" & exit 1",
                        "start": "watchify src/index.js  -t [ envify --NODE_ENV development ] -t [ babelify --presets [ es2015 ] ] -o dist/tesseract.dev.js --standalone Tesseract & watchify src/browser/worker.js  -t [ envify --NODE_ENV development ] -t [ babelify --presets [ es2015 ] ] -o dist/worker.dev.js & http-server -p 7355",
                        "build": "browserify src/index.js -t [ babelify --presets [ es2015 ] ] -o dist/tesseract.js --standalone Tesseract && browserify src/browser/worker.js -t [ babelify --presets [ es2015 ] ] -o dist/worker.js",
                        "release": "npm run build && git commit -am 'new release' && git push && git tag `jq -r '.version' package.json` && git push origin --tags && npm publish"
                    },
                    "browser": {
                        "./src/node/index.js": "./src/browser/index.js"
                    },
                    "author": "",
                    "license": "Apache-2.0",
                    "devDependencies": {
                        "babel-preset-es2015": "^6.16.0",
                        "babelify": "^7.3.0",
                        "browserify": "^13.1.0",
                        "envify": "^3.4.1",
                        "http-server": "^0.9.0",
                        "pako": "^1.0.3",
                        "watchify": "^3.7.0"
                    },
                    "dependencies": {
                        "file-type": "^3.8.0",
                        "is-url": "^1.2.2",
                        "jpeg-js": "^0.2.0",
                        "level-js": "^2.2.4",
                        "node-fetch": "^1.6.3",
                        "object-assign": "^4.1.0",
                        "png.js": "^0.2.1",
                        "tesseract.js-core": "^1.0.2"
                    },
                    "repository": {
                        "type": "git",
                        "url": "https://github.com/naptha/tesseract.js.git"
                    },
                    "bugs": {
                        "url": "https://github.com/naptha/tesseract.js/issues"
                    },
                    "homepage": "https://github.com/naptha/tesseract.js"
                }

            }, {}],
            4: [function (require, module, exports) {
                (function (process) {
                    'use strict';

                    var defaultOptions = {
                        // workerPath: 'https://cdn.rawgit.com/naptha/tesseract.js/0.2.0/dist/worker.js',
                        corePath: 'https://cdn.rawgit.com/naptha/tesseract.js-core/0.1.0/index.js',
                        langPath: 'https://cdn.rawgit.com/naptha/tessdata/gh-pages/3.02/'
                    };

                    if (process.env.NODE_ENV === "development") {
                        console.debug('Using Development Configuration');
                        defaultOptions.workerPath = location.protocol + '//' + location.host + '/dist/worker.dev.js?nocache=' + Math.random().toString(36).slice(3);
                    } else {
                        var version = require('../../package.json').version;
                        defaultOptions.workerPath = 'https://cdn.rawgit.com/naptha/tesseract.js/' + version + '/dist/worker.js';
                    }

                    exports.defaultOptions = defaultOptions;

                    exports.spawnWorker = function spawnWorker(instance, workerOptions) {
                        if (window.Blob && window.URL) {
                            var blob = new Blob(['importScripts("' + workerOptions.workerPath + '");']);
                            var worker = new Worker(window.URL.createObjectURL(blob));
                        } else {
                            var worker = new Worker(workerOptions.workerPath);
                        }

                        worker.onmessage = function (e) {
                            var packet = e.data;
                            instance._recv(packet);
                        };
                        return worker;
                    };

                    exports.terminateWorker = function (instance) {
                        instance.worker.terminate();
                    };

                    exports.sendPacket = function sendPacket(instance, packet) {
                        loadImage(packet.payload.image, function (img) {
                            packet.payload.image = img;
                            instance.worker.postMessage(packet);
                        });
                    };

                    function loadImage(image, cb) {
                        if (typeof image === 'string') {
                            if (/^\#/.test(image)) {
                                // element css selector
                                return loadImage(document.querySelector(image), cb);
                            } else if (/(blob|data)\:/.test(image)) {
                                // data url
                                var im = new Image();
                                im.src = image;
                                im.onload = function (e) {
                                    return loadImage(im, cb);
                                };
                                return;
                            } else {
                                var xhr = new XMLHttpRequest();
                                xhr.open('GET', image, true);
                                xhr.responseType = "blob";
                                xhr.onload = function (e) {
                                    return loadImage(xhr.response, cb);
                                };
                                xhr.onerror = function (e) {
                                    if (/^https?:\/\//.test(image) && !/^https:\/\/crossorigin.me/.test(image)) {
                                        console.debug('Attempting to load image with CORS proxy');
                                        loadImage('https://crossorigin.me/' + image, cb);
                                    }
                                };
                                xhr.send(null);
                                return;
                            }
                        } else if (image instanceof File) {
                            // files
                            var fr = new FileReader();
                            fr.onload = function (e) {
                                return loadImage(fr.result, cb);
                            };
                            fr.readAsDataURL(image);
                            return;
                        } else if (image instanceof Blob) {
                            return loadImage(URL.createObjectURL(image), cb);
                        } else if (image.getContext) {
                            // canvas element
                            return loadImage(image.getContext('2d'), cb);
                        } else if (image.tagName == "IMG" || image.tagName == "VIDEO") {
                            // image element or video element
                            var c = document.createElement('canvas');
                            c.width = image.naturalWidth || image.videoWidth;
                            c.height = image.naturalHeight || image.videoHeight;
                            var ctx = c.getContext('2d');
                            ctx.drawImage(image, 0, 0);
                            return loadImage(ctx, cb);
                        } else if (image.getImageData) {
                            // canvas context
                            var data = image.getImageData(0, 0, image.canvas.width, image.canvas.height);
                            return loadImage(data, cb);
                        } else {
                            return cb(image);
                        }
                        throw new Error('Missing return in loadImage cascade');
                    }

                }).call(this, require('_process'))
            }, {
                "../../package.json": 3,
                "_process": 2
            }],
            5: [function (require, module, exports) {
                "use strict";

                // The result of dump.js is a big JSON tree
                // which can be easily serialized (for instance
                // to be sent from a webworker to the main app
                // or through Node's IPC), but we want
                // a (circular) DOM-like interface for walking
                // through the data.

                module.exports = function circularize(page) {
                    page.paragraphs = [];
                    page.lines = [];
                    page.words = [];
                    page.symbols = [];

                    page.blocks.forEach(function (block) {
                        block.page = page;

                        block.lines = [];
                        block.words = [];
                        block.symbols = [];

                        block.paragraphs.forEach(function (para) {
                            para.block = block;
                            para.page = page;

                            para.words = [];
                            para.symbols = [];

                            para.lines.forEach(function (line) {
                                line.paragraph = para;
                                line.block = block;
                                line.page = page;

                                line.symbols = [];

                                line.words.forEach(function (word) {
                                    word.line = line;
                                    word.paragraph = para;
                                    word.block = block;
                                    word.page = page;
                                    word.symbols.forEach(function (sym) {
                                        sym.word = word;
                                        sym.line = line;
                                        sym.paragraph = para;
                                        sym.block = block;
                                        sym.page = page;

                                        sym.line.symbols.push(sym);
                                        sym.paragraph.symbols.push(sym);
                                        sym.block.symbols.push(sym);
                                        sym.page.symbols.push(sym);
                                    });
                                    word.paragraph.words.push(word);
                                    word.block.words.push(word);
                                    word.page.words.push(word);
                                });
                                line.block.lines.push(line);
                                line.page.lines.push(line);
                            });
                            para.page.paragraphs.push(para);
                        });
                    });
                    return page;
                };

            }, {}],
            6: [function (require, module, exports) {
                'use strict';

                var _createClass = function () {
                    function defineProperties(target, props) {
                        for (var i = 0; i < props.length; i++) {
                            var descriptor = props[i];
                            descriptor.enumerable = descriptor.enumerable || false;
                            descriptor.configurable = true;
                            if ("value" in descriptor) descriptor.writable = true;
                            Object.defineProperty(target, descriptor.key, descriptor);
                        }
                    }
                    return function (Constructor, protoProps, staticProps) {
                        if (protoProps) defineProperties(Constructor.prototype, protoProps);
                        if (staticProps) defineProperties(Constructor, staticProps);
                        return Constructor;
                    };
                }();

                function _classCallCheck(instance, Constructor) {
                    if (!(instance instanceof Constructor)) {
                        throw new TypeError("Cannot call a class as a function");
                    }
                }

                var adapter = require('../node/index.js');

                var jobCounter = 0;

                module.exports = function () {
                    function TesseractJob(instance) {
                        _classCallCheck(this, TesseractJob);

                        this.id = 'Job-' + ++jobCounter + '-' + Math.random().toString(16).slice(3, 8);

                        this._instance = instance;
                        this._resolve = [];
                        this._reject = [];
                        this._progress = [];
                        this._finally = [];
                    }

                    _createClass(TesseractJob, [{
                        key: 'then',
                        value: function then(resolve, reject) {
                            if (this._resolve.push) {
                                this._resolve.push(resolve);
                            } else {
                                resolve(this._resolve);
                            }

                            if (reject) this.catch(reject);
                            return this;
                        }
                    }, {
                        key: 'catch',
                        value: function _catch(reject) {
                            if (this._reject.push) {
                                this._reject.push(reject);
                            } else {
                                reject(this._reject);
                            }
                            return this;
                        }
                    }, {
                        key: 'progress',
                        value: function progress(fn) {
                            this._progress.push(fn);
                            return this;
                        }
                    }, {
                        key: 'finally',
                        value: function _finally(fn) {
                            this._finally.push(fn);
                            return this;
                        }
                    }, {
                        key: '_send',
                        value: function _send(action, payload) {
                            adapter.sendPacket(this._instance, {
                                jobId: this.id,
                                action: action,
                                payload: payload
                            });
                        }
                    }, {
                        key: '_handle',
                        value: function _handle(packet) {
                            var data = packet.data;
                            var runFinallyCbs = false;

                            if (packet.status === 'resolve') {
                                if (this._resolve.length === 0) console.log(data);
                                this._resolve.forEach(function (fn) {
                                    var ret = fn(data);
                                    if (ret && typeof ret.then == 'function') {
                                        console.warn('TesseractJob instances do not chain like ES6 Promises. To convert it into a real promise, use Promise.resolve.');
                                    }
                                });
                                this._resolve = data;
                                this._instance._dequeue();
                                runFinallyCbs = true;
                            } else if (packet.status === 'reject') {
                                if (this._reject.length === 0) console.error(data);
                                this._reject.forEach(function (fn) {
                                    return fn(data);
                                });
                                this._reject = data;
                                this._instance._dequeue();
                                runFinallyCbs = true;
                            } else if (packet.status === 'progress') {
                                this._progress.forEach(function (fn) {
                                    return fn(data);
                                });
                            } else {
                                console.warn('Message type unknown', packet.status);
                            }

                            if (runFinallyCbs) {
                                this._finally.forEach(function (fn) {
                                    return fn(data);
                                });
                            }
                        }
                    }]);

                    return TesseractJob;
                }();

            }, {
                "../node/index.js": 4
            }],
            7: [function (require, module, exports) {
                'use strict';

                var _createClass = function () {
                    function defineProperties(target, props) {
                        for (var i = 0; i < props.length; i++) {
                            var descriptor = props[i];
                            descriptor.enumerable = descriptor.enumerable || false;
                            descriptor.configurable = true;
                            if ("value" in descriptor) descriptor.writable = true;
                            Object.defineProperty(target, descriptor.key, descriptor);
                        }
                    }
                    return function (Constructor, protoProps, staticProps) {
                        if (protoProps) defineProperties(Constructor.prototype, protoProps);
                        if (staticProps) defineProperties(Constructor, staticProps);
                        return Constructor;
                    };
                }();

                function _classCallCheck(instance, Constructor) {
                    if (!(instance instanceof Constructor)) {
                        throw new TypeError("Cannot call a class as a function");
                    }
                }

                var adapter = require('./node/index.js');
                var circularize = require('./common/circularize.js');
                var TesseractJob = require('./common/job');
                var objectAssign = require('object-assign');
                var version = require('../package.json').version;

                function create(workerOptions) {
                    workerOptions = workerOptions || {};
                    var worker = new TesseractWorker(objectAssign({}, adapter.defaultOptions, workerOptions));
                    worker.create = create;
                    worker.version = version;
                    return worker;
                }

                var TesseractWorker = function () {
                    function TesseractWorker(workerOptions) {
                        _classCallCheck(this, TesseractWorker);

                        this.worker = null;
                        this.workerOptions = workerOptions;
                        this._currentJob = null;
                        this._queue = [];
                    }

                    _createClass(TesseractWorker, [{
                        key: 'recognize',
                        value: function recognize(image, options) {
                            var _this = this;

                            return this._delay(function (job) {
                                if (typeof options === 'string') {
                                    options = {
                                        lang: options
                                    };
                                } else {
                                    options = options || {};
                                    options.lang = options.lang || 'eng';
                                }

                                job._send('recognize', {
                                    image: image,
                                    options: options,
                                    workerOptions: _this.workerOptions
                                });
                            });
                        }
                    }, {
                        key: 'detect',
                        value: function detect(image, options) {
                            var _this2 = this;

                            options = options || {};
                            return this._delay(function (job) {
                                job._send('detect', {
                                    image: image,
                                    options: options,
                                    workerOptions: _this2.workerOptions
                                });
                            });
                        }
                    }, {
                        key: 'terminate',
                        value: function terminate() {
                            if (this.worker) adapter.terminateWorker(this);
                            this.worker = null;
                        }
                    }, {
                        key: '_delay',
                        value: function _delay(fn) {
                            var _this3 = this;

                            if (!this.worker) this.worker = adapter.spawnWorker(this, this.workerOptions);

                            var job = new TesseractJob(this);
                            this._queue.push(function (e) {
                                _this3._queue.shift();
                                _this3._currentJob = job;
                                fn(job);
                            });
                            if (!this._currentJob) this._dequeue();
                            return job;
                        }
                    }, {
                        key: '_dequeue',
                        value: function _dequeue() {
                            this._currentJob = null;
                            if (this._queue.length > 0) {
                                this._queue[0]();
                            }
                        }
                    }, {
                        key: '_recv',
                        value: function _recv(packet) {

                            if (packet.status === 'resolve' && packet.action === 'recognize') {
                                packet.data = circularize(packet.data);
                            }

                            if (this._currentJob.id === packet.jobId) {
                                this._currentJob._handle(packet);
                            } else {
                                console.warn('Job ID ' + packet.jobId + ' not known.');
                            }
                        }
                    }]);

                    return TesseractWorker;
                }();

                var DefaultTesseract = create();

                module.exports = DefaultTesseract;

            }, {
                "../package.json": 3,
                "./common/circularize.js": 5,
                "./common/job": 6,
                "./node/index.js": 4,
                "object-assign": 1
            }]
        }, {}, [7])(7)
    });
    $(document).ready(function() {
        $('#prompt-textarea').on('input', function() {
            $(this).css('height', 'auto');

            // Calculate the number of rows
            var rows = Math.floor(this.scrollHeight / parseInt($(this).css('line-height')));

            // Conditionally set overflow-y property based on the number of rows
            if (rows > 2) {
                $(this).css('overflow-y', 'scroll');
                $(this).css('height', Math.min(this.scrollHeight, 100) + 'px');
            } else {
                $(this).css('overflow-y', 'hidden');
                $(this).css('height', 'auto');
            }
        });
    });

    $(document).ready(function () {
        // Attach click event to the dropdown button to refresh conversations
        $("#dropdownSelectChatButton").on("click", function () {
            fetchConversations();
        });

        // Attach click event to conversation list items to load messages
        $("#conversationList").on("click", "li", function () {
            var conversationId = $(this).data("conversation-id");
            chatLog.scrollTop(chatLog[0].scrollHeight);

            $(".close-modal-btn").trigger("click");
            // Remove the 'selected' class from all conversation items
            $("#conversationList li").removeClass("!bg-gray-200 dark:!bg-dark-600");

            // Remove stored color for all conversations
            $("#conversationList li").each(function () {
                var id = $(this).data("conversation-id");
                localStorage.removeItem("conversationColor_" + id);
            });

            if (conversationId) {
                // Add the 'selected' class to the clicked conversation item
                $(this).addClass("!bg-gray-200 dark:!bg-dark-600");

                // Store the selected color for the conversation
                localStorage.setItem("conversationColor_" + conversationId, $(this).attr("class"));

                // Update the URL with the selected conversation ID
                updateUrlParameter("c", conversationId);

                // Fetch conversation messages via AJAX
                fetchConversationMessages(conversationId);
            }
        });

        // Add keyup event for search input
        $("#input-group-search").on("keyup", function () {
            searchConversations($(this).val());
        });

        // Fetch and display conversations on page load
        fetchConversations();

        // Load conversation based on the URL parameter on page load
        loadConversationFromUrl();
    });

    // Function to update URL parameters
    function updateUrlParameter(key, value) {
        var url = window.location.pathname;
        var pathSegments = url.split('/');

        // Check if the 'c' parameter is already set
        var existingIndex = pathSegments.findIndex(segment => segment === 'c');
        if (existingIndex === -1) {
            // 'c' parameter not set, so add it
            pathSegments.push('c', value);
        } else {
            // 'c' parameter already set, so update its value
            pathSegments[existingIndex + 1] = value;
        }

        // Construct the new URL
        var newUrl = pathSegments.join('/');
        history.pushState({}, "", newUrl);
    }



    // Function to fetch conversations
    function fetchConversations() {
        // AJAX call to fetch conversations
        $.ajax({
            url: "/dino/fetch_conversations", // Change to the actual server-side script
            type: "POST",
            dataType: "json",
            success: function (data) {
                // Clear existing conversation list
                $("#conversationList").empty();

                if (data.length === 0) {
                    // If there are no conversations, display a message
                    $("#conversationList").append("<p>No conversations available yet.</p>");
                } else {
                    // Categorize and render conversations
                    categorizeAndRenderConversations(data);
                }
            },
            error: function (error) {
                console.error("Error fetching conversations:", error);
            }
        });
    }


    // Function to categorize and render conversations
    function categorizeAndRenderConversations(data) {
        // Get current date
        var currentDate = new Date();
        currentDate.setHours(0, 0, 0, 0); // Set time to midnight for accurate comparison

        // Separate conversations into categories
        var todayConversations = [];
        var yesterdayConversations = [];
        var previous7DaysConversations = [];
        var previous30DaysConversations = [];
        var otherMonthsConversations = [];

        // Iterate through each conversation
        data.forEach(function (conversation) {
            // Parse the last message date
            var lastMessageDate = new Date(conversation.last_message_date);
            lastMessageDate.setHours(0, 0, 0, 0); // Set time to midnight for accurate comparison

            // Calculate the difference in days between the last message date and today
            var timeDifference = Math.ceil((currentDate - lastMessageDate) / (1000 * 60 * 60 * 24));

            // Categorize conversations based on time difference
            if (timeDifference === 0) {
                todayConversations.push(conversation);
            } else if (timeDifference === 1) {
                yesterdayConversations.push(conversation);
            } else if (timeDifference <= 7) {
                previous7DaysConversations.push(conversation);
            } else if (timeDifference <= 30) {
                previous30DaysConversations.push(conversation);
            } else {
                otherMonthsConversations.push(conversation);
            }
        });

        // Render conversations with titles for categories that have conversations
        if (todayConversations.length > 0) {
            renderConversationsWithTitle("<?php echo $lang['account-dino-c-modal-today']; ?>", todayConversations);
        }

        if (yesterdayConversations.length > 0) {
            renderConversationsWithTitle("<?php echo $lang['account-dino-c-modal-yesterday']; ?>", yesterdayConversations);
        }

        if (previous7DaysConversations.length > 0) {
            renderConversationsWithTitle("<?php echo $lang['account-dino-c-modal-a-week-ago']; ?>", previous7DaysConversations);
        }

        if (previous30DaysConversations.length > 0) {
            renderConversationsWithTitle("<?php echo $lang['account-dino-c-modal-a-month-ago']; ?>", previous30DaysConversations);
        }

        if (otherMonthsConversations.length > 0) {
            renderConversationsWithTitle("<?php echo $lang['account-dino-c-modal-other-month']; ?>", otherMonthsConversations);
        }
    }

    // Function to render conversations with title
    function renderConversationsWithTitle(title, conversations) {
        // Render the title
        $("#conversationList").append(`
        <p class="text-gray-500 dark:text-gray-400 font-light mb-2 mx-2 mt-6">${title}</p>
    `);

        // Render conversations in the category
        conversations.forEach(function (conversation) {
            // Retrieve the stored color for the conversation
            var storedColor = localStorage.getItem("conversationColor_" + conversation.id);

            // Add a data-search attribute for search functionality
            $("#conversationList").append(`
            <li class="flex w-full items-center bg-white dark:bg-dark-700 hover:bg-gray-200 dark:hover:bg-dark-600 p-3 rounded-3xl cursor-pointer whitespace-nowrap ${storedColor}" data-conversation-id="${conversation.id}" data-search="${conversation.name.toLowerCase()}">
                <div class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-100 dark:bg-dark-800 rounded-full"><span class="material-symbols-outlined text-sm font-bold">chat_bubble</span></div>
                <p class="w-32 overflow-hidden overflow-ellipsis break-words">${conversation.name}</p>
            </li>
        `);

        });
    }


    // Call fetchConversations to initiate the process
    fetchConversations();


    // Function to search conversations
    function searchConversations(query) {
        query = query.toLowerCase();
        $("#conversationList li").each(function () {
            var conversationName = $(this).data("search");
            if (conversationName.includes(query)) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    }
    $(document).ready(function () {
        var url = window.location.pathname;
        var match = url.match(/\/c\/([0-9a-f-]+)$/);

        if (match) {
            var conversationIdURL = match[1];

            // Fetch conversation messages
            fetchConversationMessages(conversationIdURL);

            // Fully clear all conversationColor_ entries
            for (var i = 0; i < localStorage.length; i++) {
                var key = localStorage.key(i);
                if (key.startsWith("conversationColor_")) {
                    localStorage.removeItem(key);
                }
            }

            // Loop through each li element in the conversation list
            $("#conversationList li").each(function () {
                // Remove the 'selected' class from all conversation items
                $(this).removeClass("!bg-gray-200 dark:!bg-dark-600");
            });

            // Set the stored color for the selected conversation
            localStorage.setItem("conversationColor_" + conversationIdURL, "!bg-gray-200 dark:!bg-dark-600");

            // Add the 'selected' class to the conversation item with the specified ID
            var $conversationItem = $(`#conversationList li[data-conversation-id="${conversationIdURL}"]`);
            $conversationItem.addClass("!bg-gray-200 dark:!bg-dark-600");
        }
    });
    function setSelectedConversation() {
        var url = window.location.pathname;
        var match = url.match(/\/c\/([0-9a-f-]+)$/);

        if (match) {
            var conversationIdURL = match[1];

            // Fully clear all conversationColor_ entries
            for (var i = 0; i < localStorage.length; i++) {
                var key = localStorage.key(i);
                if (key.startsWith("conversationColor_")) {
                    localStorage.removeItem(key);
                }
            }

            // Loop through each li element in the conversation list
            $("#conversationList li").each(function () {
                // Remove the 'selected' class from all conversation items
                $(this).removeClass("!bg-gray-200 dark:!bg-dark-600");
            });

            // Set the stored color for the selected conversation
            localStorage.setItem("conversationColor_" + conversationIdURL, "!bg-gray-200 dark:!bg-dark-600");

            // Add the 'selected' class to the conversation item with the specified ID
            var $conversationItem = $(`#conversationList li[data-conversation-id="${conversationIdURL}"]`);
            $conversationItem.addClass("!bg-gray-200 dark:!bg-dark-600");
        } else {
            // URL doesn't have a UUID, clear selected conversation
            clearSelectedConversation();
        }
    }

    function clearSelectedConversation() {
        // Fully clear all conversationColor_ entries
        for (var i = 0; i < localStorage.length; i++) {
            var key = localStorage.key(i);
            if (key.startsWith("conversationColor_")) {
                localStorage.removeItem(key);
            }
        }

        // Loop through each li element in the conversation list
        $("#conversationList li").each(function () {
            // Remove the 'selected' class from all conversation items
            $(this).removeClass("!bg-gray-200 dark:!bg-dark-600");
        });

        // Remove UUID from the URL
        removeConversationIdFromUrl();
    }

    function removeConversationIdFromUrl() {
        var url = window.location.href;

        // Use a regular expression to remove the '/c/uuid' segment
        var newUrl = url.replace(/\/c\/\w+$/, '');

        // Replace the current URL without adding a new entry to the browser's history
        history.replaceState({}, '', newUrl);
    }

    setSelectedConversation();
    // Function to remove the '/c/uuid' segment from the URL on error
    function removeConversationIdFromUrlAndReload() {
        var url = new URL(window.location.href);

        // Remove the '/c/uuid' segment using a regular expression
        url.pathname = url.pathname.replace(/\/c\/[\w-]+$/, '');

        // Replace the current URL without adding a new entry to the browser's history
        history.replaceState({}, '', url.toString());

        // Reload the page using Ajax
        window.location.reload();
    }


    // Function to fetch conversation messages
    function fetchConversationMessages(conversationId) {
        // Clear existing messages in the chat log
        clearChatLog();

        // Show the spinner for 1 second
        $('.spinner').removeClass('hidden');
        $('#dino-introduction').fadeOut();
        setTimeout(function () {
            $('.spinner').addClass('hidden');

            // AJAX call to fetch conversation messages
            $.ajax({
                url: "/dino/fetch_messages", // Change to the actual server-side script
                type: "POST",
                data: { id: conversationId },
                dataType: "json",
                success: function (data) {
                    console.log(data);
                    // Handle the fetched messages, e.g., display in a chat area
                    try {
                        // Assuming data.messages is an array of messages
                        data.forEach(function (message) {
                            appendMessage(message.content, message.role, message.attachment_filename);
                            scrollToBottom();
                        });
                    } catch (error) {
                        console.error("Error processing messages:", error);
                        removeConversationIdFromUrlAndReload();
                    }
                    // Add code to display messages in the chat area
                },
                error: function (error) {
                    console.error("Error fetching messages:", error);

                }
            });
        }, 500); // Show spinner for 1 second
    }

    // Function to clear the chat log
    function clearChatLog() {
        chatLog.find('.user-message, .bot-message').remove();
    }

    function scrollToBottom() {
        var chatLog = $('#chat-log');
        chatLog.scrollTop(chatLog.prop("scrollHeight"));
    }
    setTimeout(function () {
        scrollToBottom();
    }, 1100); // Show spinner for 1 second
    // Function to load conversation from the URL parameter
    function loadConversationFromUrl() {
        var urlParams = new URLSearchParams(window.location.search);
        var initialConversationId = urlParams.get("c");

        if (initialConversationId) {
            // Remove the 'selected' class from all conversation items
            $("#conversationList li").removeClass("bg-gray-200 dark:bg-dark-600");

            // Add the 'selected' class to the conversation item with the specified ID
            var $conversationItem = $(`#conversationList li[data-conversation-id="${initialConversationId}"]`);
            $conversationItem.addClass("bg-gray-200 dark:bg-dark-600");

            // Trigger click event on the conversation item with the specified ID
            $conversationItem.trigger("click");

            // Update the conversation list with the fetched data
            $conversationItem.html(`
            <p class="w-32 overflow-hidden overflow-ellipsis break-words">${$conversationItem.data("search")}</p>
        `);
        }
    }

    var chatLog = $('#chat-log');

    // Function to append a message to the chat log
    function appendMessage(message, sender, attachment_filename) {
        const profilePic = '<?php echo $this_userAvatar?>';
        let avatar = '';

        if (sender === 'user') {
            // Check if the user is logged in and has a profile picture
            if (profilePic) {
                avatar = profilePic;
            } else {
                avatar = '<span class="material-symbols-outlined">person</span>';
            }
        } else {
            avatar = '<svg class="w-6 h-6" width="328" height="187" viewBox="0 0 650 650" fill="none" xmlns="http://www.w3.org/2000/svg"> <defs> <linearGradient id="gradient-datanito"> <stop offset="0" stop-color="#086FFF"> <animate attributeName="stop-color" values="#086FFF;#FFDDB7;#086FFF" dur="3s" repeatCount="indefinite"></animate> </stop> <stop offset="50%" stop-color="#FFDDB7"> <animate attributeName="offset" values=".5;.2;.5" dur="3.1500000000000004s" repeatCount="indefinite"></animate> </stop> <stop offset="100%" stop-color="#FFDDB7"> <animate attributeName="offset" values="1;.9;1" dur="3.1500000000000004s" repeatCount="indefinite"></animate> <animate attributeName="stop-color" values="#FFDDB7;#086FFF;#FFDDB7" dur="3.1500000000000004s" repeatCount="indefinite"></animate> </stop> <animateTransform attributeName="gradientTransform" type="rotate" from="0 .5 .5" to="360 .5 .5" dur="5.4s" repeatCount="indefinite"></animateTransform> </linearGradient> </defs> <rect x="0" y="0" width="600" height="600" fill="url(#gradient-datanito)" mask="url(#logo-datanito)"></rect> <mask id="logo-datanito"> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/> </mask> </svg>';
        }

        const className = sender === 'user' ? 'user-message bg-transparent' : 'bot-message bg-gray-50 dark:bg-dark-700';
        const classNameAvatar = sender === 'user' ? '' : 'message-avatar w-9 h-9 p-1.5 bg-black text-gray-800 dark:text-gray-200 overflow-hidden rounded-full';
        const dinoMessage = typeof message === 'object' ? JSON.stringify(message) : message;
        var escapeHtmlMessage = escapeHtml(dinoMessage);

        function escapeHtml(unsafe) {
            return unsafe
                .replace(/&/g, "&amp;")
                .replace(/</g, "&lt;")
                .replace(/>/g, "&gt;")
                .replace(/"/g, "&quot;")
                .replace(/'/g, "&#039;");
        }

// Assuming you have a function to copy text to the clipboard
        function copyToClipboard(text) {
            const textarea = document.createElement('textarea');
            textarea.value = text;
            document.body.appendChild(textarea);
            textarea.select();
            document.execCommand('copy');
            document.body.removeChild(textarea);
        }

        const regexCodeBlock = /```(\w+)\s*([\s\S]+?)```/g;
        const regexHeading = /\*\*(.*?)\*\*/g;

// Replace code blocks and headings
        formattedMessage = escapeHtmlMessage.replace(regexCodeBlock, (match, language, code) => {
            // Create a temporary element to insert the code block
            const tempElement = document.createElement('div');
            tempElement.innerHTML = `<div class="relative flex w-full codebox">
        <div class="grid !bg-black rounded-2xl">
            <div class="flex items-center relative text-gray-200 bg-dark-600 dark:bg-dark-600 px-4 py-2 text-xs font-sans justify-between rounded-t-2xl">
                <span>${language}</span>
                <button class="flex gap-1 items-center copy-code-btn"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-sm"><path fill-rule="evenodd" clip-rule="evenodd" d="M12 4C10.8954 4 10 4.89543 10 6H14C14 4.89543 13.1046 4 12 4ZM8.53513 4C9.22675 2.8044 10.5194 2 12 2C13.4806 2 14.7733 2.8044 15.4649 4H17C18.6569 4 20 5.34315 20 7V19C20 20.6569 18.6569 22 17 22H7C5.34315 22 4 20.6569 4 19V7C4 5.34315 5.34315 4 7 4H8.53513ZM8 6H7C6.44772 6 6 6.44772 6 7V19C6 19.5523 6.44772 20 7 20H17C17.5523 20 18 19.5523 18 19V7C18 6.44772 17.5523 6 17 6H16C16 7.10457 15.1046 8 14 8H10C8.89543 8 8 7.10457 8 6Z" fill="currentColor"></path></svg><?php echo $lang['account-dino-copy-code']; ?></button>
            </div>
            <div class="p-4 overflow-y-auto"><pre class="language-${language} !bg-black !p-0"><code class="language-${language} block w-full">${code}</code></pre></div>
        </div>
    </div>`;

            // Get the code block element within the temporary element
            const codeElement = tempElement.querySelector('code');

            // Highlight the code block
            Prism.highlightElement(codeElement);

            // Return the HTML content of the temporary element
            return tempElement.innerHTML;
        }).replace(regexHeading, (match, content) => {
            return `<h3 class="inline text-base">${content}</h3>`;
        });



// Use formattedMessage in your further code
        const messageContainer = `
    <div class="${className} text-left text-sm py-10 px-4 mb-4 rounded-3xl">
        <div class="block">
            <div class="flex items-center space-x-2">
                <div class="message-avatar ${classNameAvatar}">${avatar}</div>
                <div class="font-extrabold">${sender === 'user' ? '<?php echo $lang['account-dino-user']; ?>' : '<?php echo $lang['account-dino-ai-assistant']; ?>'}</div>
            </div>
        </div>
        <pre class="message-content prose max-w-none dark:prose-invert prose-img:rounded-xl prose-a:text-blue-500 font-medium mt-4 md:mt-0 md:ml-12">${formattedMessage}</pre>
                                ${attachment_filename ? `
                                    <img src="<?php echo asset('uploads/dino/${attachment_filename}'); ?>" class="rounded-2xl w-36 h-36 mt-12 ml-6 object-cover border border-gray-200 dark:border-dark-500">
                              ` : ''}
    </div>
`;


        $(document).on('click', '.copy-code-btn', function() {
            const button = $(this);
            const originalContent = button.html();

            const codeElement = button.closest('.copy-code-btn').parent().next().find('code');
            const codeText = codeElement.text();
            copyToClipboard(codeText);

            // Change button content to "Copied"
            button.html('<button class="flex gap-1 items-center"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-sm"><path fill-rule="evenodd" clip-rule="evenodd" d="M18.0633 5.67375C18.5196 5.98487 18.6374 6.607 18.3262 7.06331L10.8262 18.0633C10.6585 18.3093 10.3898 18.4678 10.0934 18.4956C9.79688 18.5234 9.50345 18.4176 9.29289 18.2071L4.79289 13.7071C4.40237 13.3166 4.40237 12.6834 4.79289 12.2929C5.18342 11.9023 5.81658 11.9023 6.20711 12.2929L9.85368 15.9394L16.6738 5.93664C16.9849 5.48033 17.607 5.36263 18.0633 5.67375Z" fill="currentColor"></path></svg><?php echo $lang['account-dino-code-copied']; ?></button>');

            // Restore original content after 2 seconds
            setTimeout(function() {
                button.html('<button class="flex gap-1 items-center copy-code-btn"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-sm"><path fill-rule="evenodd" clip-rule="evenodd" d="M12 4C10.8954 4 10 4.89543 10 6H14C14 4.89543 13.1046 4 12 4ZM8.53513 4C9.22675 2.8044 10.5194 2 12 2C13.4806 2 14.7733 2.8044 15.4649 4H17C18.6569 4 20 5.34315 20 7V19C20 20.6569 18.6569 22 17 22H7C5.34315 22 4 20.6569 4 19V7C4 5.34315 5.34315 4 7 4H8.53513ZM8 6H7C6.44772 6 6 6.44772 6 7V19C6 19.5523 6.44772 20 7 20H17C17.5523 20 18 19.5523 18 19V7C18 6.44772 17.5523 6 17 6H16C16 7.10457 15.1046 8 14 8H10C8.89543 8 8 7.10457 8 6Z" fill="currentColor"></path></svg><?php echo $lang['account-dino-copy-code']; ?></button>');
            }, 2000);
        });


        chatLog.append(messageContainer);
        chatLog.scrollTop(chatLog[0].scrollHeight);
    }

    $(document).ready(function() {
        var chatLog = $('#chat-log');
        var sendButton = $('#send-button');
        var userInput = $('#prompt-textarea');

        // Function to append a message to the chat log
        function appendMessage(message, sender, savedImagesHtml) {
            const profilePic = '<?php echo $this_userAvatar?>';
            let avatar = '';

            if (sender === 'user') {
                // Check if the user is logged in and has a profile picture
                if (profilePic) {
                    avatar = profilePic;
                } else {
                    avatar = '<span class="material-symbols-outlined">person</span>';
                }
            } else {
                avatar = '<svg class="w-6 h-6" width="328" height="187" viewBox="0 0 650 650" fill="none" xmlns="http://www.w3.org/2000/svg"> <defs> <linearGradient id="gradient-datanito"> <stop offset="0" stop-color="#086FFF"> <animate attributeName="stop-color" values="#086FFF;#FFDDB7;#086FFF" dur="3s" repeatCount="indefinite"></animate> </stop> <stop offset="50%" stop-color="#FFDDB7"> <animate attributeName="offset" values=".5;.2;.5" dur="3.1500000000000004s" repeatCount="indefinite"></animate> </stop> <stop offset="100%" stop-color="#FFDDB7"> <animate attributeName="offset" values="1;.9;1" dur="3.1500000000000004s" repeatCount="indefinite"></animate> <animate attributeName="stop-color" values="#FFDDB7;#086FFF;#FFDDB7" dur="3.1500000000000004s" repeatCount="indefinite"></animate> </stop> <animateTransform attributeName="gradientTransform" type="rotate" from="0 .5 .5" to="360 .5 .5" dur="5.4s" repeatCount="indefinite"></animateTransform> </linearGradient> </defs> <rect x="0" y="0" width="600" height="600" fill="url(#gradient-datanito)" mask="url(#logo-datanito)"></rect> <mask id="logo-datanito"> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/> </mask> </svg>';
            }

            const className = sender === 'user' ? 'user-message bg-transparent' : 'bot-message bg-gray-50 dark:bg-dark-700';
            const classNameAvatar = sender === 'user' ? '' : 'message-avatar w-9 h-9 p-1.5 bg-black text-gray-800 dark:text-gray-200 overflow-hidden rounded-full';
            const dinoMessage = typeof message === 'object' ? JSON.stringify(message) : message;

// Assuming you have a function to copy text to the clipboard
            function copyToClipboard(text) {
                const textarea = document.createElement('textarea');
                textarea.value = text;
                document.body.appendChild(textarea);
                textarea.select();
                document.execCommand('copy');
                document.body.removeChild(textarea);
            }

            const regexCodeBlock = /```(\w+)\s*([\s\S]+?)```/g;
            const regexHeading = /\*\*(.*?)\*\*/g;

// Replace code blocks and headings
            formattedMessage = dinoMessage.replace(regexCodeBlock, (match, language, code) => {
                // Escape HTML entities in the code block
                const escapedCode = document.createElement('div');
                escapedCode.textContent = code;

                // Use Prism to highlight the code
                const codeElement = document.createElement('code');
                codeElement.className = `language-${language}`;
                codeElement.textContent = escapedCode.textContent;

                const preElement = document.createElement('pre');
                preElement.className = '!bg-black !p-0'; // Add the bg-black class here
                preElement.appendChild(codeElement);

                // Append the preElement to the escapedCode container
                escapedCode.innerHTML = '';
                escapedCode.appendChild(preElement);

                // Use Prism to highlight the code element
                Prism.highlightElement(codeElement);

                return `<div class="relative w-full">
                <div class="grid !bg-black rounded-2xl">
                    <div class="flex items-center relative text-gray-200 bg-dark-600 dark:bg-dark-600 px-4 py-2 text-xs font-sans justify-between rounded-t-2xl">
                        <span>${language}</span>
                        <button class="flex gap-1 items-center copy-code-btn"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-sm"><path fill-rule="evenodd" clip-rule="evenodd" d="M12 4C10.8954 4 10 4.89543 10 6H14C14 4.89543 13.1046 4 12 4ZM8.53513 4C9.22675 2.8044 10.5194 2 12 2C13.4806 2 14.7733 2.8044 15.4649 4H17C18.6569 4 20 5.34315 20 7V19C20 20.6569 18.6569 22 17 22H7C5.34315 22 4 20.6569 4 19V7C4 5.34315 5.34315 4 7 4H8.53513ZM8 6H7C6.44772 6 6 6.44772 6 7V19C6 19.5523 6.44772 20 7 20H17C17.5523 20 18 19.5523 18 19V7C18 6.44772 17.5523 6 17 6H16C16 7.10457 15.1046 8 14 8H10C8.89543 8 8 7.10457 8 6Z" fill="currentColor"></path></svg><?php echo $lang['account-dino-copy-code']; ?></button>
                    </div>
                    <div class="p-4 overflow-y-auto">${escapedCode.outerHTML}</div>
                </div>
            </div>`;
            }).replace(regexHeading, (match, content) => {
                return `<h3 class="inline text-base">${content}</h3>`;
            });


            var escapeHtmlMessage = escapeHtml(formattedMessage);
            formattedMessage = sender === 'user' ?  escapeHtmlMessage : formattedMessage;

            function escapeHtml(unsafe) {
                return unsafe
                    .replace(/&/g, "&amp;")
                    .replace(/</g, "&lt;")
                    .replace(/>/g, "&gt;")
                    .replace(/"/g, "&quot;")
                    .replace(/'/g, "&#039;");
            }

// Use formattedMessage in your further code
            const messageContainer = `
    <div class="${className} text-left text-sm py-10 px-4 mb-4 rounded-3xl">
        <div class="block">
            <div class="flex items-center space-x-2">
                <div class="message-avatar ${classNameAvatar}">${avatar}</div>
                <div class="font-extrabold">${sender === 'user' ? '<?php echo $lang['account-dino-user']; ?>' : '<?php echo $lang['account-dino-ai-assistant']; ?>'}</div>
            </div>
        </div>
        <pre class="message-content prose max-w-none dark:prose-invert prose-img:rounded-xl prose-a:text-blue-500 font-medium mt-4 md:mt-0 md:ml-12">${formattedMessage}</pre>
<div>${savedImagesHtml}</div>
    </div>
`;
            $(document).on('click', '.copy-code-btn', function() {
                const button = $(this);
                const originalContent = button.html();

                const codeElement = button.closest('.copy-code-btn').parent().next().find('code');
                const codeText = codeElement.text();
                copyToClipboard(codeText);

                // Change button content to "Copied"
                button.html('<button class="flex gap-1 items-center"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-sm"><path fill-rule="evenodd" clip-rule="evenodd" d="M18.0633 5.67375C18.5196 5.98487 18.6374 6.607 18.3262 7.06331L10.8262 18.0633C10.6585 18.3093 10.3898 18.4678 10.0934 18.4956C9.79688 18.5234 9.50345 18.4176 9.29289 18.2071L4.79289 13.7071C4.40237 13.3166 4.40237 12.6834 4.79289 12.2929C5.18342 11.9023 5.81658 11.9023 6.20711 12.2929L9.85368 15.9394L16.6738 5.93664C16.9849 5.48033 17.607 5.36263 18.0633 5.67375Z" fill="currentColor"></path></svg><?php echo $lang['account-dino-code-copied']; ?></button>');

                // Restore original content after 2 seconds
                setTimeout(function() {
                    button.html('<button class="flex gap-1 items-center copy-code-btn"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-sm"><path fill-rule="evenodd" clip-rule="evenodd" d="M12 4C10.8954 4 10 4.89543 10 6H14C14 4.89543 13.1046 4 12 4ZM8.53513 4C9.22675 2.8044 10.5194 2 12 2C13.4806 2 14.7733 2.8044 15.4649 4H17C18.6569 4 20 5.34315 20 7V19C20 20.6569 18.6569 22 17 22H7C5.34315 22 4 20.6569 4 19V7C4 5.34315 5.34315 4 7 4H8.53513ZM8 6H7C6.44772 6 6 6.44772 6 7V19C6 19.5523 6.44772 20 7 20H17C17.5523 20 18 19.5523 18 19V7C18 6.44772 17.5523 6 17 6H16C16 7.10457 15.1046 8 14 8H10C8.89543 8 8 7.10457 8 6Z" fill="currentColor"></path></svg><?php echo $lang['account-dino-copy-code']; ?></button>');
                }, 2000);
            });
            chatLog.append(messageContainer);
            chatLog.scrollTop(chatLog[0].scrollHeight);
        }
        $('.predefined-message').on('click', function() {
            var predefinedMessage = $(this).find('p').text(); // Get the text inside the <p> tag within the clicked element
            $('#send-button').removeClass('hidden'); // Apply the animation class
            $('#prompt-textarea').text(predefinedMessage);
        });
        function showLoading() {
            const avatar = '<svg class="w-6 h-6" width="328" height="187" viewBox="0 0 650 650" fill="none" xmlns="http://www.w3.org/2000/svg"> <defs> <linearGradient id="gradient-datanito"> <stop offset="0" stop-color="#086FFF"> <animate attributeName="stop-color" values="#086FFF;#FFDDB7;#086FFF" dur="3s" repeatCount="indefinite"></animate> </stop> <stop offset="50%" stop-color="#FFDDB7"> <animate attributeName="offset" values=".5;.2;.5" dur="3.1500000000000004s" repeatCount="indefinite"></animate> </stop> <stop offset="100%" stop-color="#FFDDB7"> <animate attributeName="offset" values="1;.9;1" dur="3.1500000000000004s" repeatCount="indefinite"></animate> <animate attributeName="stop-color" values="#FFDDB7;#086FFF;#FFDDB7" dur="3.1500000000000004s" repeatCount="indefinite"></animate> </stop> <animateTransform attributeName="gradientTransform" type="rotate" from="0 .5 .5" to="360 .5 .5" dur="5.4s" repeatCount="indefinite"></animateTransform> </linearGradient> </defs> <rect x="0" y="0" width="600" height="600" fill="url(#gradient-datanito)" mask="url(#logo-datanito)"></rect> <mask id="logo-datanito"> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/> </mask> </svg>';
            const loadingMessages = [
                "<?php echo $lang['dino-generating-generating'];?>",
                "<?php echo $lang['dino-generating-analyzing'];?>",
                "<?php echo $lang['dino-generating-deep-thinking'];?>",
                "<?php echo $lang['dino-generating-oracle'];?>"
            ];
            const loadingDiv = `
                <div class="bot-message overflow-hidden bg-gray-50 dark:bg-dark-700 text-left text-sm py-10 px-4 mb-4 rounded-3xl">
                    <div class="block">
                        <div class="flex items-center space-x-2">
                            <div class="message-avatar w-9 h-9 p-1.5 bg-dark-600 dark:bg-dark-600 text-gray-800 dark:text-gray-200 overflow-hidden rounded-full">${avatar}</div>
                            <div class="font-bold"><?php echo $lang['dino']; ?></div>
                            <div class="dino-generating-status flex">
                                <div class="vl border-0.5 h-5 border-gray-200 dark:border-dark-500 mr-2 ml-0"></div>
                                <p id="loading-message">${loadingMessages[0]}</p>
                            </div>
                        </div>
                    </div>
                    <div class="flex" id="dino-generating">
                        <div role="status" class="space-y-2.5 animate-pulse max-w-lg m-2 md:m-6">
                            <div class="flex items-center w-full">
                                <div class="h-2.5 bg-gray-200 rounded-full dark:bg-dark-500 w-32"></div>
                                <div class="h-2.5 ms-2 bg-gray-300 rounded-full dark:bg-dark-600 w-24"></div>
                                <div class="h-2.5 ms-2 bg-gray-300 rounded-full dark:bg-dark-600 w-full"></div>
                            </div>
                            <div class="flex items-center w-full max-w-[480px]">
                                <div class="h-2.5 bg-gray-200 rounded-full dark:bg-dark-500 w-full"></div>
                                        <div class="h-2.5 ms-2 bg-gray-300 rounded-full dark:bg-dark-600 w-full"></div>
                                <div class="h-2.5 ms-2 bg-gray-300 rounded-full dark:bg-dark-600 w-24"></div>
                            </div>
                            <div class="flex items-center w-full max-w-[400px]">
                                <div class="h-2.5 bg-gray-300 rounded-full dark:bg-dark-600 w-full"></div>
                                <div class="h-2.5 ms-2 bg-gray-200 rounded-full dark:bg-dark-500 w-80"></div>
                                <div class="h-2.5 ms-2 bg-gray-300 rounded-full dark:bg-dark-600 w-full"></div>
                            </div>
                            <div class="flex items-center w-full max-w-[480px]">
                                <div class="h-2.5 ms-2 bg-gray-200 rounded-full dark:bg-dark-500 w-full"></div>
                                        <div class="h-2.5 ms-2 bg-gray-300 rounded-full dark:bg-dark-600 w-full"></div>
                                <div class="h-2.5 ms-2 bg-gray-300 rounded-full dark:bg-dark-600 w-24"></div>
                            </div>
                            <div class="flex items-center w-full max-w-[440px]">
                                <div class="h-2.5 ms-2 bg-gray-300 rounded-full dark:bg-dark-600 w-32"></div>
                                <div class="h-2.5 ms-2 bg-gray-300 rounded-full dark:bg-dark-600 w-24"></div>
                                <div class="h-2.5 ms-2 bg-gray-200 rounded-full dark:bg-dark-500 w-full"></div>
                            </div>
                            <div class="flex items-center w-full max-w-[360px]">
                                <div class="h-2.5 ms-2 bg-gray-300 rounded-full dark:bg-dark-600 w-full"></div>
                                <div class="h-2.5 ms-2 bg-gray-200 rounded-full dark:bg-dark-500 w-80"></div>
                                <div class="h-2.5 ms-2 bg-gray-300 rounded-full dark:bg-dark-600 w-full"></div>
                            </div>
                            <span class="sr-only">Loading...</span>
                        </div>
                    </div>
                    </div>
                </div>
            `;
            chatLog.append(loadingDiv);
            let index = 1;
            const messageInterval = setInterval(() => {
                if (index < loadingMessages.length) {
                    document.getElementById('loading-message').innerText = loadingMessages[index];
                    index++;
                } else {
                    clearInterval(messageInterval);
                }
            }, 4000); // Change interval here (milliseconds)
        }

        function sendMessage(message, attachment_vision, savedImagesHtml) {
            $('#dino-introduction').fadeOut();

            appendMessage(message, 'user', savedImagesHtml);
            localStorage.removeItem('uploadedImages');
            sendButton.prop('disabled', true);

            showLoading();
            chatLog.scrollTop(chatLog[0].scrollHeight);
            // Get the current URL
            var url = window.location.href;

// Use a regular expression to extract the UUID from the 'id' parameter
            var match = url.match(/\/c\/([0-9a-f-]+)$/i);

// Check if a match is found
            if (match) {
                // Extracted UUID value
                var id = match[1];

                // Use the 'id' value as needed
                console.log('UUID:', id);
            } else {
                console.log('UUID not found in the URL');
            }

            function htmlDecode(input) {
                return $("<div/>").html(input).text();
            }
            var DinoVisionInput = $('#DinoVisionInput')[0].files[0]; // Get the first selected file

            var formData = new FormData();
            formData.append('message', message);
            formData.append('attachment_vision', attachment_vision);
            formData.append('conversationId', id);
            formData.append('attachment_file', DinoVisionInput);
            $.ajax({
                type: 'POST',
                url: '/dino-core',
                data: formData,
                contentType: false,
                processData: false,
                dataType: 'json', // Specify that the expected response is JSON
                success: function(response) {
                    sendButton.prop('disabled', false);
                    sendButton.html('<svg class="w-5 h-5 rotate-90" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 18 20"> <path d="m17.914 18.594-8-18a1 1 0 0 0-1.828 0l-8 18a1 1 0 0 0 1.157 1.376L8 18.281V9a1 1 0 0 1 2 0v9.281l6.758 1.689a1 1 0 0 0 1.156-1.376Z"/> </svg> <span class="sr-only">Send message</span>'); // Change the send button text back to "Send"

                    console.log(response); // Log the entire JSON response
                    // Access the properties of the JSON response
                    const conversationId = response.id;
                    updateUrlParameter("c", conversationId);
                    fetchConversations();
                    setSelectedConversation();
                    const aiResponse = response.response;
                    response = htmlDecode(response);
                    console.log(response);
                    const dinoMessage = typeof aiResponse === 'object' ? JSON.stringify(aiResponse) : aiResponse;
                    var escapeHtmlMessage = escapeHtml(dinoMessage);

                    function escapeHtml(unsafe) {
                        return unsafe
                            .replace(/&/g, "&amp;")
                            .replace(/</g, "&lt;")
                            .replace(/>/g, "&gt;")
                            .replace(/"/g, "&quot;")
                            .replace(/'/g, "&#039;");
                    }

// Assuming you have a function to copy text to the clipboard
                    function copyToClipboard(text) {
                        const textarea = document.createElement('textarea');
                        textarea.value = text;
                        document.body.appendChild(textarea);
                        textarea.select();
                        document.execCommand('copy');
                        document.body.removeChild(textarea);
                    }

                    const regexCodeBlock = /```(\w+)\s*([\s\S]+?)```/g;
                    const regexHeading = /\*\*(.*?)\*\*/g;

// Replace code blocks and headings
                    formattedMessage = escapeHtmlMessage.replace(regexCodeBlock, (match, language, code) => {
                        // Create a temporary element to insert the code block
                        const tempElement = document.createElement('div');
                        tempElement.innerHTML = `<div class="relative flex w-full codebox">
        <div class="grid !bg-black rounded-2xl">
            <div class="flex items-center relative text-gray-200 bg-dark-600 dark:bg-dark-600 px-4 py-2 text-xs font-sans justify-between rounded-t-2xl">
                <span>${language}</span>
                <button class="flex gap-1 items-center copy-code-btn"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-sm"><path fill-rule="evenodd" clip-rule="evenodd" d="M12 4C10.8954 4 10 4.89543 10 6H14C14 4.89543 13.1046 4 12 4ZM8.53513 4C9.22675 2.8044 10.5194 2 12 2C13.4806 2 14.7733 2.8044 15.4649 4H17C18.6569 4 20 5.34315 20 7V19C20 20.6569 18.6569 22 17 22H7C5.34315 22 4 20.6569 4 19V7C4 5.34315 5.34315 4 7 4H8.53513ZM8 6H7C6.44772 6 6 6.44772 6 7V19C6 19.5523 6.44772 20 7 20H17C17.5523 20 18 19.5523 18 19V7C18 6.44772 17.5523 6 17 6H16C16 7.10457 15.1046 8 14 8H10C8.89543 8 8 7.10457 8 6Z" fill="currentColor"></path></svg><?php echo $lang['account-dino-copy-code']; ?></button>
            </div>
            <div class="p-4 overflow-y-auto"><pre class="language-${language} !bg-black !p-0"><code class="language-${language} block w-full">${code}</code></pre></div>
        </div>
    </div>`;

                        // Get the code block element within the temporary element
                        const codeElement = tempElement.querySelector('code');

                        // Highlight the code block
                        Prism.highlightElement(codeElement);

                        // Return the HTML content of the temporary element
                        return tempElement.innerHTML;
                    }).replace(regexHeading, (match, content) => {
                        return `<h3 class="inline text-base">${content}</h3>`;
                    });

                    // Update the loading message with Dino's response
                    // chatLog.find('.bot-message:last #dino-generating').html(formattedMessage + '<div class="message-additional mt-12"><span class="copy-to-clipboard material-symbols-outlined text-[1rem] cursor-pointer">content_copy</span></div>');
                    chatLog.find('.bot-message:last #dino-generating').html('<pre class="message-content prose max-w-none dark:prose-invert prose-img:rounded-xl prose-a:text-blue-500 font-medium mt-4 md:mt-0 md:ml-12">'+formattedMessage+'</pre>');
                    chatLog.find('.bot-message:last .dino-generating-status').addClass('hidden');
                    chatLog.find('.bot-message:last #dino-generating').removeClass('flex');
                    chatLog.scrollTop(chatLog[0].scrollHeight);

                }
            });
        }
        $(document).ready(function() {
            // Check if there are any image data stored in local storage
            var imageArray = JSON.parse(localStorage.getItem('uploadedImages')) || [];

            // Display the previews of stored images
            if (imageArray.length > 0) {
                $('.image-preview').append('<div class="DinoVisionInput"><img src="' + imageArray[0] + '"></div>');
            }

            // Capture change event of the input field
            $('#DinoVisionInput').on('change', function(e) {
                var files = e.target.files;

                // Clear existing images
                $('.image-preview').empty();

                for (var i = 0; i < files.length; i++) {
                    var reader = new FileReader();
                    reader.onload = function(event) {
                        // Display the preview
                        $('.image-preview').append('<div class="DinoVisionInput"><img src="' + event.target.result + '"></div>');

                        // Update the image data in the array (replace the existing one)
                        imageArray = [event.target.result];

                        // Store image array in local storage
                        localStorage.setItem('uploadedImages', JSON.stringify(imageArray));
                    };

                    // Read the file as data URL
                    reader.readAsDataURL(files[i]);
                }
            });
        });
        sendButton.on('click', function() {
            var userMessage = userInput.val().trim();
            var attachment_vision = $('#DinoVision').val().trim();
            var imageArray = JSON.parse(localStorage.getItem('uploadedImages')) || []; // Retrieve saved images

            // Clear image preview
            $('.image-preview').empty();

            // Append saved images
            var savedImagesHtml = '';
            imageArray.forEach(function(imageData) {
                savedImagesHtml += '<img src="' + imageData + '" class="rounded-2xl w-36 h-36 mt-12 ml-6 object-cover border border-gray-200 dark:border-dark-500">';
            });

            // Send message with attachments

            if (userMessage !== '') {
                sendMessage(userMessage, attachment_vision, savedImagesHtml);
                userInput.val('');
                userInput.empty();
                $('#send-button').addClass('hidden'); // Apply the animation class
                $('#imgPreview').addClass('hidden'); // Remove the image preview
                $('#imgPreview canvas').addClass('hidden');
                $('#DinoVision').empty(); // Empty the DinoVision content
                $('#deleteImageBtn').addClass('hidden');
            }
        });

        userInput.on('keyup', function(event) {
            if (event.keyCode === 13) {
                sendButton.click();
            }
        });
    });

    // Keyboard shortcuts
    $(document).keydown(function(e) {
        // Check for Ctrl + Shift + O
        if (e.ctrlKey && e.shiftKey && e.key === 'O') {
            alert('Open new chat');
        }

        // Check for Shift + Esc
        if (e.shiftKey && e.key === 'F1') {
            // Focus on the textarea
            $('#prompt-textarea').focus();
        }

        // Check for Ctrl + Shift + ;
        if (e.ctrlKey && e.shiftKey && e.key === ';') {
            alert('Copy last code block');
            // Add logic to copy the last code block
        }

        // Check for Ctrl + Shift + C
        if (e.ctrlKey && e.shiftKey && e.key === 'C') {
            alert('Copy last response');
            // Add logic to copy the last response
        }

        // Check for Ctrl + Shift + I
        if (e.ctrlKey && e.shiftKey && e.key === 'I') {
            alert('Set custom instructions');
            // Add logic to set custom instructions
        }

        // Check for Ctrl + Shift + S
        if (e.ctrlKey && e.shiftKey && e.key === 'S') {
            alert('Toggle sidebar');
            // Add logic to toggle the sidebar
        }

        // Check for Ctrl + Shift + ⌫ (Delete)
        if (e.ctrlKey && e.shiftKey && e.code === 'Backspace') {
            alert('Delete chat');
            // Add logic to delete the chat
        }

        // Check for Ctrl + /
        if (e.ctrlKey && e.key === '/') {
            alert('Show shortcuts');
            // Add logic to show shortcuts
        }

        // Check for Shift + Enter
        if (e.shiftKey && e.key === ' ') {
            // Add logic to handle Shift + Enter (go to the next line)
            // For example, you can trigger a line break in the textarea
            var textarea = $('#prompt-textarea');
            textarea.val(textarea.val() + '\r\n');
        }

    });
</script>

