<?php
$meta = array(
    'us' => array(
        'title' => 'Datanito - Your Account Overview',
        'description' => 'Get an overview of your Datanito account. Manage your profile, settings, and more from your account dashboard.',
        'og:title' => 'Datanito - Your Account Overview',
        'og:description' => 'Get an overview of your Datanito account. Manage your profile, settings, and more from your account dashboard.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Datanito - Hesap Genel Bakışı',
        'description' => 'Datanito hesabınızın genel bir bakışını alın. Profilinizi, ayarlarınızı ve daha fazlasını hesap panelinizden yönetin.',
        'og:title' => 'Datanito - Hesap Genel Bakışı',
        'og:description' => 'Datanito hesabınızın genel bir bakışını alın. Profilinizi, ayarlarınızı ve daha fazlasını hesap panelinizden yönetin.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);


$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/dashboard.php');
?>
<style>
    .domain-card {
        transition: transform 0.2s ease, box-shadow 0.2s ease;
    }

    .domain-card:hover {
        transform: translateY(-2px);
    }

    .domain-card .progress-bar {
        transition: width 1s ease;
    }
</style>
<main class="p-4 md:pl-64 md:ml-8 md:mr-4 h-full pt-20 pb-12 min-h-[70em] overflow-hidden">
    <!-- Email Verification Banner -->
    <div id="email-confirmation-banner" tabindex="-1" class="hidden rounded-xl bg-gradient-to-r from-yellow-100 to-yellow-50 dark:from-yellow-900/30 dark:to-yellow-950 border border-yellow-200 dark:border-yellow-800 p-4 flex items-center justify-between mb-6 shadow-sm">
        <div class="flex items-center space-x-3">
            <span class="flex items-center justify-center w-8 h-8 rounded-full bg-yellow-500 text-white">
                <span class="material-symbols-outlined text-sm">mail</span>
            </span>
            <p class="text-sm font-medium text-yellow-800 dark:text-yellow-200">
                <?php echo $lang['resend-email-conformation-headline']?>
            </p>
        </div>
        <?php set_csrf(); ?>
        <button id="resend-verification-button" class="flex items-center space-x-2 text-center text-white bg-gradient-to-r from-yellow-600 to-yellow-500 hover:from-yellow-700 hover:to-yellow-600 focus:ring-0 font-medium rounded-full text-sm px-4 py-2 transition-all duration-200" type="button">
            <span><?php echo $lang['resend-email-conformation-cta']?></span>
        </button>
    </div>

    <!-- Main Dashboard Grid -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-5 mb-5">
        <!-- Profile Card -->
        <div class="rounded-xl bg-white dark:bg-dark-700 border border-gray-100 dark:border-dark-600 p-6 space-y-4 shadow-sm hover:shadow-md transition-shadow duration-300">
            <div class="text-center">
                <div data-popover id="popover-user-profile" role="tooltip" class="absolute z-20 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-xl shadow-lg opacity-0 dark:text-gray-400 dark:bg-dark-800 dark:border-dark-600">
                    <div class="p-4">
                        <p class="text-base font-medium leading-none text-gray-900 dark:text-white">
                            <?php echo $lang['verified-account']?>
                        </p>
                        <p class="mt-1 mb-3 text-sm font-normal">
                            <span class="text-sm text-gray-500 dark:text-gray-400 user-username"></span>
                        </p>
                        <p class="mb-4 text-sm flex items-center">
                            <span class="flex user-verification-badge"></span>
                            <span class="ml-2">
                                <?php echo $lang['verified-account']?>.
                                <a href="#" class="text-blue-600 dark:text-blue-400 hover:underline">
                                    <?php echo $lang['learn-more']?>
                                </a>
                            </span>
                        </p>
                        <p class="mb-4 text-sm flex items-center">
                            <span class="material-symbols-outlined text-gray-800 dark:text-gray-400 mr-2">calendar_month</span>
                            <?php echo $lang['verified-since']?> January 2023
                        </p>
                        <div class="flex items-center justify-between mt-4 w-full">
                            <button type="button" class="text-white bg-gradient-to-r from-gray-700 to-gray-600 hover:from-gray-800 hover:to-gray-700 focus:ring-0 font-medium rounded-xl text-xs px-3 py-2 w-full transition-all duration-200">
                                <?php echo $lang['get-verified']?>
                            </button>
                        </div>
                    </div>
                    <div data-popper-arrow></div>
                </div>
                <div class="p-6 pb-0">
                    <div class="flex justify-between items-start">
                        <div>
                            <h3 class="text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">
                                <?php echo $lang['welcome-back']?>
                            </h3>
                            <h2 class="text-xl font-semibold text-gray-900 dark:text-white user-name"></h2>
                        </div>
                        <div class="flex">
                            <a href="<?php echo url('/account/profile/update'); ?>" class="flex items-center justify-center w-10 h-10 rounded-full bg-gray-100 dark:bg-dark-500 text-gray-700 dark:text-gray-300 hover:bg-gray-200 dark:hover:bg-dark-400 transition-colors" title="<?php echo $lang['edit-profile']?>">
                                <svg class="w-6 h-6 ml-0.5 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                                    <path stroke="currentColor" stroke-linecap="square" stroke-linejoin="round" stroke-width="2" d="M7 19H5a1 1 0 0 1-1-1v-1a3 3 0 0 1 3-3h1m4-6a3 3 0 1 1-6 0 3 3 0 0 1 6 0Zm7.441 1.559a1.907 1.907 0 0 1 0 2.698l-6.069 6.069L10 19l.674-3.372 6.07-6.07a1.907 1.907 0 0 1 2.697 0Z"/>
                                </svg>
                            </a>
                        </div>
                    </div>

                    <div class="mt-6 flex justify-center">
                        <div class="relative">
                            <div class="user-avatar w-36 h-36 rounded-full overflow-hidden border-4 border-white dark:border-dark-700 shadow-md mx-auto">
                                <!-- Avatar will be inserted here -->
                            </div>
                        </div>
                    </div>

                    <div class="mt-4 text-center">
                        <div class="flex items-center justify-center">
                            <p class="text-sm text-gray-500 dark:text-gray-400 user-username"></p>
                            <span class="user-verification-badge flex items-center justify-center"></span>
                        </div>
                        <p class="text-xs text-gray-400 dark:text-gray-500 mt-1">
                            <?php echo $lang['datanito-profile-id']?> <span class="user-id font-medium"></span>
                        </p>
                    </div>
                </div>

                <div class="mt-6 border-t border-gray-200 dark:border-dark-500 p-4">
                    <div class="flex justify-between items-center">
                        <div class="flex items-center">
                            <span class="material-symbols-outlined text-gray-400 dark:text-gray-500 mr-2">calendar_today</span>
                            <span class="text-sm text-gray-600 dark:text-gray-300">
                            <span class="grid">
                               <span class="w-full"> <?php echo $lang['profile-since']?></span> <span class="member-since-date w-full text-left font-medium"></span>
                            </span>
                        </span>
                        </div>
                        <a href="<?php echo url('/account/profile/update'); ?>" class="text-sm font-medium text-blue-600 dark:text-blue-400 hover:underline flex items-center">
                            <?php echo $lang['view-profile']?>
                            <span class="material-symbols-outlined ml-1 text-base">chevron_right</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Dino AI Card -->
        <div class="rounded-xl bg-white dark:bg-dark-700 border border-gray-100 dark:border-dark-600 p-6 space-y-4 shadow-sm hover:shadow-md transition-shadow duration-300">
            <div class="grid grid-cols-2 justify-between items-center">
                <div class="flex items-center space-x-2">
                    <a href="<?php echo url('/account/dino'); ?>" class="flex items-center text-center justify-start magic-container">
                        <span class="magic">
                            <span class="magic-text text-2xl tracking-tight font-extrabold">
                                <?php echo $lang['dino']; ?>
                            </span>
                        </span>
                    </a>
                    <span class="inline-flex justify-center items-center w-6 h-6 text-xs font-semibold rounded-lg p-2 bg-gradient-to-r from-purple-600 to-blue-500 text-white">
                        <span class="text-sm tracking-tight font-extrabold"><?php echo $lang['ai']; ?></span>
                    </span>
                </div>
                <div class="flex items-center justify-end">
                    <a href="<?php echo url('/account/dino'); ?>" class="flex items-center justify-between space-x-2 text-center text-white bg-gradient-to-r from-dark-700 to-dark-600 hover:from-dark-800 hover:to-dark-700 focus:ring-0 font-medium rounded-full text-sm px-4 py-2 transition-all duration-200">
                        <span><?php echo $lang['dino-new-chat']; ?></span>
                        <span class="material-symbols-outlined flex items-center justify-center w-6 h-6 p-1 bg-dark-600/30 dark:bg-dark-800/50 rounded-full font-bold text-lg">chevron_right</span>
                    </a>
                </div>
            </div>

            <h5 class="font-bold text-sm text-gray-600 dark:text-gray-400"><?php echo $lang['dino-recent-conversations']; ?></h5>

            <div class="overflow-y-auto overflow-x-hidden h-56 bg-gray-50 dark:bg-dark-600 rounded-xl">
                <div id="conversationList" class="overflow-hidden text-left px-3 pb-3 overflow-y-auto text-sm text-gray-700 dark:text-gray-200 space-y-2">
                    <!-- Conversations will be loaded here -->
                </div>
            </div>
        </div>

        <!-- Analytics Card -->
        <div class="rounded-xl bg-white dark:bg-dark-700 border border-gray-100 dark:border-dark-600 p-6 space-y-4 shadow-sm hover:shadow-md transition-shadow duration-300">
            <div class="grid grid-cols-2 justify-between items-center">
                <div class="flex items-center space-x-2">
                    <a href="<?php echo url('/account/analytics'); ?>" class="flex items-center text-center justify-center">
                        <svg class="w-7 h-7 mr-3" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="text-gray-900 dark:text-white">
                            <path d="M18.375 2.25c-1.035 0-1.875.84-1.875 1.875v15.75c0 1.035.84 1.875 1.875 1.875h.75c1.035 0 1.875-.84 1.875-1.875V4.125c0-1.036-.84-1.875-1.875-1.875h-.75zM9.75 8.625c0-1.036.84-1.875 1.875-1.875h.75c1.036 0 1.875.84 1.875 1.875v11.25c0 1.035-.84 1.875-1.875 1.875h-.75a1.875 1.875 0 01-1.875-1.875V8.625zM3 13.125c0-1.036.84-1.875 1.875-1.875h.75c1.036 0 1.875.84 1.875 1.875v6.75c0 1.035-.84 1.875-1.875 1.875h-.75A1.875 1.875 0 013 19.875v-6.75z" />
                        </svg>
                        <h3 class="text-2xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['DAnalytics']; ?></h3>
                    </a>
                </div>
                <div class="flex items-center justify-end">
                    <span class="flex items-center justify-center space-x-1 p-2 bg-gray-50 dark:bg-dark-600 rounded-xl text-gray-600 dark:text-gray-400 text-md skeleton hidden" id="website_info">
                        <span class="material-symbols-outlined">language</span>
                        <span id="website_url" class="truncate max-w-[120px]"></span>
                    </span>
                </div>
            </div>

            <div id="website-info" class="min-h-[200px]">
                <!-- Analytics data will be loaded here -->
            </div>
        </div>
    </div>

    <!-- Second Row Grid -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-2 gap-5 mb-5">
        <!-- Cloud Services Card -->
        <div class="rounded-xl bg-white dark:bg-dark-700 border border-gray-100 dark:border-dark-600 p-6 space-y-4 shadow-sm hover:shadow-md transition-shadow duration-300">
            <div class="grid grid-cols-2 justify-between items-center">
                <div class="flex items-center space-x-2">
                    <a href="<?php echo url('/account/cloud'); ?>" class="flex items-center text-center justify-start">
                        <svg class="w-7 h-7 mr-3" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="text-gray-900 dark:text-white">
                            <path fill-rule="evenodd" d="M4.5 9.75a6 6 0 0111.573-2.226 3.75 3.75 0 014.133 4.303A4.5 4.5 0 0118 20.25H6.75a5.25 5.25 0 01-2.23-10.004 6.072 6.072 0 01-.02-.496z" clip-rule="evenodd" />
                        </svg>
                        <h3 class="text-2xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['DCloud']; ?></h3>
                    </a>
                </div>
                <div class="flex items-center justify-end">
                    <button id="addNewCloudButton" data-dropdown-toggle="addNewCloud" class="flex items-center justify-between text-center text-white bg-gradient-to-r from-dark-700 to-dark-600 hover:from-dark-800 hover:to-dark-700 focus:ring-0 font-medium rounded-full text-sm px-4 py-2 transition-all duration-200" type="button">
                        <?php echo $lang['cloud-add-new'];?>
                        <svg class="w-2.5 h-2.5 ml-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 4 4 4-4"/>
                        </svg>
                    </button>

                    <!-- Dropdown menu -->
                    <div id="addNewCloud" class="z-10 hidden bg-white divide-y divide-gray-100 rounded-xl shadow-lg w-48 dark:bg-dark-700 border border-gray-100 dark:border-dark-600">
                        <ul class="py-2 px-2 space-y-1 text-sm text-gray-700 dark:text-gray-200" aria-labelledby="addNewCloudButton">
                            <li>
                                <a href="<?php echo url('/cloud'); ?>" class="block px-4 py-2 hover:bg-gray-50 dark:hover:bg-dark-600 dark:hover:text-white rounded-lg transition-colors duration-200">
                                    <?php echo $lang['cloud']?>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo url('/cloud/web-hosting'); ?>" class="block px-4 py-2 hover:bg-gray-50 dark:hover:bg-dark-600 dark:hover:text-white rounded-lg transition-colors duration-200">
                                    <?php echo $lang['web-hosting']?>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo url('/cloud/business-hosting'); ?>" class="block px-4 py-2 hover:bg-gray-50 dark:hover:bg-dark-600 dark:hover:text-white rounded-lg transition-colors duration-200">
                                    <?php echo $lang['business-hosting']?>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="text-center overflow-hidden overflow-x-hidden h-[300px]">
                <div id="productsList" class="py-6">
                    <div>
                        <div role="status" class="spinner hidden my-6 p-4 bg-gray-50 dark:bg-dark-600 border border-gray-100 dark:border-dark-600 rounded-xl">
                            <svg aria-hidden="true" class="inline w-20 h-20 text-gray-200 animate-spin dark:text-gray-600 fill-blue-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                                <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                            </svg>
                            <span class="sr-only">Loading...</span>
                        </div>
                        <span class="inline-flex justify-center text-center items-center empty-message md:w-96 h-60 w-full rounded-xl hidden">
                            <div class="p-6 bg-gray-50 dark:bg-dark-600 rounded-xl cursor-pointer w-full text-center">
                                <dl class="space-y-2 text-center">
                                    <span class="material-symbols-outlined flex mx-auto items-center justify-center text-center text-4xl w-14 h-14 bg-white dark:bg-dark-500 text-gray-600 dark:text-gray-400 rounded-full">cloud</span>
                                    <h2 class="text-gray-600 dark:text-gray-400 text-lg"><?php echo $lang['cloud-products-empty-headline']?></h2>
                                    <p class="text-gray-600 dark:text-gray-400 text-md"><?php echo $lang['cloud-products-empty-subheading']?></p>
                                </dl>
                            </div>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Datanito Pay Card -->
        <div class="rounded-xl bg-white dark:bg-dark-700 border border-gray-100 dark:border-dark-600 p-6 space-y-4 shadow-sm hover:shadow-md transition-shadow duration-300">
            <div class="grid grid-cols-2 justify-between items-center">
                <div class="flex items-center space-x-2">
                    <a href="<?php echo url('/account/pay'); ?>" class="flex items-center text-center justify-start">
                        <svg class="w-7 h-7 mr-3" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="text-gray-900 dark:text-white">
                            <path d="M12 7.5a2.25 2.25 0 100 4.5 2.25 2.25 0 000-4.5z" />
                            <path fill-rule="evenodd" d="M1.5 4.875C1.5 3.839 2.34 3 3.375 3h17.25c1.035 0 1.875.84 1.875 1.875v9.75c0 1.036-.84 1.875-1.875 1.875H3.375A1.875 1.875 0 011.5 14.625v-9.75zM8.25 9.75a3.75 3.75 0 117.5 0 3.75 3.75 0 01-7.5 0zM18.75 9a.75.75 0 00-.75.75v.008c0 .414.336.75.75.75h.008a.75.75 0 00.75-.75V9.75a.75.75 0 00-.75-.75h-.008zM4.5 9.75A.75.75 0 015.25 9h.008a.75.75 0 01.75.75v.008a.75.75 0 01-.75.75H5.25a.75.75 0 01-.75-.75V9.75z" clip-rule="evenodd" />
                            <path d="M2.25 18a.75.75 0 000 1.5c5.4 0 10.63.722 15.6 2.075 1.19.324 2.4-.558 2.4-1.82V18.75a.75.75 0 00-.75-.75H2.25z" />
                        </svg>
                        <h3 class="text-2xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['datanito-pay']; ?></h3>
                    </a>
                </div>
            </div>

            <div class="text-center overflow-y-auto overflow-x-hidden h-[300px]">
                <div id="paymentsList">
                    <span class="inline-flex justify-center text-center items-center empty-message md:w-96 h-60 w-full rounded-xl">
                        <div class="p-6 bg-gray-50 dark:bg-dark-600 rounded-xl cursor-pointer w-full text-center">
                            <dl class="space-y-2 text-center">
                                <span class="material-symbols-outlined flex mx-auto items-center justify-center text-center text-4xl w-14 h-14 bg-white dark:bg-dark-500 text-gray-600 dark:text-gray-400 rounded-full">payments</span>
                                <h2 class="text-gray-600 dark:text-gray-400 text-lg"><?php echo $lang['datanito-pay']; ?></h2>
                                <p class="text-gray-600 dark:text-gray-400 text-md"><?php echo $lang['datanito-pay-notice-subheading']; ?></p>
                            </dl>
                        </div>
                    </span>
                </div>
            </div>
        </div>
    </div>
    <!-- Second Row Grid -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-2 gap-5 mb-5">
        <!-- Domains Card -->
        <div class="rounded-xl bg-white dark:bg-dark-700 border border-gray-100 dark:border-dark-600 p-6 space-y-4 shadow-sm hover:shadow-md transition-shadow duration-300">
            <div class="grid grid-cols-2 justify-between items-center">
                <div class="flex items-center space-x-2">
                    <a href="<?php echo url('/account/domains'); ?>" class="flex items-center text-center justify-start">
                        <svg class="w-7 h-7 mr-3" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="text-gray-900 dark:text-white">
                            <path fill-rule="evenodd" d="M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25zM6.262 6.072a8.25 8.25 0 1010.562-.766 4.5 4.5 0 01-1.318 1.357L14.25 7.5l.165.33a.809.809 0 01-1.086 1.085l-.604-.302a1.125 1.125 0 00-1.298.21l-.132.131c-.439.44-.439 1.152 0 1.591l.296.296c.256.257.622.374.98.314l1.17-.195c.323-.054.654.036.905.245l1.33 1.108c.32.267.46.694.358 1.1a8.7 8.7 0 01-2.288 4.04l-.723.724a1.125 1.125 0 01-1.298.21l-.153-.076a1.125 1.125 0 01-.622-1.006v-1.052c0-.292-.224-.534-.509-.534l-.423.001a8.25 8.25 0 01-6.802-6.803l1.052-.423a.534.534 0 00.534-.509L8.288 7.15a1.125 1.125 0 01.756-1.303l1.108-.37a.809.809 0 011.086-1.085l.33.165.33-.165a.809.809 0 011.086 1.086l-.37 1.108a1.125 1.125 0 001.303.756l1.052-.423a.534.534 0 00.509-.534l-.001-.423a8.25 8.25 0 00-6.803-6.802z" clip-rule="evenodd" />
                        </svg>
                        <h3 class="text-2xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['domain-name']; ?></h3>
                    </a>
                </div>
                <div class="flex items-center justify-end">
                    <a href="<?php echo url('/account/domains/register'); ?>" class="flex items-center justify-between space-x-2 text-center text-white bg-gradient-to-r from-dark-700 to-dark-600 hover:from-dark-800 hover:to-dark-700 focus:ring-0 font-medium rounded-full text-sm px-4 py-2 transition-all duration-200">
                        <span><?php echo $lang['register-new']; ?></span>
                        <span class="material-symbols-outlined flex items-center justify-center w-6 h-6 p-1 bg-dark-600/30 dark:bg-dark-800/50 rounded-full font-bold text-lg">add</span>
                    </a>
                </div>
            </div>

            <div class="overflow-y-auto overflow-x-hidden h-[300px]">
                <div id="domainsList" class="py-6">
                    <div role="status" class="spinner hidden my-6 p-4 bg-gray-50 dark:bg-dark-600 border border-gray-100 dark:border-dark-600 rounded-xl">
                        <svg aria-hidden="true" class="inline w-20 h-20 text-gray-200 animate-spin dark:text-gray-600 fill-blue-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                            <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                        </svg>
                        <span class="sr-only">Loading...</span>
                    </div>
                    <div class="empty-message hidden flex flex-col items-center justify-center h-full">
                        <div class="p-6 bg-gray-50 dark:bg-dark-600 rounded-xl cursor-pointer w-full text-center">
                            <dl class="space-y-2 text-center">
                                <span class="material-symbols-outlined flex mx-auto items-center justify-center text-center text-4xl w-14 h-14 bg-white dark:bg-dark-500 text-gray-600 dark:text-gray-400 rounded-full">public</span>
                                <h2 class="text-gray-600 dark:text-gray-400 text-lg"><?php echo $lang['no-domains']; ?></h2>
                                <p class="text-gray-600 dark:text-gray-400 text-md"><?php echo $lang['register-new-domain']; ?></p>
                            </dl>
                        </div>
                    </div>
                    <div id="domainsContent" class="hidden">
                        <div class="w-full space-y-4" id="domainsTableBody">
                        <!-- Domains will be loaded here -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Invoices Card -->
        <div class="rounded-xl bg-white dark:bg-dark-700 border border-gray-100 dark:border-dark-600 p-6 space-y-4 shadow-sm hover:shadow-md transition-shadow duration-300">
            <div class="grid grid-cols-2 justify-between items-center">
                <div class="flex items-center space-x-2">
                    <a href="<?php echo url('/account/invoices'); ?>" class="flex items-center text-center justify-start">
                        <svg class="w-7 h-7 mr-3" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="text-gray-900 dark:text-white">
                            <path fill-rule="evenodd" d="M5.625 1.5c-1.036 0-1.875.84-1.875 1.875v17.25c0 1.035.84 1.875 1.875 1.875h12.75c1.035 0 1.875-.84 1.875-1.875V12.75A3.75 3.75 0 0016.5 9h-1.875a1.875 1.875 0 01-1.875-1.875V5.25A3.75 3.75 0 009 1.5H5.625zM7.5 15a.75.75 0 01.75-.75h7.5a.75.75 0 010 1.5h-7.5A.75.75 0 017.5 15zm.75 2.25a.75.75 0 000 1.5H12a.75.75 0 000-1.5H8.25z" clip-rule="evenodd" />
                            <path d="M12.971 1.816A5.23 5.23 0 0114.25 5.25v1.875c0 .207.168.375.375.375H16.5a5.23 5.23 0 013.434 1.279 9.768 9.768 0 00-6.963-6.963z" />
                        </svg>
                        <h3 class="text-2xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['invoices']; ?></h3>
                    </a>
                </div>
                <div class="flex items-center justify-end">
                    <div class="flex space-x-2">
                        <button id="showDueInvoices" class="text-xs font-medium px-3 py-1.5 rounded-full bg-red-100 dark:bg-red-900/20 text-red-800 dark:text-red-200">
                            <?php echo $lang['due-invoices']; ?>
                        </button>
                        <button id="showPaidInvoices" class="text-xs font-medium px-3 py-1.5 rounded-full bg-green-100 dark:bg-green-900/20 text-green-800 dark:text-green-200">
                            <?php echo $lang['paid-invoices']; ?>
                        </button>
                        <button id="showAllInvoices" class="text-xs font-medium px-3 py-1.5 rounded-full bg-gray-100 dark:bg-gray-600 text-gray-800 dark:text-gray-200">
                            <?php echo $lang['all']; ?>
                        </button>
                    </div>
                </div>
            </div>

            <div class="overflow-y-auto overflow-x-hidden h-[300px]">
                <div id="invoicesList">
                    <div role="status" class="spinner hidden my-6 p-4 bg-gray-50 dark:bg-dark-600 border border-gray-100 dark:border-dark-600 rounded-xl">
                        <svg aria-hidden="true" class="inline w-20 h-20 text-gray-200 animate-spin dark:text-gray-600 fill-blue-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                            <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                        </svg>
                        <span class="sr-only">Loading...</span>
                    </div>
                    <div class="empty-message hidden flex flex-col items-center justify-center h-full">
                        <div class="p-6 bg-gray-50 dark:bg-dark-600 rounded-xl cursor-pointer w-full text-center">
                            <dl class="space-y-2 text-center">
                                <span class="material-symbols-outlined flex mx-auto items-center justify-center text-center text-4xl w-14 h-14 bg-white dark:bg-dark-500 text-gray-600 dark:text-gray-400 rounded-full">receipt</span>
                                <h2 class="text-gray-600 dark:text-gray-400 text-lg"><?php echo $lang['no-invoices']; ?></h2>
                                <p class="text-gray-600 dark:text-gray-400 text-md"><?php echo $lang['no-invoices-message']; ?></p>
                            </dl>
                        </div>
                    </div>
                    <div id="invoicesContent" class="hidden">
                        <div class="w-full space-y-4" id="invoicesTableBody">
                        <!-- Invoices will be loaded here -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
</main>

<?php
include_once includes('layouts/dashboard-end.php');
?>

<!-- Enhanced JavaScript -->
<script>
    $(document).ready(function() {
        // Initialize CSRF token
        var csrf = $('input[name="csrf"]').val();

        // Show loading spinner
        $('.spinner').show();

// Global variable to store all invoices
        let allInvoices = [];

        function loadInvoices() {
            const invoicesContainer = $('#invoicesList');
            const spinner = invoicesContainer.find('.spinner');
            const emptyMessage = invoicesContainer.find('.empty-message');
            const content = $('#invoicesContent');
            const tableBody = $('#invoicesTableBody');

            spinner.removeClass('hidden').show();
            emptyMessage.addClass('hidden').hide();
            content.addClass('hidden');

            $.ajax({
                type: 'POST',
                url: '/get_invoices', // This now gets ALL invoices
                dataType: 'json',
                data: { csrf: csrf },
                success: function(response) {
                    spinner.hide();

                    if (!response || !response.invoices || response.invoices.length === 0) {
                        emptyMessage.removeClass('hidden').show();
                        return;
                    }

                    // Store all invoices globally
                    allInvoices = response.invoices;

                    // Sort all invoices by date (newest first)
                    allInvoices.sort((a, b) => new Date(b.invoice_date || b.date) - new Date(a.invoice_date || a.date));

                    // Apply the current filter (defaults to 'all')
                    applyInvoiceFilter();

                    content.removeClass('hidden');
                },
                error: function(xhr, status, error) {
                    spinner.hide();
                    emptyMessage.removeClass('hidden').show();
                    console.error("Invoices loading error:", error);

                    emptyMessage.html(`
                <div class="p-6 bg-red-50 dark:bg-red-900/10 rounded-lg text-center border border-red-200 dark:border-red-800">
                    <span class="material-symbols-outlined flex mx-auto text-red-600 dark:text-red-400 text-4xl mb-3">error</span>
                    <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-1">Error Loading Invoices</h3>
                    <p class="text-sm text-gray-600 dark:text-gray-300 mb-4">We couldn't load your invoices. Please try again later.</p>
                    <button onclick="loadInvoices()" class="retry-button px-4 py-2 bg-red-600 hover:bg-red-700 text-white text-sm font-medium rounded-lg transition-colors">
                        Retry
                    </button>
                </div>
            `);
                }
            });
        }

        function applyInvoiceFilter(filter = 'all') {
            const tableBody = $('#invoicesTableBody');
            const emptyMessage = $('#invoicesList').find('.empty-message');

            // Filter invoices based on the selected filter
            let filteredInvoices = allInvoices;

            if (filter === 'due') {
                filteredInvoices = allInvoices.filter(invoice =>
                    invoice.invoice_status === 'Unpaid' || invoice.status === 'due'
                );
            } else if (filter === 'paid') {
                filteredInvoices = allInvoices.filter(invoice =>
                    invoice.invoice_status === 'Paid' || invoice.status === 'paid'
                );
            }

            // Update the UI based on filtered results
            if (filteredInvoices.length === 0) {
                tableBody.empty();
                emptyMessage.removeClass('hidden').show();
                return;
            }

            emptyMessage.addClass('hidden').hide();
            tableBody.empty();

            filteredInvoices.forEach(invoice => {
                const invoiceDate = new Date(invoice.invoice_date || invoice.date);
                const dueDate = new Date(invoiceDate);
                dueDate.setDate(dueDate.getDate() + 5);
                const isOverdue = invoice.invoice_status === 'Unpaid' && new Date() > dueDate;
                const invoiceDateFormat = formatCreatedAt(invoice.invoice_date || invoice.date);
                const isDueSoon = (invoice.invoice_status === 'Unpaid' || invoice.status === 'due') && !isOverdue;

                let statusClass = 'bg-green-100 dark:bg-green-900/20 text-green-800 dark:text-green-200';
                let statusText = '<?php echo $lang['status-paid']; ?>';

                if (invoice.invoice_status === 'Unpaid' || invoice.status === 'due') {
                    statusClass = isOverdue
                        ? 'bg-red-100 dark:bg-red-900/20 text-red-800 dark:text-red-200'
                        : 'bg-yellow-100 dark:bg-yellow-900/20 text-yellow-800 dark:text-yellow-200';
                    statusText = isOverdue
                        ? '<?php echo $lang['status-overdue']; ?>'
                        : '<?php echo $lang['status-due']; ?>';
                }

                tableBody.append(`
            <div class="invoice-card flex flex-col md:flex-row justify-between items-start md:items-center gap-4 p-2.5 md:p-4 bg-gray-50 dark:bg-dark-600 rounded-xl border border-gray-100 dark:border-dark-600 shadow-xs hover:shadow-sm transition-shadow">
            <!-- Left Section -->
            <div class="flex items-start gap-4 w-full md:w-auto">
                <div class="flex-shrink-0 p-3 bg-blue-50 dark:bg-blue-900/20 rounded-lg">
                    <span class="material-symbols-outlined text-blue-600 dark:text-blue-300">receipt</span>
                </div>

                <div class="flex-1 min-w-0">
                    <div class="flex items-center gap-2 mb-1">
                        <h4 class="text-base font-semibold text-gray-900 dark:text-white">
                            #${invoice.invoice_number}
                        </h4>
                        <span class="text-xs font-medium px-2.5 py-0.5 rounded-full ${statusClass}">
                            ${statusText}
                        </span>
                    </div>

                    <div class="grid grid-cols-2 gap-x-4 gap-y-1 text-sm">
                        <div class="text-gray-500 dark:text-gray-400"><?php echo $lang['invoice-date']; ?></div>
                        <div class="text-gray-700 dark:text-gray-300">${invoiceDate.toLocaleDateString()}</div>

                        <div class="text-gray-500 dark:text-gray-400"><?php echo $lang['invoice-amount']; ?></div>
                        <div class="text-gray-700 dark:text-gray-300 font-medium">
                            ${invoice.total_amount || invoice.amount}
                        </div>

                        <div class="text-gray-500 dark:text-gray-400"><?php echo $lang['invoice-due-date']; ?></div>
                        <div class="text-gray-700 dark:text-gray-300">
                            ${dueDate.toLocaleDateString()}
                            ${isOverdue ? '<span class="text-red-500 dark:text-red-400 ml-1">('+Math.ceil((new Date() - dueDate)/(1000*60*60*24))+' days overdue)</span>' : ''}
                            ${isDueSoon ? '<span class="text-yellow-500 dark:text-yellow-400 ml-1">('+Math.ceil((dueDate - new Date())/(1000*60*60*24))+' days left)</span>' : ''}
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Section -->
            <div class="flex-shrink-0 w-full md:w-auto">
                <div class="flex flex-col sm:flex-row gap-2">
                    <a href="<?php echo url('/account/billing/invoices/${invoice.invoice_number}')?>"
                       class="flex items-center justify-center gap-1 w-full px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-lg transition-colors">
                        <span class="material-symbols-outlined text-sm">visibility</span>
                        <span><?php echo $lang['invoice-view']; ?></span>
                    </a>

                    ${(invoice.invoice_status === 'Unpaid' || invoice.status === 'due') ? `
                    <a href="<?php echo url('/account/billing/invoices/${invoice.invoice_number}')?>"
                       class="flex items-center justify-center gap-1 w-full px-4 py-2 bg-green-600 hover:bg-green-700 text-white text-sm font-medium rounded-lg transition-colors">
                        <span class="material-symbols-outlined text-sm">payments</span>
                        <span><?php echo $lang['invoice-pay']; ?></span>
                    </a>
                    ` : ''}
                </div>
            </div>
        </div>
        `);
            });
        }

// Invoice filter buttons - updated to use client-side filtering
        $('#showDueInvoices').click(function() {
            applyInvoiceFilter('due');
            $(this).removeClass('shadow-lg')
                .addClass('shadow-lg');
            $('#showAllInvoices').removeClass('shadow-lg')
                .addClass('border-transparent');
            $('#showPaidInvoices').removeClass('shadow-lg')
                .addClass('border-transparent');
        });

        $('#showAllInvoices').click(function() {
            applyInvoiceFilter('all');
            $(this).removeClass('shadow-lg')
                .addClass('shadow-lg');
            $('#showDueInvoices').removeClass('shadow-lg')
                .addClass('border-transparent');
            $('#showPaidInvoices').removeClass('shadow-lg')
                .addClass('border-transparent');
        });

        $('#showPaidInvoices').click(function() {
            applyInvoiceFilter('paid');
            $(this).removeClass('shadow-lg')
                .addClass('shadow-lg');
            $('#showAllInvoices').removeClass('shadow-lg')
                .addClass('border-transparent');
            $('#showDueInvoices').removeClass('shadow-lg')
                .addClass('border-transparent');
        });


        // Initialize all components
        loadProfile();
        loadProducts();
        fetchConversations();
        fetchAnalyticsData();
        loadDomains();
        loadInvoices();

        // Set up periodic refresh
        setInterval(loadProducts, 300000);
        setInterval(fetchAnalyticsData, 300000);
        setInterval(loadDomains, 3600000); // Refresh domains every hour
        setInterval(loadInvoices, 3600000); // Refresh invoices every hour

        // Load user profile
        function loadProfile() {
            $.ajax({
                type: 'POST',
                url: '/view_profile',
                dataType: 'json',
                data: { csrf: csrf },
                success: function(data) {
                    $('.spinner').hide();
                    if (data.user_name) {
                        // Populate user information
                        $('.user-name').text(data.user_name);
                        if (data.user_username) {
                            $('.user-username').text('@'+data.user_username);
                        }
                        if (!data.email_verification_status) {
                            $('#email-confirmation-banner').removeClass('hidden');
                        }
                        $('.user-id').text(data.user_id);
                        $('.user-avatar').html(data.userAvatar);
                        $('.user-avatar img').removeClass('w-24 h-24').addClass('w-36 h-36');
                        $('.user-verification-badge').html(data.user_verificationBadge);

                        // Format and display member since date
                        if (data.created_at) {
                            const memberSince = new Date(data.created_at);
                            $('.member-since-date').text(memberSince.toLocaleDateString(undefined, {
                                year: 'numeric',
                                month: 'short'
                            }));
                        }
                    }
                },
                error: function(error) {
                    console.error("Profile loading error:", error);
                }
            });
        }

// Load domains with improved structure and design
        function loadDomains() {
            const domainsContainer = $('#domainsList');
            const spinner = domainsContainer.find('.spinner');
            const emptyMessage = domainsContainer.find('.empty-message');
            const content = $('#domainsContent');
            const tableBody = $('#domainsTableBody');

            // Show loading state
            spinner.removeClass('hidden').show();
            emptyMessage.addClass('hidden').hide();
            content.addClass('hidden');

            $.ajax({
                type: 'POST',
                url: '/get_user_products',
                dataType: 'json',
                data: {
                    categories: 'domain',
                    include: 'status,renewal_date,order_date'
                },
                success: function(response) {
                    spinner.hide();

                    if (!response || response.length === 0) {
                        showEmptyState(emptyMessage, 'public',
                            '<?php echo $lang["no-domains"]; ?>',
                            '<?php echo $lang["register-new-domain"]; ?>');
                        return;
                    }

                    // Process and sort domains
                    const sortedDomains = processDomains(response);

                    if (sortedDomains.length === 0) {
                        showEmptyState(emptyMessage, 'public',
                            '<?php echo $lang["no-domains"]; ?>',
                            '<?php echo $lang["register-new-domain"]; ?>');
                        return;
                    }

                    renderDomainsTable(tableBody, sortedDomains);
                    content.removeClass('hidden');
                },
                error: function(xhr, status, error) {
                    showErrorState(spinner, emptyMessage, error, 'domains');
                }
            });
        }

// Helper function to process and sort domains
        function processDomains(domains) {
            return domains.map(domain => {
                const expiryDate = new Date(domain.renewal_date);
                const regDate = new Date(domain.order_date);
                const daysLeft = domain.days_left;
                const formattedDate = formatCreatedAt(expiryDate);

                return {
                    ...domain,
                    expiryDate,
                    regDate,
                    daysLeft,
                    formattedDate,
                    status: getDomainStatus(daysLeft)
                };
            }).sort((a, b) => {
                // Sort by status priority (expired > expiring soon > active)
                // Then by days left (closest to expiry first)
                if (a.status.priority !== b.status.priority) {
                    return a.status.priority - b.status.priority;
                }
                return a.daysLeft - b.daysLeft;
            });
        }

// Helper function to determine domain status
        function getDomainStatus(daysLeft) {
            if (daysLeft <= 0) {
                return {
                    text: '<?php echo $lang["expired"]; ?>',
                    class: 'bg-red-100 dark:bg-red-900/20 text-red-800 dark:text-red-200',
                    priority: 1,
                    icon: 'warning'
                };
            } else if (daysLeft <= 7) {
                return {
                    text: '<?php echo $lang["expiring-soon"]; ?>',
                    class: 'bg-yellow-100 dark:bg-yellow-900/20 text-yellow-800 dark:text-yellow-200',
                    priority: 2,
                    icon: 'schedule'
                };
            } else {
                return {
                    text: '<?php echo $lang["active"]; ?>',
                    class: 'bg-green-100 dark:bg-green-900/20 text-green-800 dark:text-green-200',
                    priority: 3,
                    icon: 'check_circle'
                };
            }
        }

// Helper function to render domains table
        function renderDomainsTable(tableBody, domains) {
            tableBody.empty();

            // Sort domains: active first, then expiring soon, then expired
            const sortedDomains = [...domains].sort((a, b) => {
                // Active domains (more than 30 days left) come first
                if (a.daysLeft > 30 && b.daysLeft <= 30) return -1;
                if (a.daysLeft <= 30 && b.daysLeft > 30) return 1;

                // Then domains expiring soon (7-30 days)
                if (a.daysLeft > 7 && b.daysLeft <= 7) return -1;
                if (a.daysLeft <= 7 && b.daysLeft > 7) return 1;

                // Then domains expiring very soon (1-7 days)
                if (a.daysLeft > 0 && b.daysLeft <= 0) return -1;
                if (a.daysLeft <= 0 && b.daysLeft > 0) return 1;

                // Finally sort by remaining days
                return a.daysLeft - b.daysLeft;
            });

            sortedDomains.forEach(domain => {
                const daysLeftText = domain.daysLeft <= 0 ?
                    '<?php echo $lang["expired"]; ?>' :
                    `${domain.daysLeft} <?php echo $lang["days-left"]; ?>`;

                const progressWidth = Math.min(Math.max(0, domain.daysLeft), 365);

                // Enhanced progress bar colors with more granular states
                const progressColor =
                    domain.daysLeft <= 0 ? 'bg-red-500' :
                        domain.daysLeft <= 3 ? 'bg-red-400' :
                            domain.daysLeft <= 7 ? 'bg-yellow-500' :
                                domain.daysLeft <= 30 ? 'bg-orange-400' : 'bg-green-500';

                // Enhanced status colors and text
                const statusInfo =
                    domain.daysLeft <= 0 ? {
                        color: 'bg-red-100 text-red-800 dark:bg-red-900/20 dark:text-red-200',
                        text: '<?php echo $lang["expired"]; ?>'
                    } : domain.daysLeft <= 3 ? {
                        color: 'bg-red-100 text-red-800 dark:bg-red-900/20 dark:text-red-200',
                        text: '<?php echo $lang["expiring-soon"]; ?>'
                    } : domain.daysLeft <= 7 ? {
                        color: 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900/20 dark:text-yellow-200',
                        text: '<?php echo $lang["expiring-soon"]; ?>'
                    } : domain.daysLeft <= 30 ? {
                        color: 'bg-orange-100 text-orange-800 dark:bg-orange-900/20 dark:text-orange-200',
                        text: '<?php echo $lang["active"]; ?>'
                    } : {
                        color: 'bg-green-100 text-green-800 dark:bg-green-900/20 dark:text-green-200',
                        text: '<?php echo $lang["active"]; ?>'
                    };

                tableBody.append(`
        <div class="domain-card group relative bg-gray-50 dark:bg-dark-600 rounded-xl border border-gray-200 dark:border-dark-600 overflow-hidden shadow-sm hover:shadow-md transition-all duration-200">
            <!-- Status ribbon -->
            <div class="absolute top-0 right-0 px-3 py-1 text-xs font-medium rounded-bl-lg ${statusInfo.color}">
                ${statusInfo.text}
            </div>

            <!-- Card content -->
            <div class="p-4 sm:p-5">
                <!-- Domain name and icon -->
                <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4 mb-4 mt-2">
                    <div class="flex items-start w-full">
                        <div class="flex-shrink-0 p-2 bg-indigo-50 dark:bg-indigo-800/50 rounded-lg">
                            <span class="material-symbols-outlined text-indigo-600 dark:text-indigo-300">language</span>
                        </div>
                        <div class="ml-3 flex-1 min-w-0">
                            <h3 class="text-lg font-semibold text-gray-900 dark:text-white truncate">${domain.order_name}</h3>
                            <p class="text-sm text-gray-500 dark:text-gray-400">
                                <?php echo $lang["registered"]; ?>: ${domain.regDate.toLocaleDateString()}
                            </p>
                        </div>
                    </div>
                    <div class="w-full sm:w-auto">
                        <a href="<?php echo url('/account/domain/${domain.order_number}')?>" class="flex items-center justify-center gap-1 w-full px-4 py-2 bg-dark-600 hover:bg-dark-700 dark:bg-dark-700 dark:hover:bg-dark-800 text-white text-sm font-medium rounded-xl transition-colors">
                            <span><?php echo $lang["manage-cta"]; ?></span>
                            <span class="material-symbols-outlined text-base">chevron_right</span>
                        </a>
                    </div>
                </div>

                <!-- Expiration progress -->
                <div class="mt-2">
                    <div class="flex flex-col xs:flex-row xs:justify-between xs:items-center text-sm mb-1 gap-1 xs:gap-0">
                        <span class="font-medium text-gray-700 dark:text-gray-300">${domain.formattedDate}</span>
                        <span class="${
                    domain.daysLeft <= 0 ? 'text-red-600 dark:text-red-400' :
                        domain.daysLeft <= 7 ? 'text-yellow-600 dark:text-yellow-400' :
                            'text-gray-500 dark:text-gray-400'
                }">
                            ${daysLeftText}
                        </span>
                    </div>
                    <div class="w-full bg-gray-200 dark:bg-dark-700 rounded-full h-2">
                        ${domain.daysLeft > 0 ? `
                        <div class="h-2 rounded-full ${progressColor} transition-all duration-500"
                             style="width: ${(progressWidth/365)*100}%"></div>
                        ` : ''}
                    </div>
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                        <?php echo $lang["expires"]; ?>: ${domain.expiryDate.toLocaleDateString()}
                    </p>
                </div>
            </div>
        </div>
    `);
            });
            // Add empty state if no domains
            if (sortedDomains.length === 0) {
                tableBody.append(`
            <div class="col-span-full text-center py-12">
                <div class="mx-auto max-w-md px-4">
                    <span class="material-symbols-outlined mx-auto flex items-center justify-center text-gray-400 dark:text-gray-500 text-4xl w-14 h-14 bg-gray-100 dark:bg-dark-600 rounded-full">public_off</span>
                    <h3 class="mt-2 text-lg font-medium text-gray-900 dark:text-white">
                        <?php echo $lang["no-domains-found"]; ?>
                    </h3>
                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                        <?php echo $lang["no-domains-message"]; ?>
                    </p>
                    <div class="mt-6">
                        <a href="<?php echo url('/domains/register'); ?>" class="inline-flex items-center px-4 py-2 bg-indigo-600 hover:bg-indigo-700 text-white text-sm font-medium rounded-lg transition-colors">
                            <span class="material-symbols-outlined mr-2">add</span>
                            <?php echo $lang["register-domain"]; ?>
                        </a>
                    </div>
                </div>
            </div>
        `);
            }
        }

// Helper function to show empty state
        function showEmptyState(container, icon, title, subtitle) {
            container.html(`
        <div class="flex flex-col items-center justify-center h-full p-6 text-center">
            <span class="material-symbols-outlined flex items-center justify-center w-16 h-16 mb-4 rounded-full bg-gray-100 dark:bg-dark-600 text-gray-400 dark:text-gray-500 text-4xl">
                ${icon}
            </span>
            <h3 class="text-lg font-medium text-gray-700 dark:text-gray-300 mb-1">${title}</h3>
            <p class="text-sm text-gray-500 dark:text-gray-400 mb-4">${subtitle}</p>
            <a href="<?php echo url('/account/domains/register')?>"
               class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-lg transition-colors">
                <span class="material-symbols-outlined mr-2">add</span>
                <?php echo $lang['register-new-domain']; ?>
            </a>
        </div>
    `).removeClass('hidden').show();
        }

// Helper function to show error state
        function showErrorState(spinner, container, error, type) {
            spinner.hide();
            const errorMessages = {
                'domains': {
                    icon: 'public',
                    title: '<?php echo $lang["domains-load-error-title"]; ?>',
                    message: '<?php echo $lang["domains-load-error-message"]; ?>'
                },
                'default': {
                    icon: 'error',
                    title: '<?php echo $lang["loading-failed"]; ?>',
                    message: '<?php echo $lang["loading-error-message"]; ?>'
                }
            };

            const {icon, title, message} = errorMessages[type] || errorMessages.default;

                container.html(`
            <div class="flex flex-col items-center justify-center h-full p-6 text-center">
                <span class="material-symbols-outlined flex items-center justify-center w-16 h-16 mb-4 rounded-full bg-red-100 dark:bg-red-900/10 text-red-600 dark:text-red-400 text-4xl">
                    ${icon}
                </span>
                <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-1">${title}</h3>
                <p class="text-sm text-gray-600 dark:text-gray-300 mb-4">${message}</p>
                <button onclick="loadDomains()"
                        class="px-4 py-2 bg-red-600 hover:bg-red-700 text-white text-sm font-medium rounded-lg transition-colors">
                    <?php echo $lang['retry']?>
                </button>
            </div>
        `).removeClass('hidden').show();

            console.error(`${type} loading error:`, error);
        }
        // Load products
        function loadProducts() {
            const productsContainer = $('#productsList');
            const spinner = productsContainer.find('.spinner');
            const emptyMessage = productsContainer.find('.empty-message');

            spinner.removeClass('hidden').show();
            emptyMessage.addClass('hidden').hide();

            $.ajax({
                type: 'POST',
                url: '/get_user_products',
                dataType: 'json',
                data: {
                    categories: 'web-hosting,business-hosting,cloud',
                    include: 'category,is_featured'
                },
                success: function(response) {
                    spinner.hide();

                    if (!response || response.length === 0) {
                        emptyMessage.removeClass('hidden').show();
                        return;
                    }

                    productsContainer.empty();
                    const sortedProducts = [...response].sort((a, b) => {
                        const statusOrder = { 'Active': 1, 'Pending': 2, 'Overdue': 3 };
                        return statusOrder[a.status] - statusOrder[b.status];
                    });

                    const productsByCategory = sortedProducts.reduce((acc, product) => {
                        if (!acc[product.category]) acc[product.category] = [];
                        acc[product.category].push(product);
                        return acc;
                    }, {});

                    Object.entries(productsByCategory).forEach(([category, products]) => {
                        const categoryTitle = category.split('-').map(word =>
                            word.charAt(0).toUpperCase() + word.slice(1)
                        ).join(' ');

                        productsContainer.append(`
                        <div class="product-category-section mb-6">
                            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3 flex items-center gap-2">
                                <span class="material-symbols-outlined text-gray-600 dark:text-gray-400">
                                    ${getProductIcon(category)}
                                </span>
                                ${categoryTitle} (${products.length})
                            </h3>
                            <div class="grid gap-3 relative overflow-y-auto max-h-[400px] pb-10">
                                ${products.map(product => productCardTemplate(product)).join('')}
                            </div>
                        </div>
                    `);
                    });
                },
                error: function(xhr, status, error) {
                    spinner.hide();
                    emptyMessage.removeClass('hidden').show();
                    console.error("Product loading error:", error);

                    emptyMessage.html(`
                    <div class="p-6 bg-red-50 dark:bg-red-900/10 rounded-lg text-center border border-red-200 dark:border-red-800">
                        <span class="material-symbols-outlined flex mx-auto text-red-600 dark:text-red-400 text-4xl mb-3">error</span>
                        <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-1"><?php echo $lang['loading-failed']?></h3>
                        <p class="text-sm text-gray-600 dark:text-gray-300 mb-4">We couldn't load your products. Please try again.</p>
                        <button onclick="loadProducts()" class="retry-button px-4 py-2 bg-red-600 hover:bg-red-700 text-white text-sm font-medium rounded-lg transition-colors">
                            <?php echo $lang['retry']?>
                        </button>
                    </div>
                `);
                }
            });
        }

        // Product card template
        const productCardTemplate = (product) => {
            const formattedDate = formatCreatedAt(product.renewal_date);
            const statusData = getStatusData(product.status);
            const renewalData = getRenewalData(product.days_left, product.renewal_date);
            const expiryDate = new Date(product.renewal_date);
            const regDate = new Date(product.order_date);
            const daysLeft = product.days_left;
            const daysLeftText = product.daysLeft <= 0 ?
                '<?php echo $lang["expired"]; ?>' :
                `${daysLeft} <?php echo $lang["days-left"]; ?>`;

            const progressWidth = Math.min(Math.max(0, daysLeft), 365);

            // Enhanced progress bar colors with more granular states
            const progressColor =
                daysLeft <= 0 ? 'bg-red-500' :
                    daysLeft <= 3 ? 'bg-red-400' :
                        daysLeft <= 7 ? 'bg-yellow-500' :
                            daysLeft <= 30 ? 'bg-orange-400' : 'bg-green-500';

            // Enhanced status colors and text
            const statusInfo =
                daysLeft <= 0 ? {
                    color: 'bg-red-100 text-red-800 dark:bg-red-900/20 dark:text-red-200',
                    text: '<?php echo $lang["expired"]; ?>'
                } : daysLeft <= 3 ? {
                    color: 'bg-red-100 text-red-800 dark:bg-red-900/20 dark:text-red-200',
                    text: '<?php echo $lang["expiring-soon"]; ?>'
                } : daysLeft <= 7 ? {
                    color: 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900/20 dark:text-yellow-200',
                    text: '<?php echo $lang["expiring-soon"]; ?>'
                } : daysLeft <= 30 ? {
                    color: 'bg-orange-100 text-orange-800 dark:bg-orange-900/20 dark:text-orange-200',
                    text: '<?php echo $lang["active"]; ?>'
                } : {
                    color: 'bg-green-100 text-green-800 dark:bg-green-900/20 dark:text-green-200',
                    text: '<?php echo $lang["active"]; ?>'
                };
            return `
<div class="domain-card group relative bg-gray-50 dark:bg-dark-600 rounded-xl border border-gray-200 dark:border-dark-600 overflow-hidden shadow-sm hover:shadow-md transition-all duration-200">
            <!-- Status ribbon -->
            <div class="absolute top-0 right-0 px-3 py-1 text-xs font-medium rounded-bl-lg ${statusInfo.color}">
                ${statusInfo.text}
            </div>

            <!-- Card content -->
            <div class="p-4 sm:p-5">
                <!-- Domain name and icon -->
                <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4 mb-4 mt-2">
                    <div class="flex items-start w-full">
                        <div class="flex-shrink-0 p-2 bg-indigo-50 dark:bg-indigo-800/50 rounded-lg">
                            <span class="material-symbols-outlined text-indigo-600 dark:text-indigo-300">language</span>
                        </div>
                        <div class="ml-3 flex-1 min-w-0">
                            <h3 class="text-lg font-semibold text-gray-900 dark:text-white truncate">${product.order_name}</h3>
                            <p class="text-sm text-gray-500 dark:text-gray-400">
                                <?php echo $lang["registered"]; ?>: ${regDate.toLocaleDateString()}
                            </p>
                        </div>
                    </div>
                    <div class="w-full sm:w-auto">
                        <a href="<?php echo url('/account/cloud/${product.order_number}')?>" class="flex items-center justify-center gap-1 w-full px-4 py-2 bg-dark-600 hover:bg-dark-700 dark:bg-dark-700 dark:hover:bg-dark-800 text-white text-sm font-medium rounded-xl transition-colors">
                            <span><?php echo $lang["manage-cta"]; ?></span>
                            <span class="material-symbols-outlined text-base">chevron_right</span>
                        </a>
                    </div>
                </div>

                <!-- Expiration progress -->
                <div class="mt-2">
                    <div class="flex flex-col xs:flex-row xs:justify-between xs:items-center text-sm mb-1 gap-1 xs:gap-0">
                        <span class="font-medium text-gray-700 dark:text-gray-300">${formattedDate}</span>
                        <span class="${
                daysLeft <= 0 ? 'text-red-600 dark:text-red-400' :
                    daysLeft <= 7 ? 'text-yellow-600 dark:text-yellow-400' :
                        'text-gray-500 dark:text-gray-400'
            }">
                            ${daysLeftText}
                        </span>
                    </div>
                    <div class="w-full bg-gray-200 dark:bg-dark-700 rounded-full h-2">
                        ${daysLeft > 0 ? `
                        <div class="h-2 rounded-full ${progressColor} transition-all duration-500"
                             style="width: ${(progressWidth/365)*100}%"></div>
                        ` : ''}
                    </div>
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                        <?php echo $lang["expires"]; ?>: ${expiryDate.toLocaleDateString()}
                    </p>
                </div>
            </div>
        </div>
        `;
        };

        // Helper functions for products
        const formatCreatedAt = (dateString) => {
            const date = new Date(dateString);
            const options = { year: 'numeric', month: 'long', day: 'numeric' };
            <?php
            $websiteLanguage = $_SESSION["country"];
            if ($websiteLanguage === 'tr') {
                echo "return date.toLocaleDateString('tr-TR', options);";
            } else {
                echo "return date.toLocaleDateString(undefined, options);";
            }
            ?>
        };

        const getStatusData = (status) => {
            const statusMap = {
                'Active': { color: 'bg-green-500 dark:bg-green-600', title: '<?php echo $lang['product-status-active']?>' },
                'Overdue': { color: 'bg-red-500 dark:bg-red-600', title: '<?php echo $lang['product-status-overdue']?>' },
                'Pending': { color: 'bg-yellow-500 dark:bg-yellow-600', title: '<?php echo $lang['product-status-pending']?>' }
            };
            return statusMap[status] || { color: 'bg-gray-500', title: status };
        };

        const getRenewalData = (daysLeft, renewalDate) => {
            if (!renewalDate) {
                return {
                    text: '<?php echo $lang['waiting-for-payment']?>',
                    textColor: 'text-gray-500',
                    dateDisplayClass: 'hidden'
                };
            }

            if (daysLeft > 30) {
                const monthsLeft = Math.ceil(daysLeft / 30);
                if (monthsLeft < 12) {
                    return {
                        text: '<?php echo $lang['renew-in-d-months']; ?>'.replace('%d', monthsLeft),
                        textColor: 'text-gray-600 dark:text-gray-300',
                        dateDisplayClass: ''
                    };
                } else {
                    const yearsLeft = Math.floor(monthsLeft / 12);
                    return {
                        text: '<?php echo $lang['renew-in-d-years']; ?>'.replace('%d', yearsLeft),
                        textColor: 'text-gray-600 dark:text-gray-300',
                        dateDisplayClass: ''
                    };
                }
            } else if (daysLeft <= 30 && daysLeft > 7) {
                return {
                    text: '<?php echo $lang['renew-in-d-days']; ?>'.replace('%d', daysLeft),
                    textColor: 'text-green-600 dark:text-green-400',
                    dateDisplayClass: ''
                };
            } else if (daysLeft <= 7 && daysLeft > 3) {
                return {
                    text: '<?php echo $lang['renew-in-d-days']; ?>'.replace('%d', daysLeft),
                    textColor: 'text-yellow-600 dark:text-yellow-400',
                    dateDisplayClass: ''
                };
            } else if (daysLeft <= 3) {
                return {
                    text: daysLeft >= 0
                        ? '<?php echo $lang['renew-in-d-days']; ?>'.replace('%d', daysLeft)
                        : '<?php echo $lang['overdue-d-days-ago']; ?>'.replace('%d', Math.abs(daysLeft)),
                    textColor: 'text-red-600 dark:text-red-400',
                    dateDisplayClass: ''
                };
            }
        };

        const getProductIcon = (category) => {
            const icons = {
                'web-hosting': 'language',
                'business-hosting': 'business_center',
                'cloud': 'cloud',
                'vps': 'dns',
                'dedicated': 'storage'
            };
            return icons[category] || 'widgets';
        };

        // Fetch and display conversations
        function fetchConversations() {
            $.ajax({
                url: "/dino/fetch_conversations",
                type: "POST",
                dataType: "json",
                success: function(data) {
                    $("#conversationList").empty();
                    if (data.length === 0) {
                        $("#conversationList").append("<p class='flex items-center justify-center h-52 mt-1'>No conversations available yet.</p>");
                    } else {
                        categorizeAndRenderConversations(data);
                    }
                },
                error: function(error) {
                    console.error("Error fetching conversations:", error);
                }
            });
        }

        function categorizeAndRenderConversations(data) {
            const currentDate = new Date();
            currentDate.setHours(0, 0, 0, 0);

            const todayConversations = [];
            const yesterdayConversations = [];
            const previous7DaysConversations = [];
            const previous30DaysConversations = [];
            const otherMonthsConversations = [];

            data.forEach(function(conversation) {
                const lastMessageDate = new Date(conversation.last_message_date);
                lastMessageDate.setHours(0, 0, 0, 0);
                const timeDifference = Math.ceil((currentDate - lastMessageDate) / (1000 * 60 * 60 * 24));

                if (timeDifference === 0) todayConversations.push(conversation);
                else if (timeDifference === 1) yesterdayConversations.push(conversation);
                else if (timeDifference <= 7) previous7DaysConversations.push(conversation);
                else if (timeDifference <= 30) previous30DaysConversations.push(conversation);
                else otherMonthsConversations.push(conversation);
            });

            if (todayConversations.length > 0) renderConversationsWithTitle("<?php echo $lang['account-dino-c-modal-today']; ?>", todayConversations);
            if (yesterdayConversations.length > 0) renderConversationsWithTitle("<?php echo $lang['account-dino-c-modal-yesterday']; ?>", yesterdayConversations);
            if (previous7DaysConversations.length > 0) renderConversationsWithTitle("<?php echo $lang['account-dino-c-modal-a-week-ago']; ?>", previous7DaysConversations);
            if (previous30DaysConversations.length > 0) renderConversationsWithTitle("<?php echo $lang['account-dino-c-modal-a-month-ago']; ?>", previous30DaysConversations);
            if (otherMonthsConversations.length > 0) renderConversationsWithTitle("<?php echo $lang['account-dino-c-modal-other-month']; ?>", otherMonthsConversations);
        }

        function renderConversationsWithTitle(title, conversations) {
            const conversationList = $("#conversationList");

            conversationList.append(`
            <div class="conversation-section-header flex items-center py-2 px-3 text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                <span class="mr-2">${title}</span>
                <span class="flex-1 border-t border-gray-200 dark:border-dark-600"></span>
            </div>
        `);

            conversations.forEach(conversation => {
                const lastMessageTime = formatConversationTime(conversation.last_message_date);

                conversationList.append(`
                <a href="<?php echo url('/account/dino/c/${conversation.id}')?>" class="conversation-item flex items-center p-3 hover:bg-gray-100 dark:hover:bg-dark-500 rounded-lg transition-colors" data-conversation-id="${conversation.id}">
                    <div class="flex-shrink-0 mr-3">
                        <div class="w-10 h-10 rounded-full bg-purple-100 dark:bg-purple-900/20 flex items-center justify-center text-purple-600 dark:text-purple-300">
                            <span class="material-symbols-outlined">forum</span>
                        </div>
                    </div>
                    <div class="flex-1 min-w-0">
                        <div class="flex justify-between items-center">
                            <p class="text-sm font-medium text-gray-900 dark:text-white truncate">${conversation.name}</p>
                            <span class="text-xs text-gray-500 dark:text-gray-400">${lastMessageTime}</span>
                        </div>
                        <p class="text-sm text-gray-500 dark:text-gray-400 truncate">${conversation.last_message || 'No messages yet'}</p>
                    </div>
                </a>
            `);
            });
        }

        function formatConversationTime(dateString) {
            const date = new Date(dateString);
            const now = new Date();
            const diffInHours = Math.floor((now - date) / (1000 * 60 * 60));

            if (diffInHours < 24) {
                return date.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' });
            } else if (diffInHours < 168) {
                return date.toLocaleDateString([], { weekday: 'short' });
            } else {
                return date.toLocaleDateString([], { month: 'short', day: 'numeric' });
            }
        }

        // Fetch and display analytics
        function fetchAnalyticsData() {
            const spinner = $('.spinner');
            const websiteInfo = $('#website-info');

            spinner.removeClass('hidden').show();

            $.ajax({
                url: '/analytics_get_summary',
                type: 'POST',
                dataType: 'json',
                data: {
                    timeframe: '30d',
                    metrics: 'visits,unique_visitors,bounce_rate,avg_duration'
                },
                success: function(response) {
                    setTimeout(() => spinner.hide(), 300);

                    if (response.success) {
                        $('#website_info').removeClass('hidden');
                        $('#website_url').text(response.websiteInfo.website_url);
                        displayWebsiteInfo(response.websiteInfo, response.analyticsData);
                    } else if (response.message === 'no_domain') {
                        websiteInfo.html(`
                        <div class="no-domain text-center">
                            <div class="p-6 bg-gray-50 dark:bg-dark-600 rounded-lg">
                                <span class="material-symbols-outlined flex mx-auto text-gray-400 dark:text-gray-500 text-4xl mb-3">public</span>
                                <h3 class="text-lg font-medium text-gray-700 dark:text-gray-300 mb-1">
                                    <?php echo $lang['datanito-analytics-no-domain-headline']?>
                                </h3>
                                <p class="text-sm text-gray-500 dark:text-gray-400 mb-4">
                                    <?php echo $lang['datanito-analytics-no-domain-subheading']?>
                                </p>
                                <a href="<?php echo url('/account/analytics'); ?>" class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-lg transition-colors">
                                    <?php echo $lang['datanito-analytics-no-domain-cta']?>
                                    <span class="material-symbols-outlined ml-2 text-base">arrow_forward</span>
                                </a>
                            </div>
                        </div>
                    `);
                    } else {
                        console.error("Analytics error:", response.message);
                        showAnalyticsError(response.message);
                    }
                },
                error: function(xhr, status, error) {
                    spinner.hide();
                    console.error("Analytics fetch error:", error);
                    showAnalyticsError(error);
                }
            });
        }

        function displayWebsiteInfo(websiteInfo, analyticsData) {
            const websiteInfoContainer = $('#website-info');

            if (!analyticsData || analyticsData.length === 0) {
                websiteInfoContainer.html(`
                <div class="no-data p-6 bg-gray-50 dark:bg-dark-600 rounded-lg text-center">
                    <span class="material-symbols-outlined flex items-center justify-center mx-auto text-gray-400 dark:text-gray-500 text-4xl mb-3">analytics</span>
                    <h3 class="text-lg font-medium text-gray-700 dark:text-gray-300 mb-1">No Analytics Data</h3>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mb-4">We don't have enough data to display yet.</p>
                </div>
            `);
                return;
            }

            const totalVisits = calculateTotal(analyticsData, 'visits');
            const visitsChange = calculateChange(analyticsData, 'visits');
            const totalUnique = calculateTotal(analyticsData, 'unique_visitors');
            const uniqueChange = calculateChange(analyticsData, 'unique_visitors');

            websiteInfoContainer.html(`
            <div class="analytics-grid grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                ${analyticsCardTemplate('<?php echo $lang['total-visits']?>', totalVisits, visitsChange, 'group')}
                ${analyticsCardTemplate('<?php echo $lang['unique-visitors']?>', totalUnique, uniqueChange, 'person')}
                ${analyticsCardTemplate('<?php echo $lang['bounce-rate']?>', '24%', '+2.3%', 'signal_cellular_alt')}
                ${analyticsCardTemplate('<?php echo $lang['avg-duration']?>', '2m 45s', '+12%', 'schedule')}
            </div>
            <div class="mt-6 flex justify-center">
                <a href="<?php echo url('/account/analytics'); ?>" class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-lg transition-colors">
                    <?php echo $lang['view-full-analytics']?>
                    <span class="material-symbols-outlined ml-2 text-base">arrow_forward</span>
                </a>
            </div>
        `);
        }

        function analyticsCardTemplate(title, value, change, icon) {
            const isPositive = !change.includes('-');
            const arrowIcon = isPositive ? 'trending_up' : 'trending_down';

            return `
            <div class="analytics-card p-5 bg-white dark:bg-dark-700 rounded-lg border border-gray-100 dark:border-dark-600 hover:shadow-xs transition-shadow">
                <div class="flex items-center justify-between mb-3">
                    <h3 class="text-sm font-medium text-gray-500">${title}</h3>
                    <span class="flex items-center justify-center w-8 h-8 rounded-lg bg-blue-50 dark:bg-blue-900/20 text-blue-600 dark:text-blue-300">
                        <span class="material-symbols-outlined">${icon}</span>
                    </span>
                </div>
                <div class="flex items-end justify-between">
                    <div>
                        <p class="text-3xl font-light text-gray-900 dark:text-white mb-1">${value}</p>
                        <div class="flex items-center ${isPositive ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400'}">
                            <span class="material-symbols-outlined text-base">${arrowIcon}</span>
                            <span class="text-sm font-medium ml-1">${change}</span>
                        </div>
                    </div>
                </div>
            </div>
        `;
        }

        function calculateTotal(data, property) {
            if (!data || !Array.isArray(data)) return 0;
            return data.reduce((sum, item) => sum + (item[property] || 0), 0).toLocaleString();
        }

        function calculateChange(data, property) {
            if (!data || data.length < 2) return '0%';
            const current = data[data.length - 1][property] || 0;
            const previous = data[data.length - 2][property] || 1;
            const change = ((current - previous) / previous * 100).toFixed(1);
            return `${change > 0 ? '+' : ''}${change}%`;
        }

        function showAnalyticsError(error) {
            $('#website-info').html(`
            <div class="analytics-error p-6 bg-red-50 dark:bg-red-900/10 rounded-lg text-center border border-red-200 dark:border-red-800">
                <span class="material-symbols-outlined flex mx-auto text-red-600 dark:text-red-400 text-4xl mb-3">error</span>
                <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-1"><?php echo $lang['analytics-unavailable']?></h3>
                <p class="text-sm text-gray-600 dark:text-gray-300 mb-4">We're unable to load analytics data at this time.</p>
                <button onclick="fetchAnalyticsData()" class="retry-button px-4 py-2 bg-red-600 hover:bg-red-700 text-white text-sm font-medium rounded-lg transition-colors">
                    <?php echo $lang['retry']?>
                </button>
            </div>
        `);
        }

        // Resend verification email
        $('#resend-verification-button').click(function() {
            $.ajax({
                url: '/resend_verification_email',
                type: 'POST',
                data: { csrf: csrf },
                success: function(response) {
                    if (response.success) {
                        // Show success message
                        $('#email-confirmation-banner').html(`
                        <div class="flex items-center space-x-3">
                            <span class="flex items-center justify-center w-8 h-8 rounded-full bg-green-500 text-white">
                                <span class="material-symbols-outlined text-sm">check</span>
                            </span>
                            <p class="text-sm font-medium text-gray-800 dark:text-gray-200">
                                Verification email sent successfully!
                            </p>
                        </div>
                    `);
                    }
                },
                error: function(error) {
                    console.error("Error resending verification email:", error);
                }
            });
        });

        // Initialize all components
        loadProfile();
        loadProducts();
        fetchConversations();
        fetchAnalyticsData();

        // Set up periodic refresh
        setInterval(loadProducts, 300000);
        setInterval(fetchAnalyticsData, 300000);
    });
</script>