<?php
$meta = array(
    'us' => array(
        'title' => 'Datanito Pay - Payment Management for Your Account',
        'description' => 'Manage your payments and subscriptions with Datanito Pay. Keep your account up to date with our easy-to-use payment system.',
        'og:title' => 'Datanito Pay - Payment Management for Your Account',
        'og:description' => 'Manage your payments and subscriptions with Datanito Pay. Keep your account up to date with our easy-to-use payment system.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Datanito Pay (Türkiye) - Hesabınız İçin Ödeme Yönetimi',
        'description' => 'Datanito Pay ile ödemelerinizi ve aboneliklerinizi yönetin. Hesabınızı kolayca güncel tutmak için kullanımı kolay ödeme sistemi.',
        'og:title' => 'Datanito Pay (Türkiye) - Hesabınız İçin Ödeme Yönetimi',
        'og:description' => 'Datanito Pay ile ödemelerinizi ve aboneliklerinizi yönetin. Hesabınızı kolayca güncel tutmak için kullanımı kolay ödeme sistemi.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);

$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/dashboard.php');
?>
<main class="p-4 md:pl-64 md:ml-8 md:mr-4 h-full pt-20 min-h-[70em] !overflow-hidden">
    <div class="relative rounded-xl border border-gray-200 bg-gray-50 dark:bg-dark-700 dark:border-gray-600 p-4 md:p-6 skeleton min-h-[50em]">
        <div class="absolute left-[50%] top-[50%] translate-y-[-50%] translate-x-[-50%] flex justify-center items-center z-10 h-full w-full text-center backdrop-blur rounded-xl skeleton">
            <div class="block space-y-4 w-[75%]">
                <a href="<?php echo url('/account/pay'); ?>" class="flex items-center text-center justify-center absolute top-5 left-5">
                    <svg class="w-7 h-7 mr-4" xmlns="http://www.w3.org/2000/svg"
                         xmlns:xlink="http://www.w3.org/1999/xlink" width="151px" height="150px"
                         viewBox="0 0 639 636">
                        <g id="surface1">
                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                  class="fill-dark-950 dark:fill-white"
                                  d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/>
                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                  class="fill-dark-950 dark:fill-white"
                                  d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/>
                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                  class="fill-dark-950 dark:fill-white"
                                  d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/>
                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                  class="fill-dark-950 dark:fill-white"
                                  d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/>
                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                  class="fill-dark-950 dark:fill-white"
                                  d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/>
                        </g>
                    </svg>
                    <h1 class="text-2xl ml-[-0.6em] tracking-tight font-bold text-dark-950 dark:text-white"><?php echo $lang['datanito-pay']; ?></h1>
                </a>
                <p class="text-xl font-medium text-gray-800 dark:text-gray-200">
                    <?php echo $lang['datanito-pay-ea-headline']; ?>
                </p>
                <p class="text-lg font-medium text-gray-500 dark:text-gray-400">
                    <?php echo $lang['datanito-pay-ea-subheading']; ?>
                </p>
                <button type="button" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-3xl text-sm px-5 py-2.5 dark:bg-blue-600 dark:hover-bg-blue-700 focus:outline-none dark:focus:ring-blue-800">
                    <?php echo $lang['datanito-pay-ea-cta']; ?>
                </button>
                </div>
            </div>
        <div class="opacity-20">
        </div>
    </div>
</main>
<?php
include_once includes('layouts/dashboard-end.php');
?>

