<?php
$meta = array(
    'us' => array(
        'title' => 'New Post - Datanito',
        'description' => 'View and manage your previous support requests with Datanito. Access details of your support history and find solutions to common issues.',
        'og:title' => 'View Previous Help Requests - Datanito',
        'og:description' => 'View and manage your previous support requests with Datanito. Access details of your support history and find solutions to common issues.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Yardım Taleplerini - Datanito (Türkiye)',
        'description' => 'Datanito ile önceki yardım taleplerinizi görüntüleyin ve yönetin. Destek geçmişinizin detaylarına erişin ve ortak sorunlara çözüm bulun.',
        'og:title' => 'Önceki Yardım Taleplerini Görüntüle - Datanito (Türkiye)',
        'og:description' => 'Datanito ile önceki yardım taleplerinizi görüntüleyin ve yönetin. Destek geçmişinizin detaylarına erişin ve ortak sorunlara çözüm bulun.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = $meta[$_SESSION["country"]];
include_once includes('layouts/dashboard.php');
include_once includes('auth/admin-validation.php');

// Perform SQL query to retrieve blog categories
$query = "SELECT * FROM blog_categories";
$result = $conn->query($query);

// Check if the query was successful
if ($result) {
    // Fetch the results as an associative array
    $categories = $result->fetch_all(MYSQLI_ASSOC);
} else {
    // Send JSON response with an error
}
?>
<main class="p-4 md:ml-64 h-full pt-20 min-h-[70em]">
    <div class="container mx-auto mt-8">
        <h1 class="text-3xl font-bold mb-4">Blog Editor</h1>

        <form id="blogForm" method="post" enctype="multipart/form-data" class="space-y-6">
            <!-- Title, Content, Meta Fields -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label for="meta_title" class="block text-sm font-medium text-gray-700">Meta Title</label>
                    <input type="text" name="meta_title" id="meta_title" class="mt-1 block w-full p-3 border border-gray-300 rounded-xl shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-700 dark:border-gray-600 dark:text-white" placeholder="Enter Meta Title">
                </div>

                <div>
                    <label for="meta_description" class="block text-sm font-medium text-gray-700">Meta Description</label>
                    <input type="text" name="meta_description" id="meta_description" class="mt-1 block w-full p-3 border border-gray-300 rounded-xl shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-700 dark:border-gray-600 dark:text-white" placeholder="Enter Meta Description">
                </div>

                <div>
                    <label for="slug" class="block text-sm font-medium text-gray-700">Slug</label>
                    <input type="text" name="slug" id="slug" class="mt-1 block w-full p-3 border border-gray-300 rounded-xl shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-700 dark:border-gray-600 dark:text-white" placeholder="Enter URL Slug">
                </div>

                <div>
                    <label for="title" class="block text-sm font-medium text-gray-700">Title</label>
                    <input type="text" name="title" id="title" class="mt-1 block w-full p-3 border border-gray-300 rounded-xl shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-700 dark:border-gray-600 dark:text-white" placeholder="Enter Blog Title">
                </div>
            </div>

            <!-- Language and Status -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label for="language" class="block text-sm font-medium text-gray-700">Language</label>
                    <select name="language" id="language" class="mt-1 block w-full p-2.5 border border-gray-300 rounded-xl shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-700 dark:border-gray-600 dark:text-white">
                        <option value="en">English</option>
                        <option value="tr">Turkish</option>
                    </select>
                </div>

                <div>
                    <label for="status" class="block text-sm font-medium text-gray-700">Status</label>
                    <select name="status" id="status" class="mt-1 block w-full p-2.5 border border-gray-300 rounded-xl shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-700 dark:border-gray-600 dark:text-white">
                        <option value="published">Published</option>
                        <option value="draft">Draft</option>
                        <option value="archive">Archive</option>
                    </select>
                </div>

                <div>
                    <label for="main_photo" class="block text-sm font-medium text-gray-700">Main Photo</label>
                    <input type="file" name="main_photo" id="main_photo" accept="image/*" class="mt-1 block w-full p-2 border border-gray-300 rounded-xl shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-700 dark:border-gray-600 dark:text-white">
                </div>
            </div>

            <!-- Categories Dropdown -->
            <div class="relative">
                <button id="dropdownCategoriesButton" data-dropdown-toggle="dropdownCategories" class="inline-flex items-center justify-between bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-xl focus:ring-blue-500 focus:border-blue-500 block w-full p-3 dark:bg-dark-700 dark:border-gray-600 dark:text-white">
                    Categories
                    <svg class="w-2.5 h-2.5 ms-2.5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 4 4 4-4" />
                    </svg>
                </button>

                <div id="dropdownCategories" class="z-10 hidden bg-white rounded-lg shadow w-60 dark:bg-gray-700">
                    <div class="p-3">
                        <input type="text" id="input-group-search" class="block w-full p-2.5 text-sm bg-gray-50 border border-gray-300 rounded-lg shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-600 dark:border-gray-500 dark:text-white" placeholder="Search categories">
                    </div>

                    <ul id="dropdownCategoriesList" class="h-48 px-3 pb-3 overflow-y-auto text-sm text-gray-700 dark:text-gray-200">
                        <!-- Categories will be dynamically loaded -->
                    </ul>
                </div>

                <div id="selectedCategories" class="mt-2 text-sm text-gray-600 dark:text-gray-300"></div>
            </div>

            <!-- Editor -->
            <div class="mt-6">
                <label for="editor" class="block text-sm font-medium text-gray-700">Content</label>
                <div id="editor" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-xl shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-700 dark:border-gray-600 dark:text-white"></div>
            </div>

            <!-- Submit Button -->
            <button type="submit" class="flex items-center mt-8 bg-blue-700 hover:bg-blue-800 text-white font-medium rounded-3xl px-5 py-2.5 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                <span>Publish</span>
                <span class="material-symbols-outlined ms-2">publish</span>
            </button>
        </form>
    </div>
</main>
<?php
include_once includes('layouts/dashboard-end.php');
?>

<script src="https://cdn.tiny.cloud/1/u5xlafwcya8zxwk9t9kqjw347h4mo8i6ldv93r883wdpagq5/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>

<script>
    // Fetch categories from the server
    function loadCategories() {
        $.ajax({
            url: '/admin/blog/fetch-categories',
            type: 'POST',
            dataType: 'json',
            success: function (categories) {
                console.log(categories);
                populateCategories(categories);
            },
            error: function (error) {
                console.error('Error fetching categories:', error);
            }
        });
    }

    // Populate the select element with categories
    // Populate the select element with categories
    function populateCategories(categories) {
        const dropdownSearchList = $('#dropdownCategoriesList');

        categories.forEach(category => {
            const listItem = $(`
            <li>
                <div class="flex items-center p-2 rounded hover:bg-gray-100 dark:hover:bg-gray-600">
                    <input id="checkbox-item-${category.category_id}" type="checkbox" value="${category.category_id}" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-700 dark:focus:ring-offset-gray-700 focus:ring-2 dark:bg-gray-600 dark:border-gray-500">
                    <label for="checkbox-item-${category.category_id}" class="w-full ms-2 text-sm font-medium text-gray-900 rounded dark:text-gray-300">${category.name}</label>
                </div>
            </li>
        `);

            dropdownSearchList.append(listItem);
        });

        // Listen for changes in category checkboxes
        $(document).on('change', '#dropdownCategoriesList input[type="checkbox"]', function () {
            updateSelectedCategories();
        });

        // Additional function to update the displayed selected categories
        function updateSelectedCategories() {
            const selectedCategoryNames = $('#dropdownCategoriesList input[type="checkbox"]:checked')
                .map(function () {
                    return $(this).next('label').text();
                })
                .get()
                .join(', ');

            $('#selectedCategories').text(selectedCategoryNames);
        }
    }


    // Load categories when the page is ready
    $(document).ready(function () {
        loadCategories();
    });

    // Initialize TinyMCE editor
    tinymce.init({
        selector: '#editor',
        height: 300,
        plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount linkchecker',
        toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
    });

    $(document).ready(function() {
        $('#blogForm').submit(function(event) {
            event.preventDefault();

            // Get the TinyMCE editor content
            const content = tinymce.get('editor').getContent();
            // Get selected category IDs
            const selectedCategoryIds = $('#dropdownCategoriesList input[type="checkbox"]:checked')
                .map(function () {
                    return $(this).val();
                })
                .get();

            // Add content to the FormData object
            var formData = new FormData(this);
            formData.append('content', content);
            formData.append('category', JSON.stringify(selectedCategoryIds));

            $.ajax({
                type: 'POST',
                url: '/blog-submit-post',
                data: formData,
                contentType: false,
                processData: false,
                dataType: 'json',
                success: function(response) {
                    if (response.status === 'success') {
                        alert(response.message);
                        // Optionally, redirect to another page or perform additional actions
                    } else {
                        alert(response.message);
                    }
                },
                error: function(error) {
                    console.error(error);
                    alert('Error submitting the form. Please try again.');
                }
            });
        });
    });


</script>

