<?php
$meta = array(
    'us' => array(
        'title' => 'Send Professional Emails - Datanito',
        'description' => 'Send beautifully designed emails to your customers with Datanito\'s professional email system.',
        'og:title' => 'Professional Email System - Datanito',
        'og:description' => 'Send beautifully designed emails to your customers with Datanito\'s professional email system.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Profesyonel E-Posta Gönder - Datanito',
        'description' => 'Datanito\'nun profesyonel e-posta sistemi ile müşterilerinize güzel tasarlanmış e-postalar gönderin.',
        'og:title' => 'Profesyonel E-Posta Sistemi - Datanito',
        'og:description' => 'Datanito\'nun profesyonel e-posta sistemi ile müşterilerinize güzel tasarlanmış e-postalar gönderin.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/dashboard.php');
?>
<main class="p-4 md:pl-64 md:ml-8 md:mr-4 h-full pt-20 min-h-[70em]">
    <div class="h-full">
        <div class="my-6 ml-5">
            <h3 class="text-2xl tracking-tight font-semibold text-gray-900 dark:text-white">Professional Email System</h3>
            <h3 class="text-lg mt-2 tracking-tight font-normal text-gray-900 dark:text-white">Send beautifully designed emails to customers and users</h3>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
            <div class="bg-white dark:bg-dark-800 p-6 rounded-xl shadow-sm cursor-pointer hover:shadow-md transition-shadow" onclick="loadTemplate('invoice')">
                <div class="flex items-center space-x-4">
                    <div class="bg-blue-100 dark:bg-blue-900 p-3 rounded-lg">
                        <span class="material-symbols-outlined text-blue-600 dark:text-blue-300">receipt</span>
                    </div>
                    <div>
                        <h4 class="font-medium">Invoice</h4>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Professional invoice template</p>
                    </div>
                </div>
            </div>

            <div class="bg-white dark:bg-dark-800 p-6 rounded-xl shadow-sm cursor-pointer hover:shadow-md transition-shadow" onclick="loadTemplate('receipt')">
                <div class="flex items-center space-x-4">
                    <div class="bg-green-100 dark:bg-green-900 p-3 rounded-lg">
                        <span class="material-symbols-outlined text-green-600 dark:text-green-300">paid</span>
                    </div>
                    <div>
                        <h4 class="font-medium">Receipt</h4>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Payment confirmation</p>
                    </div>
                </div>
            </div>

            <div class="bg-white dark:bg-dark-800 p-6 rounded-xl shadow-sm cursor-pointer hover:shadow-md transition-shadow" onclick="loadTemplate('overdue')">
                <div class="flex items-center space-x-4">
                    <div class="bg-red-100 dark:bg-red-900 p-3 rounded-lg">
                        <span class="material-symbols-outlined text-red-600 dark:text-red-300">warning</span>
                    </div>
                    <div>
                        <h4 class="font-medium">Overdue Notice</h4>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Payment reminder</p>
                    </div>
                </div>
            </div>

            <div class="bg-white dark:bg-dark-800 p-6 rounded-xl shadow-sm cursor-pointer hover:shadow-md transition-shadow" onclick="loadTemplate('product')">
                <div class="flex items-center space-x-4">
                    <div class="bg-purple-100 dark:bg-purple-900 p-3 rounded-lg">
                        <span class="material-symbols-outlined text-purple-600 dark:text-purple-300">new_releases</span>
                    </div>
                    <div>
                        <h4 class="font-medium">Product Announcement</h4>
                        <p class="text-sm text-gray-500 dark:text-gray-400">New service/product</p>
                    </div>
                </div>
            </div>
        </div>

        <form id="emailForm" class="mb-2 mx-3" enctype="multipart/form-data">
            <?php set_csrf(); ?>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <div>
                    <label for="emailType" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Email Type</label>
                    <select id="emailType" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-xl focus:ring-blue-500 focus:border-blue-500 block w-full p-3 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                        <option value="custom">Custom Email</option>
                        <option value="invoice">Invoice</option>
                        <option value="receipt">Receipt</option>
                        <option value="overdue">Overdue Notice</option>
                        <option value="product">Product Announcement</option>
                    </select>
                </div>

                <div>
                    <label for="emailLang" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Language</label>
                    <select id="emailLang" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-xl focus:ring-blue-500 focus:border-blue-500 block w-full p-3 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                        <option value="us">English</option>
                        <option value="tr">Turkish</option>
                    </select>
                </div>
            </div>

            <div class="relative rounded-xl w-full bg-gray-50 dark:bg-dark-800 mb-6">
                <input type="text" id="subject" name="subject" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-xl focus:ring-blue-500 focus:border-blue-500 block w-full p-3.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Subject line (keep it under 100 characters)" maxlength="100">
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <div>
                    <label for="email" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Recipient Email</label>
                    <input type="email" id="email" name="email" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-xl focus:ring-blue-500 focus:border-blue-500 block w-full p-3.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="customer@example.com" required>
                </div>

                <div>
                    <label for="name" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Recipient Name</label>
                    <input type="text" id="name" name="name" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-xl focus:ring-blue-500 focus:border-blue-500 block w-full p-3.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="John Doe" required>
                </div>
            </div>

            <div class="relative rounded-xl w-full bg-gray-50 dark:bg-dark-800 mb-6">
                <input type="text" id="emailHeadline" name="emailHeadline" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-xl focus:ring-blue-500 focus:border-blue-500 block w-full p-3.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Email Headline (appears at top of email)" required>
            </div>

            <!-- Add this button to trigger the modal (place it where you want the "Create Invoice" button to appear) -->
            <button data-modal-target="create-invoice-modal" data-modal-toggle="create-invoice-modal" class="block text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm my-3 px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800" type="button">
                Create Invoice
            </button>
            <!-- Dynamic fields based on template -->
            <div id="templateFields">
                <!-- Invoice fields -->
                <div id="invoiceFields" class="hidden grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
                    <div>
                        <label for="invoiceNumber" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Invoice #</label>
                        <input type="text" id="invoiceNumber" name="invoiceNumber" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-xl focus:ring-blue-500 focus:border-blue-500 block w-full p-3.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="INV-2023-001">
                    </div>
                    <div>
                        <label for="invoiceAmount" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Amount</label>
                        <input type="text" id="invoiceAmount" name="invoiceAmount" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-xl focus:ring-blue-500 focus:border-blue-500 block w-full p-3.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="$99.00">
                    </div>
                    <div>
                        <label for="dueDate" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Due Date</label>
                        <input type="date" id="dueDate" name="dueDate" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-xl focus:ring-blue-500 focus:border-blue-500 block w-full p-3.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                    </div>
                </div>

                <!-- Product fields -->
                <div id="productFields" class="hidden grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                    <div>
                        <label for="productName" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Product Name</label>
                        <input type="text" id="productName" name="productName" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-xl focus:ring-blue-500 focus:border-blue-500 block w-full p-3.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="AI Payment Processor">
                    </div>
                    <div>
                        <label for="productPrice" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Price</label>
                        <input type="text" id="productPrice" name="productPrice" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-xl focus:ring-blue-500 focus:border-blue-500 block w-full p-3.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="$99/month">
                    </div>
                    <div class="md:col-span-2">
                        <label for="productDescription" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Description</label>
                        <textarea id="productDescription" name="productDescription" rows="2" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-xl focus:ring-blue-500 focus:border-blue-500 block w-full p-3.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Brief description of your product/service"></textarea>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <div>
                    <label for="btnCta" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Button Text</label>
                    <input type="text" id="btnCta" name="btnCta" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-xl focus:ring-blue-500 focus:border-blue-500 block w-full p-3.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="e.g. Pay Now, Learn More" value="View Details">
                </div>
                <div>
                    <label for="btnLink" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Button Link</label>
                    <input type="url" id="btnLink" name="btnLink" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-xl focus:ring-blue-500 focus:border-blue-500 block w-full p-3.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="https://datanito.com/payment">
                </div>
            </div>

            <div class="w-full mb-6 border border-gray-200 rounded-xl bg-gray-100 dark:bg-dark-600 dark:border-gray-600">
                <div class="relative rounded-xl skeleton w-full bg-gray-50 dark:bg-dark-800">
                    <div id="editor"></div>
                </div>
                <div class="flex items-center justify-between px-3 py-2 border-t dark:border-gray-600">
                    <button type="submit" class="flex items-center space-x-2 text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-3xl text-sm sm:w-auto px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800 skeleton">
                        <span>Send Email</span>
                        <span class="material-symbols-outlined">send</span>
                    </button>
                </div>
            </div>

            <div id="uploadArea" class="upload-area skeleton bg-gray-50 dark:bg-dark-600 p-4 mb-8 border border-gray-200 rounded-xl dark:bg-dark-700 dark:border-gray-600 max-h-96">
                <div class="upload-area__header">
                    <p class="upload-area__paragraph text-gray-600 dark:text-gray-300">
                        <span class="upload-area__tooltip-data"></span> Attach files (PDF, JPG, PNG up to 10MB)
                    </p>
                </div>

                <div id="dropZoon" class="upload-area__drop-zoon drop-zoon mt-3 border-2 border-dashed rounded-xl border-gray-300 dark:border-gray-600 z-0">
                    <span class="drop-zoon__icon">
                      <i class='bx bxs-file-image'></i>
                    </span>
                    <p class="drop-zoon__paragraph text-gray-700 dark:text-gray-200">Drop files here or click to browse</p>
                    <span id="loadingText" class="drop-zoon__loading-text">Please wait, uploading in progress...</span>
                    <img src="" alt="Preview Image" id="previewImage" class="drop-zoon__preview-image" draggable="false">
                    <input id="fileInput" class="drop-zoon__file-input" type="file" name="fileInput">
                </div>

                <div id="fileDetails" class="upload-area__file-details file-details">
                    <h3 class="file-details__title my-3">Uploaded File</h3>
                    <div id="uploadedFile" class="uploaded-file">
                        <div class="uploaded-file__icon-container">
                            <i class='bx bxs-file-blank uploaded-file__icon'></i>
                            <span class="uploaded-file__icon-text hidden"></span>
                        </div>
                        <div id="uploadedFileInfo" class="uploaded-file__info">
                            <span class="uploaded-file__name">Proejct 1</span>
                            <span class="uploaded-file__counter">0%</span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="relative hidden">
                <input type="text" id="honeypot" name="honeypot" value="">
            </div>
        </form>
    </div>
    <div id="create-invoice-modal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full overflow-x-hidden overflow-y-auto md:inset-0 h-[calc(100%-1rem)] max-h-full">
        <div class="relative w-full max-w-4xl max-h-full">
            <!-- Modal content -->
            <div class="relative bg-white rounded-lg shadow dark:bg-dark-700">
                <!-- Modal header -->
                <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                        Create Invoice
                    </h3>
                    <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="create-invoice-modal">
                        <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                </div>
                <!-- Modal body -->
                <div class="p-4 md:p-5 space-y-4">
                    <div class="grid grid-cols-1 md:grid-cols-1 gap-6">
                        <div>
                            <label for="invoice-customer-name" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Customer Name*</label>
                            <input type="text" id="invoice-customer-name" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="John Doe" required>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                        <div>
                            <label for="invoice-number" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Invoice #*</label>
                            <input type="text" id="invoice-number" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="INV-2023-001" required>
                        </div>
                        <div>
                            <label for="invoice-date" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Invoice Date*</label>
                            <input type="date" id="invoice-date" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" required>
                        </div>
                        <div>
                            <label for="invoice-due-date" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Due Date*</label>
                            <input type="date" id="invoice-due-date" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" required>
                        </div>
                        <div>
                            <label for="invoice-currency" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Currency*</label>
                            <select id="invoice-currency" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                <option value="$">USD ($)</option>
                                <option value="₺">TRY (₺)</option>
                                <option value="€">EUR (€)</option>
                                <option value="£">GBP (£)</option>
                            </select>
                        </div>
                    </div>

                    <div>
                        <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Invoice Items</label>
                        <div class="overflow-x-auto">
                            <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
                                <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-dark-700 dark:text-gray-400">
                                <tr>
                                    <th scope="col" class="px-6 py-3">Description</th>
                                    <th scope="col" class="px-6 py-3">Quantity</th>
                                    <th scope="col" class="px-6 py-3">Price</th>
                                    <th scope="col" class="px-6 py-3">Tax</th>
                                    <th scope="col" class="px-6 py-3">Total</th>
                                    <th scope="col" class="px-6 py-3"></th>
                                </tr>
                                </thead>
                                <tbody id="invoice-items">
                                <tr class="bg-white border-b dark:bg-dark-800 dark:border-gray-700">
                                    <td class="px-6 py-4">
                                        <input type="text" class="item-description bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Service or product" required>
                                    </td>
                                    <td class="px-6 py-4">
                                        <input type="number" class="item-quantity bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" value="1" min="1" required>
                                    </td>
                                    <td class="px-6 py-4">
                                        <input type="number" step="0.01" class="item-price bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="0.00" required>
                                    </td>
                                    <td class="px-6 py-4">
                                        <select class="item-tax bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                            <option value="0">0%</option>
                                            <option value="8">8%</option>
                                            <option value="18" selected>18%</option>
                                            <option value="20">20%</option>
                                        </select>
                                    </td>
                                    <td class="px-6 py-4 item-total">
                                        $0.00
                                    </td>
                                    <td class="px-6 py-4">
                                        <button type="button" class="remove-item text-red-600 hover:text-red-800 dark:text-red-400 dark:hover:text-red-300">
                                            <span class="material-symbols-outlined">delete</span>
                                        </button>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                            <button type="button" id="add-item" class="mt-2 text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300 text-sm font-medium">
                                + Add Item
                            </button>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="invoice-notes" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Notes</label>
                            <textarea id="invoice-notes" rows="3" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Additional notes or terms"></textarea>
                        </div>
                        <div>
                            <div class="bg-gray-50 dark:bg-dark-800 p-4 rounded-lg">
                                <div class="flex justify-between mb-2">
                                    <span class="text-gray-700 dark:text-gray-300">Subtotal:</span>
                                    <span id="invoice-subtotal" class="font-medium">$0.00</span>
                                </div>
                                <div class="flex justify-between mb-2">
                                    <span class="text-gray-700 dark:text-gray-300">Tax:</span>
                                    <span id="invoice-tax" class="font-medium">$0.00</span>
                                </div>
                                <div class="flex justify-between text-lg font-bold">
                                    <span class="text-gray-900 dark:text-white">Total:</span>
                                    <span id="invoice-total" class="text-blue-600 dark:text-blue-400">$0.00</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="border border-gray-300 hidden md:block">
                        <div id="invoice" class="show-invoice bg-white overflow-x-auto">
                            <div class="px-6 md:px-14 py-6">
                                <table class="w-full border-collapse border-spacing-0">
                                    <tbody>
                                    <tr>
                                        <td class="w-full align-top">
                                            <div>
                                                <svg class="h-12 w-12" xmlns="http://www.w3.org/2000/svg"
                                                     xmlns:xlink="http://www.w3.org/1999/xlink" width="151px" height="150px"
                                                     viewBox="0 0 639 636">
                                                    <g id="surface1">
                                                        <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                                              class="fill-dark-950"
                                                              d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/>
                                                        <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                                              class="fill-dark-950"
                                                              d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/>
                                                        <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                                              class="fill-dark-950"
                                                              d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/>
                                                        <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                                              class="fill-dark-950"
                                                              d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/>
                                                        <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                                              class="fill-dark-950"
                                                              d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/>
                                                    </g>
                                                </svg>
                                            </div>
                                        </td>

                                        <td class="align-top">
                                            <div class="text-sm">
                                                <table class="border-collapse border-spacing-0">
                                                    <tbody>
                                                    <tr>
                                                        <td class="border-r pr-4">
                                                            <div>
                                                                <p class="whitespace-nowrap text-slate-400 text-right"><?php echo $lang['invoice-date']; ?></p>
                                                                <p class="whitespace-nowrap text-black font-bold text-main text-right invoice_date">
                                                                </p>
                                                            </div>
                                                        </td>
                                                        <td class="pl-4">
                                                            <div>
                                                                <p class="whitespace-nowrap text-slate-400 text-right"><?php echo $lang['invoice-number']; ?></p>
                                                                <p class="whitespace-nowrap text-black font-bold text-main text-right invoice_number"></p>
                                                            </div>
                                                        </td>
                                                        <td class="pl-4">
                                                            <div>
                                                                <p class="whitespace-nowrap text-slate-400 text-right"><?php echo $lang['invoice-due-date']; ?></p>
                                                                <p class="whitespace-nowrap text-black font-bold text-main text-right invoice_due_date"></p>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>

                            <div class="bg-slate-100 px-14 py-6 text-sm h-36">
                                <table class="w-full border-collapse border-spacing-0">
                                    <tbody>
                                    <tr>
                                        <td class="w-1/2 align-top">
                                            <div class="text-sm text-neutral-600">
                                                <p class="font-bold"><?php echo $lang['invoice-billed-to']; ?></p>
                                                <p class="customer-name"></p>
                                                <p class="hidden"><?php echo $lang['invoice-datanito-id']; ?>: #<span class="profile-id"></span></p>
                                                <p class="customer-vat-on hidden"><?php echo $lang['invoice-vat']; ?>: <span class="customer-vat"></span></p>
                                                <p class="customer-address"></p>
                                                <p class="customer-address-2"></p>
                                                <p><span class="customer-city"></span><span class="customer-postcode"></span></p>
                                                <p class="customer-country"></p>
                                            </div>
                                        </td>
                                        <td class="w-1/2 align-top text-right">
                                            <div class="text-sm text-neutral-600 text-right flex justify-end">
                                                <span class="font-semibold text-lg invoice_status"></span>
                                            </div>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>

                            <div class="px-4 md:px-14 py-10 text-sm text-neutral-700 min-h-[630px]">
                                <table class="w-full border-collapse border-spacing-0 overflow-x-scroll">
                                    <thead>
                                    <tr>
                                        <td class="border-b-2 border-main pb-3 pl-3 font-bold">#</td>
                                        <td class="border-b-2 border-main pb-3 pl-2 font-bold"><?php echo $lang['invoice-product-details']; ?></td>
                                        <td class="border-b-2 border-main pb-3 pl-2 text-right font-bold"><?php echo $lang['invoice-price']; ?></td>
                                        <td class="border-b-2 border-main pb-3 pl-2 text-center font-bold"><?php echo $lang['invoice-qty']; ?></td>
                                        <td class="border-b-2 border-main pb-3 pl-2 text-center font-bold"><?php echo $lang['invoice-vat']; ?></td>
                                        <td class="border-b-2 border-main pb-3 pl-2 text-right font-bold"><?php echo $lang['invoice-subtotal']; ?></td>
                                        <td class="border-b-2 border-main pb-3 pl-2 pr-3 text-right font-bold"><?php echo $lang['invoice-subtotal-vat']; ?></td>
                                    </tr>
                                    </thead>
                                    <tbody class="order_table">
                                    </tbody>
                                    <tr>
                                        <td colspan="7">
                                            <table class="w-full border-collapse border-spacing-0">
                                                <tbody>
                                                <tr>
                                                    <td class="w-full"></td>
                                                    <td>
                                                        <table class="w-full border-collapse border-spacing-0">
                                                            <tbody>
                                                            <tr>
                                                                <td class="border-b p-3">
                                                                    <div class="whitespace-nowrap text-slate-400"><?php echo $lang['invoice-net-total']; ?></div>
                                                                </td>
                                                                <td class="border-b p-3 text-right">
                                                                    <div class="whitespace-nowrap font-bold text-main amount"></div>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="border-b p-3">
                                                                    <div class="whitespace-nowrap text-slate-400"><?php echo $lang['invoice-vat-total']; ?></div>
                                                                </td>
                                                                <td class="border-b p-3 text-right">
                                                                    <div class="whitespace-nowrap font-bold text-main tax_amount"></div>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="border-b p-3">
                                                                    <div class="whitespace-nowrap text-slate-400"><?php echo $lang['invoice-total']; ?></div>
                                                                </td>
                                                                <td class="border-b p-3 text-right">
                                                                    <div class="whitespace-nowrap font-bold text-main total_amount"></div>
                                                                </td>
                                                            </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </div>

                            <div class="flex w-full justify-between min-h-[150px] max-h-[150px]">
                                <div class="px-14 text-sm text-neutral-700">
                                    <h2 class="text-sm font-semibold text-gray-500 uppercase tracking-wider mb-3"><?php echo $lang['invoice-payment-details']; ?></h2>
                                    <div class="grid grid-cols-2 gap-2">
                                        <div>
                                            <p class="text-sm font-medium text-gray-900"><?php echo $lang['invoice-bank-name']; ?></p>
                                            <p class="text-sm text-gray-600"><?php echo $lang['invoice-bank-name-value']; ?></p>
                                        </div>
                                        <div>
                                            <p class="text-sm font-medium text-gray-900"><?php echo $lang['invoice-account-name']; ?></p>
                                            <p class="text-sm text-gray-600"><?php echo $lang['invoice-account-name-value']; ?></p>
                                        </div>
                                        <div>
                                            <p class="text-sm font-medium text-gray-900"><?php echo $lang['invoice-bank-branch-name']; ?></p>
                                            <p class="text-sm text-gray-600"><?php echo $lang['invoice-bank-branch-value']; ?></p>
                                        </div>

                                        <div>
                                            <p class="text-sm font-medium text-gray-900"><?php echo $lang['invoice-account-number']; ?></p>
                                            <p class="text-sm text-gray-600"><?php echo $lang['invoice-account-number-value']; ?></p>
                                        </div>
                                        <div>
                                            <p class="text-sm font-medium text-gray-900"><?php echo $lang['invoice-iban']; ?></p>
                                            <p class="text-sm text-gray-600"><?php echo $lang['invoice-iban-value']; ?></p>
                                        </div>
                                        <div>
                                            <p class="text-sm font-medium text-gray-900"><?php echo $lang['invoice-payment-reference']; ?></p>
                                            <p class="text-sm text-gray-600 invoice_number"></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex items-end justify-end px-14 text-sm text-neutral-700 hidden">
                                    <div id="qrcode"></div>
                                </div>
                            </div>

                            <div class="relative px-14 py-10 text-sm text-neutral-700">
                                <p class="text-main font-bold hidden"><?php echo $lang['invoice-notes']; ?></p>
                                <p class="italic invoice-notes hidden"></p>

                                <footer class="absolute right-0 bottom-0 bg-slate-100 w-full text-neutral-600 text-center text-xs py-3">
                                    Datanito
                                    <span class="text-slate-300 px-2">|</span>
                                    info@datanito.com
                                    <span class="text-slate-300 px-2">|</span>
                                    datanito.com
                                </footer>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Modal footer -->
                <div class="flex items-center p-4 md:p-5 border-t border-gray-200 rounded-b dark:border-gray-600">
                    <button id="preview-invoice" type="button" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">Preview Invoice</button>
                    <button id="download-invoice" type="button" class="ms-3 text-white bg-green-600 hover:bg-green-700 focus:ring-4 focus:outline-none focus:ring-green-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-green-500 dark:hover:bg-green-600 dark:focus:ring-green-800">Download PDF</button>
                    <button id="attach-invoice" type="button" class="ms-3 text-white bg-purple-600 hover:bg-purple-700 focus:ring-4 focus:outline-none focus:ring-purple-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-purple-500 dark:hover:bg-purple-600 dark:focus:ring-purple-800">
                        Attach to Email
                    </button>
                </div>
            </div>
        </div>
    </div>

</main>
<?php
include_once includes('layouts/dashboard-end.php');
?>
<script src="https://cdn.tiny.cloud/1/u5xlafwcya8zxwk9t9kqjw347h4mo8i6ldv93r883wdpagq5/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>

<script src="https://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js" integrity="sha512-GsLlZN/3F2ErC5ifS5QtgpiJtWd43JWSuIgh7mbzZ8zBps+dvLusV+eNQATqgA/HdeKFVgA5v3S/cIrLF7QnIg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

<script>
    $(document).ready(function() {
        // Template presets with both English and Turkish versions
        const templates = {
            invoice: {
                subject: {
                    en: "Invoice #INV-{{date}} for your Datanito services",
                    tr: "Datanito hizmetleriniz için #INV-{{date}} numaralı fatura"
                },
                headline: {
                    en: "Your Invoice #{{invoiceNumber}}",  // More specific
                    tr: "Faturanız #{{invoiceNumber}}"
                },
                btnCta: {
                    en: "Pay Invoice",
                    tr: "Faturayı Öde"
                },
                btnLink: "https://datanito.com/payment",
                content: {
                    en: `<p>Your invoice for <strong>{{amount}}</strong> is now available. Payment is due by <strong>{{dueDate}}</strong>.</p>
                 <p>Services included:</p>
                 <ul>
                     <li>Monthly subscription</li>
                     <li>Premium support</li>
                 </ul>`,
                    tr: `<p><strong>{{amount}}</strong> tutarındaki faturanız hazır. Son ödeme tarihi: <strong>{{dueDate}}</strong>.</p>
                 <p>Hizmetler:</p>
                 <ul>
                     <li>Aylık abonelik</li>
                     <li>Premium destek</li>
                 </ul>`
                }
            },
            receipt: {
                subject: {
                    en: "Receipt for Payment #{{receiptNumber}}",
                    tr: "#{{receiptNumber}} Numaralı Ödeme Makbuzu"
                },
                headline: {
                    en: "Payment Confirmation",  // More professional
                    tr: "Ödeme Onayı"
                },
                btnCta: {
                    en: "View Details",
                    tr: "Detayları Gör"
                },
                btnLink: "https://datanito.com/invoices",
                content: {
                    en: `<p>We've processed your payment of <strong>{{amount}}</strong> on {{paymentDate}}.</p>
                 <p>Transaction ID: <code>{{transactionId}}</code></p>
                 <p>A receipt copy is attached for your records.</p>`,
                    tr: `<p>{{paymentDate}} tarihinde <strong>{{amount}}</strong> tutarındaki ödemeniz alınmıştır.</p>
                 <p>İşlem No: <code>{{transactionId}}</code></p>
                 <p>Kayıtlarınız için makbuz eklenmiştir.</p>`
                }
            },
            overdue: {
                subject: {
                    en: "URGENT: Payment Overdue for #{{invoiceNumber}}",
                    tr: "ACİL: #{{invoiceNumber}} Numaralı Fatura Ödenmedi"
                },
                headline: {
                    en: "Immediate Payment Required",  // Stronger call to action
                    tr: "Acil Ödeme Gerekiyor"
                },
                btnCta: {
                    en: "Pay Now",
                    tr: "Hemen Öde"
                },
                btnLink: "https://datanito.com/payment",
                content: {
                    en: `<div class="urgent-notice">
                    <p>Your payment of <strong>{{amount}}</strong> is <strong>{{daysOverdue}} days overdue</strong>.</p>
                    <p>To avoid service interruption, please pay immediately.</p>
                 </div>
                 <p>Original due date: <strong>{{dueDate}}</strong></p>`,
                    tr: `<div class="urgent-notice">
                    <p><strong>{{amount}}</strong> tutarındaki ödemeniz <strong>{{daysOverdue}} gündür gecikmiş durumda</strong>.</p>
                    <p>Hizmet kesintisi yaşamamak için lütfen hemen ödeme yapın.</p>
                 </div>
                 <p>Son ödeme tarihi: <strong>{{dueDate}}</strong></p>`
                }
            },
            product: {
                subject: {
                    en: "Now Available: {{productName}}",
                    tr: "Yeni Ürün: {{productName}}"
                },
                headline: {
                    en: "Introducing {{productName}}",
                    tr: "{{productName}} Çıktı!"  // More natural Turkish
                },
                btnCta: {
                    en: "Get Started",
                    tr: "Hemen Kullan"
                },
                btnLink: "https://datanito.com/new-product",
                content: {
                    en: `<p>We're proud to launch {{productName}}, designed to {{productDescription}}.</p>
                 <div class="product-highlights">
                     <h3>Key features:</h3>
                     <ul>
                         <li><strong>AI-powered</strong> automation</li>
                         <li>Real-time analytics dashboard</li>
                         <li>Enterprise-grade security</li>
                     </ul>
                 </div>
                 <p>Special launch offer: <strong>20% discount</strong> for first 30 days.</p>`,
                    tr: `<p>{{productDescription}} için geliştirdiğimiz {{productName}}'ı duyurmaktan gurur duyuyoruz.</p>
                 <div class="product-highlights">
                     <h3>Öne çıkan özellikler:</h3>
                     <ul>
                         <li><strong>Yapay zeka destekli</strong> otomasyon</li>
                         <li>Anlık analiz paneli</li>
                         <li>Kurumsal düzeyde güvenlik</li>
                     </ul>
                 </div>
                 <p>Özel lansman avantajı: İlk 30 gün <strong>%20 indirim</strong>.</p>`
                }
            }
        };

        // Initialize TinyMCE editor
        tinymce.init({
            selector: '#editor',
            height: 300,
            plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount linkchecker',
            toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
        });

        // Make loadTemplate available globally
        window.loadTemplate = function(templateName) {
            const template = templates[templateName];
            if (!template) return;

            const isTurkish = $('#emailLang').val() === 'tr';
            const langKey = isTurkish ? 'tr' : 'en';
            const currencySymbol = isTurkish ? '₺' : '$';

            // Set basic fields
            $('#subject').val(template.subject[langKey]);
            $('#emailHeadline').val(template.headline[langKey]);
            $('#btnCta').val(template.btnCta[langKey]);
            $('#btnLink').val(template.btnLink);

            // Set editor content
            tinymce.get('editor').setContent(template.content[langKey]);

            // Auto-fill sample data
            const today = new Date();
            const dueDate = new Date();
            dueDate.setDate(today.getDate() + 5);

            if (templateName === 'invoice' || templateName === 'overdue' || templateName === 'receipt') {
                $('#invoiceNumber').val('INV-' + today.getFullYear() + '-' + String(today.getMonth() + 1).padStart(2, '0') + '-' + String(Math.floor(Math.random() * 1000)).padStart(3, '0'));
                $('#invoiceAmount').val((isTurkish ? '₺' : '$') + (Math.random() * 500 + 50).toFixed(2));
                $('#dueDate').val(dueDate.toISOString().split('T')[0]);
            }

            if (templateName === 'product') {
                $('#productName').val(isTurkish ? 'AI Ödeme İşlemcisi Pro' : 'AI Payment Processor Pro');
                $('#productPrice').val(isTurkish ? '₺999/ay' : '$99/month');
                $('#productDescription').val(isTurkish ? 'ödeme işlemlerinizi AI ile dönüştürün' : 'revolutionize your payment processing with AI');
            }
        };

        // Handle template card clicks
        $('.template-card').click(function() {
            const templateName = $(this).data('template');
            loadTemplate(templateName);
            $('#emailType').val(templateName);
        });

        // Handle template selection change
        $('#emailType').change(function() {
            if ($(this).val() !== 'custom') {
                loadTemplate($(this).val());
            }
        });

        // Handle language change
        $('#emailLang').change(function() {
            const templateType = $('#emailType').val();
            if (templateType !== 'custom') {
                loadTemplate(templateType);
            }
        });

        $('#attach-invoice').click(function() {
            attachInvoiceToEmail();
            $('#create-invoice-modal').addClass('hidden');
        });

        function attachInvoiceToEmail() {
            // First ensure the preview is up to date
            updateInvoicePreview();

            const invoiceToSave = document.getElementById('invoice');
            const opt = {
                margin: 0,
                filename: 'invoice-' + $('#invoice-number').val() + '.pdf',
                image: { type: 'jpeg', quality: 0.98 },
                html2canvas: {
                    scale: 2,
                    useCORS: true,
                    allowTaint: true,
                    logging: true
                },
                jsPDF: {
                    unit: 'mm',
                    format: 'a4',
                    orientation: 'portrait'
                }
            };

            // Generate PDF and attach to form
            html2pdf().set(opt).from(invoiceToSave).outputPdf('blob').then(function(pdfBlob) {
                // Create a new File object from the Blob
                const file = new File([pdfBlob], 'invoice.pdf', { type: 'application/pdf' });

                // Create a new DataTransfer object
                const dataTransfer = new DataTransfer();
                dataTransfer.items.add(file);

                // Get the file input element
                const fileInput = document.getElementById('fileInput');

                // Clear any existing files
                fileInput.value = '';

                // Add the new file
                fileInput.files = dataTransfer.files;

                // Update the UI to show the attached file
                updateFileDisplay(file);

                // Auto-fill the email template
                autoFillInvoiceEmail();

                // Close the modal
                $('#create-invoice-modal').addClass('hidden');
            }).catch(function(error) {
                console.error('Error generating PDF:', error);
                alert('Error generating PDF. Please try again.');
            });
        }

        function updateFileDisplay(file) {
            const fileDetails = $('#fileDetails');
            const uploadedFileInfo = $('#uploadedFileInfo');

            fileDetails.removeClass('hidden');
            uploadedFileInfo.find('.uploaded-file__name').text(file.name);
            uploadedFileInfo.find('.uploaded-file__counter').text('100%');

            // Show the file type icon
            const fileIcon = uploadedFileInfo.closest('.uploaded-file').find('.uploaded-file__icon');
            fileIcon.removeClass().addClass('bx bxs-file-pdf uploaded-file__icon');
        }

// Function to auto-fill invoice email template
        function autoFillInvoiceEmail() {
            // Select invoice template
            $('#emailType').val('invoice').trigger('change');

            // Populate subject and headline
            const isTurkish = $('#emailLang').val() === 'tr';
            const invoiceNumber = $('#invoice-number').val();
            const totalAmount = $('#invoice-total').text();
            const dueDate = $('#invoice-due-date').val();

            // Format dates
            const formattedDueDate = new Date(dueDate).toLocaleDateString(
                isTurkish ? 'tr-TR' : 'en-US',
                { year: 'numeric', month: 'short', day: 'numeric' }
            );

            // Set subject and headline
            $('#subject').val(
                isTurkish
                    ? `Fatura #${invoiceNumber} - ${totalAmount} (Son Ödeme: ${formattedDueDate})`
                    : `Invoice #${invoiceNumber} - ${totalAmount} (Due: ${formattedDueDate})`
            );

            $('#emailHeadline').val(
                isTurkish
                    ? `Faturanız #${invoiceNumber}`
                    : `Your Invoice #${invoiceNumber}`
            );

            // Set email content
            const content = isTurkish
                ? `<p>${totalAmount} tutarındaki faturanız hazır. Son ödeme tarihi: <strong>${formattedDueDate}</strong>.</p>
           <p>Ekte fatura detaylarını bulabilirsiniz.</p>
           <p>Ödeme yapmak için aşağıdaki butona tıklayabilirsiniz.</p>`
                : `<p>Your invoice for <strong>${totalAmount}</strong> is now available. Payment is due by <strong>${formattedDueDate}</strong>.</p>
           <p>You can find the invoice details attached.</p>
           <p>Click the button below to make payment.</p>`;

            tinymce.get('editor').setContent(content);

            // Set payment button
            $('#btnCta').val(isTurkish ? 'Ödeme Yap' : 'Pay Now');
            $('#btnLink').val('https://datanito.com/payment');
        }

        $('#emailForm').submit(function(event) {
            event.preventDefault();

            // Create FormData object
            const formData = new FormData(this);

            // Add all form fields
            formData.append('subject', $('#subject').val());
            formData.append('email', $('#email').val());
            formData.append('emailLang', $('#emailLang').val());
            formData.append('name', $('#name').val());
            formData.append('emailHeadline', $('#emailHeadline').val());
            formData.append('btnCta', $('#btnCta').val());
            formData.append('btnLink', $('#btnLink').val());
            formData.append('message', tinymce.get('editor').getContent());
            formData.append('csrf', $('input[name="csrf"]').val());
            formData.append('honeypot', $('#honeypot').val());

            // Add the file if it exists
            const fileInput = $('#fileInput')[0];
            if (fileInput.files.length > 0) {
                formData.append('attachment', fileInput.files[0]);
            }

            // AJAX request
            $.ajax({
                type: 'POST',
                url: '/email/send',
                data: formData,
                processData: false,
                contentType: false,
                dataType: 'json',
                success: function(response) {
                    // Show success message
                    $("#toast-success").css("display", "flex").removeClass("hidden");
                    $(".toast-message").text(response.message);

                    if (response.icon === 'error') {
                        $(".notification-success").addClass("hidden");
                        $(".notification-error").removeClass("hidden");
                    }

                    $("#toast-success").addClass("notification-opened");
                    $("#toast-success svg").addClass("notification-checkmark");

                    // Hide after 2 seconds
                    setTimeout(function() {
                        $("#toast-success").addClass("notification-closed");
                        $("#toast-success").removeClass("notification-opened");
                        $("#toast-success svg").removeClass("notification-checkmark");
                    }, 2000);
                },
                error: function(xhr, status, error) {
                    console.error('Error:', error);
                    alert('Error sending email. Please try again.');
                }
            });
        });
// Set default invoice date to today
        $('#invoice-date').val(new Date().toISOString().split('T')[0]);

        // Set default due date to 14 days from today
        const dueDate = new Date();
        dueDate.setDate(dueDate.getDate() + 14);
        $('#invoice-due-date').val(dueDate.toISOString().split('T')[0]);

        // Generate a default invoice number
        const today = new Date();
        $('#invoice-number').val('INV-' + today.getFullYear() + '-' +
            String(today.getMonth() + 1).padStart(2, '0') + '-' +
            String(Math.floor(Math.random() * 1000)).padStart(3, '0'));

        // Add new item row
        $('#add-item').click(function() {
            const newRow = `
            <tr class="bg-white border-b dark:bg-dark-800 dark:border-gray-700">
                <td class="px-6 py-4">
                    <input type="text" class="item-description bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Service or product" required>
                </td>
                <td class="px-6 py-4">
                    <input type="number" class="item-quantity bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" value="1" min="1" required>
                </td>
                <td class="px-6 py-4">
                    <input type="number" step="0.01" class="item-price bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="0.00" required>
                </td>
                <td class="px-6 py-4">
                    <select class="item-tax bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                        <option value="0">0%</option>
                        <option value="8">8%</option>
                        <option value="18" selected>18%</option>
                        <option value="20">20%</option>
                    </select>
                </td>
                <td class="px-6 py-4 item-total">
                    $0.00
                </td>
                <td class="px-6 py-4">
                    <button type="button" class="remove-item text-red-600 hover:text-red-800 dark:text-red-400 dark:hover:text-red-300">
                        <span class="material-symbols-outlined">delete</span>
                    </button>
                </td>
            </tr>
        `;
            $('#invoice-items').append(newRow);
            attachItemEventHandlers();
        });

        // Remove item row
        $(document).on('click', '.remove-item', function() {
            if($('#invoice-items tr').length > 1) {
                $(this).closest('tr').remove();
                calculateTotals();
            } else {
                alert('An invoice must have at least one item.');
            }
        });

        // Calculate totals when item values change
        function attachItemEventHandlers() {
            $('#invoice-items').off('input change', '.item-quantity, .item-price, .item-tax');
            $('#invoice-items').on('input change', '.item-quantity, .item-price, .item-tax', function() {
                const row = $(this).closest('tr');
                calculateRowTotal(row);
                calculateTotals();
            });
        }

// Update the calculateRowTotal function to use selected currency
        function calculateRowTotal(row) {
            const quantity = parseFloat(row.find('.item-quantity').val()) || 0;
            const price = parseFloat(row.find('.item-price').val()) || 0;
            const taxRate = parseFloat(row.find('.item-tax').val()) || 0;
            const currency = $('#invoice-currency').val();

            const subtotal = quantity * price;
            const tax = subtotal * (taxRate / 100);
            const total = subtotal + tax;

            row.find('.item-total').text(`${currency}${total.toFixed(2)}`);
        }

// Update the calculateTotals function
        function calculateTotals() {
            let subtotal = 0;
            let totalTax = 0;
            let total = 0;
            const currency = $('#invoice-currency').val();

            $('#invoice-items tr').each(function() {
                const quantity = parseFloat($(this).find('.item-quantity').val()) || 0;
                const price = parseFloat($(this).find('.item-price').val()) || 0;
                const taxRate = parseFloat($(this).find('.item-tax').val()) || 0;

                const rowSubtotal = quantity * price;
                const rowTax = rowSubtotal * (taxRate / 100);

                subtotal += rowSubtotal;
                totalTax += rowTax;
            });

            total = subtotal + totalTax;

            $('#invoice-subtotal').text(`${currency}${subtotal.toFixed(2)}`);
            $('#invoice-tax').text(`${currency}${totalTax.toFixed(2)}`);
            $('#invoice-total').text(`${currency}${total.toFixed(2)}`);
        }

        // Initialize event handlers
        attachItemEventHandlers();
        calculateRowTotal($('#invoice-items tr:first'));
        calculateTotals();

// Function to update the live invoice preview
// Update the updateInvoicePreview function to include due date
        function updateInvoicePreview() {
            // Update customer information
            $('.customer-name').text($('#invoice-customer-name').val());
            $('.invoice_number').text($('#invoice-number').val());
            $('.invoice-notes').text($('#invoice-notes').val());
            const currency = $('#invoice-currency').val();

            // Format and display dates
            const invoiceDate = new Date($('#invoice-date').val());
            const dueDate = new Date($('#invoice-due-date').val());
            $('.invoice_date').text(invoiceDate.toLocaleDateString());
            $('.invoice_due_date').text(dueDate.toLocaleDateString());

            // Update invoice status (you can customize this based on your needs)
            const today = new Date();
            const isOverdue = dueDate < today;

            if (isOverdue) {
                $('.invoice_status').html(`
            <span class="flex items-center text-red-500 dark:text-red-400">
                <div class="h-2.5 w-2.5 rounded-full bg-red-500 mr-2"></div>
                <?php echo $lang['invoice-status-overdue']?>
            </span>
        `);
            } else {
                $('.invoice_status').html(`
            <span class="flex items-center text-yellow-500 dark:text-yellow-400">
                <div class="h-2.5 w-2.5 rounded-full bg-yellow-500 mr-2"></div>
                <?php echo $lang['invoice-status-pending']?>
            </span>
        `);
            }
            // Rest of the function remains the same...
            // Update invoice items table
            const orderTable = $('.order_table');
            orderTable.empty();

            let subtotal = 0;
            let totalTax = 0;

            $('#invoice-items tr').each(function(index) {
                const description = $(this).find('.item-description').val();
                const quantity = parseFloat($(this).find('.item-quantity').val()) || 0;
                const price = parseFloat($(this).find('.item-price').val()) || 0;
                const taxRate = parseFloat($(this).find('.item-tax').val()) || 0;

                const rowSubtotal = quantity * price;
                const taxAmount = rowSubtotal * (taxRate / 100);
                const rowTotal = rowSubtotal + taxAmount;
                subtotal += rowSubtotal;
                totalTax += taxAmount;

                orderTable.append(`
            <tr>
                <td class="border-b py-3 pl-3">${index + 1}.</td>
                <td class="border-b py-3 pl-2">${description}</td>
                <td class="border-b py-3 pl-2 text-right">${currency}${price.toFixed(2)}</td>
                <td class="border-b py-3 pl-2 text-center">${quantity}</td>
                <td class="border-b py-3 pl-2 text-center">${taxRate}%</td>
                <td class="border-b py-3 pl-2 text-right">${currency}${rowSubtotal.toFixed(2)}</td>
                <td class="border-b py-3 pl-2 pr-3 text-right">${currency}${rowTotal.toFixed(2)}</td>
            </tr>
        `);
            });

            // Update totals
            const total = subtotal + totalTax;
            $('.amount').text(`${currency}${subtotal.toFixed(2)}`);
            $('.tax_amount').text(`${currency}${totalTax.toFixed(2)}`);
            $('.total_amount').text(`${currency}${total.toFixed(2)}`);

            // Generate QR code with invoice link
            $('#qrcode').empty();
            new QRCode(document.getElementById('qrcode'), {
                text: 'https://datanito.com',
                width: 128,
                height: 128,
            });
        }

// Set up event listeners for all invoice fields
        function setupInvoicePreviewListeners() {
            // Customer info fields
            $('#invoice-customer-name, #invoice-number, #invoice-date, #invoice-due-date, #invoice-notes').on('input change', updateInvoicePreview);

            // Item fields - we'll handle these with the existing item calculation handlers
        }

// Modify the existing calculateTotals function to also update the preview
        const originalCalculateTotals = calculateTotals;
        calculateTotals = function() {
            originalCalculateTotals();
            updateInvoicePreview();
        };

// Initialize everything when the modal opens
        $('[data-modal-toggle="create-invoice-modal"]').on('click', function(e) {
            setupInvoicePreviewListeners();
            updateInvoicePreview();
        });

// Add preview button functionality
        $('#preview-invoice').click(function() {
            updateInvoicePreview();
            $('.show-invoice').removeClass('hidden');
        });

// Update the download function to use the preview invoice
        $('#download-invoice').click(function() {
            // Ensure preview is up to date
            updateInvoicePreview();

            const element = document.getElementById('invoice');
            const opt = {
                margin: 0,
                filename: 'invoice-' + $('#invoice-number').val() + '.pdf',
                image: {
                    type: 'jpeg',
                    quality: 0.98
                },
                html2canvas: {
                    scale: 2,
                    useCORS: true,
                    letterRendering: true,
                    logging: true
                },
                jsPDF: {
                    unit: 'mm',
                    format: 'a4',
                    orientation: 'portrait'
                }
            };

            // Generate PDF
            html2pdf().set(opt).from(element).save();
        });

    });
</script>