<?php
include_once includes('layouts/dashboard.php');
?>
    <main class="p-4 md:ml-64 h-auto pt-20">
        <div id="adminOverview" class="grid grid-cols-1 gap-4">
            <!-- Summary Cards -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 mb-4">
                <div class="p-6 bg-white rounded-lg shadow dark:bg-gray-800">
                    <h3 class="text-lg font-medium">Total Sales</h3>
                    <p id="totalSales" class="text-2xl font-bold text-green-500">$0</p>
                </div>
                <div class="p-6 bg-white rounded-lg shadow dark:bg-gray-800">
                    <h3 class="text-lg font-medium">Total Orders</h3>
                    <p id="totalOrders" class="text-2xl font-bold text-blue-500">0</p>
                </div>
                <div class="p-6 bg-white rounded-lg shadow dark:bg-gray-800">
                    <h3 class="text-lg font-medium">Total Customers</h3>
                    <p id="totalCustomers" class="text-2xl font-bold text-yellow-500">0</p>
                </div>
                <div class="p-6 bg-white rounded-lg shadow dark:bg-gray-800">
                    <h3 class="text-lg font-medium">Profit</h3>
                    <p id="totalProfit" class="text-2xl font-bold text-red-500">$0</p>
                </div>
            </div>

            <!-- Recent Leads Table -->
            <div class="bg-white p-4 rounded-lg shadow dark:bg-gray-800">
                <h3 class="text-xl font-semibold mb-4">Recent Leads</h3>
                <div id="leadListContainer" class="overflow-x-auto">
                    <table class="min-w-full text-left text-sm">
                        <thead>
                        <tr class="border-b dark:border-gray-700">
                            <th class="p-2">Lead Name</th>
                            <th class="p-2">Email</th>
                            <th class="p-2">Created At</th>
                        </tr>
                        </thead>
                        <tbody id="leadList"></tbody>
                    </table>
                </div>
            </div>
            <!-- Recent Orders Table -->
            <div class="bg-white p-4 rounded-lg shadow dark:bg-gray-800">
                <h3 class="text-xl font-semibold mb-4">Recent Orders</h3>
                <div id="ordersListContainer" class="overflow-x-auto">
                    <table class="min-w-full text-left text-sm">
                        <thead>
                        <tr class="border-b dark:border-gray-700">
                            <th class="p-2">Order ID</th>
                            <th class="p-2">Total Amount</th>
                            <th class="p-2">Created At</th>
                        </tr>
                        </thead>
                        <tbody id="ordersList"></tbody>
                    </table>
                </div>
            </div>

            <!-- Recent Users Table -->
            <div class="bg-white p-4 rounded-lg shadow dark:bg-gray-800">
                <h3 class="text-xl font-semibold mb-4">Recent Users</h3>
                <div id="usersListContainer" class="overflow-x-auto">
                    <table class="min-w-full text-left text-sm">
                        <thead>
                        <tr class="border-b dark:border-gray-700">
                            <th class="p-2">User Name</th>
                            <th class="p-2">Email</th>
                            <th class="p-2">Created At</th>
                        </tr>
                        </thead>
                        <tbody id="usersList"></tbody>
                    </table>
                </div>
            </div>

        </div>
    </main>

<?php
include_once includes('layouts/dashboard-end.php');
?>
<script>
    $(document).ready(function () {
        $.ajax({
            url: '/admin/fetch-overview', // Backend PHP file
            type: 'POST',
            dataType: 'json',
            success: function (data) {
                console.log(data);
                if (data.success) {
                    // Update summary cards for sales
                    $('#totalSales').html(
                        `${data.summary.total_sales.tl} / ${data.summary.total_sales.usd}`
                    );

                    // Update total orders
                    $('#totalOrders').text(data.summary.total_orders);

                    // Update total customers
                    $('#totalCustomers').text(data.summary.total_customers);

                    // Update profit
                    $('#totalProfit').html(
                        `${data.summary.total_profit.tl} / ${data.summary.total_profit.usd}`
                    );

                    // Render recent leads
                    const leads = data.leads.recent;
                    const leadList = $('#leadList');
                    if (leads.length > 0) {
                        leadList.empty();
                        leads.forEach((lead) => {
                            leadList.append(`
                            <tr class="border-b dark:border-gray-700">
                                <td class="p-2">${lead.name}</td>
                                <td class="p-2">${lead.email}</td>
                                <td class="p-2">${lead.created_at}</td>
                            </tr>
                        `);
                        });
                    } else {
                        leadList.append('<tr><td colspan="3" class="p-2 text-center">No leads found.</td></tr>');
                    }

                    // Render recent orders
                    const orders = data.orders.recent;
                    const ordersList = $('#ordersList');
                    if (orders.length > 0) {
                        ordersList.empty();
                        orders.forEach((order) => {
                            ordersList.append(`
                            <tr class="border-b dark:border-gray-700">
                                <td class="p-2">${order.order_id}</td>
                                <td class="p-2">${order.total_amount}</td>
                                <td class="p-2">${order.order_date}</td>
                            </tr>
                        `);
                        });
                    } else {
                        ordersList.append('<tr><td colspan="3" class="p-2 text-center">No recent orders found.</td></tr>');
                    }

                    // Render recent users
                    const users = data.users.recent;
                    const usersList = $('#usersList');
                    if (users.length > 0) {
                        usersList.empty();
                        users.forEach((user) => {
                            usersList.append(`
                            <tr class="border-b dark:border-gray-700">
                                <td class="p-2">${user.name}</td>
                                <td class="p-2">${user.email}</td>
                                <td class="p-2">${user.created_at}</td>
                            </tr>
                        `);
                        });
                    } else {
                        usersList.append('<tr><td colspan="3" class="p-2 text-center">No new users found.</td></tr>');
                    }
                } else {
                    alert(data.message || 'Failed to load data');
                }
            },
            error: function () {
                alert('An error occurred while fetching data.');
            },
        });
    });



</script>
