<?php
$meta = array(
    'us' => array(
        'title' => 'Help Requests - Datanito',
        'description' => 'View and manage your previous support requests with Datanito. Access details of your support history and find solutions to common issues.',
        'og:title' => 'View Previous Help Requests - Datanito',
        'og:description' => 'View and manage your previous support requests with Datanito. Access details of your support history and find solutions to common issues.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Yardım Taleplerini - Datanito (Türkiye)',
        'description' => 'Datanito ile önceki yardım taleplerinizi görüntüleyin ve yönetin. Destek geçmişinizin detaylarına erişin ve ortak sorunlara çözüm bulun.',
        'og:title' => 'Önceki Yardım Taleplerini Görüntüle - Datanito (Türkiye)',
        'og:description' => 'Datanito ile önceki yardım taleplerinizi görüntüleyin ve yönetin. Destek geçmişinizin detaylarına erişin ve ortak sorunlara çözüm bulun.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/dashboard.php');
?>
<main class="p-4 md:ml-64 h-full pt-20 min-h-[70em]">
    <div class="h-full">
        <div id="ticketListContainer">
            <div class="my-6 ml-5">
                <h3 class="text-2xl tracking-tight font-semibold text-gray-900 dark:text-white"><?php echo $lang['support-requests-headline']; ?></h3>
                <h3 class="text-lg mt-2 tracking-tight font-normal text-gray-900 dark:text-white"><?php echo $lang['support-requests-subheading']; ?></h3>
            </div>
            <div class="relative overflow-x-auto sm:rounded-lg mx-3">
                <div id="ticketDetail" class="flex skeleton justify-between w-full dark:bg-dark-800 p-4 mb-8 space-x-4 text-center border border-gray-200 rounded-xl bg-gray-50 dark:bg-dark-700 dark:border-gray-600"></div>

                <div class="flex mb-8 items-center">
                    <label for="statusSelect" class="sr-only">Change Status:</label>
                    <select id="statusSelect" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-xl focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-dark-800 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                        <option value="Open">Open</option>
                        <option value="In Progress">In Progress</option>
                        <option value="Closed">Closed</option>
                    </select>
                    <button type="button" id="changeStatusBtn" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-xl text-sm px-5 py-1.5 ml-2 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800"><span class="material-symbols-outlined">check</span></button>
                </div>

                <form id="messageForm" class="mb-12" enctype="multipart/form-data">
                    <?php set_csrf(); ?>
                    <div class="relative mb-6 rounded-xl skeleton bg-white dark:bg-dark-800">
                        <label for="messageInput" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-white dark:bg-dark-800 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1"><?php echo $lang['your-message']; ?></label>
                        <textarea id="messageInput" rows="12" class="block px-2.5 pb-2.5 pt-4 w-full text-sm text-gray-900 bg-transparent rounded-xl border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer resize-none" placeholder=" " required></textarea>
                    </div>
                    <div class="relative hidden">
                        <input type="text" id="honeypot" name="honeypot" value="">
                    </div>
                    <div id="uploadArea" class="upload-area skeleton bg-white dark:bg-dark-800 p-4 mb-8 border border-gray-200 rounded-xl dark:bg-dark-700 dark:border-gray-600 md:w-[50%] max-h-96">
                        <!-- Header -->
                        <div class="upload-area__header">
                            <p class="upload-area__paragraph text-gray-600 dark:text-gray-300">
                                .<span class="upload-area__tooltip-data"></span> (MAX. 2MB)
                            </p>
                        </div>
                        <!-- End Header -->

                        <!-- Drop Zoon -->
                        <div id="dropZoon" class="upload-area__drop-zoon drop-zoon mt-3 border-2 border-dashed rounded-xl border-gray-300 dark:border-gray-600 z-0">
                    <span class="drop-zoon__icon">
                      <i class='bx bxs-file-image'></i>
                    </span>
                            <p class="drop-zoon__paragraph text-gray-700 dark:text-gray-200">Drop your file here or Click to browse</p>
                            <span id="loadingText" class="drop-zoon__loading-text">Please Wait</span>
                            <img src="" alt="Preview Image" id="previewImage" class="drop-zoon__preview-image" draggable="false">
                            <input id="fileInput" class="drop-zoon__file-input" type="file" name="fileInput" accept=".pdf, .jpg, .jpeg, .png">
                        </div>
                        <!-- End Drop Zoon -->

                        <!-- File Details -->
                        <div id="fileDetails" class="upload-area__file-details file-details">
                            <h3 class="file-details__title">Uploaded File</h3>

                            <div id="uploadedFile" class="uploaded-file">
                                <div class="uploaded-file__icon-container">
                                    <i class='bx bxs-file-blank uploaded-file__icon'></i>
                                    <span class="uploaded-file__icon-text hidden"></span><!-- Data Will be Comes From Js -->
                                </div>

                                <div id="uploadedFileInfo" class="uploaded-file__info">
                                    <span class="uploaded-file__name">Proejct 1</span>
                                    <span class="uploaded-file__counter">0%</span>
                                </div>
                            </div>
                        </div>
                        <!-- End File Details -->
                    </div>
                    <p class="ml-auto text-sm text-gray-500 dark:text-gray-400 mb-6">Remember, all interactions and contributions within our support system must adhere to our <a href="#" class="text-blue-600 dark:text-blue-500 hover:underline">guidelines and policies</a>.</p>
                    <button type="submit" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm w-full sm:w-auto px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800 mt-2">Open Request</button>
                </form>
                <div id="messageHistory"></div>
            </div>
            <div class="text-center mx-auto mt-24">
                <div role="status" class="spinner hidden my-6">
                    <svg aria-hidden="true" class="inline w-20 h-20 mr-2 text-gray-200 animate-spin dark:text-gray-600 fill-green-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                    </svg>
                    <span class="sr-only">Loading...</span>
                </div>
                <div id="emptyMessage" class="hidden">No help requests found.</div>
            </div>
        </div>
    </div>
</main>
<?php
include_once includes('layouts/dashboard-end.php');
?>
<script>
    $(document).ready(function () {
        const ticketDetail = $('#ticketDetail');
        const messageHistory = $('#messageHistory');
        const loadingSpinner = $('.spinner');
        var csrf = $('input[name="csrf"]').val();

        // Call the function to load message history when the page loads
        loadMessageHistory();

        // Show the loading spinner while data is being loaded
        loadingSpinner.removeClass('hidden');

        $('#messageForm').on('submit', function (event) {
            event.preventDefault();
            const messageInput = $('#messageInput').val();
            const honeypot = $('#honeypot').val();
            const attachmentInput = $('#fileInput')[0].files[0]; // Get the selected file

            // Create a FormData object for sending data with files
            const formData = new FormData();
            formData.append('ticket_id', '<?php echo $id ?>');
            formData.append('message', messageInput);
            formData.append('csrf', csrf);
            formData.append('attachment', attachmentInput);
            formData.append('honeypot', honeypot);

            // Send the new message to the server
            $.ajax({
                type: 'POST',
                url: '/admin_support_reply', // Replace with the actual URL for submitting messages
                data: formData, // Use the FormData object for data
                processData: false,
                contentType: false,
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        // Clear the message input field
                        $('#messageInput').val('');


                        // Reload the message history to display the new message
                        loadMessageHistory();
                        $("#toast-success").css("display", "flex");
                        $("#toast-success").removeClass("hidden");
                        $(".toast-message").text(response.message);
                        $(".toast-title").text(response.title);
                        $(".toast-icon").text(response.icon);
                        $("#toast-success").addClass("notification-opened");
                        $("#toast-success svg").addClass("notification-checkmark");
                        $("#toast-success").removeClass("notification-closed");

                        // Hide the element after 2 seconds
                        setTimeout(function () {
                            $("#toast-success").addClass("notification-closed");
                            $("#toast-success").removeClass("notification-opened");
                            $("#toast-success svg").removeClass("notification-checkmark");
                        }, 2000);

                    } else {
                        alert('Error: ' + response.message);
                    }
                },
                error: function (error) {
                    alert('Error: ' + error.responseText);
                }
            });
        });


        // Function to load message history
        function loadMessageHistory() {
            $.ajax({
                type: 'POST',
                url: '/admin_support_requests_view', // Replace with the actual URL to fetch tickets
                dataType: 'json',
                data: {
                    ticket_id: '<?php echo $id?>',
                    csrf: csrf,
                },
                success: function (data) {
                    // Hide the loading spinner when data is loaded
                    loadingSpinner.addClass('hidden');
                    function formatCreatedAt(created_at) {
                        const date = new Date(created_at);
                        const options = { year: 'numeric', month: 'long', day: 'numeric' };
                        return date.toLocaleDateString(undefined, options);
                    }

                    const formattedCreatedAt = formatCreatedAt(data.created_at);

                    // Determine the status indicator and color
                    let statusIndicator = '';
                    let statusColorClass = '';

                    if (data.status === 'Open') {
                        statusIndicator = '<div class="h-2.5 w-2.5 rounded-full bg-green-500 mr-2"></div>';
                        statusColorClass = 'text-green-500 dark:text-green-400';
                    } else if (data.status === 'Closed') {
                        statusIndicator = '<div class="h-2.5 w-2.5 rounded-full bg-red-500 mr-2"></div>';
                        statusColorClass = 'text-red-500 dark:text-red-400';
                    } else if (data.status === 'In Progress') {
                        statusIndicator = '<div class="h-2.5 w-2.5 rounded-full bg-yellow-500 mr-2"></div>';
                        statusColorClass = 'text-yellow-500 dark:text-yellow-400';
                    }

                    // Display ticket details
                    ticketDetail.html(`
                        <p class="text-gray-900 dark:text-gray-200">Subject: ${data.subject}</p>
                        <span class="flex items-center ${statusColorClass}">${statusIndicator} ${data.status}</span>
                        <p class="text-gray-900 dark:text-gray-200">
                            ${formattedCreatedAt}
                        </p>
                        `);

                    // Clear the message history before adding new messages
                    messageHistory.empty();

                    // Display message history
                    $.each(data.messages, function (index, message) {
                        const userName = '<?php echo $user_name; ?>';

                        if (message.user_type === 'client') {
                            // Check if the user is logged in and has a profile picture
                            if (data.profile_picture) {
                                avatar = data.profile_picture;
                            } else {
                                avatar = '<span class="material-symbols-outlined">person</span>';
                            }
                        } else {
                            avatar = '<svg class="h-6 w-6" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="151px" height="150px" viewBox="0 0 639 636"> <g id="surface1"> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/> </g> </svg>';
                        }
                        function formatCreatedAt(created_at) {
                            const date = new Date(created_at);
                            const options = { year: 'numeric', month: 'long', day: 'numeric', hour: '2-digit', minute: '2-digit', second: '2-digit' };
                            return date.toLocaleDateString(undefined, options);
                        }
                        const messageElement = $(`
                        <div class="message-container flex ${message.user_type === 'client' ? 'justify-end' : 'justify-start'}">
                            <span class="msg-avatar bg-gray-100 dark:bg-gray-700 text-gray-800 dark:text-gray-200 mr-2 ${message.user_type === 'client' ? 'hidden' : ''}">${avatar}</span>
                            <div class="message mb-6 bg-gray-100 p-4 rounded-xl w-[90%] md:w-[50%] ${message.user_type === 'client' ? 'bg-gray-200 dark:bg-dark-700 text-gray-800 dark:text-gray-200 max-w-[75%] break-normal' : 'bg-blue-500 dark:bg-blue-700 text-gray-100 dark:text-gray-100 max-w-[75%] break-normal'}">
                                <p class="font-normal mb-12">${message.message.replace(/\n/g, '<br>')}</p>
                                ${message.attachment_filename ? `
                                    <a href="<?php echo asset('uploads/support/${message.attachment_filename}'); ?>" target="_blank" class="my-2 inline-flex items-center text-sm tracking-tight font-medium " + (message.user_type === 'client' ? 'text-gray-600 dark:text-gray-500' : 'text-blue-600 dark:text-blue-500')">
                                        <span class="material-symbols-outlined">attach_file</span> <span class="hover:underline">View Attached File</span>
                                    </a>
                                ` : ''}
                                <p class="text-sm ${message.user_type === 'client' ? 'text-gray-600 dark:text-gray-400' : 'text-gray-300'}">${formatCreatedAt(message.created_at)}</p>
                            </div>
                            <span class="msg-avatar bg-gray-100 dark:bg-gray-700 text-gray-800 dark:text-gray-200 ml-2 ${message.user_type === 'client' ? '' : 'hidden'}">${avatar}</span>
                        </div>
                    `);



                        messageHistory.append(messageElement);
                    });


                },
                error: function (error) {
                    // Hide the loading spinner on error
                    loadingSpinner.addClass('hidden');
                    alert('Error: ' + error.responseText);
                }
            });
        }
        $("#changeStatusBtn").click(function() {
            var newStatus = $("#statusSelect").val();
            var ticketId = <?php echo $id; ?>; // Replace with the actual ticket ID

            $.ajax({
                type: "POST",
                url: "/change_support_status", // Create this PHP file
                data: { ticket_id: ticketId, new_status: newStatus, csrf: csrf},
                dataType: "json",
                success: function(response) {
                    if (response.success) {
                        // Update the UI or show a success message
                        loadMessageHistory();
                        $("#toast-success").css("display", "flex");
                        $("#toast-success").removeClass("hidden");
                        $(".toast-message").text(response.message);
                        $(".toast-title").text(response.title);
                        $(".toast-icon").text(response.icon);
                        $("#toast-success").addClass("notification-opened");
                        $("#toast-success svg").addClass("notification-checkmark");
                        $("#toast-success").removeClass("notification-closed");

                        // Hide the element after 2 seconds
                        setTimeout(function () {
                            $("#toast-success").addClass("notification-closed");
                            $("#toast-success").removeClass("notification-opened");
                            $("#toast-success svg").removeClass("notification-checkmark");
                        }, 2000);
                    } else {
                        alert("Error: " + response.message);
                    }
                },
                error: function() {
                    alert("Error: Something went wrong.");
                }
            });
        });
    });

</script>


