<?php
$meta = array(
    'us' => array(
        'title' => 'Help Requests - Datanito',
        'description' => 'View and manage your previous support requests with Datanito. Access details of your support history and find solutions to common issues.',
        'og:title' => 'View Previous Help Requests - Datanito',
        'og:description' => 'View and manage your previous support requests with Datanito. Access details of your support history and find solutions to common issues.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Yardım Taleplerini - Datanito (Türkiye)',
        'description' => 'Datanito ile önceki yardım taleplerinizi görüntüleyin ve yönetin. Destek geçmişinizin detaylarına erişin ve ortak sorunlara çözüm bulun.',
        'og:title' => 'Önceki Yardım Taleplerini Görüntüle - Datanito (Türkiye)',
        'og:description' => 'Datanito ile önceki yardım taleplerinizi görüntüleyin ve yönetin. Destek geçmişinizin detaylarına erişin ve ortak sorunlara çözüm bulun.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = $meta[$_SESSION["country"]];
include_once includes('layouts/dashboard.php');
include_once includes('auth/admin-validation.php');
?>
<main class="p-4 md:ml-64 h-full pt-20 min-h-[70em]">
    <div class="h-full">
        <div id="userListContainer">
            <div class="my-6 ml-5">
                <h3 class="text-2xl tracking-tight font-semibold text-gray-900 dark:text-white"><?php echo $lang['support-requests-headline']; ?></h3>
                <h3 class="text-lg mt-2 tracking-tight font-normal text-gray-900 dark:text-white"><?php echo $lang['support-requests-subheading']; ?></h3>
            </div>
            <div class="relative">
                <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                    <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m19 19-4-4m0-7A7 7 0 1 1 1 8a7 7 0 0 1 14 0Z"/>
                    </svg>
                </div>
                <input type="search" id="searchInput" class="block mb-12 w-full p-4 pl-10 text-sm text-gray-900 border border-gray-300 rounded-lg bg-gray-50 focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Search by ID, Subject, Username, or Email" required>
            </div>
            <div class="relative overflow-x-auto sm:rounded-lg mx-3">
                <div id="userList"></div>
            </div>
            <div class="text-center mx-auto mt-24">
                <div role="status" class="spinner hidden my-6">
                    <svg aria-hidden="true" class="inline w-20 h-20 mr-2 text-gray-200 animate-spin dark:text-gray-600 fill-green-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                    </svg>
                    <span class="sr-only">Loading...</span>
                </div>
                <div id="emptyMessage" class="hidden">No users found.</div>
            </div>
        </div>
    </div>
</main>
<?php
include_once includes('layouts/dashboard-end.php');
?>
<script>
    $(document).ready(function () {
        const userList = $('#userList');
        const loadingSpinner = $('.spinner');
        const emptyMessage = $('#emptyMessage');
        const searchInput = $('#searchInput');
        let allUsers = [];

        function formatCreatedAt(created_at) {
            const date = new Date(created_at);
            const options = { year: 'numeric', month: 'long', day: 'numeric' };
            return date.toLocaleDateString(undefined, options);
        }

        function renderUsers(users) {
            if (users.length === 0) {
                emptyMessage.removeClass('hidden');
            } else {
                emptyMessage.addClass('hidden');
                userList.empty();

                $.each(users, function (index, user) {
                    const formattedCreatedAt = formatCreatedAt(user.created_at);

                    let statusIndicator = '';
                    let statusColorClass = '';

                    if (user.status === 'Open') {
                        statusIndicator = '<div class="h-2.5 w-2.5 rounded-full bg-green-500 mr-2"></div>';
                        statusColorClass = 'text-green-500 dark:text-green-400';
                    } else if (user.status === 'Closed') {
                        statusIndicator = '<div class="h-2.5 w-2.5 rounded-full bg-red-500 mr-2"></div>';
                        statusColorClass = 'text-red-500 dark:text-red-400';
                    } else if (user.status === 'In Progress') {
                        statusIndicator = '<div class="h-2.5 w-2.5 rounded-full bg-yellow-500 mr-2"></div>';
                        statusColorClass = 'text-yellow-500 dark:text-yellow-400';
                    }

                    const userRow = $("<div class='block md:flex justify-between mb-4 px-4 sm:px-5 py-4 sm:py-6 space-y-4 md:space-y-0 rounded-3xl border border-gray-200 bg-gray-50 dark:bg-dark-600 dark:border-gray-600 max-h-42 md:max-h-24 overflow-hidden w-full'>");
                    userRow.html(`
                    <span class="flex md:space-x-12 justify-between items-center">
                        <div class="text-left block font-medium text-gray-900 whitespace-nowrap dark:text-white max-w-56 w-96">
                            <div class="font-medium text-sm flex items-center"><span class="material-symbols-outlined text-sm mr-1">badge</span> <span>${user.name} (@${user.username ? user.username : ''})</span></div>
                            <div class="font-medium text-sm flex items-center"><span class="material-symbols-outlined text-sm mr-1">mail</span> <span>${user.email ? user.email : ''}</span></div>
                            <div class="font-medium text-sm flex items-center"><span class="material-symbols-outlined text-sm mr-1">call</span> <span>${user.phone_number ? user.phone_number : ''}</span></div>
                            <div class="font-medium text-sm">ID: ${user.user_id ? user.user_id : ''}</div>
                        </div>
                        <span>
                            <span class="flex items-center ${statusColorClass}">${statusIndicator} ${user.status ? user.status : ''}</span>
                        </span>
                    </span>
                    <span class="flex md:space-x-12 justify-between items-center">
                        <span>
                            ${formattedCreatedAt}
                        </span>
                        <span>
                                    <a href="requests/${user.user_id}" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-3xl text-sm p-2.5 text-center inline-flex items-center mr-2 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                                          <svg class="w-5 h-5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 10">
                                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M1 5h12m0 0L9 1m4 4L9 9"/>
                                          </svg>
                                          <span class="sr-only">Icon description</span>
                                    </a>                        </span>
                    </span>
                `);

                    userList.append(userRow);
                });
            }
        }

        function filterUsers(searchText) {
            return allUsers.filter(function (user) {
                return (
                    user.id.toString().includes(searchText) ||
                    (user.name && user.name.toLowerCase().includes(searchText)) ||
                    (user.username && user.username.toLowerCase().includes(searchText)) ||
                    (user.email && user.email.toLowerCase().includes(searchText))
                );
            });
        }

        loadingSpinner.removeClass('hidden');

        $.ajax({
            type: 'POST',
            url: '/fetch_users',
            dataType: 'json',
            success: function (data) {
                console.log(data);
                loadingSpinner.addClass('hidden');
                allUsers = data.users;
                renderUsers(allUsers); // Render all users initially
            },
            error: function (error) {
                loadingSpinner.addClass('hidden');
                alert('Error: ' + error.responseText);
            }
        });

        searchInput.on('input', function () {
            const searchText = searchInput.val().toLowerCase();
            const filteredUsers = filterUsers(searchText);
            renderUsers(filteredUsers);
        });
    });



</script>


