<?php
// Include necessary files and configurations
include_once includes('config.php');
$slug = $id;
// Function to set title and description based on user's country

global $title, $description, $icon, $notFound;

function getBlogMeta($slug, $conn) {
    global $title, $description, $icon, $notFound;

    $query = "SELECT meta_title, meta_description, main_photo FROM blog WHERE slug = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $slug);
    $stmt->execute();
    $result = $stmt->get_result();

    // Check if the query was successful
    if ($result && $result->num_rows > 0) {
        // Fetch the meta information
        $metaData = $result->fetch_assoc();

        return array(
            'title' => $metaData['meta_title'],
            'description' => $metaData['meta_description'],
            'og_title' => $metaData['meta_title'],
            'og_description' => $metaData['meta_description'],
            'og_image' => asset($metaData['main_photo']),
        );
    } else {
        // Category not available, handle the error
        $notFound = true;
        return array(
            'title' => '404 - Post Not Found',
            'description' => 'The requested post could not be found.',
            'og_title' => '404 - Post Not Found',
            'og_description' => 'The requested post could not be found.',
            'og_image' => asset('images/brand/open_graph_logo.png'),
        );
    }
}

$currentMeta = getBlogMeta($slug, $conn);
function getBlogBySlug($slug, $conn) {
    // Set character encoding for the database connection
    $conn->set_charset("utf8mb4");

    // Perform SQL query to retrieve blog posts with author information
    $query = "
        SELECT b.*, c.slug as category_slug, c.name as category_name, u.user_id as author_id, u.name as author_name, u.verification_badge as author_verification_badge, u.profile_picture as author_avatar
        FROM blog b
        INNER JOIN users u ON b.user_id = u.user_id
        LEFT JOIN blog_categories c ON b.category = c.category_id
        WHERE b.slug = ? AND b.status = 'published'";

    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $slug);
    $stmt->execute();
    $result = $stmt->get_result();

    // Check if the query was successful
    if ($result) {
        // Fetch the results as an associative array with UTF-8 encoding
        $blogPost = $result->fetch_array(MYSQLI_ASSOC);

        // Check if the blog post was found
        if ($blogPost) {
            // Add verification badge HTML
            $authorVerificationBadgeStatus = $blogPost['author_verification_badge'];
            $blogPost['author_verification_badge_html'] = getVerificationBadgeHTML($authorVerificationBadgeStatus);
            // Add other modifications as needed
            $blogPost['short_content'] = substr(strip_tags($blogPost['content']), 0, 200);
            // ... (other modifications)

            // Fetch category information
            $categories = json_decode($blogPost['category'], true);
            $categoryInfo = array();

            if ($categories) {
                foreach ($categories as $categoryId) {
                    $categoryInfo[] = array(
                        'slug' => getCategorySlugById($categoryId, $conn),
                        'name' => getCategoryNameById($categoryId, $conn),
                    );
                }
            }

            $blogPost['category_info'] = $categoryInfo;

            return $blogPost;
        }
    }

    // Return null if blog post not found or an error occurred
    return null;
}
function getCategorySlugById($categoryId, $conn) {
    $query = "SELECT slug FROM blog_categories WHERE category_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $categoryId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && $row = $result->fetch_assoc()) {
        return $row['slug'];
    }

    // Return null if the category ID is not found or an error occurred
    return null;
}

function getCategoryNameById($categoryId, $conn) {
    $query = "SELECT name FROM blog_categories WHERE category_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $categoryId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && $row = $result->fetch_assoc()) {
        return $row['name'];
    }

    // Return null if the category ID is not found or an error occurred
    return null;
}

// Function to fetch related articles by category and title
function getRelatedArticles($category, $blogId, $language, $conn) {
    // Perform SQL query to retrieve related articles
    $query = "
        SELECT b.*, u.name as author_name, u.profile_picture as author_avatar
FROM blog b
INNER JOIN users u ON b.user_id = u.user_id
WHERE (b.category = ? OR b.title LIKE ? OR b.title LIKE ?) AND b.blog_id != ? AND b.status = 'published' AND b.language = ?
ORDER BY RAND()
LIMIT 4
";  // Adjust the limit as needed

    $stmt = $conn->prepare($query);

// Define patterns for category and similar titles
    $similarTitlePattern= '';
    $exactCategoryPattern = '%' . $category . '%';
    $similarTitlePattern1 = '%' . $category . '%'; // Adjust as needed
    $similarTitlePattern2 = '%' . $similarTitlePattern . '%'; // Adjust as needed

// Bind parameters
    $stmt->bind_param("sssss", $exactCategoryPattern, $similarTitlePattern1, $similarTitlePattern2, $blogId, $language);

    $stmt->execute();
    $result = $stmt->get_result();

    // Check if the query was successful
    if ($result) {
        // Fetch the results as an associative array
        $relatedArticles = $result->fetch_all(MYSQLI_ASSOC);

        // Check if the blog posts were found
        if ($relatedArticles) {
            // Iterate through each related article and make modifications
            foreach ($relatedArticles as &$relatedArticle) {
                // Add verification badge HTML
                $authorVerificationBadgeStatus = $relatedArticle['author_verification_badge'];
                $relatedArticle['author_verification_badge_html'] = getVerificationBadgeHTML($authorVerificationBadgeStatus);
                // Add other modifications as needed
                // Add other modifications as needed
// For short_content
                $relatedArticle['short_content'] = mb_substr(strip_tags($relatedArticle['content']), 0, 40, 'UTF-8');
                $relatedArticle['short_content'] .= (mb_strlen(strip_tags($relatedArticle['content']), 'UTF-8') > 40) ? '...' : '';

// For short_title
                $relatedArticle['short_title'] = mb_substr(strip_tags($relatedArticle['title']), 0, 40, 'UTF-8');
                $relatedArticle['short_title'] .= (mb_strlen(strip_tags($relatedArticle['title']), 'UTF-8') > 40) ? '...' : '';
                $relatedArticle['category'] = $relatedArticle['category'] ?: 'Uncategorized'; // Use 'Uncategorized' or any default message you prefer
                $relatedArticle['reading_time'] = calculateReadingTime($relatedArticle['content']);
                // Display the main photo
                $relatedArticle['main_photo'] = $relatedArticle['main_photo'] ? "<img class='w-full h-52 object-cover rounded-3xl' src='" . asset('uploads/blog/' . $relatedArticle['main_photo']) . "' alt='{$relatedArticle['title']}' />" : "<div class='flex items-center justify-center bg-gray-100 dark:bg-dark-600 w-full h-52 rounded-3xl'><span class='material-symbols-outlined text-gray-300 dark:text-dark-500'>no_photography</span></div>";

            }

            return $relatedArticles;
        }
    }

    // Return an empty array if no related articles found or an error occurred
    return array();
}


// Function to get verification badge HTML based on verification status
function getVerificationBadgeHTML($verificationBadgeStatus) {
    $verificationBadge = '';

    if (!empty($verificationBadgeStatus)) {
        // Display the verification badge and type
        if ($verificationBadgeStatus === 'government') {
            $verificationBadge = '<button data-popover-target="popover-user-profile" data-popover-placement="bottom" type="button" class="h-5 w-5 ml-1 verified__government-checkmark"><svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z"></path></g></svg></button>';
        } elseif ($verificationBadgeStatus === 'corporation') {
            $verificationBadge = '<button data-popover-target="popover-user-profile" data-popover-placement="bottom" type="button" class="h-5 w-5 ml-1 verified__corporation-checkmark"><svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z"></path></g></svg></button>';
        } elseif ($verificationBadgeStatus === 'personal') {
            $verificationBadge = '<button data-popover-target="popover-user-profile" data-popover-placement="bottom" type="button" class="h-5 w-5 ml-1 verified__personal-checkmark"><svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z"></path></g></svg></button>';
        }
    }

    return $verificationBadge;
}

// Get blog post based on slug
if (!$notFound){
    $blogPost = getBlogBySlug($slug, $conn);
}
function calculateReadingTime($text, $wordsPerMinute = 200) {
    // Count the number of words in the text
    $wordCount = str_word_count(strip_tags($text));

    // Calculate the reading time in minutes
    $readingTime = ceil($wordCount / $wordsPerMinute);

    return $readingTime;
}
// Return the blog post as JSON
if ($blogPost) {
    // Fetch related articles based on category and title
    $relatedArticles = getRelatedArticles($blogPost['category'], $blogPost['blog_id'], $blogPost['language'], $conn);

    // Combine blog post and related articles in the response
    $response = array(
        'blogPost' => $blogPost,
        'relatedArticles' => $relatedArticles,
    );



    $readingTime = calculateReadingTime($blogPost['content']);

    // Collapse consecutive newlines into a single newline
    $blogTitle = $blogPost['title'];
    $blogContent = $blogPost['content'];
    function formatCreatedAt($updated_at, $lang) {
        // Assuming the format is Y-m-d H:i:s
        $postDate = DateTime::createFromFormat('Y-m-d H:i:s', $updated_at, new DateTimeZone('+0300'));

        if (!$postDate) {
            // Handle invalid date format
            return "Unknown time ago";
        }

        $currentDate = new DateTime('now', new DateTimeZone('+0300'));

        $interval = $postDate->diff($currentDate);

        $years = $interval->y;
        $months = $interval->m;
        $days = $interval->d;
        $hours = $interval->h;
        $minutes = $interval->i;
        $seconds = $interval->s;

        if ($years > 0) {
            $translationKey = $years === 1 ? 'd-year-ago' : 'd-years-ago';
            return sprintf($lang[$translationKey], $years);
        } elseif ($months > 0) {
            $translationKey = $months === 1 ? 'd-month-ago' : 'd-months-ago';
            return sprintf($lang[$translationKey], $months);
        } elseif ($days > 0) {
            $translationKey = $days === 1 ? 'd-day-ago' : 'd-days-ago';
            return sprintf($lang[$translationKey], $days);
        } elseif ($hours > 0) {
            $translationKey = $hours === 1 ? 'd-hour-ago' : 'd-hours-ago';
            return sprintf($lang[$translationKey], $hours);
        } elseif ($minutes > 0) {
            $translationKey = $minutes === 1 ? 'd-minute-ago' : 'd-minutes-ago';
            return sprintf($lang[$translationKey], $minutes);
        } else {
            $translationKey = $seconds === 1 ? 'd-second-ago' : 'd-seconds-ago';
            return sprintf($lang[$translationKey], $seconds);
        }
    }



    $formattedCreatedAt = formatCreatedAt($response['blogPost']['updated_at'], $lang);
    $blogCategory = $response['blogPost']['category'] ?: 'Uncategorized'; // Use 'Uncategorized' or any default message you prefer

// Display the main photo
    $mainPhoto = $response['blogPost']['main_photo'] ? "<img class='w-full h-72 mb-12 object-cover rounded-3xl' src='" . asset('uploads/blog/' . $response['blogPost']['main_photo']) . "' alt='{$response['blogPost']['title']}' />" : "<div class='flex items-center justify-center bg-gray-100 dark:bg-dark-600 w-full h-72 mb-12 rounded-3xl cursor-default'><span class='material-symbols-outlined text-gray-300 dark:text-dark-500'>no_photography</span></div>";

// Display author data
    $authorData = "<address class='flex items-center mb-6 not-italic'>";
    $authorData .= "
    <div class='flex justify-between items-center'>
        <div class='inline-flex items-center mr-3 text-sm text-gray-900 dark:text-white'>
            <img class='mr-4 w-16 h-16 rounded-full' src='" . asset('uploads/profile_pictures/' . $response['blogPost']['author_avatar']) . "' alt='{$response['blogPost']['author_name']}'>
            <div>
                <a href='#' rel='author' class='flex items-center text-xl font-bold text-gray-900 dark:text-white'>{$response['blogPost']['author_name']} {$response['blogPost']['author_verification_badge_html']}</a>
                <p class='text-base text-gray-500 dark:text-gray-400'>{$lang['ceo-description']}</p>
                <span class='flex items-center space-x-1'><span class='material-symbols-outlined text-base text-gray-500 dark:text-gray-400'>update</span><p class='text-base text-gray-500 dark:text-gray-400'><time pubdate datetime='{$response['blogPost']['updated_at']}' title='$formattedCreatedAt'>$formattedCreatedAt</time></p></span>
            </div>
        </div>
    </div>";

} else {
    // Return an empty response or handle the error as needed
}
// Function to generate navigation links based on list items in the content
function generateNavigation($content) {
    // Use a DOMDocument to parse HTML content
    $doc = new DOMDocument();
    // Specify UTF-8 encoding
    $doc->loadHTML(mb_convert_encoding($content, 'HTML-ENTITIES', 'UTF-8'));

    // Extract headings (h2) from the content
    $headings = $doc->getElementsByTagName('h2');

    // Create an array to store anchor links
    $anchors = [];

    // Loop through each heading
    foreach ($headings as $index => $heading) {
        // Generate a unique ID for the anchor link
        $anchorId = 'section_' . ($index + 1);

        // Add an ID attribute to the heading for navigation
        $heading->setAttribute('id', $anchorId);

        // Add the anchor link to the array
        $anchors[] = [
            'id' => $anchorId,
            'text' => $heading->nodeValue,
        ];
    }

    // Save the modified HTML back to $content
    $modifiedContent = $doc->saveHTML();

    // Return an array containing anchor links and the modified content
    return [
        'anchors' => $anchors,
        'content' => $modifiedContent,
    ];
}

if (!$notFound){
    $navigationData = generateNavigation($blogContent);
    // Access the array of anchors and the modified content
    $anchors = $navigationData['anchors'];
    $modifiedContent = $navigationData['content'];
}


include_once includes('layouts/header.php');
?>
    <div id="indicator" class="fixed top-[50px] left-0 h-1.5 bg-blue-500 dark:bg-blue-600 z-10"></div>
    <div id="content" class="container mx-auto lg:mt-5 mt-10">
        <?php if ($notFound): ?>
        <section class="bg-dark-950 dark:bg-dark-800 mt-8 skeleton">
            <div class="py-6 px-4 mx-auto max-w-screen-xl text-center pb-0 lg:pt-12 lg:px-4 h-[20em] sm:h-[25em] overflow-hidden">
                    <div class="container mx-auto mt-10 text-center">
                        <div class="flex justify-center mb-6">
                            <span class="material-symbols-outlined text-5xl text-green-400">error</span>
                        </div>
                        <div class="flex justify-center mb-2 mt-4 items-center mb-4">
                            <h1 class="text-4xl tracking-tight font-bold text-white dark:text-white"><?php echo $lang['post-not-found-headline'];?></h1>
                        </div>
                        <div class="mb-8 mx-auto">
                            <h2 class="text-lg tracking-tight font-normal text-white dark:text-white"><?php echo $lang['post-not-found-subheading'];?></h2>
                        </div>
                        <div class="mb-8 mx-auto">
                            <a href="<?php echo url('/blog')?>" class="text-blue-500 hover:underline"><?php echo $lang['post-not-found-cta'];?></a>
                        </div>
                    </div>
            </div>
        </section>
        <?php else: ?>
        <section class="pt-8 pb-16 lg:pt-16 lg:pb-24 bg-gray-50 dark:bg-dark-700 overflow-hidden antialiased">
            <div class="text-center mx-auto">
                <div role="status" class="spinner hidden my-6">
                    <svg aria-hidden="true" class="inline w-20 h-20 mr-2 text-gray-200 animate-spin dark:text-gray-600 fill-green-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                    </svg>
                    <span class="sr-only">Loading...</span>
                </div>
            </div>

            <div class="articleArea flex justify-between px-4 mx-auto max-w-screen-xl">
                <div class="hidden lg:block w-72 p-4 border-r border-gray-200 dark:border-dark-500">
                    <div class="post-navigator-left !overflow-hidden">
                        <h3 class="text-gray-500 dark:text-gray-400 ml-4 text-[15px] mb-2 font-semibold"><?php echo $lang['blog-contents']?></h3>
                        <?php
                        // Generate navigation from PHP
                        $navigationData = generateNavigation($blogContent);

                        // Display navigation
                        if (!empty($navigationData['anchors'])) {
                            echo '<nav class="blogNav w-full">';
                            echo '<ol class="w-full space-y-2 list-inside">';
                            foreach ($navigationData['anchors'] as $anchor) {
                                echo "<li class='w-full text-[16px] font-normal text-gray-700 dark:text-gray-300 hover:text-blue-500 dark:hover:text-green-400 p-2 rounded-xl'>
                    <a href='#{$anchor['id']}'>{$anchor['text']}</a>
                </li>";
                            }
                            echo '</ol>';
                            echo '</nav>';
                        }
                        ?>
                    </div>
                </div>

                <article class="mx-auto w-full max-w-2xl format format-sm sm:format-base lg:format-lg format-blue dark:format-invert">
                    <header class="not-format">
                        <div><?php echo $mainPhoto;?></div>
                        <div><?php echo $authorData;?></div>
                        <span class="flex items-center space-x-1 mb-2"><span class="material-symbols-outlined text-base text-gray-500 dark:text-gray-400">visibility</span><p class="text-base text-gray-500 dark:text-gray-400"><?php echo sprintf($lang['x-min-read'], $readingTime); ;?></p></span>
                        <?php
                        // Assuming $blogPost['category_info'] is an array of categories

                        // Check if there are categories
                        if (isset($blogPost['category_info']) && is_array($blogPost['category_info'])) {
                            ?>
                            <span class="flex items-center mb-4"><span class="material-symbols-outlined text-base text-gray-500 dark:text-gray-400 mr-1">category</span>
                            <?php
                            $numCategories = count($blogPost['category_info']);
                            $counter = 0;

                            // Iterate through each category
                            foreach ($blogPost['category_info'] as $category) {
                                $categorySlug = $category['slug'];
                                $categoryName = $category['name'];
                                ?>
                                <a href="<?php echo url('/blog/category/' . $categorySlug) ?>" class="text-base text-gray-500 dark:text-gray-400">
                                    <?php echo $categoryName; ?>
                                </a>
                                <?php

                                // Add a comma if it's not the last category
                                if (++$counter < $numCategories) {
                                    echo '<span class="text-base text-gray-500 dark:text-gray-400 mr-1">,</span>';
                                }
                            }
                            ?>
                        </span>
                            <?php
                        }
                        ?>

                        <h1 class="text-3xl font-extrabold leading-tight text-gray-900 lg:mb-6 lg:text-4xl dark:text-white"><?php echo $blogTitle;?></h1>
                    </header>
                    <span class="prose dark:prose-invert prose-img:rounded-xl  prose-a:text-blue-500">
                        <div class="mb-6">
                            <div class="post-navigator-left !overflow-hidden">
                                <?php
                                // Generate navigation from PHP
                                $navigationData = generateNavigation($blogContent);

                                // Display navigation
                                if (!empty($navigationData['anchors'])) {
                                    echo '<nav class="blogNav w-full">';
                                    echo '<ol class="w-full">';
                                    foreach ($navigationData['anchors'] as $anchor) {
                                        echo "<li class='w-full'>
                            <a class='w-full text-[16px] font-normal hover:text-blue-400 dark:hover:text-blue-400 no-underline' href='#{$anchor['id']}'>{$anchor['text']}</a>
                        </li>";
                                    }
                                    echo '</ol>';
                                    echo '</nav>';
                                }
                                ?>
                        </div>
                        </div>
                        <?php echo $modifiedContent;?>
                    </span>
                </article>
            </div>
        </section>

        <aside aria-label="<?php echo $lang['keep-learning']; ?>" class="py-8 lg:py-24 bg-white dark:bg-dark-800">
            <div class="px-4 mx-auto max-w-screen-xl">
                <h2 class="mb-8 text-2xl font-bold text-gray-900 dark:text-white"><?php echo $lang['keep-learning']; ?></h2>
                <div class="grid gap-12 sm:grid-cols-2 lg:grid-cols-4">
                    <?php
                    foreach ($response['relatedArticles'] as $index => $blog) {
                        echo "<article class='relative max-w-xs p-5 bg-white rounded-3xl border border-gray-200 dark:bg-dark-700 dark:border-dark-600'>";
                        echo "
                                <a href='" . url("/blog/{$blog['slug']}") . "' class='photo-container w-full h-36 mb-4 rounded-3xl'>
                                    " . $blog['main_photo'] . "
                                </a>
                                <div class='mx-1 mt-4'>
                                    <h2 class='mb-2 text-xl font-bold leading-tight text-gray-900 dark:text-white'>
                                        <a href='" . url("/blog/{$blog['slug']}") . "'>{$blog['short_title']}</a>
                                    </h2>
                                    <p class='mb-4 text-gray-500 dark:text-gray-400 mb-12 h-20'>{$blog['short_content']}</p>
                                    <div class='absolute w-full flex justify-between bottom-0.5 right-0.5'>
                                        <div class='inline ml-4'>
                                            <span class='flex items-center space-x-2'><span class='material-symbols-outlined text-gray-600 dark:text-gray-400 text-sm'>person</span><span class='text-gray-600 dark:text-gray-400 text-sm'>".$blog['author_name']."</span></span>
                                            <span class='flex items-center space-x-2'><span class='material-symbols-outlined text-gray-600 dark:text-gray-400 text-sm'>visibility</span><span class='text-gray-600 dark:text-gray-400 text-sm'>".sprintf($lang['x-min-read'], $blog['reading_time'])."</span></span>
                                        </div>    
                                        <a href='" . url("/blog/{$blog['slug']}") . "' class='inline-flex items-center text-white bg-blue-700 hover:bg-blue-800 focus:outline-none focus:ring-4 focus:ring-blue-300 font-medium rounded-full text-sm px-3 py-3 text-center me-2 mb-2 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800'>
                                            <svg class='w-5 h-5' fill='currentColor' viewBox='0 0 20 20' xmlns='http://www.w3.org/2000/svg'>
                                                <path fill-rule='evenodd' d='M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-4.293-4.293a1 1 0 010-1.414z' clip-rule='evenodd'></path>
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                            ";
                        echo "</article>";
                    }
                    ?>

                </div>
            </div>
        </aside>

        <section class="bg-white dark:bg-dark-800">
            <div class="py-8 px-4 mx-auto max-w-screen-xl lg:py-16 lg:px-6">
                <div class="mx-auto max-w-screen-md sm:text-center">
                    <h2 class="mb-4 text-3xl font-extrabold tracking-tight text-gray-900 sm:text-4xl dark:text-white"><?php echo $lang['news-letter-headline']?></h2>
                    <p class="mx-auto mb-8 max-w-2xl  text-gray-500 md:mb-12 sm:text-xl dark:text-gray-400"><?php echo $lang['news-letter-subheading']?></p>
                    <form action="#">
                        <div class="items-center mx-auto mb-3 space-y-4 max-w-screen-sm sm:flex sm:space-y-0">
                            <div class="relative w-full">
                                <label for="email" class="hidden mb-2 text-sm font-medium text-gray-900 dark:text-gray-300"><?php echo $lang['news-letter-email']?></label>
                                <div class="flex absolute inset-y-0 left-0 items-center pl-3 pointer-events-none">
                                    <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 16">
                                        <path d="m10.036 8.278 9.258-7.79A1.979 1.979 0 0 0 18 0H2A1.987 1.987 0 0 0 .641.541l9.395 7.737Z"/>
                                        <path d="M11.241 9.817c-.36.275-.801.425-1.255.427-.428 0-.845-.138-1.187-.395L0 2.6V14a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V2.5l-8.759 7.317Z"/>
                                    </svg>
                                </div>
                                <input class="block p-3 pl-9 w-full text-sm text-gray-900 bg-white rounded-xl border border-gray-300 sm:rounded-none sm:rounded-l-xl focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-700 dark:border-dark-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="<?php echo $lang['news-letter-email-placeholder']?>" type="email" id="email" required="">
                            </div>
                            <div>
                                <button type="submit" class="py-3 px-5 w-full sm:w-[8em] text-sm font-medium text-center text-white rounded-xl border cursor-pointer bg-blue-700 border-blue-600 sm:rounded-none sm:rounded-r-xl hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800"><?php echo $lang['news-letter-cta']?></button>
                            </div>
                        </div>
                        <div class="mx-auto max-w-screen-sm text-sm text-left text-gray-500 newsletter-form-footer dark:text-gray-300"><?php echo $lang['news-letter-privacy']?></div>
                    </form>
                </div>
            </div>
        </section>
    </div>
<?php endif; ?>

<?php
include_once includes('layouts/footer.php');
?>
<script>
    // Calculate the maximum scroll position based on article height
    var articleHeight = $('.articleArea').height();
    var windowHeight = $(window).height();

    // jQuery to smoothly scroll to anchor links with an offset of 80 pixels
    $('.blogNav a').on('click', function (e) {
        e.preventDefault();
        var targetId = $(this).attr('href');
        var offset = $(targetId).offset().top - 80;
        $('html, body').animate({
            scrollTop: offset
        }, 'slow');
    });

    // jQuery to limit the scrolling of blogNav to the content area
    $(window).on('scroll', function () {
        var scrollPosition = $(window).scrollTop();
        var selectedCount = 0;

        // Limit the scroll position to the end of the articleArea
        var cappedScrollPosition = Math.min(scrollPosition, articleHeight);

        // Set the top position of blogNav, ensuring it stays inside articleArea
        $('.post-navigator-left').css('top', Math.max(0, cappedScrollPosition) + 80);

        // Add "active" class to the last section when at the end of the articleArea
        // Remove "active" class from other sections
        $('.blogNav a').each(function () {
            var targetId = $(this).attr('href');
            var targetOffset = $(targetId).offset().top;
            var targetHeight = $(targetId).outerHeight();
            if (scrollPosition >= targetOffset - 80) {
                // Add "active" class to the current section
                $(this).parent().addClass('bg-gray-100 dark:bg-dark-600 text-blue-600 dark:text-green-400 selected');
                selectedCount++;
            } else {
                // Remove "active" class from other sections
                $(this).parent().removeClass('bg-gray-100 dark:bg-dark-600 text-blue-600 dark:text-green-400 selected');
            }
        });

        // Decrease the top position by 20 for each selected element
        $(selectedCount).each(function () {
            $('.post-navigator-left').css('top', Math.max(0, cappedScrollPosition) - (20 * selectedCount));
        });
    });

</script>




