<?php
$meta = array(
    'us' => array(
        'title' => 'Secure Checkout - Complete Your Order - Datanito',
        'description' => 'Securely complete your order for web hosting services at Datanito. Choose the best hosting plan and enjoy exceptional performance and value.',
        'og:title' => 'Secure Checkout - Complete Your Order - Datanito Web Hosting',
        'og:description' => 'Securely complete your order for web hosting services at Datanito. Choose the best hosting plan and enjoy exceptional performance and value.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Güvenli Ödeme - Siparişinizi Tamamlayın - Datanito (Türkiye)',
        'description' => 'Datanito\'da web hosting hizmetleri için güvenli bir şekilde siparişinizi tamamlayın. En iyi hosting planını seçin ve olağanüstü performans ve değerin tadını çıkarın.',
        'og:title' => 'Güvenli Ödeme - Siparişinizi Tamamlayın - Datanito Web Hosting',
        'og:description' => 'Datanito\'da web hosting hizmetleri için güvenli bir şekilde siparişinizi tamamlayın. En iyi hosting planını seçin ve olağanüstü performans ve değerin tadını çıkarın.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/header.php');
if (!isset($_SESSION['user']['id'])) {
    echo '<div class="absolute left-[50%] top-[50%] translate-y-[-50%] translate-x-[-50%]">';
    echo '<div class="flex items-center justify-center">';
    echo '<div role="status" class="spinner my-6">
            <svg aria-hidden="true" class="inline w-20 h-20 mr-2 text-gray-200 animate-spin dark:text-gray-600 fill-blue-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
            </svg>
            <span class="sr-only">Loading...</span>
        </div>';
    echo '</div>';
    echo '<div class="flex items-center justify-center">';
    echo '<p class="text-center">'.$lang['user-not-logged-in'].'</p>';
    echo '</div>';
    echo '</div>';

    $loginURL = url('/account/login');
    echo '<script>
        setTimeout(function() {
            window.location.href = "'.$loginURL.'";
        }, 1000);
    </script>';
    $_SESSION['intended_destination'] = url('/checkout');

    exit;
}
?>

<style>
    /* Apple-inspired Cart Styles */
    .cart-item {
        transition: all 0.3s ease;
        padding: 16px;
        border-radius: 12px;
    }

    .cart-item:hover {
        background-color: rgba(0,0,0,0.02);
    }

    .cart-drawer {
        box-shadow: -10px 0 30px rgba(0,0,0,0.1);
        transition: transform 0.3s cubic-bezier(0.16, 1, 0.3, 1);
    }

    .domain-input input {
        border: 1px solid #d1d5db;
        transition: all 0.2s ease;
    }

    .domain-input input:focus {
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    /* Dark mode support */
    .dark .cart-item {
        background-color: rgba(255,255,255,0.03);
    }

    .dark .cart-item:hover {
        background-color: rgba(255,255,255,0.05);
    }

    .dark .domain-input input {
        background-color: #1f2937;
        border-color: #374151;
    }
</style>
<div id="content" class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8 pt-20">
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Left Column - Cart Items -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Urgency Banner -->
            <div class="bg-gradient-to-r from-blue-600 to-blue-500 text-white px-6 py-3 rounded-xl text-center font-medium mb-6 relative overflow-hidden hidden">
                <div class="absolute inset-0 bg-gradient-to-r from-transparent via-white/20 to-transparent animate-[shimmer_3s_infinite]"></div>
                <div class="flex items-center justify-center relative z-10">
                    <svg class="w-5 h-5 text-white mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"/>
                    </svg>
                    <span id="urgency-timer" class="mr-2"><?php echo $lang['checkout-urgency-message']; ?></span>
                    <span id="countdown" class="font-bold">15:00</span>
                </div>
            </div>

            <!-- Cart Header -->
            <div class="flex justify-between items-center">
                <h1 class="text-2xl sm:text-3xl font-semibold text-gray-900 dark:text-white tracking-tight">
                    <?php echo $lang['check-out-headline']; ?>
                </h1>
                <span class="text-sm text-gray-500 dark:text-gray-400">Step 1 of 2</span>
            </div>

            <!-- Cart Items -->
            <div class="bg-white dark:bg-dark-800 rounded-2xl shadow-sm border border-gray-200 dark:border-dark-700 overflow-hidden transition-all hover:shadow-md dark:hover:shadow-gray-700/50">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-4">
                        <?php echo $lang['check-out-bag-items']; ?>
                    </h3>

                    <div class="cart-items-list space-y-4">
                        <!-- Cart items will be dynamically inserted here -->
                        <p class="cart-empty-message text-center text-gray-500 dark:text-gray-400 py-10">
                            <?php echo $lang['cart-is-empty'] ?>
                        </p>
                    </div>
                </div>
            </div>

            <!-- Testimonial -->
            <div class="bg-white dark:bg-dark-800 rounded-2xl shadow-sm border border-gray-200 dark:border-dark-700 overflow-hidden">
                <div class="p-6">
                    <div class="flex items-center mb-4">
                        <!-- 5 stars -->
                        <?php for ($i = 1; $i <= 5; $i++): ?>
                            <svg class="w-5 h-5 text-yellow-400 mr-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                            </svg>
                        <?php endfor; ?>
                        <p class="text-sm font-medium text-gray-600 dark:text-gray-300 ml-2">
                            4.9/5 from 1,200+ reviews
                        </p>
                    </div>
                    <p class="text-gray-600 dark:text-gray-300 italic">
                        "<?php echo $lang['customer-testimonial']; ?>"
                    </p>
                    <p class="text-gray-500 dark:text-gray-400 mt-2 font-medium">
                        - <?php echo $lang['customer-name']; ?>
                    </p>
                </div>
            </div>
        </div>

        <!-- Right Column - Order Summary -->
        <div class="lg:col-span-1">
            <div class="bg-white dark:bg-dark-800 rounded-2xl shadow-sm border border-gray-200 dark:border-dark-700 sticky top-6">
                <div class="p-6">
                    <h2 class="text-lg font-medium text-gray-900 dark:text-white mb-4">
                        <?php echo $lang['check-out-billing-headline'] ?>
                    </h2>

                    <div class="billing-information space-y-4">
                        <div class="flex justify-between py-3 border-b border-gray-200 dark:border-gray-700">
                            <span class="text-gray-600 dark:text-gray-300"><?php echo $lang['check-out-subtotal'] ?></span>
                            <span class="subtotal text-gray-900 dark:text-white">-</span>
                        </div>
                        <div class="flex justify-between py-3 border-b border-gray-200 dark:border-gray-700">
                            <span class="text-gray-600 dark:text-gray-300"><?php echo $lang['check-out-estimated-tax'] ?></span>
                            <span class="text-gray-900 dark:text-white"><?php echo $lang['check-out-tax-rate'] ?> | <span class="tax-estimated"></span></span>
                        </div>
                        <div class="flex justify-between py-3 border-b border-gray-200 dark:border-gray-700">
                            <span class="text-green-600 dark:text-green-500"><?php echo $lang['cart-saving']?></span>
                            <span class="text-base font-medium text-green-600 dark:text-green-400"><span>-</span><span class="saving-amount">$0.00</span></span>
                        </div>

                        <div class="flex justify-between py-4 border-t border-gray-200 dark:border-gray-700">
                            <span class="font-semibold text-gray-900 dark:text-white"><?php echo $lang['check-out-total'] ?></span>
                            <span class="cart-total-tax font-semibold text-gray-900 dark:text-white">-</span>
                        </div>
                    </div>

                    <button type="button" data-modal-target="process-payment-modal" data-modal-toggle="process-payment-modal"
                            class="hidden md:flex items-center justify-center w-full mt-6 bg-dark-900 dark:bg-white hover:bg-dark-700 dark:hover:bg-gray-100 text-white dark:text-gray-900 font-medium rounded-xl py-4 px-6 transition-all duration-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 dark:focus:ring-offset-gray-800">
                        <?php echo $lang['invoice-pay-cta']; ?>
                    </button>
                    <!-- Mobile sticky footer -->
                    <div class="md:hidden fixed z-20 bottom-0 left-0 right-0 bg-white dark:bg-dark-800 shadow-lg p-4 border-t border-gray-200 dark:border-gray-700">
                        <div class="flex justify-between items-center">
                            <div>
                                <p class="text-sm text-gray-600 dark:text-gray-300"><?php echo $lang['check-out-total'] ?></p>
                                <p class="text-lg font-bold cart-total-tax"></p>
                            </div>
                            <button type="button" data-modal-target="process-payment-modal" data-modal-toggle="process-payment-modal" class="appearance-none inline-flex hover:shadow-2xl transition-all duration-300 hover:scale-105 items-center group space-x-2.5 bg-black dark:bg-gray-100 text-gray-50 dark:text-dark-700 py-3 px-4 md:py-3 md:px-5 rounded-full cursor-pointer">
                                <span class="material-symbols-outlined">check_circle</span>
                                <span><?php echo $lang['invoice-pay-cta']; ?></span>
                            </button>
                        </div>
                    </div>
                    <div class="flex flex-wrap gap-3 mt-6">
                        <img class="h-6" src="<?php echo asset('images/content/logos/visa.png'); ?>" alt="Visa">
                        <img class="h-6" src="<?php echo asset('images/content/logos/mastercard.png'); ?>" alt="Mastercard">
                        <img class="h-6" src="<?php echo asset('images/content/logos/amex.png'); ?>" alt="American Express">
                    </div>

                    <div class="mt-6 flex items-start p-4 bg-gray-50 dark:bg-dark-700 rounded-xl">
                        <svg class="flex-shrink-0 w-12 h-12 text-green-500 mt-1 mr-3" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"/>
                        </svg>
                        <div>
                            <h4 class="text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo $lang['check-out-secure-headline']?>
                            </h4>
                            <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                <?php echo $lang['check-out-secure-subheading']?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Payment Modal -->
<div id="process-payment-modal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full overflow-x-hidden overflow-y-auto md:inset-0 h-[100%] max-h-full cssanimation fadeInBottom dark:!bg-dark-800/25">
    <div class="sm:relative sm:w-full sm:max-w-md sm:max-h-full fixed bottom-0 w-full">
        <div class="relative bg-white sm:rounded-3xl shadow dark:bg-dark-700 rounded-t-[2rem]">
            <button type="button" class="absolute top-3 right-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-full text-sm w-8 h-8 ml-auto inline-flex justify-center items-center dark:hover:bg-dark-600 dark:hover:text-white" data-modal-hide="process-payment-modal">
                <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                </svg>
                <span class="sr-only">Close modal</span>
            </button>
            <div class="px-6 pt-4 pb-0 rounded-t">
                <h3 class="flex items-center text-base font-semibold text-gray-900 lg:text-xl dark:text-white space-x-2">
                    <svg class="w-5 h-5 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 16 20">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.5 8V4.5a3.5 3.5 0 1 0-7 0V8M8 12v3M2 8h12a1 1 0 0 1 1 1v9a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V9a1 1 0 0 1 1-1Z"/>
                    </svg>
                    <span><?php echo $lang['modal-pay-headline'] ?></span>
                </h3>
                <span class="!flex items-center text-sm"><?php echo $lang['modal-pay-by-datanito-pay'] ?></span>
            </div>
            <div class="modal-body sm:rounded-3xl bg-gray-100 dark:bg-dark-500">
                <div id="pay-step1">
                    <div class="block bg-white dark:bg-dark-700 p-2 space-y-2 mb-2">
                        <div class="flex justify-between space-x-4 p-2">
                            <div class="whitespace-nowrap text-black dark:text-white"><?php echo $lang['invoice-total']; ?></div>
                            <div class="whitespace-nowrap text-black dark:text-white cart-total-tax"></div>
                        </div>
                    </div>
                    <div class="bg-white dark:bg-dark-700 border-b border-gray-200 dark:border-gray-700 px-2">
                        <ul class="flex flex-wrap -mb-px text-sm font-medium text-center" id="checkoutTabs" data-tabs-toggle="#checkoutTabsContent" role="tablist">
                            <li class="mr-2" role="presentation">
                                <button class="inline-block p-4 border-b-2 rounded-t-lg" id="saved-card-tab" data-tabs-target="#saved-card" type="button" role="tab" aria-controls="saved-card" aria-selected="false"><?php echo $lang['check-out-saved-cards'] ?></button>
                            </li>
                            <li class="mr-2" role="presentation">
                                <button class="inline-block p-4 border-b-2 rounded-t-lg" id="add-card-tab" data-tabs-target="#add-card" type="button" role="tab" aria-controls="add-card" aria-selected="false"><?php echo $lang['check-out-add-new-card'] ?></button>
                            </li>
                        </ul>
                    </div>
                    <div class="block bg-white dark:bg-dark-700 p-2 space-y-2 h-72 md:h-96 overflow-y-auto">
                        <div id="checkoutTabsContent">
                            <div class="hidden p-1 md:p-4 rounded-lg" id="saved-card" role="tabpanel" aria-labelledby="saved-card-tab">
                                <div role="status" class="spinner hidden my-6">
                                    <svg aria-hidden="true" class="inline w-20 h-20 mr-2 text-gray-200 animate-spin dark:text-gray-600 fill-green-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                                    </svg>
                                    <span class="sr-only">Loading...</span>
                                </div>
                                <h3 class='mb-5 text-base font-semibold text-gray-600 dark:text-gray-300 px-2 pt-2'><?php echo $lang['check-out-select-card'];?></h3>
                                <div id="saved-cards-list" class="w-full"></div>
                            </div>
                            <div class="hidden p-1 md:p-4 rounded-lg" id="add-card" role="tabpanel" aria-labelledby="add-card-tab">
                                <h3 class='mb-5 text-base font-semibold text-gray-600 dark:text-gray-300 px-2 pt-2'><?php echo $lang['check-out-save-card-headline'] ?></h3>
                                <form class="save-card-form space-y-2 lg:space-y-6 w-full" method="POST">
                                    <?php set_csrf(); ?>
                                    <div class="relative">
                                        <input type="text" id="card-number" name="card-number" class="block rounded-t-lg px-2.5 pb-2.5 pt-5 w-full text-sm text-gray-900 bg-gray-50 dark:bg-dark-700 border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required />
                                        <label for="card-number" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-4 z-10 origin-[0] left-2.5 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-4"><?php echo $lang['check-out-card-number'] ?></label>
                                    </div>
                                    <div class="relative grid grid-cols-2 space-y-0 space-x-3 mb-5 w-full sm:w-[70%]">
                                        <div class="relative">
                                            <select id="expiration-month" name="expiration-month" class="block rounded-t-lg w-full px-2.5 pb-2.5 pt-5 w-1/2 text-sm text-gray-900 bg-gray-50 dark:bg-dark-700 border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" required>
                                                <option value="" disabled selected hidden>Month</option>
                                                <?php
                                                for ($month = 1; $month <= 12; $month++) {
                                                    $monthStr = str_pad($month, 2, '0', STR_PAD_LEFT);
                                                    echo "<option value='$monthStr'>$monthStr</option>";
                                                }
                                                ?>
                                            </select>
                                            <label for="expiration-month" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-4 z-10 origin-[0] left-2.5 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-4"><?php echo $lang['check-out-expiration-month'] ?></label>
                                        </div>
                                        <div class="relative">
                                            <select id="expiration-year" name="expiration-year" class="block rounded-t-lg w-full px-2.5 pb-2.5 pt-5 w-1/2 text-sm text-gray-900 bg-gray-50 dark:bg-dark-700 border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" required>
                                                <option value="" disabled selected hidden>Year</option>
                                                <?php
                                                $currentYear = date('Y');
                                                $futureYears = range($currentYear, $currentYear + 10);
                                                foreach ($futureYears as $year) {
                                                    echo "<option value='$year'>$year</option>";
                                                }
                                                ?>
                                            </select>
                                            <label for="expiration-year" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-4 z-10 origin-[0] left-2.5 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-4"><?php echo $lang['check-out-expiration-year'] ?></label>
                                        </div>
                                    </div>
                                    <div class="relative">
                                        <input type="text" id="CVV" name="cvv" maxlength="3" class="block rounded-t-lg px-2.5 pb-2.5 pt-5 w-full text-sm text-gray-900 bg-gray-50 dark:bg-dark-700 border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required />
                                        <label for="CVV" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-4 z-10 origin-[0] left-2.5 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-4"><?php echo $lang['check-out-cvv'] ?></label>
                                    </div>
                                    <div class="relative">
                                        <input type="text" id="name" name="name" class="block rounded-t-lg px-2.5 pb-2.5 pt-5 w-full text-sm text-gray-900 bg-gray-50 dark:bg-dark-700 border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required />
                                        <label for="name" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-4 z-10 origin-[0] left-2.5 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-4"><?php echo $lang['check-out-holder-name'] ?></label>
                                    </div>
                                    <div class="relative hidden">
                                        <input type="text" id="honeypot" name="honeypot" value="">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="block bg-white dark:bg-dark-700 p-2 border-t border-gray-200 dark:border-dark-500 sm:rounded-3xl !rounded-t-none">
                        <div class="pay-now"></div>
                        <div>
                            <button type="submit" class="hidden save-card-info-btn flex items-center justify-center w-full h-10 text-neutral-800 bg-primary-500 hover:bg-primary-600 focus:outline-none focus:ring-4 focus:ring-primary-300 font-medium rounded-full text-sm px-5 py-2.5 text-center dark:bg-primary-500 dark:hover:bg-parimary-600 dark:focus:ring-primary-800">
                                <span><?php echo $lang['modal-save-card-cta']?></span>
                            </button>
                        </div>
                    </div>
                </div>
                <div id="pay-step2"></div>
            </div>
        </div>
    </div>
</div>
<?php
include_once includes('layouts/footer.php');
?>

<script>
    // Countdown Timer for Urgency Banner
    function startCountdown() {
        // Set the initial time (15 minutes in seconds)
        let timeLeft = 15 * 60;

        // Get the countdown element
        const countdownElement = document.getElementById('countdown');
        const urgencyBanner = document.querySelector('.urgency-banner');

        // Update the countdown every second
        const countdownInterval = setInterval(function() {
            // Calculate minutes and seconds
            const minutes = Math.floor(timeLeft / 60);
            const seconds = timeLeft % 60;

            // Display the time in MM:SS format
            countdownElement.textContent =
                minutes.toString().padStart(2, '0') + ':' +
                seconds.toString().padStart(2, '0');

            // Change styles when under 5 minutes
            if (timeLeft <= 5 * 60) {
                urgencyBanner.style.background = 'linear-gradient(90deg, #ef4444, #dc2626)';
                countdownElement.style.color = '#fef08a'; // Yellow color for emphasis
            }

            // Change styles when under 1 minute
            if (timeLeft <= 60) {
                urgencyBanner.style.animation = 'pulse 1s infinite';
                countdownElement.style.fontWeight = '800';
            }

            // Decrement the time left
            timeLeft--;

            // Stop the countdown when time runs out
            if (timeLeft < 0) {
                clearInterval(countdownInterval);
                urgencyBanner.innerHTML = `
                <div class="container mx-auto flex items-center justify-center">
                    <svg class="w-5 h-5 text-white mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                    </svg>
                    <span class="font-medium"><?php echo $lang['checkout-urgency-expired']; ?></span>
                </div>
            `;
            }
        }, 1000);
    }

    // Start the countdown when the page loads
    document.addEventListener('DOMContentLoaded', function() {
        startCountdown();
    });
    $(document).ready(function () {
        // Initialize credit card input formatting
        $('#card-number').on('input', function() {
            var val = $(this).val().replace(/\s+/g, ''); // Remove all spaces
            var newval = '';
            for(var i = 0; i < val.length; i++) {
                if(i%4 == 0 && i > 0) newval += ' ';
                newval += val[i];
            }
            $(this).val(newval);
        });

        // Auto-select the first card when the modal opens
        $('#process-payment-modal').on('shown.bs.modal', function() {
            var firstCard = $('input[name="selected_card"]:first');
            if(firstCard.length) {
                firstCard.prop('checked', true);
            }
        });

        function switchButton(selectedTabId) {
            if (selectedTabId === 'add-card') {
                $('.save-card-info-btn').removeClass('hidden');
                $('.pay-now-btn').addClass('hidden');
            } else if (selectedTabId === 'saved-card') {
                $('.pay-now-btn').removeClass('hidden');
                $('.save-card-info-btn').addClass('hidden');
            }
        }

        $('#add-card-tab').on('click', function() {
            switchButton('add-card');
        });

        $('#saved-card-tab').on('click', function() {
            switchButton('saved-card');
        });

        getCards();
        const loadingSpinner = $('.spinner');
        loadingSpinner.removeClass('hidden');

        // Handle form submission to save a card
        $('.save-card-info-btn').click(function () {
            var formData = $('.save-card-form').serialize();

            $.ajax({
                type: 'POST',
                url: '/save_card',
                data: formData,
                success: function (response) {
                    console.log(response);
                    var result = JSON.parse(response);

                    if (result.success) {
                        getCards();
                        $('#saved-card-tab').trigger('click');
                        $("#toast-success").css("display", "flex");
                        $("#toast-success").removeClass("hidden");
                        $(".toast-message").text(result.message);
                        $("#toast-success").addClass("notification-opened");
                        $("#toast-success svg").addClass("notification-checkmark");
                        $("#toast-success").removeClass("notification-closed");
                        $('.save-card-form input[type="text"], .save-card-form input[type="number"]').val('');

                        setTimeout(function () {
                            $("#toast-success").addClass("notification-closed");
                            $("#toast-success").removeClass("notification-opened");
                            $("#toast-success svg").removeClass("notification-checkmark");
                        }, 2000);
                    } else {
                        $("#toast-success").css("display", "flex");
                        $(".notification-success").addClass("hidden");
                        $(".notification-error").removeClass("hidden");
                        $(".toast-message").text(result.message);
                        $("#toast-success").addClass("notification-opened");
                        $("#toast-success svg").addClass("notification-checkmark");
                        $("#toast-success").removeClass("notification-closed");

                        setTimeout(function () {
                            $("#toast-success").addClass("notification-closed");
                            $("#toast-success").removeClass("notification-opened");
                            $("#toast-success svg").removeClass("notification-checkmark");
                        }, 2000);
                    }
                },
                error: function (xhr, status, error) {
                    console.error(error);
                }
            });
        });

        function getCards() {
            $.ajax({
                type: 'POST',
                dataType: "json",
                url: '/get_cards',
                success: function (response) {
                    loadingSpinner.addClass('hidden');
                    const cardsContainer = $("#saved-cards-list");
                    cardsContainer.empty();

                    if (response.message) {
                        const message = $("<div class='text-center text-gray-700 dark:text-gray-300 mt-4'>");
                        message.text(response.message);
                        cardsContainer.append(message);
                        $('.pay-now-btn').addClass('hidden');
                    } else {
                        $.each(response, function (index, card) {
                            const showCard = $("<div>");
                            showCard.html(`
                            <div>
                                <input type='radio' id='card-${card.cardNumber}' name='selected_card' value='${card.cardNumber}' class='hidden peer' required>
                                <label for='card-${card.cardNumber}' class='inline-flex items-center justify-between w-full p-3 md:p-5 text-gray-500 mb-4 space-y-4 space-x-4 md:space-x-5 md:space-y-0 bg-gray-50 border-2 border-gray-200 rounded-3xl dark:bg-dark-700 dark:border-dark-500 hover:bg-gray-100 dark:hover:bg-dark-600 peer-checked:border-2 peer-checked:shadow-blue-500 peer-checked:border-blue-500'>
                                    <div class='flex'>
                                        <img class='w-12 h-12 mr-4' src='${card.cardType}'>
                                        <div class='block'>
                                            <div class='w-full text-lg font-semibold text-gray-700 dark:text-gray-300'>**** **** **** ${card.lastFourDigits}</div>
                                            <div class='w-full text-gray-700 dark:text-gray-300'>${card.cardholderName}</div>
                                        </div>
                                    </div>
                                    <span class='md:flex md:space-x-12 justify-between items-center'>
                                        <p class='text-gray-700 dark:text-gray-300'>${card.expirationDate}</p>
                                    </span>
                                </label>
                            </div>
                        `);

                            cardsContainer.append(showCard);
                        });

                        const firstCardRadio = $("input[name='selected_card']:first");
                        if (firstCardRadio.length > 0) {
                            firstCardRadio.prop('checked', true).trigger('click');
                        }
                    }
                },
                error: function (xhr, status, error) {
                    console.error(error);
                    loadingSpinner.addClass('hidden');
                    const cardsContainer = $("#saved-cards-list");
                    cardsContainer.empty();
                    const errorMessage = $("<div class='text-center text-red-700 dark:text-red-300 mt-4'>");
                    errorMessage.text('An error occurred while fetching your cards. Please try again.');
                    cardsContainer.append(errorMessage);
                }
            });
        }

        // Retrieve cart items from localStorage
        var storedCartItems = localStorage.getItem('cartItems');
        var cartItems = storedCartItems ? JSON.parse(storedCartItems) : [];

        var total = 0;
        if (cartItems.length > 0) {
            var currency = cartItems[0].currency;
            var total = 0;
            var totalWithOffer = 0;

            cartItems.forEach(function (item) {
                var itemPrice = parseFloat(item.price.replace(',', '').trim());
                var itemOfferPrice = item.offerprice !== null ? parseFloat(item.offerprice.replace(',', '').trim()) : itemPrice;

                total += itemPrice * item.quantity;
                totalWithOffer += itemOfferPrice * item.quantity;
            });

            var taxRate = 0.2;
            var taxAmount = totalWithOffer * taxRate;
            var totalWithTax = totalWithOffer + taxAmount;
            var savings = total - totalWithOffer;

            function formatCurrency(amount, currency) {
                var formattedAmount = amount.toFixed(2);
                if (currency === ' TL') {
                    return formattedAmount + ' ' + currency.trim();
                } else {
                    return currency + ' ' + formattedAmount;
                }
            }

            $('.cart-total').text(formatCurrency(total, currency));
            $('.cart-total-tax').text(formatCurrency(totalWithTax, currency));
            var total_amount_to_pay = formatCurrency(totalWithTax, currency);
            $('.saving-amount').text(formatCurrency(savings, currency));
            $('.subtotal').text(formatCurrency(totalWithOffer, currency));

        } else {
            console.log("Cart is empty.");
        }

        if (cartItems.length > 0) {
            // Render cart items if needed
        } else {
            $('.cart-summary').empty();
            $('.cart-checkout').empty();
            $('.pay-now').addClass('hidden');
        }

        const amountToPay = '<?php echo str_replace('%d', '\' + total_amount_to_pay + \'', $lang['modal-pay-cta']); ?>';
        $(".pay-now").html(`<button type="button" class="pay-now-btn flex items-center justify-between w-full h-10 text-neutral-800 bg-primary-500 hover:bg-primary-600 focus:outline-none focus:ring-4 focus:ring-primary-300 font-medium rounded-full text-sm px-5 py-2.5 text-center dark:bg-primary-500 dark:hover:bg-parimary-600 dark:focus:ring-primary-800">
                            <span>
                                <svg aria-hidden="true" class="w-6 h-6 text-gray-200 animate-spin dark:text-gray-600 fill-neutral-800 spinner-status opacity-0" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                                    <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                                </svg>
                                <span class="sr-only">Loading...</span>
                            </span>
                    <span>${amountToPay}</span>
                    <span class="w-6 h-6 opacity-0"></span>
                </button>`);

        $(document).on('click', '.pay-now-btn', function () {
            var $button = $(this);
            $button.prop('disabled', true);
            var $spinner = $button.find('.spinner-status');
            $spinner.removeClass('opacity-0');

            var cardNumber = $('[name="selected_card"]:checked').val();
            var storedCartItems = localStorage.getItem('cartItems');
            var cartItems = storedCartItems ? JSON.parse(storedCartItems) : [];

            var products = [];

            cartItems.forEach(function (item) {
                var productId = item.id;
                var productDomain = item.domain;
                var productTLD = item.tld;
                var productPrice = item.price;
                var productOfferPrice = item.offerprice;
                var productCurrency = item.currency;
                var productDuration = item.duration;

                var productData = {
                    product_id: productId,
                    domain: productDomain,
                    tld: productTLD,
                    quantity: 1,
                    duration: productDuration
                };

                if (item.category === 'domain-name') {
                    productData.category = 'domain-name';
                    productData.price = productPrice;
                    productData.offerprice = productOfferPrice;
                    productData.currency = productCurrency;
                }

                products.push(productData);
            });

            var paymentData = {
                cardNumber: cardNumber,
                products: products
            };

            $.ajax({
                type: 'POST',
                url: '/process_checkout',
                data: paymentData,
                success: function (response) {
                    $spinner.addClass('opacity-0');
                    $button.prop('disabled', false);

                    var result = JSON.parse(response);
                    console.log(result);

                    $("#toast-success").css("display", "flex");
                    $("#toast-success").removeClass("hidden");
                    $(".toast-message").text(result.message);

                    if (result.icon === 'error') {
                        $(".notification-success").addClass("hidden");
                        $(".notification-error").removeClass("hidden");
                    } else {
                        $(".notification-success").removeClass("hidden");
                        $(".notification-error").addClass("hidden");
                        $("#process-payment-modal .modal-body #pay-step1").addClass("hidden");
                        $("#process-payment-modal .modal-body #pay-step2").removeClass("hidden");
                        $('#process-payment-modal .modal-body #pay-step2').html(result.iframe);
                        localStorage.removeItem('cartItems');
                    }

                    $("#toast-success").addClass("notification-opened");
                    $("#toast-success svg").addClass("notification-checkmark");
                    $("#toast-success").removeClass("notification-closed");

                    setTimeout(function () {
                        $("#toast-success").addClass("notification-closed");
                        $("#toast-success").removeClass("notification-opened");
                        $("#toast-success svg").removeClass("notification-checkmark");
                    }, 2000);

                    const invoiceId = result['invoice-id'];
                    $('body').on('tryAgainClicked', function() {
                        window.location.href = `/account/billing/invoices/${invoiceId}`;
                    });
                },
                error: function (xhr, status, error) {
                    console.error(error);
                }
            });
        });
    });
</script>