<?php
$meta = array(
    'us' => array(
        'title' => 'AI Business Hosting | High-Performance Solutions | Datanito',
        'description' => 'Discover reliable AI Business Hosting solutions with unmatched performance. Elevate your enterprise hosting with advanced features and top-notch support.',
        'og:title' => 'AI Business Hosting | High-Performance Solutions | Datanito',
        'og:description' => 'Explore reliable AI Business Hosting solutions with unmatched performance. Elevate your enterprise hosting with advanced features and top-notch support.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'AI Kurumsal Hosting - Yüksek Performans Çözümleri - Datanito',
        'description' => 'Eşsiz performansa sahip güvenilir AI Kurumsal Hosting çözümlerini keşfedin. İşletme hosting ihtiyaçlarınızı yüksek özellikler ve üstün destek ile artırın.',
        'og:title' => 'AI Kurumsal Hosting - Yüksek Performans Çözümleri - Datanito',
        'og:description' => 'Güvenilir AI Kurumsal Hosting çözümlerini eşsiz performans ile keşfedin. İşletme hosting ihtiyaçlarınızı yüksek özellikler ve üstün destek ile artırın.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
// Add each question-answer pair to the mainEntity array
$faqSchema = array();
// Check if $faqSectionWebHosting is set and is an array
if (isset($faqSectionWebHosting) && is_array($faqSectionWebHosting)) {
    // Initialize $faqSchema array
    $faqSchema = array();

    // Iterate through $faqSectionWebHosting
    foreach ($faqSectionWebHosting as $faq) {
        // Construct each FAQ schema entry
        $faqSchema[] = array(
            "@type" => "Question",
            "name" => $faq["question"],
            "acceptedAnswer" => array(
                "@type" => "Answer",
                "text" => $faq["answer"]
            )
        );
    }
}

// Convert the schema FAQPage to JSON-LD format
$jsonFaqLD = json_encode($faqSchema, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);

// Set up the schema Organization
$schemaOrg = array(
    "@context" => "http://schema.org",
    "@type" => "Organization",
    "name" => "Datanito",
    "description" => "Datanito provides web hosting, web design, app development, SEO, SMO, domain name, marketing and advertising services.",
    "url" => "https://datanito.com",
    "logo" => "https://datanito.com/logo.png",
    "sameAs" => array(
        "https://www.facebook.com/datanito",
        "https://twitter.com/datanito",
        "https://www.instagram.com/datanito/",
        "https://www.linkedin.com/company/datanito/"
    ),
    "contactPoint" => array(
        array(
            "@type" => "ContactPoint",
            "telephone" => "+90-538-224-4717",
            "contactType" => "customer service"
        )
    ),
    "address" => array(
        "@type" => "PostalAddress",
        "streetAddress" => "Yakuplu, Hürriyet Blv, Skyport Residance",
        "addressLocality" => "Beylikdüzü",
        "addressRegion" => "Istanbul",
        "postalCode" => "34524",
        "addressCountry" => "Türkiye"
    ),
    "founder" => array(
        "@type" => "Person",
        "name" => "Milad Saraf"
    )
);
// Convert the schema Organization to JSON-LD format
$jsonOrgLD = json_encode($schemaOrg, JSON_UNESCAPED_SLASHES);
include_once includes('layouts/header.php');
?>
    <div id="content" class="container mx-auto lg:mt-12 mt-12">
        <section class="bg-transparent my-12 overflow-hidden">
            <div aria-hidden="true" class="absolute sm:inset-0 h-max w-full mx-auto grid grid-cols-2 -space-x-52 opacity-20">
                <div class="blur-[50px] sm:blur-[106px] h-56 bg-gradient-to-br  to-purple-400 from-blue-700"></div>
                <div class="blur-[50px] sm:blur-[106px] h-32 bg-gradient-to-r from-cyan-400  to-indigo-600"></div>
            </div>
            <div class="mx-auto text-center mt-20">
                <h1 class="text-5xl md:text-9xl font-bold text-black dark:text-gray-100"><?php echo $lang['business-hosting-superior'] ?></h1>
                <div class="flex items-center justify-center space-x-1 my-4 md:my-10">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-6 h-6 text-purple-300 dark:text-purple-400">
                        <path fill-rule="evenodd"
                              d="M9 4.5a.75.75 0 01.721.544l.813 2.846a3.75 3.75 0 002.576 2.576l2.846.813a.75.75 0 010 1.442l-2.846.813a3.75 3.75 0 00-2.576 2.576l-.813 2.846a.75.75 0 01-1.442 0l-.813-2.846a3.75 3.75 0 00-2.576-2.576l-2.846-.813a.75.75 0 010-1.442l2.846-.813A3.75 3.75 0 007.466 7.89l.813-2.846A.75.75 0 019 4.5zM18 1.5a.75.75 0 01.728.568l.258 1.036c.236.94.97 1.674 1.91 1.91l1.036.258a.75.75 0 010 1.456l-1.036.258c-.94.236-1.674.97-1.91 1.91l-.258 1.036a.75.75 0 01-1.456 0l-.258-1.036a2.625 2.625 0 00-1.91-1.91l-1.036-.258a.75.75 0 010-1.456l1.036-.258a2.625 2.625 0 001.91-1.91l.258-1.036A.75.75 0 0118 1.5zM16.5 15a.75.75 0 01.712.513l.394 1.183c.15.447.5.799.948.948l1.183.395a.75.75 0 010 1.422l-1.183.395c-.447.15-.799.5-.948.948l-.395 1.183a.75.75 0 01-1.422 0l-.395-1.183a1.5 1.5 0 00-.948-.948l-1.183-.395a.75.75 0 010-1.422l1.183-.395c.447-.15.799-.5.948-.948l.395-1.183A.75.75 0 0116.5 15z"
                              clip-rule="evenodd"></path>
                    </svg>
                    <h2 class="text-lg md:text-2xl text-transparent bg-clip-text bg-gradient-to-r to-cyan-600 from-purple-400"><?php echo $lang['business-hosting-headline'] ?></h2>
                </div>
            </div>

            <div class="block md:flex items-center justify-center w-full mx-auto space-y-4 md:space-y-0 md:space-x-3 p-1 md:p-4 relative z-10">
                <div class="flex items-center justify-center">
                    <p class="text-lg md:text-xl font-semibold platinum-gradient-text"><?php echo $lang['business-hosting-subheading'] ?></p>
                </div>
                <div class="hidden md:block vl border h-10 border-gray-200 dark:border-dark-700"></div>
                <div class="inline-flex w-full md:w-max items-center justify-center rounded-full space-x-2 md:space-x-3" role="group">
                    <button data-scroll-target="plans" type="button" class="scroll-link px-5 py-3 text-base font-normal text-gray-100 bg-dark-700 hover:bg-dark-600 rounded-full focus:z-10 focus:ring-0 dark:bg-dark-700 dark:text-white dark:hover:text-white dark:hover:bg-dark-600 cursor-pointer">
                        <?php echo $lang['navigateBar-plans']?>
                    </button>
                    <button data-scroll-target="features" type="button" class="scroll-link px-5 py-3 text-base font-normal text-gray-100 bg-dark-700 hover:bg-dark-600 rounded-full focus:z-10 focus:ring-0 dark:bg-dark-700 dark:text-white dark:hover:text-white dark:hover:bg-dark-600 cursor-pointer">
                        <?php echo $lang['navigateBar-features']?>
                    </button>
                    <button data-scroll-target="faqs" type="button" class="scroll-link px-5 py-3 text-base font-normal text-gray-100 bg-dark-700 hover:bg-dark-600 rounded-full focus:z-10 focus:ring-0 dark:bg-dark-700 dark:text-white dark:hover:text-white dark:hover:bg-dark-600 cursor-pointer">
                        <?php echo $lang['navigateBar-faqs']?>
                    </button>
                    <button type="button" id="plansPopupButton" data-dropdown-toggle="plansPopup" class="flex items-center justify-center w-12 h-12 text-base font-normal text-gray-100 bg-dark-700 hover:bg-dark-600 rounded-full focus:z-10 focus:ring-0 dark:bg-dark-700 dark:text-white dark:hover:text-white dark:hover:bg-dark-600 cursor-pointer">
                        <span id="navigateBarAction" class="material-symbols-outlined flex items-center justify-center font-bold text-2xl ml-0.5">chevron_right</span>
                        <svg id="navigateBarLoading" aria-hidden="true" class="w-7 h-7 text-gray-400  animate-spin dark:text-gray-600 fill-purple-200 dark:fill-purple-200 spinner-status hidden" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                            <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                        </svg>
                    </button>
                </div>
            </div>
            <div id="plansPopup" class="z-10 hidden bg-dark-600 dark:bg-dark-600 backdrop-blur bg-opacity-75 dark:bg-opacity-75 shadow-sm dark:shadow-sm-light divide-y divide-gray-100 rounded-3xl shadow max-w-xs min-w-xs">
                <ul class="navigateBarPlans py-2 text-sm text-gray-200 dark:text-gray-200 w-full p-2 space-y-1" aria-labelledby="plansPopupButton">
                </ul>
            </div>
        </section>

        <div id="navigateBar" class="invisible fixed max-h-14 -translate-x-1/2 left-1/2 z-20 w-full max-w-[7em] mx-auto flex space-x-3">
            <div class="navigation_items grid grid-cols-3 justify-between bg-dark-600 dark:bg-dark-600 dark:bg-opacity-75 backdrop-blur bg-opacity-75 rounded-full p-1 w-[77%] h-14" role="group">
                <button type="button" id="featuresButton" class="nav-button text-white dark:text-white text-xs !font-bold border-b-2 border-transparent rounded-full">
                    <?php echo $lang['navigateBar-features']?>
                </button>
                <button type="button" id="plansButton" class="nav-button text-white dark:text-white text-xs !font-bold border-b-2 border-transparent rounded-full">
                    <?php echo $lang['navigateBar-plans']?>
                </button>
                <button type="button" id="faqsButton" class="nav-button text-white dark:text-white text-xs !font-bold border-b-2 border-transparent rounded-full">
                    <?php echo $lang['navigateBar-faqs']?>
                </button>
            </div>
            <div class="action-button text-white dark:text-white bg-dark-600 dark:bg-dark-600 dark:hover:bg-dark-500 dark:!bg-opacity-75 backdrop-blur !bg-opacity-75 rounded-full flex items-center justify-center w-14 h-14" role="group">
                <button id="navigateBarPopupButton" data-dropdown-toggle="navigateBarPopup" data-dropdown-trigger="hover" class="flex items-center justify-center w-full h-full text-xs font-medium rounded-full text-white dark:text-white">
                    <span id="navigateBarAction" class="material-symbols-outlined font-bold">add</span>
                    <svg id="navigateBarLoading" aria-hidden="true" class="w-7 h-7 text-gray-400  animate-spin dark:text-gray-600 fill-purple-400 dark:fill-purple-500 spinner-status hidden" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                    </svg>
                </button>
            </div>
        </div>
        <!-- Dropdown menu -->
        <div id="navigateBarPopup" class="z-10 hidden bg-dark-600 dark:bg-dark-600 backdrop-blur bg-opacity-75 dark:bg-opacity-75 shadow-sm dark:shadow-sm-light divide-y divide-gray-100 rounded-3xl shadow max-w-xs min-w-xs">
            <ul class="navigateBarPlans py-2 text-sm text-gray-200 dark:text-gray-200 w-full p-2 space-y-1" aria-labelledby="navigateBarPopupButton">
            </ul>
        </div>
        <div id="navigateBarActivate"></div>
        <section id="features" class="bg-transparent">
            <div class="mx-auto max-w-screen-xl lg:py-6">
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="block text-left overflow-hidden bg-gradient-to-t from-purple-50 dark:from-purple-950 to-transparent justify-center p-5 border border-gray-200 dark:border-dark-600 rounded-3xl mt-8 sm:mt-0 !mx-auto w-full h-[20em] sm:min-w-[25em] sm:h-[25em] skeleton">
                            <div class="mb-6 flex items-center space-x-2">
                                <a href="https://datanito.com/account/dino" class="flex items-center text-center justify-start magic-container">
                                <span class="magic">
                                    <span class="magic-text text-2xl tracking-tight font-extrabold">
                                            <?php echo $lang['dino']; ?>
                                    </span>
                                </span>
                                </a>
                                <span class="inline-flex justify-center items-center w-6 h-6 text-xs font-semibold rounded-lg p-2 bg-dark-800 dark:bg-dark-400">
                                <span class="text-sm tracking-tight font-extrabold text-white"><?php echo $lang['ai']; ?></span>
                            </span>
                            </div>
                            <h2 class="text-xl md:text-2xl font-bold text-gray-500 dark:text-white"><?php echo $lang['business-hosting-feature-first'] ?></h2>
                        </div>
                        <div class="space-y-6 mr-0 sm:mr-8">
                            <div class="flex items-start text-left overflow-hidden bg-gray-50 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-h-[11.5em] sm:min-w-[20em]">
                                <h4 class="text-gray-500 dark:text-white text-xl md:text-2xl font-bold"><?php echo $lang['business-hosting-feature-second'] ?></h4>
                            </div>
                            <div class="relative flex items-end text-left overflow-hidden bg-gray-50 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-h-[11.5em] sm:min-w-[20em]">
                                <div class="absolute right-6 top-6 rounded-full h-6 w-6 bg-green-500 animate-ping"></div>
                                <h4 class="text-gray-500 dark:text-white text-xl md:text-2xl font-bold"><?php echo $lang['business-hosting-feature-third'] ?></h4>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="flex items-end text-left overflow-hidden bg-gray-50 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-w-[15em] sm:h-[15em]">
                            <h4 class="text-gray-500 dark:text-white text-xl md:text-2xl font-bold"><?php echo $lang['business-hosting-feature-fourth'] ?></h4>
                            <img class="w-16 h-16" src="<?php echo asset('images/content/emoji__eriyz672w3e6_large.png')?>" alt="Shocked Emoji">
                        </div>
                        <div class="relative flex items-start text-left overflow-hidden bg-gray-50 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[15em] sm:min-h-[15em] sm:min-w-[30em]">
                            <div class="absolute -rotate-45 right-6 bottom-6">
                                <div class="spinner-speed"></div>
                            </div>
                            <h4 class="text-gray-500 dark:text-white text-xl md:text-2xl font-bold"><?php echo $lang['business-hosting-feature-fifth'] ?></h4>
                        </div>
                    </div>
                </div>
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="relative flex mx-auto max-w-screen-md items-start text-left overflow-hidden bg-gray-50 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[20em] sm:min-h-[15em] sm:min-w-[30em]">
                        <h4 class="text-gray-500 dark:text-white text-xl md:text-2xl font-bold"><?php echo $lang['business-hosting-feature-sixth'] ?></h4>
                        <button data-scroll-target="plans" type="button" class="scroll-link absolute right-6 bottom-6 flex appearance-none inline-flex hover:shadow-2xl transition-all duration-300 hover:scale-105 items-center group space-x-2.5 bg-black dark:bg-blue-600 text-white py-4 px-5 rounded-full cursor-pointer">
                            <?php echo $lang['business-hosting-feature-sixth-cta'];?>
                        </button>
                    </div>
                </div>
            </div>
        </section>

        <section class="bg-white dark:bg-dark-900" id="plans">
            <div class="pb-6 pt-1 px-4 mx-auto max-w-screen-xl lg:pt-2 lg:pb-8 lg:px-6">
                <div class="mx-auto text-center mb-8 lg:mb-10">
                    <h2 class="mb-4 text-gray-800 dark:text-gray-400 text-sm font-semibold"><?php echo $lang['business-hosting-pricing-superior'] ?></h2>
                    <h2 class="mb-4 text-4xl tracking-tight font-bold text-gray-900 dark:text-gray-100"><?php echo $lang['business-hosting-pricing-headline'] ?></h2>
                    <p class="mb-5 font-normal text-gray-500 sm:text-xl dark:text-gray-400 sm:w-[80%] mx-auto max-w-screen-md "><?php echo $lang['business-hosting-pricing-subheading'] ?></p>
                </div>
                <div id="productCards" class="space-y-4 lg:grid lg:grid-cols-4 sm:gap-3 xl:gap-4 lg:space-y-0"></div>
            </div>
        </section>
        <section class="bg-white mb-8 dark:bg-dark-900">
            <div class="mx-auto max-w-screen-md">
                <div class="flex p-4 md:p-0 pt-6 items-center">
                    <div class="space-y-8 w-full">
                        <div class="flex items-center justify-center text-center bg-gray-50 dark:bg-dark-800 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton">
                            <div class="text-center">
                                <mark class="px-2 text-white bg-blue-600 rounded dark:bg-blue-500 text-lg"><?php echo $lang['why-business-hosting-headline'] ?></mark>
                                <div class="flex-1 flex flex-col justify-between items-start gap-4 my-2">
                                    <p class="text-lg font-normal text-gray-600 dark:text-gray-300"><?php echo $lang['why-business-hosting-subheading'] ?></p>
                                </div>
                                <div class="flex justify-center mt-3">
                                    <div class="grid grid-cols-1 md:grid-cols-2 md:space-x-8">
                                        <ul class="space-y-2 text-gray-500 list-inside dark:text-gray-400 mt-1.5 sm:mt-3">
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['business-hosting-cutting-edge-infrastructure'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['business-hosting-scalable-resources'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['business-hosting-security-first'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['business-hosting-24-7-support'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['one-click-wordpress-installation'] ?>
                                            </li>
                                        </ul>
                                        <ul class="max-w-md space-y-2 text-gray-500 list-inside dark:text-gray-400 mt-1.5 sm:mt-3">
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['business-hosting-performance-boost'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['business-hosting-uptime-guarantee'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['business-hosting-cPanel-access'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['business-hosting-seamless-migration'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['24-7-security'] ?>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="bg-white dark:bg-dark-900">
            <div class="mx-auto max-w-screen-md">
                <div class="flex p-4 md:p-0 pt-8 items-center">
                    <div class="space-y-8 w-full">
                        <div class="flex items-center justify-center text-center bg-gray-50 dark:bg-dark-800 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 md:h-64 skeleton">
                            <div>
                                <p class="text-gray-900 dark:text-gray-400 mb-4"><?php echo $lang['datanito-web-hosting'] ?></p>
                                <h4 class="text-gray-600 dark:text-white text-2xl md:text-3xl font-bold mb-2"><?php echo $lang['business-hosting-suggest-headline'] ?></h4>
                                <p class="text-lg font-normal text-gray-700 dark:text-gray-300 mb-6"><?php echo $lang['business-hosting-suggest-subheading'] ?></p>
                                <a href="<?php echo url('/cloud/web-hosting'); ?>" class="bg-blue-600 text-white hover:bg-blue-700 focus:outline-none focus:ring-4 focus:ring-blue-300 font-medium rounded-full text-sm px-5 py-2.5 text-center me-2 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                                    <?php echo $lang['business-hosting-suggest-cta'] ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section id="faqs" class="bg-white dark:bg-dark-900 mb-12">
            <div class="py-8 px-4 mx-auto max-w-screen-md text-center lg:py-16 lg:px-6">
                <div class="mx-auto max-w-screen-sm">
                    <h3 class="mb-4 text-4xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['faqs-headline'] ?></h3>
                    <p class="mb-8 font-normal text-gray-500 lg:mb-16 sm:text-xl dark:text-gray-400"><?php echo $lang['faqs-subheading'] ?></p>
                </div>
                <div id="accordion-collapse" data-accordion="collapse" class="divide-y-2 divide-gray-200 dark:divide-dark-600">
                    <?php foreach ($faqSectionBusinessHosting as $index => $faq): ?>
                        <div>
                            <h2 id="accordion-collapse-heading-<?php echo $index + 1; ?>">
                                <button type="button" class="flex items-center justify-between !bg-transparent dark:!bg-transparent w-full p-5 font-medium text-left text-gray-700 focus:ring-0 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-dark-700" data-accordion-target="#accordion-collapse-body-<?php echo $index + 1; ?>" aria-expanded="false" aria-controls="accordion-collapse-body-<?php echo $index + 1; ?>">
                                    <span><?php echo $faq['question']; ?></span>
                                    <svg data-accordion-icon class="w-3 h-3 rotate-180 shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5 5 1 1 5"/>
                                    </svg>
                                </button>
                            </h2>
                            <div id="accordion-collapse-body-<?php echo $index + 1; ?>" class="ml-2 hidden !bg-transparent dark:!bg-transparent text-left rounded-xl mb-2 pt-5 px-5 pb-5 mb-6 text-gray-700 dark:text-gray-300 bg-gray-100 dark:bg-dark-700">
                                <?php echo $faq['answer']; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>


    </div>

<?php
include_once includes('layouts/footer.php');
?>

<script>
    function loadProducts() {
        $.ajax({
            type: "POST",
            url: "/get_products", // Update with the correct path to your PHP script
            dataType: "json",
            data: { category: "business-hosting" }, // You can pass the category here
            success: function (data) {
                console.log(data);
                const productCardsContainer = $("#productCards");
                const productCardsNavigateBar = $(".navigateBarPlans");
                productCardsContainer.empty();

                $.each(data, function (index, product) {
                    let featuresHtml = '';
                    if (product.features) {
                        featuresHtml = '<ul class="mb-8 space-y-4 text-left md:h-[40em]">';
                        product.features.forEach((feature, i) => {
                            const icon = product.features_icons && product.features_icons[i] ? `<span class="material-symbols-outlined text-gray-600 dark:text-gray-300 flex items-center justify-center text-xl w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full">${product.features_icons[i]}</span>` : '';
                            featuresHtml += `<li class="flex items-center space-x-3">${icon}<span class="text-gray-600 dark:text-gray-300 text-md">${feature}</span></li>`;
                        });
                        featuresHtml += '</ul>';
                    }

                    let planLabel = '';
                    if (index === 0) {
                        planLabel = '<span class="inline-block mb-2 text-white bronze-gradient px-4 py-1 rounded-2xl font-semibold text-sm"><?php echo $lang['label-bronze'];?></span>';
                    } else if (index === 1) {
                        planLabel = '<span class="inline-block mb-2 text-white silver-gradient px-4 py-1 rounded-2xl font-semibold text-sm"><?php echo $lang['label-silver'];?></span>';
                    } else if (index === 2) {
                        planLabel = '<span class="inline-block mb-2 text-white gold-gradient px-4 py-1 rounded-2xl font-semibold text-sm"><?php echo $lang['label-gold'];?></span>';
                    } else if (index === 3) {
                        planLabel = '<span class="inline-block mb-2 text-white platinum-gradient px-4 py-1 rounded-2xl font-semibold text-sm"><?php echo $lang['label-platinum'];?></span>';
                    }

                    const originalPrice = parseFloat(product.price);
                    const offerPrice = parseFloat(product.offerprice);

                    const discountPercentage = ((originalPrice - offerPrice) / originalPrice) * 100;
                    discountPercentageText = '<?php echo $lang['percentage-off']; ?>'.replace('%d', product.discount_percentage.toFixed(0));
                    savingAmountText = '<?php echo $lang['saving-amount']; ?>'.replace('%d', product.saved_amount);
                    renewAtText = '<?php echo $lang['renew-at']; ?>'.replace('%d', product.price);

                    const productCard = $("<div>");
                    productCard.addClass("rounded-[30px] md:rounded-[36px] bg-[#FAFAFA] dark:bg-dark-800 overflow-hidden border-[1px] border-gray-200 dark:border-dark-500 p-6 relative");
                    productCard.html(`
            <div>
                ${planLabel}
                <h2 class="mb-2 text-xl tracking-tight font-bold text-gray-700 dark:text-gray-200 ">${product.name}</h2>
                <p class="font-medium text-gray-500 sm:text-base dark:text-gray-400 md:h-20">${product.description}</p>
                <div class="mt-2 mb-6 space-y-2">
                    <span class="block w-full mr-2 text-lg font-normal text-gray-700 dark:text-gray-300"><span class="line-through">${product.price}</span><span class="text-sm font-light text-gray-600 dark:text-gray-300">/<?php echo $lang['mo']?></span></span>
                    <span class="block w-full mr-2 text-3xl font-semibold text-gray-700 dark:text-gray-300">${product.offerprice}<span class="text-sm font-light text-gray-600 dark:text-gray-300">/<?php echo $lang['mo']?></span></span>
                    <span class="block text-sm font-normal text-green-600"> ${discountPercentageText} - ${savingAmountText}</span>
                    <span class="block text-sm font-light text-gray-600 dark:text-gray-400">${renewAtText}</span>
                </div>
            </div>
            <div data-product-id="${product.product_id}" class="add-to-cart-btn flex items-center justify-between">
                <span>
                    <svg aria-hidden="true" class="w-8 h-8 text-gray-200 animate-spin dark:text-gray-600 fill-blue-600 spinner-status opacity-0" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                    </svg>
                    <span class="sr-only">Loading...</span>
                </span>
                <button class="flex appearance-none inline-flex hover:shadow-2xl transition-all duration-300 hover:scale-105 items-center group space-x-2.5 bg-black dark:bg-blue-600 text-white py-4 px-5 rounded-full cursor-pointer">
                    <?php echo $lang['web-hosting-cta'];?>
                </button>
            </div>
            <span class="flex items-center justify-end space-x-1 text-sm text-gray-600 dark:text-gray-400 my-2">
                <span class="material-symbols-outlined">refresh</span>
                <span><?php echo $lang['money-back-grantee-monthly'];?></span>
            </span>
            <ul role="list" class="space-y-4 text-left">
                <hr class="mb-4 border-gray-200 sm:mx-auto rounded-full border-2 w-56 mx-auto dark:border-dark-600" />
                ${featuresHtml}
            </ul>

        `);
                    productCardsContainer.append(productCard);

                    const productCardNavigateBar = $("<li>");
                    productCardNavigateBar.html(`
            <button data-product-id="${product.product_id}" class="add-to-cart-btn flex justify-between items-center space-x-4 w-full px-2.5 py-2.5 hover:bg-dark-500 hover:text-white dark:hover:bg-dark-500 dark:hover:text-white rounded-2xl">
                <span class="text-sm block text-left font-semibold text-gray-300 dark:!text-gray-300">
                    <span>
                        ${planLabel}
                    </span>
                    <br>
                    <span class="!text-xs !text-extralight !text-gray-400">
                        <p class="flex items-center justify-start space-x-1 !text-xs !text-extralight text-gray-200 dark:!text-gray-300">
                            <span class="material-symbols-outlined text-[14px]">language</span>
                            <span>${product.features[0]}</span>
                        </p>
                        <p class="flex items-center justify-start space-x-1 !text-xs !text-extralight text-gray-200 dark:!text-gray-300">
                            <span class="material-symbols-outlined text-[14px]">storage</span>
                            <span>${product.features[2]}</span>
                        </p>
                    </span>
                </span>
                <div>
                    <span class="block text-[10px] font-medium text-gray-400 dark:!text-gray-400"><span class="line-through">${product.price}</span><span class="text-[9px]">/<?php echo $lang['mo']?></span></span>
                    <span class="block text-sm font-medium text-gray-300 dark:!text-gray-300">${product.offerprice}<span class="text-xs">/<?php echo $lang['mo']?></span></span>
                </div>
            </button>
        `);
                    productCardsNavigateBar.append(productCardNavigateBar);
                });
            },
            error: function (error) {
                console.error("Error fetching product data:", error);
            },
        });
    }
    loadProducts();
</script>