<?php
$meta = array(
    'us' => array(
        'title' => 'Datanito Cloud - AI-Powered Cloud Solutions - Boost Your Business',
        'description' => 'Explore Datanito Cloud for advanced AI-optimized cloud infrastructure. Turbocharge your business with scalable resources and 24/7 support.',
        'og:title' => 'Datanito Cloud - AI-Powered Cloud Solutions - Boost Your Business',
        'og:description' => 'Explore Datanito Cloud for advanced AI-optimized cloud infrastructure. Turbocharge your business with scalable resources and 24/7 support.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Datanito Cloud - Yapay Zeka Destekli Bulut Çözümleri - İşinizi Güçlendirin',
        'description' => 'Gelişmiş Yapay Zeka uyumlu bulut altyapısı için Datanito Cloud\'u keşfedin. İşinizi ölçeklenebilir kaynaklar ve 7/24 destek ile hızlandırın.',
        'og:title' => 'Datanito Bulut - Yapay Zeka Destekli Bulut Çözümleri - İşinizi Güçlendirin',
        'og:description' => 'Gelişmiş Yapay Zeka uyumlu bulut altyapısı için Datanito Cloud\'u keşfedin. İşinizi ölçeklenebilir kaynaklar ve 7/24 destek ile hızlandırın.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);

$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/header.php');
?>
    <div id="content" class="container mx-auto lg:mt-12 mt-12">
        <section class="bg-gray-50 dark:bg-dark-800 mt-4 h-[30em] sm:h-[35em] overflow-hidden skeleton">
            <div class="py-6 mx-auto text-center pb-0 lg:pt-12 h-[40em] sm:h-[35em] overflow-hidden">
                <div class="mx-auto max-w-screen-xl">
                    <h1 class="text-gray-900 mb-4 text-sm font-semibold dark:text-gray-400"><?php echo $lang['datanito-cloud-superior'] ?></h1>
                    <h2 class="mb-2 text-4xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['datanito-cloud-headline']; ?></h2>
                    <div class="mb-3">
                        <h3 class="text-xl tracking-tight font-medium text-gray-700 dark:text-gray-300"><?php echo $lang['datanito-cloud-subheading']; ?></h3>
                    </div>
                    <button type="button" data-scroll-target="features" class="scroll-link mb-2 inline-flex text-xl tracking-tight font-medium items-center text-blue-600 dark:text-blue-400 dark:text-blue-500 hover:underline items-center">
                        <span><?php echo $lang['datanito-cloud-cta']; ?></span>
                        <svg class="w-6 h-6 mt-1" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path></svg>
                    </button>
                </div>
                <div class="mt-12">
                    <hr class="h-4 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-3.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-3.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-3 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-3 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-2.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-2.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-2.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-2 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-2 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-2 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-2 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-2 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-2 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-2 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-1 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-0.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-0.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-0.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-0.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-0.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-0.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-0.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-0.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-0.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                    <hr class="h-0.5 my-1 bg-green-600 border-0 md:my-2 dark:bg-green-700">
                </div>
            </div>
        </section>
        <section id="features" class="bg-white dark:bg-dark-900">
            <div class="mx-auto max-w-screen-xl lg:py-12">
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="block text-center overflow-hidden bg-gradient-to-b from-green-50 dark:from-dark-800 to-transparent justify-center bg-gray-100 dark:bg-dark-900 p-5 border border-gray-200 dark:border-gray-700 rounded-3xl mt-8 sm:mt-0 !mx-auto w-full h-[20em] sm:min-w-[25em] sm:h-[25em] bg-contain bg-center bg-no-repeat bg-image-[url('<?php echo asset('images/content/creative-image.png')?>')] bg-blend-multiply skeleton">
                            <h2 class="text-xl md:text-2xl font-bold text-green-600/100 dark:text-green-500/100"><?php echo $lang['datanito-cloud-feature-first'] ?></h2>
                            <p class="text-xl md:text-2xl font-bold text-green-600/75 dark:text-green-500/75"><?php echo $lang['datanito-cloud-feature-first'] ?></p>
                            <p class="text-xl md:text-2xl font-bold text-green-600/50 dark:text-green-500/50"><?php echo $lang['datanito-cloud-feature-first'] ?></p>
                            <p class="text-xl md:text-2xl font-bold text-green-600/25 dark:text-green-500/25"><?php echo $lang['datanito-cloud-feature-first'] ?></p>

                            <div id="circle">
                                <svg class="!relative !h-57" version="1.1" xmlns="http://www.w3.org/2000/svg"
                                     xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="300px"
                                     height="300px" viewBox="0 0 300 300" enable-background="new 0 0 300 300"
                                     xml:space="preserve">
                                            <defs>
                                                <path id="circlePath" d="M 150, 150 m -60, 0 a 60,60 0 0,1 120,0 a 60,60 0 0,1 -120,0 "/>
                                            </defs>
                                    <circle cx="150" cy="100" r="75" fill="none"/>
                                    <g>
                                        <use xlink:href="#circlePath" fill="none"/>
                                        <text class="fill-gray-400 dark:fill-gray-300">
                                            <textPath xlink:href="#circlePath">
                                                <?php echo $lang['datanito-cloud-circle'] ?>
                                            </textPath>
                                        </text>
                                    </g>
                                    </svg>
                            </div>
                        </div>
                        <div class="space-y-6 mr-0 sm:mr-8">
                            <div class="flex items-center text-center overflow-hidden bg-gray-100 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-h-[11.5em] sm:min-w-[20em]">
                                <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['datanito-cloud-feature-second'] ?></h4>
                            </div>
                            <div class="flex items-center text-center overflow-hidden bg-gray-100 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-h-[11.5em] sm:min-w-[20em]">
                                <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['datanito-cloud-feature-third'] ?></h4>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="flex justify-end items-end mx-auto text-start overflow-hidden bg-gray-100 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-w-[15em] sm:h-[15em]">
                            <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['datanito-cloud-feature-fourth'] ?></h4>
                            <img class="w-16 h-16" src="<?php echo asset('images/content/emoji__eriyz672w3e6_large.png')?>" alt="Shocked Emoji">
                        </div>
                        <div class="flex items-start overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl skeleton w-full min-h-[15em] sm:min-h-[15em] sm:min-w-[30em] bg-cover bg-center bg-no-repeat bg-[url('<?php echo asset('images/content/cloud-performance.jpg')?>')] bg-blend-multiply">
                            <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-gray-400 from-gray-200 text-2xl md:text-3xl font-bold backdrop-blur p-8 md:p-6 w-full min-h-[15em] sm:min-h-[8em]"><?php echo $lang['datanito-cloud-feature-fifth'] ?></h4>
                        </div>
                    </div>
                </div>
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="flex justify-end items-end mx-auto text-start overflow-hidden bg-gray-100 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-w-[15em] sm:h-[30em]">
                            <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['datanito-cloud-feature-sixth'] ?></h4>
                        </div>
                        <div class="flex items-end overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl skeleton w-full min-h-[20em] sm:min-h-[15em] sm:min-w-[30em] bg-cover bg-center bg-no-repeat bg-[url('<?php echo asset('images/content/business-excellence.jpg')?>')] bg-blend-multiply">
                            <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold backdrop-blur p-8 md:p-6 w-full min-h-[15em] md:h-full flex items-start"><?php echo $lang['datanito-cloud-feature-seventh'] ?></h4>
                        </div>
                    </div>
                </div>
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="space-y-6">
                            <div class="flex justify-start items-end text-start overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl skeleton w-full min-h-[15em] sm:min-w-[25em] sm:h-[30em] bg-cover bg-center bg-no-repeat bg-[url('<?php echo asset('images/content/cloud-solutions-tailored.jpg')?>')] bg-blend-multiply">
                                <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-gray-50 from-gray-200 text-2xl md:text-3xl font-bold backdrop-blur p-8 md:p-6 w-full min-h-[15em] md:h-full flex items-end"><?php echo $lang['datanito-cloud-feature-eighth'] ?></h4>
                            </div>
                            <div class="flex justify-between items-end text-start overflow-hidden bg-gray-100 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[12em] sm:min-w-[15em] sm:h-[30em] bg-gradient-to-t from-green-50 to-transparent dark:from-dark-800">
                                <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['datanito-cloud-feature-ninth'] ?></h4>
                                <svg width="82" height="82" viewBox="0 0 82 82" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                                    <rect width="82" height="82" fill="url(#pattern0)"/>
                                    <defs>
                                        <pattern id="pattern0" patternContentUnits="objectBoundingBox" width="1" height="1">
                                            <use xlink:href="#image0_15_323" transform="scale(0.0138889)"/>
                                        </pattern>
                                        <image id="image0_15_323" width="72" height="72" xlink:href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAC/VBMVEUAAACpmZKyp66BbFmAUxKGblGOeWx8YUWmkXWXgzZmSSXIkyqsgR9zVC2xgSe6hSa1mRVyTxaqgyR5X0HMjyHQnxNePA94Vh5dPRh0UyNtUTTKrFl+ZEKcdCloRhReOxFhQR1lRiKSdDVrTS3JqFG8pHOmfStjRRR8VhdyUx+hgjB3XDGKaj2khkzIrGbPpx9gPhZsTxprUTTJnyZ+XSfCoUSxkU1aOAx3UxWNdRymjxvUnCqJah3UwVKUbS7FrkqWbS+0jTbHoDbIo0G1lkGYfhfHkSnOvVCkdy6yizSOYyS7lDrNoTi5miTKnjfAmCz//41KOQ9GNw///4hTQA///4GQchNXQxBPPQ///nqXeROGczBbRw+TeBN1URH//HKcfhRxWRJNOw/+92tgSxCSdROPbxO9mRmZfBN2XRJuVhFlUBBDNA9wUBiKbxKMaxKHZhJ+ZBKBZxH77WLKrTuegjWfcBxpUxHWsUeZfC+McxP8/Yiujzp6Wx1kTBOHaxKEYhJ7YRLDoUC6mT+ylz62mTLDjyp+YBx1VRpuSROEahJ4YRHfuErjvDuNdzGMbSiWdiSDZiSLax6HaR5nRBD39oLOq0bXu0LwyjipiDW8kBaUaRaAXhH+8mbizUvHpkOqjTe9mjS0kC6peSPHoBmkfxL95F7qxTiVdiyQcSqSbyHarR2CZRteRxJ3VhH15VzyzFK+nz+jhTGtjS2Cbyy8jiiefyWQdh+1jxlpUBeNZBaGWBX621n301bu21SliSrEhyG7ghx9XBOXcBBjPxDliwaqUwTm1FXsxFDmvk2kjDvCpDPEmiGKcSCxhxisjhXLlhOqhRKyexHt4GbOu0vLqTa2lDbXrDTsuTDQnzCddxSdgxPPbgT59nLUyFLaw0vdtDeQfTbPmCZ7UxGqdg6jdgr7zTe4ny3fuCyLXhjKrxaWfBKjaw3XiAyLTQfBhAbQhgO/XAOcSAGQPgDiqS+ohiqTXA28cQqdYwqtYweTUgaWeRrWfQbhxEPkxVV1IjiZAAAAUHRSTlMACwUj/jATQBf+m/7+jf7+/u/pS/7+/tLQtFlYU/398r6sfnxzH/3v58SedmRKN/rj3GrYoZJd/vfa++vn3c/FurWxmoPs6dfU0cnHxsXBwSVd3GIAAAiiSURBVFjD7dd5OBRxGAfwxSrKmUrOSgfd933f9yFHIatFtqVtLdlsORZrkdZit2JXOdaG6EAhOhxFOaPIWXJ03/f99M6MbR/d5b+evn/PfOZ935nfzPxw//On6aarrKzRretOd62peLz6QPmuOrrjWu/SRXqBA+S6WI8RIeiuSDVdL3BQlxy55Xdb+QTRydhIrmZXSpIZTi9gthLo7JIahmePLkijepXXU5lMOvtaSRq3b7/xf3vvFOaRyusdnMUAVUe6UYynDNCQ+Stocml8Zb2DOEuJ3dzsERl2pG/f/j3kZf+ioDXJJLFlgYBUzuZwajxCKaf0+X3HDpL784LGJGeJzcvj4wVsTkIs62VYWCAl6Hzfftp/OCqZ+cl9Ki0tSfF9LrMTImL9/BmMpDBPoPoP7P5H/Y0ekywQm4slkG91WkyxWyJQ+sio/gCahBRErUCgngBFu9f4sTxiUIrft98ghd91hkzoI2inmldkkQCKiIh1/+i7L9oXLKACgRqg/ZuPgk6fy1UFTOvKCsFlgBL89xx0v7THfV90qp+HW1JY4G+PSnbB5ccPXkVZN1RmCQR1EZyaTwcPnj5+8dIeKAuhAoAaqyz3O509fP0mh7bZclOlIK8u4k5N0cEiV9dDZ45fhLIQihtA0T//G6tGp/eHt69afbaZW4rL865FXKu5cv1KU5PdgUOnz3yhYOr9f7lqJj1sfPuOEEzzdqivAqjaD6C9FhY2dnZIWZek1C9WjcLqD42Fjwg+PjTngra85oTbfleu7t27a5cZWEhZx5Fh+XkwuJ4wqp+tmtGLG58WPspPYTKdhQ/yOBx/XwzaZWJmZmFjY+eKdohQyA38yarRyQUoh1sWHp4tfMDmNMfsK8KgtSYQM7QsKaX/o0cBbv7rp08LeYqKjMRQOr0nZ3va1RvXMQgNWhfaoXt0qgc8ofyx3181CisKCwvfcRUVFd3chorqOCVpN7ZjkInJWollgXSIzD01JjGAwv/uqhnd69mzZ4+sbqKSyjWOf/GN20VNTRYWZmYmUgosrEOM0v/OqtGhP3/+HG8VchPCUGneH1PsPv3G2WOudjY2YJl1KktCJXkGGX4zqoWvnj9/FGBlFYJEFUbEKnnvv33/QbAO2NlIC0MttEOgIoH6atXIzHv37Nm7MCsrhOLCrN1843aHZryMK8EwOwyTWGhZMCxfoPRh1QCg0A1baMsKC9++OWGFJqmOk6q4L4N3GIJgsYBhXWKWpKxDZxCKG6g/QKP7xNlzR8qis37a+PrBCUzSe8FhFbuXHdYLPXw4HAJaemesoyzo8CJCUQwNc1Ti9EYis1Zt/PCkHYO4otr9MSzfYABCEYrHS0nhhQPWMTO0S5OOsg7AsHwjeZQgUV3s7CE43ODcCxee1CNQSFISu3Z/cWqG06lAz4AUHi8ckQIgKbzMjHMYhswfmsTKOgRUWkB2dXPkZGTpA/T+BEw6MVGvLmF7cQ15/QbT9Ue8vE5RAj09gfH09CSTyT4pZaGdMCgLOjyzJ1ZYlxA7CT5EFy48fJxpFZLIYAwVvYiILuZutF1nbGxsuwE41AMwMJBIdCQSybTwDsz1AGaZ2bgWKZUmVM/BKayEgh5nhjAYGUNVVGsTUhNPma4DCI3UswcQsmOHI9GHl4lgRTAysHbtarpNStg+C16z4FSGMtzSXqqo9rz1MSZlvamxNOvQgGeLeBuP2NvbezntIAaj2A3AmvbuLRHcAWj0jIePq8SMtHPpcezcF7f2ZxBNN2CxtbWVWhJvA+pttLd3ciSnYNiV24Jr0UtwOjMaq9rEaenpcSd759beqg53MoVD15siwTgJ1smDg4DbQUSwTYKS1Dk4nZ6v29obzoHTs6V3RES6jz0cgQU8FOzMbUWDeBjn5MgkxbKG4waz37a3N4DDbundcutOZrD9Rics9pAjKIh5kmYxTeqZRpH8YwzgeXxQUNAQBwX1hhGV7qTZOxEhjpAdEAC9JCKAUk/KGVNLWYq6uMGqb6jbNkFBvWFEtVn3aV7kYB+fYCTwFH5DSkWsX9CmiEtiNOUAeuXsgkJ5LbXJFQ1kR5fdSFyQ0Gg0H1AxU4oC6QUkmADaEkjVYQNlcINVcqJo71VVc3Pzku+UVjQ4uuzEsg2Nt7e3hKVJWDLGYqgXvyDZ32s8DiB8K9lcJS+v6uSdMWpq1sSd1l+yGWKOsRL1G5gclZW8ZZwcvEWG4glHs0VVVaKWZBJJzcXl/hZJ7t+/bwmRkIAicXDY6eAgLde5Pj7eWlkW/kIBIkTR2+gqyWPU7lWQrTdJg3KIJdXMMQxCpVK9nZ2ZVEE8aZo8+oLEBwURhEJ6zzGk+HsOLlu+UVCh43QqxBlOZ0ZF5efnTyUQ8kWl8WoG6Ct7KT6IH3Q3W6mllHRPLd/cUhK0AOziBQVCoZCa7cyMyj969OhUdSPNYVoTlUeM1NUiCJWySMPRl7/M3Bw+n99KP1maFX/PPEpSORWtHALXzhbm4PF4IyMjAoESFjBMt7u8XDcZ9JsmPyyb3mt4x0fXIOf8lPM5SifLs+5VHGWi5zLh0si1CWjUhw1UHjReu7u8rrr3ieKyEZ22ZiMNRslItnvqQXw8XUlJiaQWRcDOplDUx0H1PZRn1ieFsKZJfq5GZJtbsVI0fvjTr0XIEdJFovIsqqH6ODgdmofqFaB62eGkdMXo2wYdV9dsK7vpAY/Mj6Khjs+GuyYOV8aa77SHIzFY13tpyyKOVpv4BKush+wPIdkR6vicu9lGI2S+s6sUZDCuXp/ZQ1t7kGZ7VZlbjKHGz3Y0ulqamhM1ZL+/rcyMvHqVjsc/ekNPcvPw6iHzEwj9D/jB35yBUmVmWrS731A9hptHpFc/ub/eMhsoVWwKjWT5sViR3CMD5Luw+R7Zi6TWsLOMRyMawt67K5FfuGqC2vRF0ybCf38XoyA/apT8EFnc//xr+Qws6ySAooEKkwAAAABJRU5ErkJggg=="/>
                                    </defs>
                                </svg>
                            </div>
                        </div>
                        <div class="space-y-6">
                            <div class="flex items-start overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full h-[12em] sm:min-h-[20em] sm:min-w-[10em] bg-gradient-to-tl from-green-50 to-transparent dark:from-dark-800">
                                <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['datanito-cloud-feature-tenth'] ?></h4>
                            </div>
                            <div class="flex items-end md:items-start text-left md:text-center overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl skeleton w-full h-[25em] sm:min-h-[40em] sm:min-w-[10em] bg-cover bg-center bg-no-repeat bg-[url('<?php echo asset('images/content/fast-nvme-storages.jpg')?>')] bg-blend-multiply">
                                <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-gray-50 from-gray-200 text-2xl md:text-3xl font-bold backdrop-blur p-8 md:p-6 w-full min-h-[20em] md:h-full flex items-end md:items-start"><?php echo $lang['datanito-cloud-feature-eleventh'] ?></h4>
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </section>
        <section class="bg-white mb-8 dark:bg-dark-900">
            <div class="mx-auto max-w-screen-md">
                <div class="flex p-4 md:p-0 pt-6 items-center">
                    <div class="space-y-8 w-full">
                        <div class="flex items-center justify-center text-center bg-gray-50 dark:bg-dark-800 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton">
                            <div class="text-center">
                                <h2 class="text-gray-600 dark:text-white text-xl md:text-2xl font-bold mb-2"><?php echo $lang['why-datanito-cloud-headline'] ?></h2>
                                <div class="justify-between items-start gap-4 my-2">
                                    <p class="text-lg font-normal text-gray-600 dark:text-gray-300"><?php echo $lang['why-datanito-cloud-subheading'] ?></p>
                                </div>
                                <div class="flex justify-center mt-3">
                                    <div class="grid grid-cols-1 md:grid-cols-2 md:space-x-8">
                                        <ul class="space-y-2 text-gray-500 list-inside dark:text-gray-400 mt-1.5 sm:mt-3">
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['datanito-cloud-ai-infrastructure'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['datanito-cloud-scalable-resources'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['datanito-cloud-advanced-security'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['datanito-cloud-24-7-support'] ?>
                                            </li>
                                        </ul>
                                        <ul class="max-w-md space-y-2 text-gray-500 list-inside dark:text-gray-400 mt-1.5 sm:mt-3">
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['datanito-cloud-performance-boost'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['datanito-cloud-uptime-guarantee'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['datanito-cloud-control-panel'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['datanito-cloud-seamless-migration'] ?>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="bg-white dark:bg-dark-900">
            <div class="mx-auto text-center pt-8">
                <h2 class="my-4 text-4xl tracking-tight font-bold text-gray-600 dark:text-gray-50"><?php echo $lang['our-cloud-solutions'] ?></h2>
            </div>
            <div class="py-2 px-4 mx-auto max-w-screen-xl lg:py-4 space-y-8">
                <div class="grid md:grid-cols-4 gap-4">
                    <?php foreach ($cloudServices as $service): ?>
                        <div class="bg-gray-50 dark:bg-dark-800 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton">
                            <div class="bg-primary-100 text-primary-800 text-xs font-medium inline-flex items-center px-2.5 py-0.5 rounded-md dark:bg-dark-800 dark:text-purple-400 mb-4">
                                <span class="material-symbols-outlined mr-2"><?php echo $service['icon'] ?></span>
                                <h2 class="text-blue-800 text-xs font-medium dark:text-purple-400"><?php echo $service['title'] ?></h2>
                            </div>
                            <h2 class="text-gray-700 dark:text-white text-2xl font-bold mb-2"><?php echo $service['headline'] ?></h2>
                            <div class="flex-1 flex flex-col justify-between items-start gap-4">
                                <ol class="relative text-gray-500 border-l border-gray-200 dark:border-gray-700 dark:text-gray-400 sm:ml-5 sm:mt-5">
                                    <?php foreach ($service['points'] as $index => $point): ?>
                                        <li class="mb-10 ml-6">
                                    <span class="absolute flex items-center justify-center w-8 h-8 <?php echo ($index === count($service['points']) - 1) ? 'bg-green-200 dark:bg-green-900' : 'bg-blue-100 dark:bg-dark-800'; ?> rounded-full -left-4 ring-4 ring-white dark:ring-gray-900 0">
                                        <span class="material-symbols-outlined text-[18px]  <?php echo ($index === count($service['points']) - 1) ? 'text-green-500 dark:text-green-400' : 'text-gray-500 dark:text-gray-400'; ?>"><?php echo $point['icon'] ?></span>
                                    </span>
                                            <h3 class="font-medium leading-tight text-gray-700 dark:text-gray-300"><?php echo $point['headline'] ?></h3>
                                            <p class="text-sm"><?php echo $point['subheading'] ?></p>
                                        </li>
                                    <?php endforeach; ?>
                                </ol>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <section class="bg-white dark:bg-dark-900">
            <div class="mx-auto max-w-screen-xl">
                <div class="p-4 md:p-6 pt-8 flex items-center">
                    <div class="grid grid-cols-1 sm:grid-cols-2 sm:space-x-8 w-full">
                        <div class="flex items-center justify-center text-center bg-gray-50 dark:bg-dark-800 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 md:py-10 skeleton">
                            <div>
                                <p class="text-gray-900 dark:text-gray-400 mb-4"><?php echo $lang['datanito-cloud-suggest-web-hosting-superior'] ?></p>
                                <h4 class="text-gray-600 dark:text-white text-2xl md:text-3xl font-bold mb-2"><?php echo $lang['datanito-cloud-suggest-web-hosting-headline'] ?></h4>
                                <p class="text-lg font-normal text-gray-700 dark:text-gray-300 mb-6"><?php echo $lang['datanito-cloud-suggest-web-hosting-subheading'] ?></p>
                                <a href="<?php echo url('/cloud/web-hosting'); ?>" class="bg-blue-600 text-white hover:bg-blue-700 focus:outline-none focus:ring-4 focus:ring-blue-300 font-medium rounded-full text-sm px-5 py-2.5 text-center me-2 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                                    <?php echo $lang['datanito-cloud-suggest-web-hosting-cta'] ?>
                                </a>
                            </div>
                        </div>
                        <div class="flex items-center justify-center text-center bg-gray-50 dark:bg-dark-800 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 md:py-10 skeleton">
                            <div>
                                <p class="text-gray-900 dark:text-gray-400 mb-4"><?php echo $lang['datanito-cloud-suggest-business-hosting-superior'] ?></p>
                                <h4 class="text-gray-600 dark:text-white text-2xl md:text-3xl font-bold mb-2"><?php echo $lang['datanito-cloud-suggest-business-hosting-headline'] ?></h4>
                                <p class="text-lg font-normal text-gray-700 dark:text-gray-300 mb-6"><?php echo $lang['datanito-cloud-suggest-business-hosting-subheading'] ?></p>
                                <a href="<?php echo url('/cloud/business-hosting'); ?>" class="bg-blue-600 text-white hover:bg-blue-700 focus:outline-none focus:ring-4 focus:ring-blue-300 font-medium rounded-full text-sm px-5 py-2.5 text-center me-2 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                                    <?php echo $lang['datanito-cloud-suggest-business-hosting-cta'] ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="bg-white dark:bg-dark-900 mb-12">
            <div class="py-8 px-4 mx-auto max-w-screen-md text-center lg:py-16 lg:px-6">
                <div class="mx-auto max-w-screen-sm">
                    <h3 class="mb-4 text-4xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['faqs-headline'] ?></h3>
                    <p class="mb-8 font-normal text-gray-500 lg:mb-16 sm:text-xl dark:text-gray-400"><?php echo $lang['faqs-subheading'] ?></p>
                </div>
                <div id="accordion-collapse" data-accordion="collapse" class="divide-y-2 divide-gray-200 dark:divide-dark-600">
                    <?php foreach ($faqSectionDatanitoCloud as $index => $faq): ?>
                        <div>
                            <h2 id="accordion-collapse-heading-<?php echo $index + 1; ?>">
                                <button type="button" class="flex items-center justify-between !bg-transparent dark:!bg-transparent w-full p-5 font-medium text-left text-gray-700 focus:ring-0 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-dark-700" data-accordion-target="#accordion-collapse-body-<?php echo $index + 1; ?>" aria-expanded="false" aria-controls="accordion-collapse-body-<?php echo $index + 1; ?>">
                                    <span><?php echo $faq['question']; ?></span>
                                    <svg data-accordion-icon class="w-3 h-3 rotate-180 shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5 5 1 1 5"/>
                                    </svg>
                                </button>
                            </h2>
                            <div id="accordion-collapse-body-<?php echo $index + 1; ?>" class="ml-2 hidden !bg-transparent dark:!bg-transparent text-left rounded-xl mb-2 pt-5 px-5 pb-5 mb-6 text-gray-700 dark:text-gray-300 bg-gray-100 dark:bg-dark-700">
                                <?php echo $faq['answer']; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>


    </div>

<?php

include_once includes('layouts/footer.php');
?>