<?php
$meta = array(
    'us' => array(
        'title' => 'Web Design Services | Guaranteed Success | Starting at $149!',
        'description' => 'Web design services that deliver guaranteed success. Transform your brand with expert solutions from Datanito. Starting at $149!',
        'og:title' => 'Web Design Services | Guaranteed Success | From $249',
        'og:description' => 'Web design services to boost your success. Partner with Datanito for premium solutions. Starting at $149!',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Web Tasarım Hizmetleri | Garantili Başarı | 4.880 TL\'den Başlar!',
        'description' => 'Web tasarım hizmetleri ile garantili başarı. Markanızı güçlendirin ve hedeflerinize ulaşın! 2.880 TL’den başlıyor.',
        'og:title' => 'Web Tasarım Hizmetleri | Garantili Başarı',
        'og:description' => 'Web tasarım hizmetleri ile başarıya ulaşın. Markanızı güçlendirmek için Datanito ile çalışın. 2.880 TL’den başlıyor.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
//$meta = array(
//    'us' => array(
//        'title' => 'Corporate Web Design | Guaranteed Success | Starting at $249!',
//        'description' => 'Guaranteed success with expert web design. Boost your brand with Datanito. Starting at $249!',
//        'og:title' => 'Corporate Web Design | Guaranteed Success | From $249',
//        'og:description' => 'Guaranteed success with expert web design. Boost your brand with Datanito. Starting at $249!',
//        'og:image' => asset('images/brand/open_graph_logo.png'),
//    ),
//    'tr' => array(
//        'title' => 'Kurumsal Web Tasarım | Garantili Başarı | 3.480 TL\'den Başlar!',
//        'description' => 'Web tasarımda garantili başarı. Markanızı güçlendirin! 3.480 TL’den başlıyor.',
//        'og:title' => 'Kurumsal Web Tasarım | Garantili Başarı | 3.480 TL’den Başlar',
//        'og:description' => 'Web tasarımda garantili başarı. Markanızı güçlendirin! 3.480 TL’den başlıyor.',
//        'og:image' => asset('images/brand/open_graph_logo.png'),
//    ),
//);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/header.php');
?>
    <section id="content" class="container mx-auto lg:mt-12 mt-12">
        <section class="bg-transparent my-12 overflow-hidden">

            <div aria-hidden="true" class="absolute sm:inset-0 h-max w-full mx-auto grid grid-cols-2 -space-x-52 opacity-20">
                <div class="blur-[50px] sm:blur-[106px] h-56 bg-gradient-to-br to-primary-400 from-blue-700"></div>
                <div class="blur-[50px] sm:blur-[106px] h-32 bg-gradient-to-r from-cyan-400  to-primary-600"></div>
            </div>
            <div class="mx-auto text-center mt-20 mx-2">
                <div class="w-full flex items-center justify-center mb-4">
                    <h2 class="mx-auto group inline-flex items-center gap-x-2 py-1.5 px-2 bg-primary-800/50 font-medium text-sm text-primary-900 dark:text-primary-500 rounded-full focus:outline-none cursor-pointer hover:shadow-2xl transition-all duration-300 hover:scale-105">
                        <?php echo $lang['web-design-solution']?>
                    </h2>
                </div>
                <div class="font-semibold text-dark-900 dark:text-gray-100 text-5xl md:text-7xl mx-auto max-w-screen-lg">
                    <?php echo $lang['web-design-superior'] ?>
                </div>
                <div class="flex items-center justify-center space-x-1 my-4 md:my-10">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-6 h-6 text-purple-400 dark:text-purple-400">
                        <path fill-rule="evenodd"
                              d="M9 4.5a.75.75 0 01.721.544l.813 2.846a3.75 3.75 0 002.576 2.576l2.846.813a.75.75 0 010 1.442l-2.846.813a3.75 3.75 0 00-2.576 2.576l-.813 2.846a.75.75 0 01-1.442 0l-.813-2.846a3.75 3.75 0 00-2.576-2.576l-2.846-.813a.75.75 0 010-1.442l2.846-.813A3.75 3.75 0 007.466 7.89l.813-2.846A.75.75 0 019 4.5zM18 1.5a.75.75 0 01.728.568l.258 1.036c.236.94.97 1.674 1.91 1.91l1.036.258a.75.75 0 010 1.456l-1.036.258c-.94.236-1.674.97-1.91 1.91l-.258 1.036a.75.75 0 01-1.456 0l-.258-1.036a2.625 2.625 0 00-1.91-1.91l-1.036-.258a.75.75 0 010-1.456l1.036-.258a2.625 2.625 0 001.91-1.91l.258-1.036A.75.75 0 0118 1.5zM16.5 15a.75.75 0 01.712.513l.394 1.183c.15.447.5.799.948.948l1.183.395a.75.75 0 010 1.422l-1.183.395c-.447.15-.799.5-.948.948l-.395 1.183a.75.75 0 01-1.422 0l-.395-1.183a1.5 1.5 0 00-.948-.948l-1.183-.395a.75.75 0 010-1.422l1.183-.395c.447-.15.799-.5.948-.948l.395-1.183A.75.75 0 0116.5 15z"
                              clip-rule="evenodd"></path>
                    </svg>
                    <h2 class="text-lg md:text-2xl text-transparent bg-clip-text bg-gradient-to-r to-cyan-600 from-purple-400"><?php echo $lang['web-design-headline'] ?></h2>
                </div>
            </div>

            <div class="block md:flex items-center justify-center w-full mx-auto space-y-4 md:space-y-0 md:space-x-3 p-1 md:p-4 relative z-10">
                <div class="flex items-center justify-center">
                    <p class="text-lg md:text-xl font-semibold platinum-gradient-text"><?php echo $lang['web-design-subheading'] ?></p>
                </div>
                <div class="hidden md:block vl border h-10 border-gray-200 dark:border-dark-700"></div>
                <div class="inline-flex w-full md:w-max items-center justify-center rounded-full space-x-2 md:space-x-3" role="group">
                    <button data-scroll-target="plans" type="button" class="scroll-link px-5 py-3 text-base font-normal text-gray-100 bg-dark-700 hover:bg-dark-600 rounded-full focus:z-10 focus:ring-0 dark:bg-dark-500 dark:text-white dark:hover:text-white dark:hover:bg-dark-600 cursor-pointer">
                        <?php echo $lang['navigateBar-plans']?>
                    </button>
                    <button data-scroll-target="features" type="button" class="scroll-link px-5 py-3 text-base font-normal text-gray-100 bg-dark-700 hover:bg-dark-600 rounded-full focus:z-10 focus:ring-0 dark:bg-dark-500 dark:text-white dark:hover:text-white dark:hover:bg-dark-600 cursor-pointer">
                        <?php echo $lang['navigateBar-features']?>
                    </button>
                    <button data-scroll-target="faqs" type="button" class="scroll-link px-5 py-3 text-base font-normal text-gray-100 bg-dark-700 hover:bg-dark-600 rounded-full focus:z-10 focus:ring-0 dark:bg-dark-500 dark:text-white dark:hover:text-white dark:hover:bg-dark-600 cursor-pointer">
                        <?php echo $lang['navigateBar-faqs']?>
                    </button>
                    <button data-scroll-target="apply-form" type="button" class="scroll-link flex items-center justify-center w-12 h-12 text-base font-normal text-gray-100 bg-dark-700 hover:bg-dark-600 rounded-full focus:z-10 focus:ring-0 dark:bg-dark-500 dark:text-white dark:hover:text-white dark:hover:bg-dark-600 cursor-pointer">
                        <span id="navigateBarAction" class="material-symbols-outlined flex items-center justify-center font-bold text-2xl ml-0.5">chevron_right</span>
                    </button>
                </div>
            </div>
        </section>
        <div id="navigateBar" class="invisible fixed max-h-14 -translate-x-1/2 left-1/2 z-20 w-full max-w-[7em] mx-auto flex space-x-3">
            <div class="navigation_items grid grid-cols-3 justify-between bg-dark-600 dark:bg-dark-600 dark:bg-opacity-75 backdrop-blur bg-opacity-75 rounded-full p-1 w-[77%] h-14" role="group">
                <button type="button" id="featuresButton" class="nav-button text-white dark:text-white text-xs !font-bold border-b-2 border-transparent rounded-full">
                    <?php echo $lang['navigateBar-features']?>
                </button>
                <button type="button" id="plansButton" class="nav-button text-white dark:text-white text-xs !font-bold border-b-2 border-transparent rounded-full">
                    <?php echo $lang['navigateBar-plans']?>
                </button>
                <button type="button" id="faqsButton" class="nav-button text-white dark:text-white text-xs !font-bold border-b-2 border-transparent rounded-full">
                    <?php echo $lang['navigateBar-faqs']?>
                </button>
            </div>
            <div class="action-button text-white dark:text-white bg-dark-600 dark:bg-dark-600 dark:hover:bg-dark-500 dark:!bg-opacity-75 backdrop-blur !bg-opacity-75 rounded-full flex items-center justify-center w-14 h-14" role="group">
                <button type="button" id="applyNowButton" class="nav-button !border-0 flex items-center justify-center w-full h-full text-xs font-medium rounded-full">
                    <svg class="w-4 h-4 text-white dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 9 4-4-4-4"/>
                    </svg>
                </button>
            </div>
        </div>
        <div id="navigateBarActivate"></div>
        <section class="bg-white dark:bg-dark-900">
            <div class="py-8 lg:py-16 mx-auto max-w-screen-md px-4">
                <h2 class="mb-2 lg:mb-4 text-3xl font-bold tracking-tight leading-tight text-center text-gray-900 dark:text-white md:text-4xl"><?php echo $lang['our-partners-headline'] ?></h2>
                <div class="mb-8 lg:mb-16 mx-auto text-center">
                    <h3 class="text-2xl tracking-tight font-normal text-gray-600 dark:text-gray-400"><?php echo $lang['our-partners-subheading'] ?></h3>
                </div>
                <div class="slider">
                    <div class="slider-items">
                        <img class="h-8" src="<?php echo asset('images/brand/framer-partner.png')?>" alt="Framer Partner">

                        <img class="h-10" src="<?php echo asset('images/brand/google-partner.avif')?>" alt="Google Partner">

                        <img class="h-9" src="<?php echo asset('images/brand/meta-partner.avif')?>" alt="Meta Partner">

                        <img class="h-12" src="<?php echo asset('images/brand/wix-partner.png')?>" alt="Wix Partner">

                        <img class="h-6" src="<?php echo asset('images/brand/wixstudio-partner.png')?>" alt="Wix Studio Partner">

                        <img class="h-8" src="<?php echo asset('images/brand/framer-partner.png')?>" alt="Framer Partner">

                        <img class="h-10" src="<?php echo asset('images/brand/google-partner.avif')?>" alt="Google Partner">

                        <img class="h-9" src="<?php echo asset('images/brand/meta-partner.avif')?>" alt="Meta Partner">

                        <img class="h-12" src="<?php echo asset('images/brand/wix-partner.png')?>" alt="Wix Partner">

                        <img class="h-6" src="<?php echo asset('images/brand/wixstudio-partner.png')?>" alt="Wix Studio Partner">

                        <img class="h-8" src="<?php echo asset('images/brand/framer-partner.png')?>" alt="Framer Partner">

                        <img class="h-10" src="<?php echo asset('images/brand/google-partner.avif')?>" alt="Google Partner">

                        <img class="h-9" src="<?php echo asset('images/brand/meta-partner.avif')?>" alt="Meta Partner">

                        <img class="h-12" src="<?php echo asset('images/brand/wix-partner.png')?>" alt="Wix Partner">

                        <img class="h-6" src="<?php echo asset('images/brand/wixstudio-partner.png')?>" alt="Wix Studio Partner">

                        <img class="h-8" src="<?php echo asset('images/brand/framer-partner.png')?>" alt="Framer Partner">

                        <img class="h-10" src="<?php echo asset('images/brand/google-partner.avif')?>" alt="Google Partner">

                        <img class="h-9" src="<?php echo asset('images/brand/meta-partner.avif')?>" alt="Meta Partner">

                        <img class="h-12" src="<?php echo asset('images/brand/wix-partner.png')?>" alt="Wix Partner">

                        <img class="h-6" src="<?php echo asset('images/brand/wixstudio-partner.png')?>" alt="Wix Studio Partner">
                        <img class="h-8" src="<?php echo asset('images/brand/framer-partner.png')?>" alt="Framer Partner">

                        <img class="h-10" src="<?php echo asset('images/brand/google-partner.avif')?>" alt="Google Partner">

                        <img class="h-9" src="<?php echo asset('images/brand/meta-partner.avif')?>" alt="Meta Partner">

                        <img class="h-12" src="<?php echo asset('images/brand/wix-partner.png')?>" alt="Wix Partner">

                        <img class="h-6" src="<?php echo asset('images/brand/wixstudio-partner.png')?>" alt="Wix Studio Partner">

                        <img class="h-8" src="<?php echo asset('images/brand/framer-partner.png')?>" alt="Framer Partner">

                        <img class="h-10" src="<?php echo asset('images/brand/google-partner.avif')?>" alt="Google Partner">

                        <img class="h-9" src="<?php echo asset('images/brand/meta-partner.avif')?>" alt="Meta Partner">

                        <img class="h-12" src="<?php echo asset('images/brand/wix-partner.png')?>" alt="Wix Partner">

                        <img class="h-6" src="<?php echo asset('images/brand/wixstudio-partner.png')?>" alt="Wix Studio Partner">

                        <img class="h-8" src="<?php echo asset('images/brand/framer-partner.png')?>" alt="Framer Partner">

                        <img class="h-10" src="<?php echo asset('images/brand/google-partner.avif')?>" alt="Google Partner">

                        <img class="h-9" src="<?php echo asset('images/brand/meta-partner.avif')?>" alt="Meta Partner">

                        <img class="h-12" src="<?php echo asset('images/brand/wix-partner.png')?>" alt="Wix Partner">

                        <img class="h-6" src="<?php echo asset('images/brand/wixstudio-partner.png')?>" alt="Wix Studio Partner">

                        <img class="h-8" src="<?php echo asset('images/brand/framer-partner.png')?>" alt="Framer Partner">

                        <img class="h-10" src="<?php echo asset('images/brand/google-partner.avif')?>" alt="Google Partner">

                        <img class="h-9" src="<?php echo asset('images/brand/meta-partner.avif')?>" alt="Meta Partner">

                        <img class="h-12" src="<?php echo asset('images/brand/wix-partner.png')?>" alt="Wix Partner">

                        <img class="h-6" src="<?php echo asset('images/brand/wixstudio-partner.png')?>" alt="Wix Studio Partner">
                    </div>
                </div>
            </div>
        </section>

        <section id="features" class="bg-transparent">

            <!-- Features -->
            <div class="max-w-[85rem] px-4 py-10 sm:px-6 lg:px-8 lg:py-14 mx-auto">

                <div class="w-full flex items-center justify-center mb-5">
                    <h3 class="mx-auto group inline-flex items-center gap-x-2 py-1.5 px-2 bg-primary-800/50 font-medium text-sm text-primary-900 dark:text-primary-500 rounded-full focus:outline-none cursor-pointer hover:shadow-2xl transition-all duration-300 hover:scale-105">
                        <?php echo $lang['web-design-solution-corporate']?>
                    </h3>
                </div>
                <!-- Title -->
                <div class="mx-auto max-w-2xl mb-8 lg:mb-14 text-center">
                    <h4 class="text-3xl lg:text-4xl text-neutral-800 font-bold dark:text-neutral-200">
                        <?php echo $lang['web-design-ai-feature-headline'] ?>
                    </h4>
                    <p class="mt-3 text-neutral-600 dark:text-neutral-400">
                        <?php echo $lang['web-design-ai-feature-subheading'] ?>
                    </p>
                </div>
                <!-- End Title -->

                <!-- Grid -->
                <div class="mx-auto max-w-3xl grid grid-cols-12 gap-6 lg:gap-8">
                    <!-- Icon Block: AI-Powered Optimization -->
                    <div class="col-span-6 sm:col-span-4 text-center">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="mx-auto h-auto w-7 md:w-9 text-purple-500 dark:text-purple-400">
                            <path fill-rule="evenodd"
                                  d="M9 4.5a.75.75 0 01.721.544l.813 2.846a3.75 3.75 0 002.576 2.576l2.846.813a.75.75 0 010 1.442l-2.846.813a3.75 3.75 0 00-2.576 2.576l-.813 2.846a.75.75 0 01-1.442 0l-.813-2.846a3.75 3.75 0 00-2.576-2.576l-2.846-.813a.75.75 0 010-1.442l2.846-.813A3.75 3.75 0 007.466 7.89l.813-2.846A.75.75 0 019 4.5zM18 1.5a.75.75 0 01.728.568l.258 1.036c.236.94.97 1.674 1.91 1.91l1.036.258a.75.75 0 010 1.456l-1.036.258c-.94.236-1.674.97-1.91 1.91l-.258 1.036a.75.75 0 01-1.456 0l-.258-1.036a2.625 2.625 0 00-1.91-1.91l-1.036-.258a.75.75 0 010-1.456l1.036-.258a2.625 2.625 0 001.91-1.91l.258-1.036A.75.75 0 0118 1.5zM16.5 15a.75.75 0 01.712.513l.394 1.183c.15.447.5.799.948.948l1.183.395a.75.75 0 010 1.422l-1.183.395c-.447.15-.799.5-.948.948l-.395 1.183a.75.75 0 01-1.422 0l-.395-1.183a1.5 1.5 0 00-.948-.948l-1.183-.395a.75.75 0 010-1.422l1.183-.395c.447-.15.799-.5.948-.948l.395-1.183A.75.75 0 0116.5 15z"
                                  clip-rule="evenodd"></path>
                        </svg>
                        <div class="mt-2 sm:mt-6">
                            <p class="text-lg font-semibold text-gray-800 dark:text-neutral-200">
                                <?php echo $lang['web-design-ai-feature-first-title'] ?>
                            </p>
                        </div>
                    </div>
                    <!-- End Icon Block -->

                    <!-- Icon Block: Effectiveness Test & 90%+ Success Rate -->
                    <div class="col-span-6 sm:col-span-4 text-center">
                        <svg class="mx-auto h-auto w-7 md:w-9 text-blue-500 dark:text-blue-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                            <path fill-rule="evenodd" d="M12 2c-.791 0-1.55.314-2.11.874l-.893.893a.985.985 0 0 1-.696.288H7.04A2.984 2.984 0 0 0 4.055 7.04v1.262a.986.986 0 0 1-.288.696l-.893.893a2.984 2.984 0 0 0 0 4.22l.893.893a.985.985 0 0 1 .288.696v1.262a2.984 2.984 0 0 0 2.984 2.984h1.262c.261 0 .512.104.696.288l.893.893a2.984 2.984 0 0 0 4.22 0l.893-.893a.985.985 0 0 1 .696-.288h1.262a2.984 2.984 0 0 0 2.984-2.984V15.7c0-.261.104-.512.288-.696l.893-.893a2.984 2.984 0 0 0 0-4.22l-.893-.893a.985.985 0 0 1-.288-.696V7.04a2.984 2.984 0 0 0-2.984-2.984h-1.262a.985.985 0 0 1-.696-.288l-.893-.893A2.984 2.984 0 0 0 12 2Zm3.683 7.73a1 1 0 1 0-1.414-1.413l-4.253 4.253-1.277-1.277a1 1 0 0 0-1.415 1.414l1.985 1.984a1 1 0 0 0 1.414 0l4.96-4.96Z" clip-rule="evenodd"/>
                        </svg>
                        <div class="mt-2 sm:mt-6">
                            <p class="text-lg font-semibold text-gray-800 dark:text-neutral-200">
                                <?php echo $lang['web-design-ai-feature-second-title'] ?>
                            </p>
                        </div>
                    </div>
                    <!-- End Icon Block -->

                    <!-- Icon Block: Personalized Web Design Insights -->
                    <div class="col-span-6 col-start-4 sm:col-span-4 text-center">
                        <svg class="mx-auto h-auto w-7 md:w-9 text-yellow-500 dark:text-yellow-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                            <path stroke="currentColor" stroke-linecap="round" stroke-width="2" d="M8.737 8.737a21.49 21.49 0 0 1 3.308-2.724m0 0c3.063-2.026 5.99-2.641 7.331-1.3 1.827 1.828.026 6.591-4.023 10.64-4.049 4.049-8.812 5.85-10.64 4.023-1.33-1.33-.736-4.218 1.249-7.253m6.083-6.11c-3.063-2.026-5.99-2.641-7.331-1.3-1.827 1.828-.026 6.591 4.023 10.64m3.308-9.34a21.497 21.497 0 0 1 3.308 2.724m2.775 3.386c1.985 3.035 2.579 5.923 1.248 7.253-1.336 1.337-4.245.732-7.295-1.275M14 12a2 2 0 1 1-4 0 2 2 0 0 1 4 0Z"/>
                        </svg>
                        <div class="mt-2 sm:mt-6">
                            <p class="text-lg font-semibold text-gray-800 dark:text-neutral-200">
                                <?php echo $lang['web-design-ai-feature-third-title'] ?>
                            </p>
                        </div>
                    </div>
                    <!-- End Icon Block -->
                </div>
                <!-- End Grid -->
            </div>
            <!-- End Features -->
            <div class="max-w-screen-md mt-12 mx-6 md:mx-auto rounded-3xl bg-gradient-to-r from-green-100 to-green-50 dark:from-green-900 dark:to-green-950 px-6 py-16 text-center">
                <div class="relative m-auto max-w-xl">
                    <div class="flex flex-row items-center justify-center text-yellow-500">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"
                             class="h-auto w-10 fill-current">
                            <path
                                    d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z">
                            </path>
                        </svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"
                             class="h-auto w-10 fill-current">
                            <path
                                    d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z">
                            </path>
                        </svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"
                             class="h-auto w-10 fill-current">
                            <path
                                    d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z">
                            </path>
                        </svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"
                             class="h-auto w-10 fill-current">
                            <path
                                    d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z">
                            </path>
                        </svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"
                             class="h-auto w-10 fill-current">
                            <path
                                    d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z">
                            </path>
                        </svg>
                    </div>
                    <div>
                        <p
                                class="mt-4 font-dm-sans text-mobile-h3 font-semibold leading-snug sm:text-mobile-h2 md:text-desktop-h2">
                            <?php echo $lang['rating-hero-headline'] ?>
                        </p>
                    </div>
                    <p class="mt-4 font-dm-sans text-desktop-paragraph text-slate-body"><?php echo $lang['rating-hero-subheading'] ?></p>
                    <svg class="absolute top-40 md:top-12 -left-3 md:-left-10 h-20 md:h-36 fill-current text-slate-body sm:block md:-left-14 md:h-44"
                         viewBox="0 0 644 947" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_32_70)">
                            <path
                                    d="M292 4.3c-59.5 27-88.1 53.2-99.1 90.8-1.7 6-2.2 10.9-2.6 26.1-.5 17.7-.4 18.9 1.6 22.1 1.1 1.8 3.2 3.9 4.6 4.5 9.4 4.3 33.5-2.6 50-14.3 7.6-5.4 19.8-18.1 25.3-26.5 5.2-7.9 13-23.8 16.7-34 4.9-13.9 9.7-34 10-42.4.2-4.5 1.3-12.8 2.4-18.6 2.4-11.9 2.4-12 1.4-12-.5 0-5.1 2-10.3 4.3zM137.2 39.2c-16 29.9-25.1 54.2-28.8 76.8-2.2 13.2-1.3 44 1.6 55.7 3.7 15.6 12 31.3 20.5 39.2 3.7 3.4 5.1 4.1 8.6 4.1 8.4 0 18.2-9.6 26-25.5 5.4-11 10.3-28.2 9.5-33-.5-2.3-.4-2.7.5-1.5.8 1.2 1 1 .5-1-.2-1.4-.1-6.8.3-12 1.5-17.2-1.1-35.6-8-56-4.1-12.4-13.1-32.8-20.1-45.8l-5.5-10.4-5.1 9.4zM264.5 133.4c-21.4 7.2-30 10.7-42.3 17.1-34.4 18.2-55.4 41.3-63.2 69.5-2.4 9-4.7 29.8-3.5 32.6 1 2.4 1.2 3 1.4 4.9.2 3.2 5.5 7.5 10.1 8.3 5.1.9 21.4-.3 24.8-1.8 1.2-.5 2.2-.8 2.2-.6 0 .2-5.1 4.2-11.2 8.9-35 26.5-53.8 50.8-61.4 79.2-1.4 5.4-1.9 10.6-1.9 22.5 0 8.5.4 16.8.8 18.5.5 2.2.5 2.6-.3 1.5-.7-1.1-.8.2-.4 4.5 2.2 20.5 13.1 22.7 39.4 7.8 9.8-5.5 18.3-12.4 24.3-19.8 5.4-6.7 14.2-23.3 18-34 3.5-9.8 8-30.3 7.2-33.3-.4-1.7-.2-2.2.6-1.6.9.5 1 0 .6-1.8-.4-1.3 0-7.4.8-13.4s1.7-18.1 2-26.9c.7-17.8 1.2-22.6 2.4-22.2 1.7.4 14.1-9.6 21.4-17.3 12.2-12.9 21.3-28 30.7-51 7.1-17.4 11.1-32.4 8.1-30.5-1 .5 2.6-13.6 5.4-21.5 1.7-4.9 1.7-5 .8-5-.5 0-8 2.4-16.8 5.4zM69.7 167.5c-6.1 20.4-7.9 26.9-10.1 37-4.5 21-5.9 35.2-5.1 52 .4 8.2.7 16.1.7 17.5.1 10.9 4.6 28.6 10 39.5C71 325 81.5 338 89.9 344.1c6.1 4.4 10.9 5.1 16.2 2.4 3.6-1.9 8.6-9.6 12.2-18.6 5.9-14.8 7.2-24.1 7.1-49.9 0-12.6-.4-17-2.2-23.7-6-22.3-18.2-44.6-39.5-71.8-14.2-18.1-13.3-17.2-14-15zM17.6 327.7c.5 7.6.9 16.8.9 20.5 0 3.6.2 6.3.5 5.8.3-.4.6 2.2.7 5.8.2 9 4.6 31.1 8.9 44.1 10.6 32.6 29 55 55.6 67.6 18.5 8.8 27.1 4.1 28.6-15.8.4-4.5.7-15.9.6-25.2 0-16.5-.1-17.3-3.3-26.5-9.1-26.6-28.1-48.6-61.3-70.8-8.6-5.8-30.6-19.2-31.4-19.2-.4 0-.2 6.2.2 13.7zM195.9 379.7c-39.8 41.9-57.6 78.4-55.4 113.8.3 6 .8 14.6 1 19 .7 13.7 5.8 28.5 11.2 32 6.9 4.6 14.8 2.2 27.6-8.2 12.1-10 20.8-21.3 26.4-34.6 4.1-9.8 7.4-22.3 7.8-30.2.2-3.3.9-11.4 1.5-18 1.2-12.1.8-29-1.1-43.5-1.5-11.9-7.2-41-8-41-.4 0-5.3 4.8-11 10.7z">
                            </path>
                            <path
                                    d="M0 455.7c0 .2 1.8 4 4.1 8.4 4.7 9.5 6.2 13.2 5 12.5-1.5-1-1.8 3.9-.6 8.7 3.1 12.1 26.5 46.8 41.2 60.8C62.1 558 77.8 568.3 88 571.2c3.6 1 4.9 1.6 3 1.3-1.9-.3-7.8-1.2-13-2-11.7-1.7-35.3-3.5-47.7-3.5H21l5.3 8.2c7.2 11.2 7.2 11.2 5.9 10.4-1.8-1.1-2.6 4.1-1.3 8.4 2.5 8.4 26.1 37.6 40.4 50.2 9.5 8.3 22.2 16.8 30.4 20.5 9.8 4.3 19.4 7.3 24.2 7.4l4.6.1-4.5.8c-2.5.5-12.4 2.1-22 3.6s-17.7 2.9-18 3.1c-.2.2 0 .7.5 1.1 2.7 1.9 13.8 14.4 12.3 13.9-1.8-.6-2.8 1-2.8 4.7 0 3.8 5.3 10.8 14.1 18.7 34.9 31.3 63.1 45 93.9 45.3 6.3 0 13.1-.2 15-.7 1.9-.4-3.5 1.7-12 4.6-23.6 8.2-31 11-31 11.7 0 .3 2.9 2.8 6.5 5.4 5.5 4 10.2 8.4 6.7 6.2-1.3-.8-3.2 2.4-3.2 5.4 0 9.9 48.6 36.1 79 42.6 12.5 2.7 32.7 2.5 44.4-.4 11.3-2.8 26.1-9.8 30.9-14.5 3.9-4 5.6-9.2 3.8-12.4-.8-1.7-.4-2.4 2.9-4.9 2.2-1.6 4-3.2 4-3.6 0-.4-2.6-4-5.8-8-16.2-20.3-36.8-32.8-60.8-36.9-8.9-1.5-36.8-.6-47.4 1.5-13.1 2.6-14.7 2.6-5.9.3 5.1-1.3 10.2-3.4 12.2-5 3.8-2.9 6.1-8.4 5.1-12.3-.5-1.8.1-2.6 2.5-3.9 1.7-.8 3.1-1.9 3.1-2.3 0-.4-1.6-3.8-3.5-7.5-16.3-31.7-42.4-50.1-78.1-54.8-11.3-1.5-12.7-1.9-9.1-3 5.1-1.4 8.4-5.8 8.9-11.8.1-2 .9-3.3 2-3.7 2.3-.7 2.3-.6-1.2-11.4-10.8-32.9-30.5-53.4-64-66.2-4.1-1.5-5.9-2.5-4-2.1 1.9.5 8.2.8 14 .8 8.1 0 11.3-.4 14.2-1.8 3.9-2 7.3-7.6 6.5-10.7-.3-1.2.2-2 1.4-2.3 2.3-.6 2.3-2.1.4-12.4-6.1-32-24.9-56.8-54.4-71.8-15.7-7.9-39.4-14.7-66.6-19-8.8-1.3-17-2.6-18.2-2.9-1.3-.2-2.3-.2-2.3.1z">
                            </path>
                            <path
                                    d="M220.7 504.8c-30.5 40.8-44.3 75.7-42.2 106.7.3 5.5.8 14 1 19 .5 11.3 3 20.4 8.3 29.3 4.4 7.4 8.8 11.8 12.8 12.8 10.2 2.6 33.9-21.8 42.2-43.3 3.4-8.7 6.7-23.5 5.8-25.8-.3-.9-.1-3.9.5-6.8.5-2.8 1-11.7 1-19.7.1-15.5-1.5-28.4-5.7-45.5-3.3-13.7-11.7-40.5-12.6-40.5-.5 0-5.5 6.2-11.1 13.8zM277 582.1c-18.9 38.5-25.4 63.2-24.8 94.1.2 8.6.6 15.1 1 14.5.5-.7.5.2.2 1.9-1.9 9.8 7.7 35.4 18.1 48.7 7.6 9.6 14.1 12 21 7.7 7-4.3 19.5-24 23.9-37.5 2-6.3 4.6-19.7 4-20.7-.3-.4 0-5.4.6-11.1 2.6-25.7-5.1-55.3-24-92.2-4.2-8.3-8.7-16.5-9.8-18.4l-2.1-3.5-8.1 16.5zM344.5 638.2c-.2.7-1.4 7.8-2.7 15.8-1.9 12.3-2.2 18.8-2.3 43-.2 30.9.7 40.1 5 55.5 6.6 23.2 20.4 43 38.8 55.2 12 8 18.9 7 24.5-3.4 3.6-6.9 7.4-20.5 7.8-28.3.1-3 .5-10.9.9-17.5.9-13.5-.1-21.3-4.1-33.9-6.6-20.8-19.8-40.6-42.9-64.5-14.7-15.2-24.4-23.7-25-21.9zM430.1 730.2c5.2 12.9 6.9 17.9 5.9 17.3-.6-.4-1 1.2-1 4.2 0 7.8 11.5 31.3 25.2 51.4 21.5 31.7 52.9 50.9 83.2 50.9 12.4 0 16.6-2.7 18-11.2.1-1.1.8-2.3 1.5-2.7 1-.7 1.1-2.7.2-9.8-6.6-54.5-40.1-83.6-116.4-101.2-9.7-2.3-17.9-4.1-18.2-4.1-.3 0 .5 2.4 1.6 5.2zM383.2 818.1c-19.3 2.5-43.5 12.4-66.7 27.4-10.8 6.9-31.4 21.8-31.5 22.6 0 .4 2.8 1.6 6.3 2.9 6.6 2.4 9.2 4 6.5 4-1 0-1.9 1.2-2.3 3-1.4 6.5 4.5 10.5 22.6 15.4 57.2 15.5 98.2 9.3 127-19.4 7.5-7.4 10.1-13.1 8.1-17.4-.9-2.1-.6-3.1 2.9-7.7 2.1-2.9 3.9-5.5 3.9-5.8 0-.3-2.5-2.4-5.5-4.6-22.9-16.7-46.9-23.6-71.3-20.4zM612.333 854.83c-4.833 1.066-12.082 6.316-13.995 10.197-1.309 2.587-1.611 4.566-1.108 8.522.403 2.816.604 6.392.604 7.838-.201 7.229 6.243 14.686 14.6 16.741 13.895 3.5 28.696-3.957 29.401-14.839.101-2.13.806-5.402 1.41-7.381 1.007-2.815 1.007-4.565 0-7.685-3.122-10.577-16.815-16.513-30.912-13.393zM505.5 860.6c-27.6 4.6-58.7 22.7-93.5 54.1l-5.4 5 7.4 2.3c4.1 1.3 6.7 2.5 5.8 2.7-2.3.6-3.4 4.8-2 7.8 1.6 3.5 7.5 6.1 18.8 8.4 56.8 11.5 96.8 3.7 125-24.3 6.9-6.9 11-13 11.4-17.1.5-4.2 0-6.6-1.2-5.9-1.2.8-1.2.7 3.9-7.3 1.8-2.9 3.3-5.6 3.3-6.2 0-1.5-4.9-4.6-14.7-9.5-20.7-10.4-38.6-13.5-58.8-10z">
                            </path>
                        </g>
                        <defs>
                            <clipPath id="clip0_32_70">
                                <path transform="matrix(1 0 0 -1 0 946.016)" d="M0 0H644V946.016H0z"></path>
                            </clipPath>
                        </defs>
                    </svg>
                    <svg class="absolute top-40 md:top-12 -right-3 -md:right-10 h-20 md:h-36 fill-current text-slate-body sm:block md:-right-14 md:h-44"
                         viewBox="0 0 644 947" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_32_70)">
                            <path
                                    d="M352 4.3c59.5 27 88.1 53.2 99.1 90.8 1.7 6 2.2 10.9 2.6 26.1.5 17.7.4 18.9-1.6 22.1-1.1 1.8-3.2 3.9-4.6 4.5-9.4 4.3-33.5-2.6-50-14.3-7.6-5.4-19.8-18.1-25.3-26.5-5.2-7.9-13-23.8-16.7-34-4.9-13.9-9.7-34-10-42.4-.2-4.5-1.3-12.8-2.4-18.6-2.4-11.9-2.4-12-1.4-12 .5 0 5.1 2 10.3 4.3zM506.8 39.2c16 29.9 25.1 54.2 28.8 76.8 2.2 13.2 1.3 44-1.6 55.7-3.7 15.6-12 31.3-20.5 39.2-3.7 3.4-5.1 4.1-8.6 4.1-8.4 0-18.2-9.6-26-25.5-5.4-11-10.3-28.2-9.5-33 .5-2.3.4-2.7-.5-1.5-.8 1.2-1 1-.5-1 .2-1.4.1-6.8-.3-12-1.5-17.2 1.1-35.6 8-56 4.1-12.4 13.1-32.8 20.1-45.8l5.5-10.4 5.1 9.4zM379.5 133.4c21.4 7.2 30 10.7 42.3 17.1 34.4 18.2 55.4 41.3 63.2 69.5 2.4 9 4.7 29.8 3.5 32.6-1 2.4-1.2 3-1.4 4.9-.2 3.2-5.5 7.5-10.1 8.3-5.1.9-21.4-.3-24.8-1.8-1.2-.5-2.2-.8-2.2-.6 0 .2 5.1 4.2 11.2 8.9 35 26.5 53.8 50.8 61.4 79.2 1.4 5.4 1.9 10.6 1.9 22.5 0 8.5-.4 16.8-.8 18.5-.5 2.2-.5 2.6.3 1.5.7-1.1.8.2.4 4.5-2.2 20.5-13.1 22.7-39.4 7.8-9.8-5.5-18.3-12.4-24.3-19.8-5.4-6.7-14.2-23.3-18-34-3.5-9.8-8-30.3-7.2-33.3.4-1.7.2-2.2-.6-1.6-.9.5-1 0-.6-1.8.4-1.3 0-7.4-.8-13.4s-1.7-18.1-2-26.9c-.7-17.8-1.2-22.6-2.4-22.2-1.7.4-14.1-9.6-21.4-17.3-12.2-12.9-21.3-28-30.7-51-7.1-17.4-11.1-32.4-8.1-30.5 1 .5-2.6-13.6-5.4-21.5-1.7-4.9-1.7-5-.8-5 .5 0 8 2.4 16.8 5.4zM574.3 167.5c6.1 20.4 7.9 26.9 10.1 37 4.5 21 5.9 35.2 5.1 52-.4 8.2-.7 16.1-.7 17.5-.1 10.9-4.6 28.6-10 39.5-5.8 11.5-16.3 24.5-24.7 30.6-6.1 4.4-10.9 5.1-16.2 2.4-3.6-1.9-8.6-9.6-12.2-18.6-5.9-14.8-7.2-24.1-7.1-49.9 0-12.6.4-17 2.2-23.7 6-22.3 18.2-44.6 39.5-71.8 14.2-18.1 13.3-17.2 14-15zM626.4 327.7c-.5 7.6-.9 16.8-.9 20.5 0 3.6-.2 6.3-.5 5.8-.3-.4-.6 2.2-.7 5.8-.2 9-4.6 31.1-8.9 44.1-10.6 32.6-29 55-55.6 67.6-18.5 8.8-27.1 4.1-28.6-15.8-.4-4.5-.7-15.9-.6-25.2 0-16.5.1-17.3 3.3-26.5 9.1-26.6 28.1-48.6 61.3-70.8 8.6-5.8 30.6-19.2 31.4-19.2.4 0 .2 6.2-.2 13.7zM448.1 379.7c39.8 41.9 57.6 78.4 55.4 113.8-.3 6-.8 14.6-1 19-.7 13.7-5.8 28.5-11.2 32-6.9 4.6-14.8 2.2-27.6-8.2-12.1-10-20.8-21.3-26.4-34.6-4.1-9.8-7.4-22.3-7.8-30.2-.2-3.3-.9-11.4-1.5-18-1.2-12.1-.8-29 1.1-43.5 1.5-11.9 7.2-41 8-41 .4 0 5.3 4.8 11 10.7z">
                            </path>
                            <path
                                    d="M644 455.7c0 .2-1.8 4-4.1 8.4-4.7 9.5-6.2 13.2-5 12.5 1.5-1 1.8 3.9.6 8.7-3.1 12.1-26.5 46.8-41.2 60.8-12.4 11.9-28.1 22.2-38.3 25.1-3.6 1-4.9 1.6-3 1.3 1.9-.3 7.8-1.2 13-2 11.7-1.7 35.3-3.5 47.7-3.5h9.3l-5.3 8.2c-7.2 11.2-7.2 11.2-5.9 10.4 1.8-1.1 2.6 4.1 1.3 8.4-2.5 8.4-26.1 37.6-40.4 50.2-9.5 8.3-22.2 16.8-30.4 20.5-9.8 4.3-19.4 7.3-24.2 7.4l-4.6.1 4.5.8c2.5.5 12.4 2.1 22 3.6s17.7 2.9 18 3.1c.2.2 0 .7-.5 1.1-2.7 1.9-13.8 14.4-12.3 13.9 1.8-.6 2.8 1 2.8 4.7 0 3.8-5.3 10.8-14.1 18.7-34.9 31.3-63.1 45-93.9 45.3-6.3 0-13.1-.2-15-.7-1.9-.4 3.5 1.7 12 4.6 23.6 8.2 31 11 31 11.7 0 .3-2.9 2.8-6.5 5.4-5.5 4-10.2 8.4-6.7 6.2 1.3-.8 3.2 2.4 3.2 5.4 0 9.9-48.6 36.1-79 42.6-12.5 2.7-32.7 2.5-44.4-.4-11.3-2.8-26.1-9.8-30.9-14.5-3.9-4-5.6-9.2-3.8-12.4.8-1.7.4-2.4-2.9-4.9-2.2-1.6-4-3.2-4-3.6 0-.4 2.6-4 5.8-8 16.2-20.3 36.8-32.8 60.8-36.9 8.9-1.5 36.8-.6 47.4 1.5 13.1 2.6 14.7 2.6 5.9.3-5.1-1.3-10.2-3.4-12.2-5-3.8-2.9-6.1-8.4-5.1-12.3.5-1.8-.1-2.6-2.5-3.9-1.7-.8-3.1-1.9-3.1-2.3 0-.4 1.6-3.8 3.5-7.5 16.3-31.7 42.4-50.1 78.1-54.8 11.3-1.5 12.7-1.9 9.1-3-5.1-1.4-8.4-5.8-8.9-11.8-.1-2-.9-3.3-2-3.7-2.3-.7-2.3-.6 1.2-11.4 10.8-32.9 30.5-53.4 64-66.2 4.1-1.5 5.9-2.5 4-2.1-1.9.5-8.2.8-14 .8-8.1 0-11.3-.4-14.2-1.8-3.9-2-7.3-7.6-6.5-10.7.3-1.2-.2-2-1.4-2.3-2.3-.6-2.3-2.1-.4-12.4 6.1-32 24.9-56.8 54.4-71.8 15.7-7.9 39.4-14.7 66.6-19 8.8-1.3 17-2.6 18.2-2.9 1.3-.2 2.3-.2 2.3.1z">
                            </path>
                            <path
                                    d="M423.3 504.8c30.5 40.8 44.3 75.7 42.2 106.7-.3 5.5-.8 14-1 19-.5 11.3-3 20.4-8.3 29.3-4.4 7.4-8.8 11.8-12.8 12.8-10.2 2.6-33.9-21.8-42.2-43.3-3.4-8.7-6.7-23.5-5.8-25.8.3-.9.1-3.9-.5-6.8-.5-2.8-1-11.7-1-19.7-.1-15.5 1.5-28.4 5.7-45.5 3.3-13.7 11.7-40.5 12.6-40.5.5 0 5.5 6.2 11.1 13.8zM367 582.1c18.9 38.5 25.4 63.2 24.8 94.1-.2 8.6-.6 15.1-1 14.5-.5-.7-.5.2-.2 1.9 1.9 9.8-7.7 35.4-18.1 48.7-7.6 9.6-14.1 12-21 7.7-7-4.3-19.5-24-23.9-37.5-2-6.3-4.6-19.7-4-20.7.3-.4 0-5.4-.6-11.1-2.6-25.7 5.1-55.3 24-92.2 4.2-8.3 8.7-16.5 9.8-18.4l2.1-3.5 8.1 16.5zM299.5 638.2c.2.7 1.4 7.8 2.7 15.8 1.9 12.3 2.2 18.8 2.3 43 .2 30.9-.7 40.1-5 55.5-6.6 23.2-20.4 43-38.8 55.2-12 8-18.9 7-24.5-3.4-3.6-6.9-7.4-20.5-7.8-28.3-.1-3-.5-10.9-.9-17.5-.9-13.5.1-21.3 4.1-33.9 6.6-20.8 19.8-40.6 42.9-64.5 14.7-15.2 24.4-23.7 25-21.9zM213.9 730.2c-5.2 12.9-6.9 17.9-5.9 17.3.6-.4 1 1.2 1 4.2 0 7.8-11.5 31.3-25.2 51.4-21.5 31.7-52.9 50.9-83.2 50.9-12.4 0-16.6-2.7-18-11.2-.1-1.1-.8-2.3-1.5-2.7-1-.7-1.1-2.7-.2-9.8 6.6-54.5 40.1-83.6 116.4-101.2 9.7-2.3 17.9-4.1 18.2-4.1.3 0-.5 2.4-1.6 5.2zM260.8 818.1c19.3 2.5 43.5 12.4 66.7 27.4 10.8 6.9 31.4 21.8 31.5 22.6 0 .4-2.8 1.6-6.3 2.9-6.6 2.4-9.2 4-6.5 4 1 0 1.9 1.2 2.3 3 1.4 6.5-4.5 10.5-22.6 15.4-57.2 15.5-98.2 9.3-127-19.4-7.5-7.4-10.1-13.1-8.1-17.4.9-2.1.6-3.1-2.9-7.7-2.1-2.9-3.9-5.5-3.9-5.8 0-.3 2.5-2.4 5.5-4.6 22.9-16.7 46.9-23.6 71.3-20.4zM31.666 854.83c4.834 1.066 12.083 6.316 13.996 10.197 1.31 2.587 1.611 4.566 1.108 8.522-.403 2.816-.604 6.392-.604 7.838.201 7.229-6.243 14.686-14.6 16.741-13.895 3.5-28.696-3.957-29.401-14.839-.1-2.13-.806-5.402-1.41-7.381-1.007-2.815-1.007-4.565 0-7.685 3.122-10.577 16.815-16.513 30.912-13.393zM138.5 860.6c27.6 4.6 58.7 22.7 93.5 54.1l5.4 5-7.4 2.3c-4.1 1.3-6.7 2.5-5.8 2.7 2.3.6 3.4 4.8 2 7.8-1.6 3.5-7.5 6.1-18.8 8.4-56.8 11.5-96.8 3.7-125-24.3-6.9-6.9-11-13-11.4-17.1-.5-4.2 0-6.6 1.2-5.9 1.2.8 1.2.7-3.9-7.3-1.8-2.9-3.3-5.6-3.3-6.2 0-1.5 4.9-4.6 14.7-9.5 20.7-10.4 38.6-13.5 58.8-10z">
                            </path>
                        </g>
                        <defs>
                            <clipPath id="clip0_32_70">
                                <path transform="rotate(180 322 473.008)" d="M0 0H644V946.016H0z"></path>
                            </clipPath>
                        </defs>
                    </svg>

                </div>

                <div class="mt-6 flex flex-col items-center justify-center space-y-3">
                    <div class="flex items-center justify-center rounded-3xl border border-gray-300 dark:border-dark-500 px-4 py-2 space-x-2 bg-white dark:bg-dark-700">
                        <svg class="w-8 h-8" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="800px" height="800px" viewBox="-0.5 0 48 48" version="1.1">
                            <g id="Icons" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g id="Color-" transform="translate(-401.000000, -860.000000)">
                                    <g id="Google" transform="translate(401.000000, 860.000000)">
                                        <path d="M9.82727273,24 C9.82727273,22.4757333 10.0804318,21.0144 10.5322727,19.6437333 L2.62345455,13.6042667 C1.08206818,16.7338667 0.213636364,20.2602667 0.213636364,24 C0.213636364,27.7365333 1.081,31.2608 2.62025,34.3882667 L10.5247955,28.3370667 C10.0772273,26.9728 9.82727273,25.5168 9.82727273,24" id="Fill-1" fill="#FBBC05">

                                        </path>
                                        <path d="M23.7136364,10.1333333 C27.025,10.1333333 30.0159091,11.3066667 32.3659091,13.2266667 L39.2022727,6.4 C35.0363636,2.77333333 29.6954545,0.533333333 23.7136364,0.533333333 C14.4268636,0.533333333 6.44540909,5.84426667 2.62345455,13.6042667 L10.5322727,19.6437333 C12.3545909,14.112 17.5491591,10.1333333 23.7136364,10.1333333" id="Fill-2" fill="#EB4335">

                                        </path>
                                        <path d="M23.7136364,37.8666667 C17.5491591,37.8666667 12.3545909,33.888 10.5322727,28.3562667 L2.62345455,34.3946667 C6.44540909,42.1557333 14.4268636,47.4666667 23.7136364,47.4666667 C29.4455,47.4666667 34.9177955,45.4314667 39.0249545,41.6181333 L31.5177727,35.8144 C29.3995682,37.1488 26.7323182,37.8666667 23.7136364,37.8666667" id="Fill-3" fill="#34A853">

                                        </path>
                                        <path d="M46.1454545,24 C46.1454545,22.6133333 45.9318182,21.12 45.6113636,19.7333333 L23.7136364,19.7333333 L23.7136364,28.8 L36.3181818,28.8 C35.6879545,31.8912 33.9724545,34.2677333 31.5177727,35.8144 L39.0249545,41.6181333 C43.3393409,37.6138667 46.1454545,31.6490667 46.1454545,24" id="Fill-4" fill="#4285F4">

                                        </path>
                                    </g>
                                </g>
                            </g>
                        </svg>
                        <div class="inline">
                            <?php echo $lang['rating-hero-cta'] ?>
                        </div>
                    </div>
                </div>

            </div>

            <div class="mx-auto max-w-screen-xl lg:py-6">
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="block text-left overflow-hidden bg-gradient-to-t from-purple-50 dark:from-purple-950 to-transparent justify-center p-5 border border-gray-200 dark:border-dark-600 rounded-3xl mt-8 sm:mt-0 !mx-auto w-full h-[20em] sm:min-w-[25em] sm:h-[25em] skeleton">
                            <div class="mb-6 flex items-center space-x-2">
                                <a href="<?php echo url('/dino'); ?>" class="flex items-center text-center justify-start magic-container">
                                <span class="magic">
                                    <span class="magic-text text-2xl tracking-tight font-extrabold">
                                            <?php echo $lang['dino']; ?>
                                    </span>
                                </span>
                                </a>
                                <span class="inline-flex justify-center items-center w-6 h-6 text-xs font-semibold rounded-lg p-2 bg-dark-800 dark:bg-dark-400">
                                <span class="text-sm tracking-tight font-extrabold text-white"><?php echo $lang['ai']; ?></span>
                            </span>
                            </div>
                            <p class="text-xl md:text-2xl font-bold text-gray-500 dark:text-white"><?php echo $lang['web-design-feature-first'] ?></p>
                        </div>
                        <div class="space-y-6 mr-0 sm:mr-8">
                            <div class="flex items-start text-left overflow-hidden bg-gradient-to-t from-primary-500/10 via-gray-50 dark:via-dark-950 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-h-[11.5em] sm:min-w-[20em]">
                                <p class="text-dark-800 dark:text-white text-xl md:text-2xl font-bold"><?php echo $lang['web-design-feature-second'] ?></p>
                            </div>
                            <div class="relative flex items-end text-left overflow-hidden bg-gradient-to-t from-primary-500/10 via-gray-50 dark:via-dark-950 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-h-[11.5em] sm:min-w-[20em]">
                                <div class="absolute right-6 top-6 rounded-full h-6 w-6 bg-green-500 animate-ping"></div>
                                <p class="text-dark-800 dark:text-white text-xl md:text-2xl font-bold"><?php echo $lang['web-design-feature-third'] ?></p>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="flex items-end text-left overflow-hidden bg-gradient-to-t from-primary-500/10 via-gray-50 dark:via-dark-950 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-w-[15em] sm:h-[15em]">
                            <p class="text-dark-800 dark:text-white text-xl md:text-2xl font-bold"><?php echo $lang['web-design-feature-fourth'] ?></p>
                            <img class="w-16 h-16" src="<?php echo asset('images/content/emoji__eriyz672w3e6_large.png')?>" alt="Shocked Emoji">
                        </div>
                        <div class="relative flex items-start text-left overflow-hidden bg-gradient-to-t from-primary-500/10 via-gray-50 dark:via-dark-950 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[15em] sm:min-h-[15em] sm:min-w-[30em]">
                            <div class="absolute -rotate-45 right-6 bottom-6">
                                <div class="spinner-speed"></div>
                            </div>
                            <p class="text-dark-800 dark:text-white text-xl md:text-2xl font-bold"><?php echo $lang['web-design-feature-fifth'] ?></p>
                        </div>
                    </div>
                </div>
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="relative flex mx-auto max-w-screen-md items-start text-left overflow-hidden bg-gradient-to-t from-primary-500/10 via-gray-50 dark:via-dark-950 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[20em] sm:min-h-[15em] sm:min-w-[30em]">
                        <p class="text-dark-800 dark:text-white text-xl md:text-2xl font-bold"><?php echo $lang['web-design-feature-sixth'] ?></p>
                        <button data-scroll-target="plans" type="button" class="scroll-link absolute right-6 bottom-6 flex appearance-none inline-flex hover:shadow-2xl transition-all duration-300 hover:scale-105 items-center group space-x-2.5 bg-primary-500 dark:bg-primary-500 text-neutral-800 font-semibold py-4 px-5 rounded-full cursor-pointer">
                            <?php echo $lang['web-design-feature-sixth-cta'];?>
                        </button>
                    </div>
                </div>
            </div>

            <div class="max-w-[85rem] px-4 py-10 sm:px-6 lg:px-8 lg:py-14 mx-auto">
                <div class="w-full flex items-center justify-center mb-5">
                    <h2 class="mx-auto group inline-flex items-center gap-x-2 py-1.5 px-2 bg-primary-800/50 font-medium text-sm text-primary-900 dark:text-primary-500 rounded-full focus:outline-none cursor-pointer hover:shadow-2xl transition-all duration-300 hover:scale-105">
                        <?php echo $lang['web-design-solution-services']?>
                    </h2>
                </div>
                <h3 class="mb-2 lg:mb-4 text-3xl font-bold tracking-tight leading-tight text-center text-gray-900 dark:text-white md:text-4xl">
                    <?php echo $webDesignFeatures['headline']; ?>
                </h3>
                <div class="mb-8 lg:mb-16 mx-auto text-center">
                    <p class="text-2xl tracking-tight font-normal text-gray-600 dark:text-gray-400">
                        <?php echo $webDesignFeatures['subheading']; ?>
                    </p>
                </div>

                <div class="grid sm:grid-cols-2 lg:grid-cols-4 items-center gap-2">
                    <?php foreach ($webDesignFeatures['features'] as $feature) { ?>
                        <div class="group flex flex-col justify-center hover:bg-gray-50 focus:outline-none focus:bg-gray-50 rounded-xl p-4 md:p-7 dark:hover:bg-neutral-800 dark:focus:bg-neutral-800 cursor-pointer">
                            <div class="flex justify-center items-center size-12 bg-primary-100 dark:bg-primary-800 rounded-xl">
                    <span class="material-symbols-outlined text-neutral-800 dark:text-neutral-100">
                        <?php echo $feature['icon']; ?>
                    </span>
                            </div>
                            <div class="mt-5">
                                <p class="group-hover:text-gray-600 text-lg font-semibold text-gray-800 dark:text-white dark:group-hover:text-gray-100">
                                    <?php echo $feature['title']; ?>
                                </p>
                                <p class="mt-1 text-gray-600 dark:text-neutral-400">
                                    <?php echo $feature['description']; ?>
                                </p>
                            </div>
                        </div>
                    <?php } ?>
                </div>

                <div class="text-center mt-6">
                    <a class="group inline-flex items-center gap-x-2 py-2 px-3 bg-primary-500 font-medium text-sm text-neutral-800 rounded-full focus:outline-none cursor-pointer"
                       href="<?php echo $webDesignFeatures['cta']['href']; ?>" onclick="<?php echo $webDesignFeatures['cta']['onClick']; ?>" aria-describedby="tier-standard">
                        <svg class="shrink-0 size-4" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path><path class="opacity-0 group-hover:opacity-100 group-focus:opacity-100 group-hover:delay-100 transition" d="M14.05 2a9 9 0 0 1 8 7.94"></path><path class="opacity-0 group-hover:opacity-100 group-focus:opacity-100 transition" d="M14.05 6A5 5 0 0 1 18 10"></path></svg>

                        <?php echo $webDesignFeatures['cta']['text']; ?>
                    </a>
                </div>
            </div>
            <!-- End Icon Blocks -->
        </section>

        <section class="bg-white dark:bg-dark-900 my-8" id="plans">
            <div class="pb-6 pt-1 px-4 mx-auto max-w-screen-xl lg:pt-12 lg:pb-8 lg:px-6">
                <div class="mx-auto text-center mb-8 lg:mb-10">
                    <h2 class="mb-4 text-gray-800 dark:text-gray-400 text-sm font-semibold"><?php echo $WebDesignPackages['headline-superior'] ?></h2>
                    <h3 class="mb-4 text-4xl tracking-tight font-bold text-gray-900 dark:text-gray-100"><?php echo $WebDesignPackages['headline'] ?></h3>
                    <p class="mb-5 font-normal text-gray-500 sm:text-xl dark:text-gray-400 sm:w-[80%] mx-auto max-w-screen-md "><?php echo $WebDesignPackages['subheading'] ?></p>
                </div>
                <div class="flex items-center w-full my-6 mx-auto">
                    <div class="inline-flex mx-auto items-center justify-center py-3 px-12 rounded-full bg-black border-2 border-primary-100 dark:border-primary-200">
                        <div class="box">
                            <div class="clock"></div>
                        </div>
                        <span class="text-md font-semibold text-white">
                            <?php echo $lang['discount-headline'];?>
                        </span>
                    </div>
                </div>
                <div class="space-y-4 lg:grid lg:grid-cols-4 sm:gap-3 xl:gap-4 lg:space-y-0">
                    <?php
                    foreach ($WebDesignPackages['plans'] as $packageKey => $package) {
                        $isMostPopular = isset($package['most_popular']) && $package['most_popular'] === true;
                        ?>
                        <div class="<?php echo ($isMostPopular) ? '!bg-dark-800 dark:bg-dark-600 ring-2 ring-primary-500' : 'ring-1 ring-gray-200 dark:ring-dark-500 bg-gray-50 dark:bg-dark-950'; ?> rounded-3xl p-8 xl:p-10 skeleton">
                            <div class="flex items-center justify-between gap-x-4">
                                <p id="tier-standard" class="text-gray-900 dark:text-gray-50 text-2xl font-semibold leading-8 <?php echo ($isMostPopular) ? '!text-white' : ''; ?>"><?php echo $package['name'] ?></p>
                                <?php if ($isMostPopular): ?>
                                    <p class="rounded-full px-2.5 py-1 text-xs font-semibold leading-5 bg-primary-300/50 text-primary-400 dark:bg-primary-300/25 dark:text-primary-400">
                                        <?php echo $lang['web-design-plans-popular']?>
                                    </p>
                                <?php endif; ?>
                            </div>
                            <p class="mt-4 text-base leading-6 text-gray-600 dark:text-gray-300 <?php echo ($isMostPopular) ? '!text-gray-300' : ''; ?>"><?php echo $package['description'] ?></p>
                            <div class="mt-6 grid items-baseline gap-x-1">
                                <?php
                                // Extract numeric values from price strings
                                $originalPrice = intval(preg_replace('/[^\d]/', '', $package['price']));
                                $discountedPrice = intval(preg_replace('/[^\d]/', '', $package['discounted-price']));

                                // Calculate discount percentage if discounted price exists
                                $discountPercentage = ($discountedPrice && $originalPrice > $discountedPrice)
                                    ? round((($originalPrice - $discountedPrice) / $originalPrice) * 100)
                                    : 0;

                                // Decide the price to display
                                $displayPrice = $discountedPrice && $originalPrice > $discountedPrice
                                    ? $discountedPrice
                                    : $originalPrice;
                                ?>

                                <span class="text-xl font-sans text-gray-500/70 dark:text-gray-300/70 <?php echo ($isMostPopular) ? '!text-gray-400' : ''; ?>">
                                    <?php if ($discountPercentage > 0): ?>
                                        <span class="line-through"><?php echo $package['price']; ?></span>
                                        <span class="!no-underline rounded-full bg-primary-300/25 dark:bg-primary-500/25 px-1 py-0.5 text-xs font-semibold leading-5 text-primary-600 dark:text-primary-500 <?php echo ($isMostPopular) ? '' : '!bg-primary-300/75 !text-primary-900 dark:!bg-primary-300/25 dark:!text-primary-400'; ?>">
                                            -<?php echo $discountPercentage; ?>%
                                        </span>
                                    <?php endif; ?>
                                </span>

                                <span class="text-3xl font-medium tracking-tight text-gray-900 dark:text-gray-200 <?php echo ($isMostPopular) ? '!text-white' : ''; ?>">
                                    <?php echo $package['discounted-price']; ?>

                                                                <?php if ($package['additional_details']): ?>
                                                                    <button data-popover-target="popover-<?php echo $packageKey ?>" data-popover-placement="bottom-end" type="button">
                                                                        <svg class="w-4 h-4 text-gray-400 hover:text-gray-500" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                                                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-8-3a1 1 0 00-.867.5 1 1 0 11-1.731-1A3 3 0 0113 8a3.001 3.001 0 01-2 2.83V11a1 1 0 11-2 0v-1a1 1 0 011-1 1 1 0 100-2zm0 8a1 1 0 100-2 1 1 0 000 2z" clip-rule="evenodd"></path>
                                                                        </svg>
                                                                        <span class="sr-only">Show information</span>
                                                                    </button>
                                                                <?php endif; ?>
                                </span>

                                <?php if (!empty($package['additional_details'])): ?>
                                    <div data-popover id="popover-<?php echo $packageKey ?>" role="tooltip"
                                         class="absolute z-10 invisible inline-block text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-3xl shadow-sm opacity-0 w-72 dark:bg-dark-800 dark:border-gray-600 dark:text-gray-400">
                                        <div class="p-3 space-y-2">
                                            <p class="font-semibold"><?php echo $WebDesignPackages['more-details']; ?></p>
                                            <?php foreach ($package['additional_details'] as $detail): ?>
                                                <p><?php echo $detail; ?></p>
                                            <?php endforeach; ?>
                                        </div>
                                        <div data-popper-arrow></div>
                                    </div>
                                <?php endif; ?>
                            </div>


                            <button onclick="selectAndScroll('<?php echo $packageKey ?>')"
                               aria-describedby="tier-standard"
                               class="<?php echo ($isMostPopular) ? 'text-neutral-800 bg-primary-500' : 'text-white bg-black text-neutral-200 dark:bg-blue-600'; ?> mt-6 mx-auto flex appearance-none inline-flex hover:shadow-2xl transition-all duration-300 hover:scale-105 items-center group space-x-2.5 py-4 px-5 rounded-full cursor-pointer">
                                <?php echo $package['cta'];?></button>
                            <ul role="list" class="mt-8 space-y-3 text-sm leading-6 text-gray-600 dark:text-gray-50 xl:mt-10">
                                <?php foreach ($package['features'] as $feature) { ?>
                                    <li class="flex gap-x-3 text-base <?php echo ($isMostPopular) ? '!text-gray-100' : ''; ?>">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                                             stroke="currentColor" aria-hidden="true" class="h-6 w-5 flex-none text-green-600 dark:text-green-300 <?php echo ($isMostPopular) ? '!text-green-500' : ''; ?>">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                  d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                        </svg><?php echo $feature ?>
                                    </li>
                                <?php } ?>
                            </ul>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </section>
    <?php
    $projects = [
        [
            'name' => 'ABP Group',
            'url' => 'abpgroup.com.tr',
            'image' => 'images/projects/screenshots/screencapture-abpgroup-tr.png'
        ],
        [
            'name' => 'Beyoğlu Aksesuar',
            'url' => 'beyogluaksesuar.com',
            'image' => 'images/projects/screenshots/screencapture-beyogluaksesuar.png'
        ],
        [
            'name' => 'Proval',
            'url' => 'proval.datanito.com.tr',
            'image' => 'images/projects/screenshots/screencapture-proval-datanito-tr.png'
        ],
        [
            'name' => 'Doruk Endüstri',
            'url' => 'dorukendustri.com',
            'image' => 'images/projects/screenshots/screencapture-dorukendustri.png'
        ],
        [
            'name' => 'Storfy',
            'url' => 'studio.datanito.com/storfy',
            'image' => 'images/projects/screenshots/screencapture-studio-datanito-storfy.png'
        ],
        [
            'name' => 'TFC Oil Trading',
            'url' => '',
            'image' => 'images/projects/screenshots/screencapture-tfc-datanito-tr.png'
        ],
        [
            'name' => 'JellyCoin',
            'url' => 'jellycoin.site',
            'image' => 'images/projects/screenshots/screencapture-jellycoin-site.png'
        ],
        [
            'name' => 'Monashreklisa',
            'url' => 'monashreklisa.com',
            'image' => 'images/projects/screenshots/screencapture-monashreklisa.png'
        ],
        [
            'name' => 'LuxLuster',
            'url' => 'monashreklisa.com',
            'image' => 'images/projects/screenshots/screencapture-datanito-tr-veloura.png'
        ],
        [
            'name' => 'Loura Jewelry',
            'url' => '',
            'image' => 'images/projects/screenshots/screencapture-datanito-tr-veloura-akali-jewelry.png'
        ],
        [
            'name' => 'Akal Jewelry',
            'url' => '',
            'image' => 'images/projects/screenshots/screencapture-datanito-tr-veloura-akali-jewelry-3.png'
        ],
        [
            'name' => 'Velo Jewelry',
            'url' => 'monashreklisa.com',
            'image' => 'images/projects/screenshots/screencapture-datanito-tr-veloura-akali-jewelry-2.png'
        ],
        [
            'name' => 'Dazzle',
            'url' => '',
            'image' => 'images/projects/screenshots/screencapture-datanito-tr-aureus.png'
        ],
        [
            'name' => 'Aur Jewelry',
            'url' => '',
            'image' => 'images/projects/screenshots/screencapture-datanito-tr-aureus-jewelry-accessories.png'
        ],
        [
            'name' => 'Dazzle Fashion',
            'url' => '',
            'image' => 'images/projects/screenshots/screencapture-datanito-tr-aureus-fashion-store.png'
        ],
    ];
    ?>

    <section class="max-w-[85rem] px-4 py-10 sm:px-6 lg:px-8 lg:py-14 mx-auto my-8 relative">
        <div class="w-full flex items-center justify-center mb-4">
            <h2 class="mx-auto group inline-flex items-center gap-x-2 py-1.5 px-2 bg-primary-800/50 font-medium text-sm text-primary-900 dark:text-primary-500 rounded-full focus:outline-none cursor-pointer hover:shadow-2xl transition-all duration-300 hover:scale-105">
                <?php echo $lang['web-design-solution']?>
            </h2>
        </div>
        <p class="mb-2 lg:mb-4 text-3xl font-bold tracking-tight leading-tight text-center text-gray-900 dark:text-white md:text-4xl"><?php echo $lang['web-design-last-projects-headline']?></p>
        <div class="mb-8 lg:mb-16 mx-auto text-center">
            <p class="text-2xl tracking-tight font-normal text-gray-600 dark:text-gray-400">
                <?php echo $lang['web-design-last-projects-subheading']?>
            </p>
        </div>
        <!-- Image Grid -->
        <div id="project-grid" class="grid grid-cols-2 sm:grid-cols-3 gap-2 max-h-[700px] overflow-hidden relative transition-all duration-300">
            <?php foreach ($projects as $index => $project): ?>
                <figure class="ms-auto group me-20 relative z-[1] max-w-full w-full h-auto overflow-hidden shadow-[0_2.75rem_3.5rem_-2rem_rgb(45_55_75_/_20%),_0_0_5rem_-2rem_rgb(45_55_75_/_15%)] dark:shadow-[0_2.75rem_3.5rem_-2rem_rgb(0_0_0_/_20%),_0_0_5rem_-2rem_rgb(0_0_0_/_15%)] rounded-b-lg skeleton <?= $index > 5 ? 'hidden lazy' : '' ?>">
                    <div class="relative flex items-center max-w-[50rem] bg-gray-800 rounded-t-lg py-2 px-20 sm:px-24 dark:bg-neutral-700">
                        <div class="flex gap-x-1 absolute top-2/4 start-4 -translate-y-1">
                            <span class="size-2 bg-gray-600 rounded-full dark:bg-neutral-600"></span>
                            <span class="size-2 bg-gray-600 rounded-full dark:bg-neutral-600"></span>
                            <span class="size-2 bg-gray-600 rounded-full dark:bg-neutral-600"></span>
                        </div>
                        <div class="flex justify-center items-center size-full bg-gray-700 text-[.25rem] text-gray-400 rounded-sm sm:text-[.5rem] dark:bg-neutral-600 dark:text-neutral-400">
                            <?= htmlspecialchars($project['url']) ?>
                        </div>
                    </div>

                    <div class="window relative bg-gray-800 rounded-b-lg">
                        <img class="w-full object-cover bg-gray-100 dark:bg-neutral-800" src="<?= asset($project['image']) ?>" alt="<?= htmlspecialchars($project['name']) ?>">
                        <div class="absolute top-1 start-1 transition">
                            <div class="flex items-center gap-x-1.5 text-md py-1.5 px-3 bg-dark-700 text-gray-50 bg-opacity-50 backdrop-blur rounded-xl dark:bg-neutral-900 dark:border-neutral-700 dark:text-neutral-200">
                                <svg class="shrink-0 size-4" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.213 9.787a3.391 3.391 0 0 0-4.795 0l-3.425 3.426a3.39 3.39 0 0 0 4.795 4.794l.321-.304m-.321-4.49a3.39 3.39 0 0 0 4.795 0l3.424-3.426a3.39 3.39 0 0 0-4.794-4.795l-1.028.961"/>
                                </svg>
                                <span class="text-xs"><?= htmlspecialchars($project['name']) ?></span>
                            </div>
                        </div>
                        <div class="absolute bottom-1 end-1 opacity-0 group-hover:opacity-100 transition">
                            <div class="flex items-center gap-x-1 py-1 px-2 bg-white border border-gray-200 text-gray-800 rounded-xl dark:bg-neutral-900 dark:border-neutral-700 dark:text-neutral-200">
                                <svg class="shrink-0 size-3" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="11" cy="11" r="8"/><path d="m21 21-4.3-4.3"/></svg>
                                <span class="text-xs"><?= htmlspecialchars($project['url']) ?></span>
                            </div>
                        </div>
                    </div>
                </figure>
            <?php endforeach; ?>
            <div class="absolute inset-x-0 bottom-0 h-24 bg-gradient-to-t from-white to-transparent dark:from-dark-900 pointer-events-none z-10"></div>
        </div>
        <!-- End Image Grid -->
        <div class="text-center relative z-20 -mt-8">
            <button id="load-more-btn" class="group inline-flex items-center gap-x-2 py-2 px-3 bg-primary-500 font-medium text-sm text-neutral-800 rounded-full focus:outline-none cursor-pointer hover:shadow-2xl transition-all duration-300 hover:scale-105">
                <?php echo $lang['projects-load-more'];?>
                <svg class="shrink-0 size-4" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="m9 18 6-6-6-6"/>
                </svg>
            </button>
            <div id="loading-spinner" class="hidden w-full mt-4 mx-auto">
                <div class="w-6 h-6 border-4 border-primary-600 border-t-transparent border-t-4 rounded-full animate-spin mx-auto"></div>
            </div>
        </div>
    </section>

        <!-- Features -->
        <div class="max-w-[85rem] px-4 py-10 sm:px-6 lg:px-8 lg:py-14 mx-auto mb-6">
            <!-- Grid -->
            <div class="grid items-center lg:grid-cols-12 gap-6 lg:gap-12">
                <div class="lg:col-span-4">
                    <!-- Stats -->
                    <div class="lg:pe-6 xl:pe-12">
                        <p class="text-6xl font-bold leading-10 text-gray-600 dark:text-gray-200">
                            <?php echo $lang['stats-number-first'];?>
                            <span class="ms-1 inline-flex items-center gap-x-1 bg-gray-200 font-medium text-gray-800 text-xs leading-4 rounded-full py-0.5 px-2 dark:bg-neutral-800 dark:text-neutral-300">
                            <svg class="shrink-0 size-4" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                              <path d="M10.067.87a2.89 2.89 0 0 0-4.134 0l-.622.638-.89-.011a2.89 2.89 0 0 0-2.924 2.924l.01.89-.636.622a2.89 2.89 0 0 0 0 4.134l.637.622-.011.89a2.89 2.89 0 0 0 2.924 2.924l.89-.01.622.636a2.89 2.89 0 0 0 4.134 0l.622-.637.89.011a2.89 2.89 0 0 0 2.924-2.924l-.01-.89.636-.622a2.89 2.89 0 0 0 0-4.134l-.637-.622.011-.89a2.89 2.89 0 0 0-2.924-2.924l-.89.01-.622-.636zm.287 5.984-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7 8.793l2.646-2.647a.5.5 0 0 1 .708.708z"/>
                            </svg>
                            <?php echo $lang['stats-number-first-update'];?>
                          </span>
                        </p>
                        <p class="mt-2 sm:mt-3 text-gray-500 dark:text-neutral-400"><?php echo $lang['stats-number-first-text'];?></p>
                    </div>
                    <!-- End Stats -->
                </div>
                <!-- End Col -->

                <div class="lg:col-span-8 relative lg:before:absolute lg:before:top-0 lg:before:-start-12 lg:before:w-px lg:before:h-full lg:before:bg-gray-200 lg:before:dark:bg-neutral-700">
                    <div class="grid gap-6 grid-cols-2 md:grid-cols-4 lg:grid-cols-3 sm:gap-8">
                        <!-- Stats -->
                        <div>
                            <p class="text-3xl font-semibold text-gray-600 dark:text-gray-200"><?php echo $lang['stats-number-second'];?></p>
                            <p class="mt-1 text-gray-500 dark:text-neutral-400"><?php echo $lang['stats-number-second-text'];?></p>
                        </div>
                        <!-- End Stats -->

                        <!-- Stats -->
                        <div>
                            <p class="text-3xl font-semibold text-gray-600 dark:text-gray-200"><?php echo $lang['stats-number-third'];?></p>
                            <p class="mt-1 text-gray-500 dark:text-neutral-400"><?php echo $lang['stats-number-third-text'];?></p>
                        </div>
                        <!-- End Stats -->

                        <!-- Stats -->
                        <div>
                            <p class="text-3xl font-semibold text-gray-600 dark:text-gray-200"><?php echo $lang['stats-number-fourth'];?></p>
                            <p class="mt-1 text-gray-500 dark:text-neutral-400"><?php echo $lang['stats-number-fourth-text'];?></p>
                        </div>
                        <!-- End Stats -->
                    </div>
                </div>
                <!-- End Col -->
            </div>
            <!-- End Grid -->
        </div>
        <!-- End Features -->



        <div class="bg-neutral-800">
            <!-- Approach -->
            <div class="max-w-5xl px-4 xl:px-0 py-10 lg:pt-20 lg:pb-20 mx-auto">
                <!-- Title -->
                <div class="max-w-3xl mb-10 lg:mb-14">
                    <h2 class="text-white font-semibold text-2xl md:text-4xl md:leading-tight"><?php echo $lang['web-design-approach-headline']?></h2>
                    <p class="mt-1 text-neutral-400"><?php echo $lang['web-design-approach-subheading']?></p>
                </div>
                <!-- End Title -->

                <!-- Grid -->
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-10 lg:gap-16 lg:items-center">
                    <div class="aspect-w-16 aspect-h-9 lg:aspect-none">
                        <img class="w-full object-cover rounded-xl" src="https://images.unsplash.com/photo-1587614203976-365c74645e83?q=80&w=480&h=600&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D" alt="Features Image">
                    </div>
                    <!-- End Col -->

                    <!-- Timeline -->
                    <div>
                        <!-- Heading -->
                        <div class="mb-4">
                            <p class="text-[#ff0] text-xs font-medium uppercase"><?php echo $lang['web-design-approach-heading']?></p>
                        </div>
                        <!-- End Heading -->

                        <!-- Item -->
                        <div class="flex gap-x-5 ms-1">
                            <div class="relative last:after:hidden after:absolute after:top-8 after:bottom-0 after:start-4 after:w-px after:-translate-x-[0.5px] after:bg-neutral-400">
                                <div class="relative z-10 size-8 flex justify-center items-center">
                                    <span class="flex shrink-0 justify-center items-center size-8 border border-neutral-400 text-[#ff0] font-semibold text-xs uppercase rounded-full">1</span>
                                </div>
                            </div>
                            <div class="grow pt-0.5 pb-8 sm:pb-12">
                                <p class="text-sm lg:text-base text-neutral-400">
                                    <?php echo $lang['web-design-approach-first'] ?>
                                </p>
                            </div>
                        </div>
                        <!-- End Item -->

                        <!-- Item -->
                        <div class="flex gap-x-5 ms-1">
                            <div class="relative last:after:hidden after:absolute after:top-8 after:bottom-0 after:start-4 after:w-px after:-translate-x-[0.5px] after:bg-neutral-400">
                                <div class="relative z-10 size-8 flex justify-center items-center">
                                    <span class="flex shrink-0 justify-center items-center size-8 border border-neutral-400 text-[#ff0] font-semibold text-xs uppercase rounded-full">2</span>
                                </div>
                            </div>
                            <div class="grow pt-0.5 pb-8 sm:pb-12">
                                <p class="text-sm lg:text-base text-neutral-400">
                                    <?php echo $lang['web-design-approach-second'] ?>
                                </p>
                            </div>
                        </div>
                        <!-- End Item -->

                        <!-- Item -->
                        <div class="flex gap-x-5 ms-1">
                            <div class="relative last:after:hidden after:absolute after:top-8 after:bottom-0 after:start-4 after:w-px after:-translate-x-[0.5px] after:bg-neutral-400">
                                <div class="relative z-10 size-8 flex justify-center items-center">
                                    <span class="flex shrink-0 justify-center items-center size-8 border border-neutral-400 text-[#ff0] font-semibold text-xs uppercase rounded-full">3</span>
                                </div>
                            </div>
                            <div class="grow pt-0.5 pb-8 sm:pb-12">
                                <p class="text-sm md:text-base text-neutral-400">
                                    <?php echo $lang['web-design-approach-third'] ?>
                                </p>
                            </div>
                        </div>
                        <!-- End Item -->

                        <!-- Item -->
                        <div class="flex gap-x-5 ms-1">
                            <div class="relative last:after:hidden after:absolute after:top-8 after:bottom-0 after:start-4 after:w-px after:-translate-x-[0.5px] after:bg-neutral-400">
                                <div class="relative z-10 size-8 flex justify-center items-center">
                                    <span class="flex shrink-0 justify-center items-center size-8 border border-neutral-400 text-[#ff0] font-semibold text-xs uppercase rounded-full">4</span>
                                </div>
                            </div>
                            <div class="grow pt-0.5 pb-8 sm:pb-12">
                                <p class="text-sm md:text-base text-neutral-400">
                                    <?php echo $lang['web-design-approach-fourth'] ?>
                                </p>
                            </div>
                        </div>
                        <!-- End Item -->

                        <a class="group inline-flex items-center gap-x-2 py-2 px-3 bg-[#ff0] font-medium text-sm text-neutral-800 rounded-full focus:outline-none cursor-pointer" onclick="selectAndScroll()" aria-describedby="tier-standard">
                            <svg class="shrink-0 size-4" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path><path class="opacity-0 group-hover:opacity-100 group-focus:opacity-100 group-hover:delay-100 transition" d="M14.05 2a9 9 0 0 1 8 7.94"></path><path class="opacity-0 group-hover:opacity-100 group-focus:opacity-100 transition" d="M14.05 6A5 5 0 0 1 18 10"></path></svg>
                            <?php echo $lang['web-design-approach-cta'] ?>
                        </a>
                    </div>
                    <!-- End Timeline -->
                </div>
                <!-- End Grid -->
            </div>
        </div>


        <!-- Hero -->
        <div id="applyNow" class="relative bg-gradient-to-b from-primary-500/10 via-transparent">
            <div class="max-w-[85rem] px-4 py-10 sm:px-6 lg:px-8 lg:py-14 mx-auto">
                <!-- Grid -->
                <div class="grid items-center md:grid-cols-2 gap-8 lg:gap-12">
                    <div>
                        <p class="inline-block text-sm font-medium bg-clip-text bg-gradient-to-l from-primary-900 to-primary-700 text-transparent dark:from-primary-500 dark:to-primary-400">
                            <?php echo $lang['web-design-form-hero-superior'] ?>
                        </p>

                        <!-- Title -->
                        <div class="mt-4 md:mb-12 max-w-2xl">
                            <h2 class="mb-4 font-semibold text-gray-800 text-4xl lg:text-5xl dark:text-neutral-200">
                                <?php echo $lang['web-design-form-hero-headline'] ?>
                            </h2>
                            <p class="text-gray-600 dark:text-neutral-400">
                                <?php echo $lang['web-design-form-hero-subheading'] ?>
                            </p>
                        </div>
                        <!-- End Title -->
                        <!-- Avatar Group -->
                        <div class="sm:inline-flex sm:justify-start sm:items-center text-center sm:text-start sm:divide-x-2 divide-gray-400 mt-8">
                            <div class="shrink-0 pb-5 sm:flex sm:pb-0 sm:pe-5">
                                <!-- Avatar Group -->
                                <div class="flex justify-center -space-x-3">
                                    <img class="inline-block size-8 rounded-full ring-2 ring-white dark:ring-neutral-900" src="https://images.unsplash.com/photo-1568602471122-7832951cc4c5?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=facearea&facepad=2&w=300&h=300&q=80" alt="Avatar">
                                    <img class="inline-block size-8 rounded-full ring-2 ring-white dark:ring-neutral-900" src="https://images.unsplash.com/photo-1531927557220-a9e23c1e4794?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=facearea&facepad=2&w=300&h=300&q=80" alt="Avatar">
                                    <img class="inline-block size-8 rounded-full ring-2 ring-white dark:ring-neutral-900" src="https://images.unsplash.com/photo-1541101767792-f9b2b1c4f127?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&&auto=format&fit=facearea&facepad=3&w=300&h=300&q=80" alt="Avatar">
                                    <img class="inline-block size-8 rounded-full ring-2 ring-white dark:ring-neutral-900" src="https://images.unsplash.com/photo-1492562080023-ab3db95bfbce?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=facearea&facepad=2&w=300&h=300&q=80" alt="Avatar">
                                    <span class="inline-flex items-center justify-center size-8 rounded-full ring-2 ring-white bg-gray-800 dark:bg-neutral-600 dark:ring-neutral-900">
                                        <span class="text-xs font-medium leading-none text-white uppercase">7k+</span>
                                    </span>
                                </div>
                                <!-- End Avatar Group -->
                            </div>

                            <div class="border-t sm:border-t-0 sm:border-s border-gray-700 w-32 h-px sm:w-auto sm:h-full mx-auto sm:mx-0 dark:border-neutral-300"></div>

                            <div class="pt-5 sm:pt-0 sm:ps-5">
                                <div class="text-lg font-semibold text-gray-800 dark:text-neutral-200"><?php echo $lang['web-design-form-hero-rating-source'] ?></div>
                                <div class="text-sm text-gray-500 dark:text-neutral-400"><?php echo $lang['web-design-form-hero-rating-subheading'] ?></div>
                            </div>
                        </div>
                        <div class="block flex flex-row items-center justify-center sm:justify-start mt-6 text-yellow-500">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"
                                 class="h-auto w-10 fill-current">
                                <path
                                        d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z">
                                </path>
                            </svg>
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"
                                 class="h-auto w-10 fill-current">
                                <path
                                        d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z">
                                </path>
                            </svg>
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"
                                 class="h-auto w-10 fill-current">
                                <path
                                        d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z">
                                </path>
                            </svg>
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"
                                 class="h-auto w-10 fill-current">
                                <path
                                        d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z">
                                </path>
                            </svg>
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"
                                 class="h-auto w-10 fill-current">
                                <path
                                        d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z">
                                </path>
                            </svg>
                        </div>

                    </div>
                    <!-- End Col -->

                    <div>
                        <!-- Improved Form -->
                        <form class="submit-application">
                            <div class="lg:max-w-lg lg:mx-auto lg:me-0 ms-auto">
                                <!-- Card -->
                                <div id="apply-form" class="p-4 sm:p-7 flex flex-col bg-white rounded-2xl shadow-lg dark:bg-neutral-800">
                                    <div class="mb-6">
                                        <p class="block text-2xl font-bold text-gray-800 dark:text-white"><?php echo $lang['web-design-form-headline'] ?></p>
                                        <p class="mt-2 text-sm text-gray-600 dark:text-gray-300">
                                            <?php echo $lang['web-design-form-subheading'] ?>
                                        </p>
                                    </div>

                                    <!-- Grid -->
                                    <div class="grid grid-cols-1 gap-4">
                                        <?php set_csrf(); ?>
                                        <input type="hidden" id="selected-package" name="selected_package" value="">
                                        <input type="hidden" id="lead-source" name="lead_source" value="<?php echo $lang['web-design-solution'] ?>">
                                        <!-- Input Group: Name -->
                                        <div class="relative">
                                            <input type="text" id="name-input" required class="peer p-4 block w-full border-gray-200 rounded-lg text-sm placeholder:text-transparent focus:border-blue-500 focus:ring-blue-500 disabled:opacity-50 disabled:pointer-events-none dark:bg-neutral-900 dark:border-neutral-700 dark:text-neutral-400 dark:focus:ring-neutral-600 focus:pt-6 focus:pb-2 [&:not(:placeholder-shown)]:pt-6 [&:not(:placeholder-shown)]:pb-2" placeholder="<?php echo $lang['full-name']; ?>">
                                            <label for="name-input" class="absolute top-0 start-0 p-4 h-full text-sm truncate pointer-events-none transition ease-in-out duration-100 origin-[0_0] dark:text-white peer-focus:scale-90 peer-focus:translate-x-0.5 peer-focus:-translate-y-1.5 peer-focus:text-gray-500 dark:peer-focus:text-neutral-500 peer-[:not(:placeholder-shown)]:scale-90 peer-[:not(:placeholder-shown)]:translate-x-0.5 peer-[:not(:placeholder-shown)]:-translate-y-1.5"><?php echo $lang['full-name']; ?></label>
                                        </div>

                                        <!-- Input Group: Email -->
                                        <div class="relative">
                                            <input type="email" id="email-input" required class="peer p-4 block w-full border-gray-200 rounded-lg text-sm placeholder:text-transparent focus:border-blue-500 focus:ring-blue-500 disabled:opacity-50 disabled:pointer-events-none dark:bg-neutral-900 dark:border-neutral-700 dark:text-neutral-400 dark:focus:ring-neutral-600 focus:pt-6 focus:pb-2 [&:not(:placeholder-shown)]:pt-6 [&:not(:placeholder-shown)]:pb-2" placeholder="<?php echo $lang['email']; ?>">
                                            <label for="email-input" class="absolute top-0 start-0 p-4 h-full text-sm truncate pointer-events-none transition ease-in-out duration-100 origin-[0_0] dark:text-white peer-focus:scale-90 peer-focus:translate-x-0.5 peer-focus:-translate-y-1.5 peer-focus:text-gray-500 dark:peer-focus:text-neutral-500 peer-[:not(:placeholder-shown)]:scale-90 peer-[:not(:placeholder-shown)]:translate-x-0.5 peer-[:not(:placeholder-shown)]:-translate-y-1.5"><?php echo $lang['email']; ?></label>
                                        </div>

                                        <!-- Input Group: Phone Number -->
                                        <div class="relative">
                                            <input type="tel" id="phone-number-input" required class="peer p-4 block w-full border-gray-200 rounded-lg text-sm placeholder:text-transparent focus:border-blue-500 focus:ring-blue-500 disabled:opacity-50 disabled:pointer-events-none dark:bg-neutral-900 dark:border-neutral-700 dark:text-neutral-400 dark:focus:ring-neutral-600 focus:pt-6 focus:pb-2 [&:not(:placeholder-shown)]:pt-6 [&:not(:placeholder-shown)]:pb-2" placeholder="<?php echo $lang['phone-number']; ?>">
                                            <label for="phone-number-input" class="absolute top-0 start-0 p-4 h-full text-sm truncate pointer-events-none transition ease-in-out duration-100 origin-[0_0] dark:text-white peer-focus:scale-90 peer-focus:translate-x-0.5 peer-focus:-translate-y-1.5 peer-focus:text-gray-500 dark:peer-focus:text-neutral-500 peer-[:not(:placeholder-shown)]:scale-90 peer-[:not(:placeholder-shown)]:translate-x-0.5 peer-[:not(:placeholder-shown)]:-translate-y-1.5"><?php echo $lang['phone-number']; ?></label>
                                        </div>
                                        <div class="relative hidden">
                                            <select id="submit-reasons" class="block w-full p-3 text-sm text-gray-500 border border-gray-300 rounded-lg bg-white focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-800 dark:border-gray-600 dark:placeholder-gray-400 dark:text-gray-400 dark:focus:ring-blue-500 dark:focus:border-blue-500" required>
                                                <option><?php echo $lang['choose-reason']; ?> <span class="text-[12px]">(<?php echo $lang['required']; ?>)</span></option>
                                                <option value="web-design" selected><?php echo $lang['web-design']; ?></option>
                                                <option value="seo"><?php echo $lang['seo']; ?></option>
                                                <option value="app-development"><?php echo $lang['app-development']; ?></option>
                                                <option value="advertising"><?php echo $lang['advertising']; ?></option>
                                                <option value="digital-marketing"><?php echo $lang['digital-marketing']; ?></option>
                                                <option value="contact"><?php echo $lang['contact']; ?></option>
                                                <option value="other"><?php echo $lang['other']; ?></option>
                                            </select>
                                        </div>
                                        <!-- Input Group: Message -->
                                        <div class="relative">
                                            <textarea id="message-input" class="peer p-4 block w-full border-gray-200 rounded-lg text-sm placeholder:text-transparent focus:border-blue-500 focus:ring-blue-500 disabled:opacity-50 disabled:pointer-events-none dark:bg-neutral-900 dark:border-neutral-700 dark:text-neutral-400 dark:focus:ring-neutral-600 focus:pt-6 focus:pb-2 [&:not(:placeholder-shown)]:pt-6 [&:not(:placeholder-shown)]:pb-2" placeholder="<?php echo $lang['your-message']; ?>"></textarea>
                                            <label for="message-input" class="absolute top-0 start-0 p-4 h-full text-sm truncate pointer-events-none transition ease-in-out duration-100 origin-[0_0] dark:text-white peer-focus:scale-90 peer-focus:translate-x-0.5 peer-focus:-translate-y-1.5 peer-focus:text-gray-500 dark:peer-focus:text-neutral-500 peer-[:not(:placeholder-shown)]:scale-90 peer-[:not(:placeholder-shown)]:translate-x-0.5 peer-[:not(:placeholder-shown)]:-translate-y-1.5"><?php echo $lang['your-message']; ?></label>
                                        </div>
                                        <div class="flex items-center mb-4 hidden">
                                            <input id="promotional-offers" type="checkbox" value="" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 dark:focus:ring-offset-gray-800 focus:ring-2 dark:bg-dark-800 dark:border-gray-600">
                                            <label for="promotional-offers" class="ml-2 text-sm font-medium text-gray-900 dark:text-gray-300"><?php echo $lang['promotional-offers']; ?> <span class="text-[12px]">(<?php echo $lang['exclusive-offers']; ?>)</span></label>
                                        </div>
                                        <div class="relative hidden">
                                            <input type="text" id="honeypot" name="honeypot" value="">
                                        </div>
                                    </div>
                                    <!-- End Grid -->
                                    <p class="text-sm !mt-4 text-gray-500 dark:text-gray-400"><?php echo $lang['form-privacy']; ?></p>

                                    <!-- Submit Button -->
                                    <div class="mt-5">
                                        <button id="apply-form-btn" type="submit" class="w-full py-3 px-4 inline-flex justify-center items-center gap-x-2 text-neutral-800 text-sm font-medium rounded-lg border border-transparent bg-primary-500 hover:bg-primary-400 focus:outline-none focus:bg-primary-300 disabled:opacity-50 disabled:pointer-events-none"><?php echo $lang['apply-now']; ?></button>
                                    </div>
                                </div>
                                <!-- End Card -->
                            </div>
                        </form>

                        <!-- End Form -->
                    </div>
                    <!-- End Col -->
                </div>
                <!-- End Grid -->

                <!-- Clients Section -->
                <section class="mt-6 md:mt-12 py-3 text-gray-800 dark:text-white" aria-label="Our Trusted Partners">
                    <!-- Header -->
                    <header class="flex items-center text-sm gap-x-2 after:flex-1 after:border-t after:border-gray-200 after:ms-6 dark:after:border-neutral-700">
                        <?php echo $lang['web-design-form-hero-trusted']; ?>
                    </header>

                    <!-- Clients Logos -->
                    <div class="grid grid-cols-2 sm:grid-cols-3 lg:grid-cols-5 mx-auto items-center text-center justify-center mt-6">
                        <img class="sm:ml-14 h-8" src="<?php echo asset('images/brand/framer-partner.png') ?>"
                             alt="Framer Partner Logo" loading="lazy">
                        <img class="h-10" src="<?php echo asset('images/brand/google-partner.avif') ?>"
                             alt="Google Partner Logo" loading="lazy">
                        <img class="h-9" src="<?php echo asset('images/brand/meta-partner.avif') ?>"
                             alt="Meta Partner Logo" loading="lazy">
                        <img class="h-12" src="<?php echo asset('images/brand/wix-partner.png') ?>"
                             alt="Wix Partner Logo" loading="lazy">
                        <img class="h-6" src="<?php echo asset('images/brand/wixstudio-partner.png') ?>"
                             alt="Wix Studio Partner Logo" loading="lazy">
                    </div>
                </section>

                <!-- End Clients -->
            </div>
            <!-- End Clients Section -->
        </div>
        <!-- End Hero -->

        <section class="bg-white dark:bg-dark-900">
            <div class="py-8 px-4 mx-auto max-w-screen-xl text-center lg:py-16 lg:px-6">
                <div class="mx-auto max-w-screen-sm">
                    <h3 class="mb-4 text-4xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['case-studies-headline'] ?></h3>
                    <p class="mb-8 font-normal text-gray-500 lg:mb-16 sm:text-xl dark:text-gray-400"><?php echo $lang['case-studies-subheading'] ?></p>
                </div>

                <div id="default-carousel" class="relative w-full" data-carousel="static">
                    <!-- Carousel wrapper -->
                    <div class="relative z-10 h-96 overflow-hidden rounded-3xl md:h-96">
                        <!-- Item -->
                        <?php foreach ($caseStudiesWebDesign as $study): ?>
                            <div class="hidden duration-700 ease-in-out" data-carousel-item>
                                <figure>
                                    <blockquote class="mx-auto mb-8 max-w-2xl text-gray-500 dark:text-gray-400">
                                        <p class="text-lg font-semibold text-gray-900 dark:text-white"><?php echo $study['title']; ?></p>
                                        <p class="my-4"><?php echo $study['challenge']; ?></p>
                                        <p class="my-4"><?php echo $study['solution']; ?></p>
                                    </blockquote>
                                    <ul class="list-disc list-inside mx-auto max-w-2xl text-gray-500 dark:text-gray-400">
                                        <?php foreach ($study['results'] as $result): ?>
                                            <li><?php echo $result; ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </figure>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <!-- Slider controls -->
                    <button type="button" class="absolute top-0 left-0 z-10 flex items-center justify-center h-full px-4 cursor-pointer group focus:outline-none" data-carousel-prev>
                <span class="inline-flex items-center justify-center w-10 h-10 rounded-full bg-gray-300 dark:bg-gray-400/30 group-hover:bg-gray-300/60 dark:group-hover:bg-gray-400/60 group-focus:ring-4 group-focus:ring-white dark:group-focus:ring-gray-800/70 group-focus:outline-none">
                    <svg class="w-4 h-4 text-white dark:text-gray-800" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 1 1 5l4 4"/>
                    </svg>
                    <span class="sr-only">Previous</span>
                </span>
                    </button>
                    <button type="button" class="absolute top-0 right-0 z-10 flex items-center justify-center h-full px-4 cursor-pointer group focus:outline-none" data-carousel-next>
                <span class="inline-flex items-center justify-center w-10 h-10 rounded-full bg-gray-300 dark:bg-gray-400/30 group-hover:bg-gray-300/60 dark:group-hover:bg-gray-400/60 group-focus:ring-4 group-focus:ring-white dark:group-focus:ring-gray-800/70 group-focus:outline-none">
                    <svg class="w-4 h-4 text-white dark:text-gray-800" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 9 4-4-4-4"/>
                    </svg>
                    <span class="sr-only">Next</span>
                </span>
                    </button>
                </div>
            </div>
        </section>

        <section class="bg-white dark:bg-dark-900">
            <div class="mx-auto text-center pt-8">
                <h2 class="my-4 text-4xl font-bold text-gray-600 dark:text-gray-50"><?php echo $lang['our-web-design-services'] ?></h2>
            </div>
            <div class="py-2 px-4 mx-auto max-w-screen-xl lg:py-4 space-y-8">
                <div class="grid md:grid-cols-4 gap-6">
                    <?php foreach ($webDesignServices as $index => $service): ?>
                        <!-- Service Card -->
                        <div class="relative bg-gray-50 dark:bg-dark-800 dark:text-<?php echo $index === 0 ? 'blue' : ($index === 1 ? 'green' : ($index === 2 ? 'purple' : 'orange')); ?>-400 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 shadow-lg transition-transform">
                            <!-- Service Label with Icon -->
                            <div class="bg-<?php echo $index === 0 ? 'blue' : ($index === 1 ? 'green' : ($index === 2 ? 'purple' : 'orange')); ?>-200 text-<?php echo $index === 0 ? 'blue' : ($index === 1 ? 'green' : ($index === 2 ? 'purple' : 'orange')); ?>-800 text-xs font-medium inline-flex items-center px-3 py-1.5 rounded-xl dark:bg-dark-700 dark:text-<?php echo $index === 0 ? 'blue' : ($index === 1 ? 'green' : ($index === 2 ? 'purple' : 'orange')); ?>-400 mb-6">
                                <span class="material-symbols-outlined mr-2"><?php echo $service['icon'] ?></span>
                                <span class="text-<?php echo $index === 0 ? 'blue' : ($index === 1 ? 'green' : ($index === 2 ? 'purple' : 'orange')); ?>-800 dark:text-<?php echo $index === 0 ? 'blue' : ($index === 1 ? 'green' : ($index === 2 ? 'purple' : 'orange')); ?>-400"><?php echo $service['title'] ?></span>
                            </div>
                            <!-- Service Headline -->
                            <h3 class="text-gray-700 dark:text-white text-2xl font-semibold mb-4"><?php echo $service['headline'] ?></h3>
                            <!-- Service Points List -->
                            <div class="flex-1 flex flex-col justify-between items-start gap-6 mb-6">
                                <ol class="relative text-gray-500 border-l border-gray-200 dark:border-dark-500 dark:text-gray-400 sm:ml-5 sm:mt-5">
                                    <?php foreach ($service['points'] as $index => $point): ?>
                                        <li class="mb-8 ml-6">
                                            <!-- Bullet Point Circle -->
                                            <span class="absolute flex items-center justify-center w-8 h-8 <?php echo ($index === count($service['points']) - 1) ? 'bg-green-600 dark:bg-green-900' : 'bg-dark-800 dark:bg-dark-700'; ?> rounded-full -left-4">
                                        <span class="material-symbols-outlined text-[21px] <?php echo ($index === count($service['points']) - 1) ? 'text-green-200 dark:text-green-300' : 'text-gray-50 dark:text-gray-400'; ?>"><?php echo $point['icon'] ?></span>
                                    </span>
                                            <!-- Point Headline -->
                                            <p class="font-medium text-gray-700 dark:text-gray-300"><?php echo $point['headline'] ?></p>
                                            <!-- Point Subheading -->
                                            <p class="text-sm"><?php echo $point['subheading'] ?></p>
                                        </li>
                                    <?php endforeach; ?>
                                </ol>
                            </div>
                            <!-- Get Started CTA -->
                            <div class="absolute bottom-4 right-4 mt-6 text-center">
                                <button onclick="selectAndScroll()"
                                        aria-describedby="tier-standard"
                                        class="mt-6 bg-black text-blue-600 dark:bg-blue-600 mx-auto flex appearance-none inline-flex hover:shadow-2xl transition-all duration-300 hover:scale-105 items-center group space-x-2.5 items-center justify-center group py-3 px-4 text-white rounded-full cursor-pointer">
                                    <?php echo $lang['web-design-cta'];?>
                                    <svg class="w-6 h-6 text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m9 5 7 7-7 7"/>
                                    </svg>

                                </button>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>



        <section id="faqs" class="bg-white dark:bg-dark-900 mb-12">
            <div class="py-8 px-4 mx-auto max-w-screen-md text-center lg:py-16 lg:px-6">
                <div class="mx-auto max-w-screen-sm">
                    <h4 class="mb-4 text-4xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['faqs-headline'] ?></h4>
                    <p class="mb-8 font-normal text-gray-500 lg:mb-16 sm:text-xl dark:text-gray-400"><?php echo $lang['faqs-subheading'] ?></p>
                </div>
                <div id="accordion-collapse" data-accordion="collapse" class="divide-y-2 divide-gray-100 dark:divide-dark-600">
                    <?php foreach ($faqSectionWebDesign as $index => $faq): ?>
                        <div>
                            <p id="accordion-collapse-heading-<?php echo $index + 1; ?>">
                                <button type="button" class="flex items-center justify-between !bg-transparent dark:!bg-transparent w-full p-5 font-medium text-left text-gray-700 focus:ring-0 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-dark-700" data-accordion-target="#accordion-collapse-body-<?php echo $index + 1; ?>" aria-expanded="false" aria-controls="accordion-collapse-body-<?php echo $index + 1; ?>">
                                    <span><?php echo $faq['question']; ?></span>
                                    <svg data-accordion-icon class="w-3 h-3 rotate-180 shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5 5 1 1 5"/>
                                    </svg>
                                </button>
                            </p>
                            <div id="accordion-collapse-body-<?php echo $index + 1; ?>" class="ml-2 hidden !bg-transparent dark:!bg-transparent text-left rounded-xl mb-2 pt-5 px-5 pb-5 mb-6 text-gray-700 dark:text-gray-300 bg-gray-100 dark:bg-dark-700">
                                <?php echo $faq['answer']; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <!-- Hero -->
        <div class="bg-gradient-to-t from-primary-500/10 via-transparent">
            <div class="max-w-[85rem] mx-auto px-4 sm:px-6 lg:px-8 py-24 space-y-8">
                <div class="w-full flex items-center justify-center">
                    <h2 class="mx-auto group inline-flex items-center gap-x-2 py-1.5 px-2 bg-primary-800/50 font-medium text-sm text-primary-900 dark:text-primary-500 rounded-full focus:outline-none cursor-pointer hover:shadow-2xl transition-all duration-300 hover:scale-105">
                        <?php echo $lang['web-design-solution-business']?>
                    </h2>
                </div>
                <!-- Title -->
                <div class="max-w-3xl text-center mx-auto">
                    <p class="block font-medium text-dark-800 dark:text-gray-200 text-4xl sm:text-5xl md:text-6xl lg:text-7xl">
                        <?php echo $lang['web-design-outro-hero-headline']?>
                    </p>
                </div>
                <!-- End Title -->

                <div class="max-w-3xl text-center mx-auto">
                    <p class="text-lg text-dark-600 dark:text-white/70"><?php echo $lang['web-design-outro-hero-subheading']?></p>
                </div>

                <!-- Buttons -->
                <div class="text-center">
                    <a class="group inline-flex items-center gap-x-2 py-3 px-4 bg-primary-500 font-medium text-sm text-neutral-800 rounded-full focus:outline-none cursor-pointer hover:shadow-2xl transition-all duration-300 hover:scale-105" onclick="selectAndScroll()" aria-describedby="tier-standard">
                        <?php echo $lang['web-design-outro-hero-cta']?>
                        <svg class="shrink-0 size-4" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="m9 18 6-6-6-6"/>
                        </svg>
                    </a>
                </div>
                <!-- End Buttons -->
            </div>
        </div>
    </section>

<?php
include_once includes('layouts/footer.php');
?>