<?php
$meta = array(
    'us' => array(
        'title' => 'WordPress Premium Support - 24/7 Maintenance & Assistance',
        'description' => 'Get comprehensive 24/7 WordPress premium support, maintenance, and assistance. Ensure your website runs flawlessly with our expert WordPress support.',
        'og:title' => 'WordPress Premium Support - 24/7 Maintenance & Assistance',
        'og:description' => 'Get comprehensive 24/7 WordPress premium support, maintenance, and assistance. Ensure your website runs flawlessly with our expert WordPress support.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'WordPress Premium Destek - 7/24 Bakım ve Yardım',
        'description' => 'Kapsamlı 7/24 WordPress premium destek, bakım ve yardım alın. Uzman WordPress desteği ile web sitenizin sorunsuz çalışmasını sağlayın.',
        'og:title' => 'WordPress Premium Destek - 7/24 Bakım ve Yardım',
        'og:description' => 'Kapsamlı 7/24 WordPress premium destek, bakım ve yardım alın. Uzman WordPress desteği ile web sitenizin sorunsuz çalışmasını sağlayın.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/header.php');
?>
    <div id="content" class="container mx-auto lg:mt-12 mt-12">

        <section class="bg-gray-50 dark:bg-dark-800 mt-4 h-[40em] sm:h-[35em] overflow-hidden skeleton">
            <div class="py-6 px-4 mx-auto max-w-screen-xl text-center pb-0 lg:pt-12 lg:px-4">
                <h1 class="text-gray-900 mb-4 text-sm font-semibold dark:text-gray-400"><?php echo $lang['wordpress-premium-support-superior'] ?></h1>
                <h2 class="mb-2 text-4xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['wordpress-premium-support-headline']; ?></h2>
                <div class="mb-3">
                    <p class="text-xl tracking-tight font-medium text-gray-700 dark:text-gray-300"><?php echo $lang['wordpress-premium-support-subheading']; ?></p>
                </div>
                <div class="flex items-center justify-center mt-6">
                    <button data-scroll-target="features" class="scroll-link flex items-center justify-between space-x-2 text-center text-white bg-dark-700 focus:ring-0 font-medium rounded-full text-sm p-3 py-2.5 dark:bg-dark-500 focus:outline-none" type="button">
                        <span><?php echo $lang['wordpress-premium-support-cta']; ?></span>
                        <span class="material-symbols-outlined flex items-center justify-center w-7 h-7 p-2 bg-dark-600 dark:bg-dark-800 rounded-full font-bold text-2xl">chevron_right</span>
                    </button>
                </div>
                <div class="flex justify-center space-x-2 mt-24">
                    <div>
                        <img class="w-28" src="<?php echo asset('images/content/logos/wordpress.png')?>" alt="WordPress Logo">
                        <a href="https://wordpress.com/" rel="nofollow" target="_blank" class="mb-2 inline-flex text-sm tracking-tight font-medium items-center text-blue-600 dark:text-blue-400 dark:text-blue-500 hover:underline items-center">
                            <span>WordPress</span>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <div id="navigateBar" class="invisible fixed max-h-14 -translate-x-1/2 left-1/2 z-20 w-full max-w-[7em] mx-auto flex space-x-3">
            <div class="navigation_items grid grid-cols-3 justify-between bg-dark-600 dark:bg-dark-600 dark:bg-opacity-75 backdrop-blur bg-opacity-75 rounded-full p-1 w-[77%] h-14" role="group">
                <button type="button" id="featuresButton" class="nav-button text-white dark:text-white text-xs !font-bold border-b-2 border-transparent rounded-full">
                    <?php echo $lang['navigateBar-features']?>
                </button>
                <button type="button" id="plansButton" class="nav-button text-white dark:text-white text-xs !font-bold border-b-2 border-transparent rounded-full">
                    <?php echo $lang['navigateBar-plans']?>
                </button>
                <button type="button" id="faqsButton" class="nav-button text-white dark:text-white text-xs !font-bold border-b-2 border-transparent rounded-full">
                    <?php echo $lang['navigateBar-faqs']?>
                </button>
            </div>
            <div class="action-button text-white dark:text-white bg-dark-600 dark:bg-dark-600 dark:hover:bg-dark-500 dark:!bg-opacity-75 backdrop-blur !bg-opacity-75 rounded-full flex items-center justify-center w-14 h-14" role="group">
                <button id="navigateBarPopupButton" data-dropdown-toggle="navigateBarPopup" data-dropdown-trigger="hover" class="flex items-center justify-center w-full h-full text-xs font-medium rounded-full text-white dark:text-white">
                    <span id="navigateBarAction" class="material-symbols-outlined font-bold">add</span>
                    <svg id="navigateBarLoading" aria-hidden="true" class="w-7 h-7 text-gray-400  animate-spin dark:text-gray-600 fill-purple-400 dark:fill-purple-500 spinner-status hidden" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                    </svg>
                </button>
            </div>
        </div>
        <!-- Dropdown menu -->
        <div id="navigateBarPopup" class="z-10 hidden bg-dark-600 dark:bg-dark-600 backdrop-blur bg-opacity-75 dark:bg-opacity-75 shadow-sm dark:shadow-sm-light divide-y divide-gray-100 rounded-3xl shadow max-w-xs min-w-xs">
            <ul class="navigateBarPlans py-2 text-sm text-gray-200 dark:text-gray-200 w-full p-2 space-y-1" aria-labelledby="navigateBarPopupButton">
            </ul>
        </div>
        <div id="navigateBarActivate"></div>
        <section id="features" class="bg-white dark:bg-dark-900">
            <div class="mx-auto max-w-screen-xl lg:py-12">
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="block text-center overflow-hidden bg-gradient-to-b from-green-50 dark:from-dark-800 to-transparent justify-center bg-gray-100 dark:bg-dark-900 p-5 border border-gray-200 dark:border-gray-700 rounded-3xl mt-8 sm:mt-0 !mx-auto w-full h-[20em] sm:min-w-[25em] sm:h-[25em] bg-contain bg-center bg-no-repeat bg-image-[url('<?php echo asset('images/content/creative-image.png')?>')] bg-blend-multiply skeleton">
                            <p class="text-xl md:text-3xl font-bold text-green-600/100 dark:text-green-500/100"><?php echo $lang['wordpress-premium-feature-first'] ?></p>
                            <p class="text-xl md:text-3xl font-bold text-green-600/75 dark:text-green-500/75"><?php echo $lang['wordpress-premium-feature-first'] ?></p>
                            <p class="text-xl md:text-3xl font-bold text-green-600/50 dark:text-green-500/50"><?php echo $lang['wordpress-premium-feature-first'] ?></p>
                            <p class="text-xl md:text-3xl font-bold text-green-600/25 dark:text-green-500/25"><?php echo $lang['wordpress-premium-feature-first'] ?></p>

                            <div id="circle">
                                <svg class="!relative !h-57" version="1.1" xmlns="http://www.w3.org/2000/svg"
                                     xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="300px"
                                     height="300px" viewBox="0 0 300 300" enable-background="new 0 0 300 300"
                                     xml:space="preserve">
                                            <defs>
                                                <path id="circlePath" d="M 150, 150 m -60, 0 a 60,60 0 0,1 120,0 a 60,60 0 0,1 -120,0 "/>
                                            </defs>
                                    <circle cx="150" cy="100" r="75" fill="none"/>
                                    <g>
                                        <use xlink:href="#circlePath" fill="none"/>
                                        <text class="fill-gray-400 dark:fill-gray-300">
                                            <textPath xlink:href="#circlePath">
                                                <?php echo $lang['wordpress-premium-circle'] ?>
                                            </textPath>
                                        </text>
                                    </g>
                                    </svg>
                            </div>
                        </div>
                        <div class="space-y-6 mr-0 sm:mr-8">
                            <div class="flex items-center text-center overflow-hidden bg-gray-100 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-h-[11.5em] sm:min-w-[20em]">
                                <p class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['wordpress-premium-feature-second'] ?></p>
                            </div>
                            <div class="flex items-center text-center overflow-hidden bg-gray-100 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-h-[11.5em] sm:min-w-[20em]">
                                <p class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['wordpress-premium-feature-third'] ?></p>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="flex justify-end items-end mx-auto text-start overflow-hidden bg-gray-100 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-w-[15em] sm:h-[15em]">
                            <p class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-xl md:text-2xl font-bold"><?php echo $lang['wordpress-premium-feature-fourth'] ?></p>
                            <img class="w-16 h-16" src="<?php echo asset('images/content/emoji__eriyz672w3e6_large.png')?>" alt="Shocked Emoji">
                        </div>
                        <div class="flex items-start text-center overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl skeleton w-full min-h-[15em] sm:min-h-[15em] sm:min-w-[30em] bg-cover bg-center bg-no-repeat bg-[url('<?php echo asset('images/content/optimized-performance.jpg')?>')] bg-blend-multiply">
                            <p class="text-gray-200 text-2xl md:text-3xl font-bold backdrop-blur-[2px] p-8 md:p-6 w-full min-h-[15em] sm:min-h-[8em] flex items-end"><?php echo $lang['wordpress-premium-feature-fifth'] ?></p>
                        </div>
                    </div>
                </div>
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="flex items-center text-center overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl skeleton w-full min-h-[10em] sm:min-w-[15em] sm:h-[30em] bg-cover bg-center bg-no-repeat bg-[url('<?php echo asset('images/content/content-management.jpg')?>')] bg-blend-multiply">
                            <p class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold backdrop-blur-[2px] p-8 md:p-6 w-full min-h-[15em] md:h-full flex items-end"><?php echo $lang['wordpress-premium-feature-sixth'] ?></p>
                        </div>
                        <div class="flex items-end text-center overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl skeleton w-full min-h-[20em] sm:min-h-[15em] sm:min-w-[30em] bg-cover bg-center bg-no-repeat bg-[url('<?php echo asset('images/content/plugin-management.jpg')?>')] bg-blend-multiply">
                            <p class="text-white text-2xl md:text-3xl font-semibold backdrop-blur-[2px] p-8 md:p-6 w-full min-h-[15em] md:h-full flex items-start"><?php echo $lang['wordpress-premium-feature-seventh'] ?></p>
                        </div>
                    </div>
                </div>
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="space-y-6">
                            <div class="flex justify-start items-end text-start overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl skeleton w-full min-h-[15em] sm:min-w-[25em] sm:h-[30em] bg-cover bg-center bg-no-repeat bg-[url('<?php echo asset('images/content/theme-customization.jpg')?>')] bg-blend-multiply">
                                <p class="text-transparent bg-clip-text bg-gradient-to-b to-white from-sky-200 text-2xl md:text-3xl font-bold backdrop-blur-[3px] p-8 md:p-6 w-full min-h-[15em] md:h-full flex items-start"><?php echo $lang['wordpress-premium-feature-eighth'] ?></p>
                            </div>
                            <div class="flex justify-between items-end text-start overflow-hidden bg-gray-100 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[12em] sm:min-w-[15em] sm:h-[30em] bg-gradient-to-t from-green-50 to-transparent dark:from-dark-800">
                                <p class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['wordpress-premium-feature-ninth'] ?></p>
                                <svg width="82" height="82" viewBox="0 0 82 82" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                                    <rect width="82" height="82" fill="url(#pattern0)"/>
                                    <defs>
                                        <pattern id="pattern0" patternContentUnits="objectBoundingBox" width="1" height="1">
                                            <use xlink:href="#image0_15_323" transform="scale(0.0138889)"/>
                                        </pattern>
                                        <image id="image0_15_323" width="72" height="72" xlink:href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAC/VBMVEUAAACpmZKyp66BbFmAUxKGblGOeWx8YUWmkXWXgzZmSSXIkyqsgR9zVC2xgSe6hSa1mRVyTxaqgyR5X0HMjyHQnxNePA94Vh5dPRh0UyNtUTTKrFl+ZEKcdCloRhReOxFhQR1lRiKSdDVrTS3JqFG8pHOmfStjRRR8VhdyUx+hgjB3XDGKaj2khkzIrGbPpx9gPhZsTxprUTTJnyZ+XSfCoUSxkU1aOAx3UxWNdRymjxvUnCqJah3UwVKUbS7FrkqWbS+0jTbHoDbIo0G1lkGYfhfHkSnOvVCkdy6yizSOYyS7lDrNoTi5miTKnjfAmCz//41KOQ9GNw///4hTQA///4GQchNXQxBPPQ///nqXeROGczBbRw+TeBN1URH//HKcfhRxWRJNOw/+92tgSxCSdROPbxO9mRmZfBN2XRJuVhFlUBBDNA9wUBiKbxKMaxKHZhJ+ZBKBZxH77WLKrTuegjWfcBxpUxHWsUeZfC+McxP8/Yiujzp6Wx1kTBOHaxKEYhJ7YRLDoUC6mT+ylz62mTLDjyp+YBx1VRpuSROEahJ4YRHfuErjvDuNdzGMbSiWdiSDZiSLax6HaR5nRBD39oLOq0bXu0LwyjipiDW8kBaUaRaAXhH+8mbizUvHpkOqjTe9mjS0kC6peSPHoBmkfxL95F7qxTiVdiyQcSqSbyHarR2CZRteRxJ3VhH15VzyzFK+nz+jhTGtjS2Cbyy8jiiefyWQdh+1jxlpUBeNZBaGWBX621n301bu21SliSrEhyG7ghx9XBOXcBBjPxDliwaqUwTm1FXsxFDmvk2kjDvCpDPEmiGKcSCxhxisjhXLlhOqhRKyexHt4GbOu0vLqTa2lDbXrDTsuTDQnzCddxSdgxPPbgT59nLUyFLaw0vdtDeQfTbPmCZ7UxGqdg6jdgr7zTe4ny3fuCyLXhjKrxaWfBKjaw3XiAyLTQfBhAbQhgO/XAOcSAGQPgDiqS+ohiqTXA28cQqdYwqtYweTUgaWeRrWfQbhxEPkxVV1IjiZAAAAUHRSTlMACwUj/jATQBf+m/7+jf7+/u/pS/7+/tLQtFlYU/398r6sfnxzH/3v58SedmRKN/rj3GrYoZJd/vfa++vn3c/FurWxmoPs6dfU0cnHxsXBwSVd3GIAAAiiSURBVFjD7dd5OBRxGAfwxSrKmUrOSgfd933f9yFHIatFtqVtLdlsORZrkdZit2JXOdaG6EAhOhxFOaPIWXJ03/f99M6MbR/d5b+evn/PfOZ935nfzPxw//On6aarrKzRretOd62peLz6QPmuOrrjWu/SRXqBA+S6WI8RIeiuSDVdL3BQlxy55Xdb+QTRydhIrmZXSpIZTi9gthLo7JIahmePLkijepXXU5lMOvtaSRq3b7/xf3vvFOaRyusdnMUAVUe6UYynDNCQ+Stocml8Zb2DOEuJ3dzsERl2pG/f/j3kZf+ioDXJJLFlgYBUzuZwajxCKaf0+X3HDpL784LGJGeJzcvj4wVsTkIs62VYWCAl6Hzfftp/OCqZ+cl9Ki0tSfF9LrMTImL9/BmMpDBPoPoP7P5H/Y0ekywQm4slkG91WkyxWyJQ+sio/gCahBRErUCgngBFu9f4sTxiUIrft98ghd91hkzoI2inmldkkQCKiIh1/+i7L9oXLKACgRqg/ZuPgk6fy1UFTOvKCsFlgBL89xx0v7THfV90qp+HW1JY4G+PSnbB5ccPXkVZN1RmCQR1EZyaTwcPnj5+8dIeKAuhAoAaqyz3O509fP0mh7bZclOlIK8u4k5N0cEiV9dDZ45fhLIQihtA0T//G6tGp/eHt69afbaZW4rL865FXKu5cv1KU5PdgUOnz3yhYOr9f7lqJj1sfPuOEEzzdqivAqjaD6C9FhY2dnZIWZek1C9WjcLqD42Fjwg+PjTngra85oTbfleu7t27a5cZWEhZx5Fh+XkwuJ4wqp+tmtGLG58WPspPYTKdhQ/yOBx/XwzaZWJmZmFjY+eKdohQyA38yarRyQUoh1sWHp4tfMDmNMfsK8KgtSYQM7QsKaX/o0cBbv7rp08LeYqKjMRQOr0nZ3va1RvXMQgNWhfaoXt0qgc8ofyx3181CisKCwvfcRUVFd3chorqOCVpN7ZjkInJWollgXSIzD01JjGAwv/uqhnd69mzZ4+sbqKSyjWOf/GN20VNTRYWZmYmUgosrEOM0v/OqtGhP3/+HG8VchPCUGneH1PsPv3G2WOudjY2YJl1KktCJXkGGX4zqoWvnj9/FGBlFYJEFUbEKnnvv33/QbAO2NlIC0MttEOgIoH6atXIzHv37Nm7MCsrhOLCrN1843aHZryMK8EwOwyTWGhZMCxfoPRh1QCg0A1baMsKC9++OWGFJqmOk6q4L4N3GIJgsYBhXWKWpKxDZxCKG6g/QKP7xNlzR8qis37a+PrBCUzSe8FhFbuXHdYLPXw4HAJaemesoyzo8CJCUQwNc1Ti9EYis1Zt/PCkHYO4otr9MSzfYABCEYrHS0nhhQPWMTO0S5OOsg7AsHwjeZQgUV3s7CE43ODcCxee1CNQSFISu3Z/cWqG06lAz4AUHi8ckQIgKbzMjHMYhswfmsTKOgRUWkB2dXPkZGTpA/T+BEw6MVGvLmF7cQ15/QbT9Ue8vE5RAj09gfH09CSTyT4pZaGdMCgLOjyzJ1ZYlxA7CT5EFy48fJxpFZLIYAwVvYiILuZutF1nbGxsuwE41AMwMJBIdCQSybTwDsz1AGaZ2bgWKZUmVM/BKayEgh5nhjAYGUNVVGsTUhNPma4DCI3UswcQsmOHI9GHl4lgRTAysHbtarpNStg+C16z4FSGMtzSXqqo9rz1MSZlvamxNOvQgGeLeBuP2NvbezntIAaj2A3AmvbuLRHcAWj0jIePq8SMtHPpcezcF7f2ZxBNN2CxtbWVWhJvA+pttLd3ciSnYNiV24Jr0UtwOjMaq9rEaenpcSd759beqg53MoVD15siwTgJ1smDg4DbQUSwTYKS1Dk4nZ6v29obzoHTs6V3RES6jz0cgQU8FOzMbUWDeBjn5MgkxbKG4waz37a3N4DDbundcutOZrD9Rics9pAjKIh5kmYxTeqZRpH8YwzgeXxQUNAQBwX1hhGV7qTZOxEhjpAdEAC9JCKAUk/KGVNLWYq6uMGqb6jbNkFBvWFEtVn3aV7kYB+fYCTwFH5DSkWsX9CmiEtiNOUAeuXsgkJ5LbXJFQ1kR5fdSFyQ0Gg0H1AxU4oC6QUkmADaEkjVYQNlcINVcqJo71VVc3Pzku+UVjQ4uuzEsg2Nt7e3hKVJWDLGYqgXvyDZ32s8DiB8K9lcJS+v6uSdMWpq1sSd1l+yGWKOsRL1G5gclZW8ZZwcvEWG4glHs0VVVaKWZBJJzcXl/hZJ7t+/bwmRkIAicXDY6eAgLde5Pj7eWlkW/kIBIkTR2+gqyWPU7lWQrTdJg3KIJdXMMQxCpVK9nZ2ZVEE8aZo8+oLEBwURhEJ6zzGk+HsOLlu+UVCh43QqxBlOZ0ZF5efnTyUQ8kWl8WoG6Ct7KT6IH3Q3W6mllHRPLd/cUhK0AOziBQVCoZCa7cyMyj969OhUdSPNYVoTlUeM1NUiCJWySMPRl7/M3Bw+n99KP1maFX/PPEpSORWtHALXzhbm4PF4IyMjAoESFjBMt7u8XDcZ9JsmPyyb3mt4x0fXIOf8lPM5SifLs+5VHGWi5zLh0si1CWjUhw1UHjReu7u8rrr3ieKyEZ22ZiMNRslItnvqQXw8XUlJiaQWRcDOplDUx0H1PZRn1ieFsKZJfq5GZJtbsVI0fvjTr0XIEdJFovIsqqH6ODgdmofqFaB62eGkdMXo2wYdV9dsK7vpAY/Mj6Khjs+GuyYOV8aa77SHIzFY13tpyyKOVpv4BKush+wPIdkR6vicu9lGI2S+s6sUZDCuXp/ZQ1t7kGZ7VZlbjKHGz3Y0ulqamhM1ZL+/rcyMvHqVjsc/ekNPcvPw6iHzEwj9D/jB35yBUmVmWrS731A9hptHpFc/ub/eMhsoVWwKjWT5sViR3CMD5Luw+R7Zi6TWsLOMRyMawt67K5FfuGqC2vRF0ybCf38XoyA/apT8EFnc//xr+Qws6ySAooEKkwAAAABJRU5ErkJggg=="/>
                                    </defs>
                                </svg>
                            </div>
                        </div>
                        <div class="space-y-6">
                            <div class="flex items-start overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full h-[12em] sm:min-h-[20em] sm:min-w-[10em] bg-gradient-to-tl from-green-50 to-transparent dark:from-dark-800">
                                <p class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['wordpress-premium-feature-tenth'] ?></p>
                            </div>
                            <div class="flex items-end md:items-start text-left md:text-center overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl skeleton w-full h-[25em] sm:min-h-[40em] sm:min-w-[10em] bg-cover bg-center bg-no-repeat bg-[url('<?php echo asset('images/content/website-excellence.jpg')?>')] bg-blend-multiply">
                                <p class="text-transparent bg-clip-text bg-gradient-to-r to-gray-50 from-gray-200 text-2xl md:text-3xl font-bold backdrop-blur p-8 md:p-6 w-full min-h-[20em] md:h-full flex items-end md:items-start"><?php echo $lang['wordpress-premium-feature-eleventh'] ?></p>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </section>
        <section class="bg-white dark:bg-dark-900">
            <div class="mx-auto max-w-screen-md">
                <div class="flex p-4 md:p-0 pt-8 flex items-center">
                    <div class="space-y-8 w-full">
                        <div class="flex items-center justify-center text-center bg-gray-50 dark:bg-dark-800 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 md:h-80 skeleton">
                            <div class="text-center">
                                <h2 class="text-gray-600 dark:text-white text-xl md:text-2xl font-bold mb-2"><?php echo $lang['why-wordpress-premium-support-headline'] ?></h2>
                                <div class="flex-1 flex flex-col justify-between items-center gap-4">
                                    <p class="text-lg font-normal text-gray-500 dark:text-gray-400"><?php echo $lang['why-wordpress-premium-support-subheading'] ?></p>
                                </div>
                                <div class="flex justify-center mt-3">
                                    <div class="grid grid-cols-1 md:grid-cols-2 md:space-x-8">
                                        <ul class="max-w-md space-y-1 text-gray-500 list-inside dark:text-gray-400 mt-1.5 sm:mt-3">
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0"
                                                     aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                                     fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['continuous-website-care'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0"
                                                     aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                                     fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['timely-updates'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0"
                                                     aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                                     fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['round-the-clock-support'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0"
                                                     aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                                     fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['security-enhancements'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0"
                                                     aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                                     fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['website-performance'] ?>
                                            </li>
                                        </ul>
                                        <ul class="max-w-md space-y-1 text-gray-500 list-inside dark:text-gray-400 mt-1.5 sm:mt-3">
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0"
                                                     aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                                     fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['content-management'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0"
                                                     aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                                     fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['plugin-management'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0"
                                                     aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                                     fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['theme-customization'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0"
                                                     aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                                     fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['maintenance-audits'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0"
                                                     aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                                     fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['website-optimization'] ?>
                                            </li>
                                        </ul>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="bg-white dark:bg-dark-900 mb-12">
            <div class="mx-auto text-center pt-8">
                <h2 class="my-4 text-4xl tracking-tight font-bold text-gray-600 dark:text-gray-50"><?php echo $lang['our-wordpress-premium-support-services'] ?></h2>
            </div>
            <div class="py-2 px-4 mx-auto max-w-screen-xl lg:py-4 space-y-8">
                <div class="grid md:grid-cols-4 gap-4">
                    <?php foreach ($wordpressPremiumSupportServices as $service): ?>
                        <div class="bg-gray-50 dark:bg-dark-800 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton">
                            <div class="bg-primary-100 text-primary-800 text-xs font-medium inline-flex items-center px-2.5 py-0.5 rounded-md dark:bg-dark-800 dark:text-purple-400 mb-4">
                                <span class="material-symbols-outlined mr-2"><?php echo $service['icon'] ?></span>
                                <p class="text-blue-800 text-xs font-medium dark:text-purple-400"><?php echo $service['title'] ?></p>
                            </div>
                            <p class="text-gray-700 dark:text-white text-2xl font-bold mb-2"><?php echo $service['headline'] ?></p>
                            <div class="flex-1 flex flex-col justify-between items-start gap-4">
                                <ol class="relative text-gray-500 border-l border-gray-200 dark:border-gray-700 dark:text-gray-400 sm:ml-5 sm:mt-5">
                                    <?php foreach ($service['points'] as $index => $point): ?>
                                        <li class="mb-10 ml-6">
                                    <span class="absolute flex items-center justify-center w-8 h-8 <?php echo ($index === count($service['points']) - 1) ? 'bg-green-200 dark:bg-green-900' : 'bg-blue-100 dark:bg-dark-800'; ?> rounded-full -left-4 ring-4 ring-white dark:ring-gray-900 0">
                                        <span class="material-symbols-outlined text-[18px]  <?php echo ($index === count($service['points']) - 1) ? 'text-green-500 dark:text-green-400' : 'text-gray-500 dark:text-gray-400'; ?>"><?php echo $point['icon'] ?></span>
                                    </span>
                                            <p class="font-medium leading-tight text-gray-700 dark:text-gray-300"><?php echo $point['headline'] ?></p>
                                            <p class="text-sm"><?php echo $point['subheading'] ?></p>
                                        </li>
                                    <?php endforeach; ?>
                                </ol>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <section class="bg-white dark:bg-dark-900" id="plans">
            <div class="pb-6 pt-1 px-4 mx-auto max-w-screen-xl lg:pt-2 lg:pb-8 lg:px-6">
                <div class="mx-auto text-center mb-8 lg:mb-10">
                    <h2 class="mb-4 text-gray-800 dark:text-gray-400 text-sm font-semibold"><?php echo $lang['wordpress-premium-pricing-superior'] ?></h2>
                    <h3 class="mb-4 text-4xl tracking-tight font-bold text-gray-900 dark:text-gray-100"><?php echo $lang['wordpress-premium-pricing-headline'] ?></h3>
                    <p class="mb-5 font-normal text-gray-500 sm:text-xl dark:text-gray-400 sm:w-[80%] mx-auto max-w-screen-md "><?php echo $lang['wordpress-premium-pricing-subheading'] ?></p>
                </div>
                <div id="productCards" class="space-y-4 lg:grid lg:grid-cols-3 sm:gap-3 xl:gap-4 lg:space-y-0"></div>
            </div>
        </section>
        <section class="bg-white dark:bg-dark-900">
            <div class="py-8 px-4 mx-auto max-w-screen-xl text-center lg:py-16 lg:px-6">
                <div class="mx-auto max-w-screen-sm">
                    <h3 class="mb-4 text-4xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['case-studies-headline'] ?></h3>
                    <p class="mb-8 font-normal text-gray-500 lg:mb-16 sm:text-xl dark:text-gray-400"><?php echo $lang['case-studies-subheading'] ?></p>
                </div>

                <div id="default-carousel" class="relative w-full" data-carousel="static">
                    <!-- Carousel wrapper -->
                    <div class="relative z-10 h-96 overflow-hidden rounded-3xl md:h-96">
                        <!-- Item -->
                        <?php foreach ($caseStudiesWordPressSupport as $study): ?>
                            <div class="hidden duration-700 ease-in-out" data-carousel-item>
                                <figure>
                                    <blockquote class="mx-auto mb-8 max-w-2xl text-gray-500 dark:text-gray-400">
                                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white"><?php echo $study['title']; ?></h3>
                                        <p class="my-4"><?php echo $study['challenge']; ?></p>
                                        <p class="my-4"><?php echo $study['solution']; ?></p>
                                    </blockquote>
                                    <ul class="list-disc list-inside mx-auto max-w-2xl text-gray-500 dark:text-gray-400">
                                        <?php foreach ($study['results'] as $result): ?>
                                            <li><?php echo $result; ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </figure>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <!-- Slider controls -->
                    <button type="button" class="absolute top-0 left-0 z-10 flex items-center justify-center h-full px-4 cursor-pointer group focus:outline-none" data-carousel-prev>
                <span class="inline-flex items-center justify-center w-10 h-10 rounded-full bg-gray-300 dark:bg-gray-400/30 group-hover:bg-gray-300/60 dark:group-hover:bg-gray-400/60 group-focus:ring-4 group-focus:ring-white dark:group-focus:ring-gray-800/70 group-focus:outline-none">
                    <svg class="w-4 h-4 text-white dark:text-gray-800" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 1 1 5l4 4"/>
                    </svg>
                    <span class="sr-only">Previous</span>
                </span>
                    </button>
                    <button type="button" class="absolute top-0 right-0 z-10 flex items-center justify-center h-full px-4 cursor-pointer group focus:outline-none" data-carousel-next>
                <span class="inline-flex items-center justify-center w-10 h-10 rounded-full bg-gray-300 dark:bg-gray-400/30 group-hover:bg-gray-300/60 dark:group-hover:bg-gray-400/60 group-focus:ring-4 group-focus:ring-white dark:group-focus:ring-gray-800/70 group-focus:outline-none">
                    <svg class="w-4 h-4 text-white dark:text-gray-800" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 9 4-4-4-4"/>
                    </svg>
                    <span class="sr-only">Next</span>
                </span>
                    </button>
                </div>
            </div>
        </section>

        <section id="faqs" class="bg-white dark:bg-dark-900 mb-12">
            <div class="py-8 px-4 mx-auto max-w-screen-md text-center lg:py-16 lg:px-6">
                <div class="mx-auto max-w-screen-sm">
                    <h3 class="mb-4 text-4xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['faqs-headline'] ?></h3>
                    <p class="mb-8 font-normal text-gray-500 lg:mb-16 sm:text-xl dark:text-gray-400"><?php echo $lang['faqs-subheading'] ?></p>
                </div>
                <div id="accordion-collapse" data-accordion="collapse" class="divide-y-2 divide-gray-200 dark:divide-dark-600">
                    <?php foreach ($faqSectionWordPressSupport as $index => $faq): ?>
                        <div>
                            <p id="accordion-collapse-heading-<?php echo $index + 1; ?>">
                                <button type="button" class="flex items-center justify-between !bg-transparent dark:!bg-transparent w-full p-5 font-medium text-left text-gray-700 focus:ring-0 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-dark-700" data-accordion-target="#accordion-collapse-body-<?php echo $index + 1; ?>" aria-expanded="false" aria-controls="accordion-collapse-body-<?php echo $index + 1; ?>">
                                    <span><?php echo $faq['question']; ?></span>
                                    <svg data-accordion-icon class="w-3 h-3 rotate-180 shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5 5 1 1 5"/>
                                    </svg>
                                </button>
                            </p>
                            <div id="accordion-collapse-body-<?php echo $index + 1; ?>" class="ml-2 hidden !bg-transparent dark:!bg-transparent text-left rounded-xl mb-2 pt-5 px-5 pb-5 mb-6 text-gray-700 dark:text-gray-300 bg-gray-100 dark:bg-dark-700">
                                <?php echo $faq['answer']; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>

    </div>

<?php
include_once includes('layouts/footer.php');
?>

<script>
    function loadProducts() {
        $.ajax({
            type: "POST",
            url: "/get_products", // Update with the correct path to your PHP script
            dataType: "json",
            data: { category: "wp-support" }, // You can pass the category here
            success: function (data) {
                const productCardsContainer = $("#productCards"); // Specify the container for product cards
                const productCardsNavigateBar = $(".navigateBarPlans"); // Specify the container for product cards
                // Clear existing content in the container
                productCardsContainer.empty();
                console.log(data);
                $.each(data, function (index, product) {
                    // Extract features and convert them to an HTML list
                    let featuresHtml = '';
                    if (product.features) {
                        if (Array.isArray(product.features)) {
                            featuresHtml = '<ul class="mb-8 space-y-4 text-left md:h-[17em]">';
                            product.features.forEach(feature => {
                                featuresHtml += `<li class="flex items-center space-x-3">
                                <svg class="flex-shrink-0 w-5 h-5 text-green-500/50 dark:text-green-400/50" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                </svg>
                                <span class="text-gray-600 dark:text-gray-300">${feature}</span>
                            </li>`;
                            });
                            featuresHtml += '</ul>';
                        } else if (typeof product.features === 'string') {
                            featuresHtml = product.features;
                        } else {
                            featuresHtml = 'N/A';
                        }
                    }

                    // Create a product card
                    const productCard = $("<div>");
                    productCard.addClass("flex flex-col p-6 mx-auto max-w-lg text-center text-gray-900 !shadow-none border border-gray-200 dark:border-gray-700 rounded-3xl xl:px-4 xl:py-8 dark:text-white !bg-gray-50 dark:!bg-dark-800 skeleton");
                    productCard.html(`
                    <div class="md:h-72">
                        <p class="mb-2 text-xl tracking-tight font-bold text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700">${product.name}</h2>
                        <p class="font-medium text-gray-500 sm:text-lg dark:text-gray-400 md:h-20">${product.description}</p>
                        <div class="my-6">
                            <span class="mr-2 text-3xl font-semibold text-gray-700 dark:text-gray-300">${product.price}<span class="text-xl">/<?php echo $lang['mo']?></span></span>
                         </div>
                    </div>
                    <ul role="list" class="mb-14 space-y-4 text-left h-full">
                        <hr class="mb-6 border-gray-200 sm:mx-auto border-2 w-56 mx-auto dark:border-dark-600" />
                        ${featuresHtml}
                    </ul>
                    <div data-product-id="${product.product_id}" class="add-to-cart-btn flex items-center justify-between mx-4">
                            <span>
                                <svg aria-hidden="true" class="w-8 h-8 text-gray-200 animate-spin dark:text-gray-600 fill-blue-600 spinner-status opacity-0" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                                    <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                                </svg>
                                <span class="sr-only">Loading...</span>
                            </span>
                            <button class="flex items-center button-ux btn-arrow cursor-pointer text-white bg-blue-600 hover:bg-blue-700 focus:ring-4 focus:ring-primary-200 font-medium rounded-3xl text-sm px-5 py-3 text-center dark:text-white dark:focus:ring-primary-900" >
                                <?php echo $lang['web-hosting-cta'];?>
                            </button>
                    </div>

                `);
                    productCardsContainer.append(productCard);
                    productCardsContainer.append(productCard);
                    const productCardNavigateBar = $("<li>");
                    productCardNavigateBar.html(`
                    <button data-product-id="${product.product_id}" class="add-to-cart-btn flex justify-between items-center space-x-4 w-full px-2.5 py-2.5 hover:bg-dark-500 hover:text-white dark:hover:bg-dark-500 dark:hover:text-white rounded-2xl">
                        <span class="text-sm block text-left font-semibold text-gray-300 dark:!text-gray-300">
                            <span>
                                ${product.name}
                            </span>
                            <br>
                            <span class="!text-xs !text-extralight !text-gray-400">
                            <p class="flex items-center justify-start space-x-1 !text-xs !text-extralight text-gray-400 dark:!text-gray-400">
                                <span class="material-symbols-outlined text-[14px]">language</span>
                                <span>${product.features[0]}</span>
                            </p>
                            <p class="flex items-center justify-start space-x-1 !text-xs !text-extralight text-gray-400 dark:!text-gray-400">
                                <span class="material-symbols-outlined text-[14px]">storage</span>
                                <span>${product.features[1]}</span>
                            </p>
                            </span>
                        </span>
                        <span class="text-sm font-medium text-gray-300 dark:!text-gray-300">${product.price}<span class="text-xs">/<?php echo $lang['mo']?></span></span>
                    </button>
                    `);
                    productCardsNavigateBar.append(productCardNavigateBar);
                });
            },
            error: function (error) {
                console.error("Error fetching product data:", error);
            },
        });
    }
    loadProducts();
</script>
