<?php
include_once includes('head.php');

// To call this page, in the browser type:
// http://localhost/user/1

include_once includes('config.php');


$query = "SELECT username, profile_picture, first_name, last_name FROM users WHERE username = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $username); // Assuming $username is the value you want to search for
$stmt->execute();
$stmt->bind_result($username, $profilePicture, $firstName, $lastName);

// Fetch the results
$stmt->fetch();

// Close the statement
$stmt->close();

// Display the user's name and other information
$user_username = $username;
$user_profilePicture = $profilePicture;
$user_firstName = $firstName;
$user_lastName = $lastName;

function getUserAvatar($this_profilePicture, $this_firstName, $this_lastName, $this_username)
{
    // Check if the profile picture is empty
    if (empty($this_profilePicture)) {
        // Generate avatar based on initials
        $avatar = strtoupper(user . phpsubstr($this_firstName, 0, 1) . substr($this_lastName, 0, 1));

        // Display the avatar
        $avatarHTML = '<div class="relative inline-flex items-center justify-center w-24 h-24 mb-3 rounded-full shadow-lg overflow-hidden bg-gray-100 dark:bg-gray-600"><span class="font-medium text-gray-600 dark:text-gray-300">' . $avatar . '</span></div>';
    } else {
        // Display the user's profile picture
        $avatarHTML = '<img class="relative inline-flex w-24 h-24 mb-3 overflow-hidden rounded-full " src="' . asset($this_profilePicture) . '" alt="' . $this_username . ' Profile Picture">';
    }

    return $avatarHTML;
}

$userAvatar = getUserAvatar($profilePicture, $firstName, $lastName, $username);


// Display the user's profile picture
?>

<div class="w-full max-w-sm bg-white border border-gray-200 rounded-lg shadow dark:bg-gray-800 dark:border-gray-700">
    <div class="flex justify-end px-4 pt-4">
        <button id="dropdownButton" data-dropdown-toggle="dropdown" class="inline-block text-gray-500 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-700 focus:ring-4 focus:outline-none focus:ring-gray-200 dark:focus:ring-gray-700 rounded-lg text-sm p-1.5" type="button">
            <span class="sr-only">Open dropdown</span>
            <svg class="w-6 h-6" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path d="M6 10a2 2 0 11-4 0 2 2 0 014 0zM12 10a2 2 0 11-4 0 2 2 0 014 0zM16 12a2 2 0 100-4 2 2 0 000 4z"></path></svg>
        </button>
        <!-- Dropdown menu -->
        <div id="dropdown" class="z-10 hidden text-base list-none bg-white divide-y divide-gray-100 rounded-lg shadow w-44 dark:bg-gray-700">
            <ul class="py-2" aria-labelledby="dropdownButton">
                <li>
                    <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:hover:bg-gray-600 dark:text-gray-200 dark:hover:text-white">Edit</a>
                </li>
                <li>
                    <a href="#" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:hover:bg-gray-600 dark:text-gray-200 dark:hover:text-white">Export Data</a>
                </li>
                <li>
                    <a href="#" class="block px-4 py-2 text-sm text-red-600 hover:bg-gray-100 dark:hover:bg-gray-600 dark:text-gray-200 dark:hover:text-white">Delete</a>
                </li>
            </ul>
        </div>
    </div>
    <div class="flex flex-col items-center pb-10">
        <?php echo $userAvatar;?>
        <h5 class="mb-1 text-xl font-medium text-gray-900 dark:text-white"><?php echo $user_firstName. ' ' . $user_lastName;?></h5>
        <span class="text-sm text-gray-500 dark:text-gray-400">@<?php echo $user_username;?></span>
        <div class="flex mt-4 space-x-3 md:mt-6">
            <a href="#" class="inline-flex items-center px-4 py-2 text-sm font-medium text-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">Add friend</a>
            <a href="#" class="inline-flex items-center px-4 py-2 text-sm font-medium text-center text-gray-900 bg-white border border-gray-300 rounded-lg hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-gray-200 dark:bg-gray-800 dark:text-white dark:border-gray-600 dark:hover:bg-gray-700 dark:hover:border-gray-700 dark:focus:ring-gray-700">Message</a>
        </div>
    </div>
</div>

<?php
include_once includes('scripts.php');
?>