<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="h-100 scroll-behavior-smooth <?php echo e((config('settings.dark_mode') == 1 ? 'dark' : '')); ?>" dir="<?php echo e((__('lang_dir') == 'rtl' ? 'rtl' : 'ltr')); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('site_title'); ?></title>

    <?php echo $__env->yieldContent('head_content'); ?>

    <link href="<?php echo e(url('/')); ?>/uploads/brand/<?php echo e(config('settings.favicon') ?? 'favicon.png'); ?>" rel="icon">

    <!-- Scripts -->
    <script src="<?php echo e(asset('js/app.js')); ?>" defer></script>

    <!-- Styles -->
    <link href="<?php echo e(asset('css/app'. (__('lang_dir') == 'rtl' ? '.rtl' : '') . (config('settings.dark_mode') == 1 ? '.dark' : '').'.css')); ?>" rel="stylesheet" data-theme-light="<?php echo e(asset('css/app'. (__('lang_dir') == 'rtl' ? '.rtl' : '') . '.css')); ?>" data-theme-dark="<?php echo e(asset('css/app'. (__('lang_dir') == 'rtl' ? '.rtl' : '') . '.dark.css')); ?>" data-theme-target="href">

    <?php echo config('settings.custom_js'); ?>


    <?php if(config('settings.custom_css')): ?>
        <style>
            <?php echo config('settings.custom_css'); ?>

        </style>
    <?php endif; ?>
</head>
<?php echo $__env->yieldContent('body'); ?>
</html>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/layouts/wrapper.blade.php ENDPATH**/ ?>