

<?php $__env->startSection('site_title', formatTitle([__('Dashboard'), config('settings.title')])); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-base-1 flex-fill">
        <div class="bg-base-0">
            <div class="container py-5">
                <div class="d-flex">
                    <div class="row no-gutters w-100">
                        <div class="d-flex col-12 col-md">
                            <div class="flex-grow-1 d-flex align-items-center">
                                <div>
                                    <h1 class="h2 font-weight-medium mb-0"><?php echo e(config('settings.title')); ?></h1>

                                    <div class="d-flex flex-wrap">
                                        <div class="d-inline-block mt-2 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-4' : 'mr-4')); ?>">
                                            <div class="d-flex">
                                                <div class="d-inline-flex align-items-center">
                                                    <?php echo $__env->make('icons.info', ['class' => 'text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                </div>

                                                <div class="d-inline-block <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>">
                                                    <a href="<?php echo e(config('info.software.url')); ?>/<?php echo e(mb_strtolower(config('info.software.name'))); ?>/changelog" class="text-dark text-decoration-none d-flex align-items-center" target="_blank"><?php echo e(__('Version')); ?> <span class="badge badge-primary <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e(config('info.software.version')); ?></span></a>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="d-inline-block mt-2 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-4' : 'mr-4')); ?>">
                                            <div class="d-flex">
                                                <div class="d-inline-flex align-items-center">
                                                    <?php echo $__env->make('icons.vpn-key', ['class' => 'text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                </div>

                                                <div class="d-inline-block <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>">
                                                    <a href="<?php echo e(route('admin.settings', 'license')); ?>" class="text-dark text-decoration-none d-flex align-items-center"><?php echo e(__('License')); ?> <span class="badge badge-primary <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e(config('settings.license_type') ? 'Extended' : 'Regular'); ?></span></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-12 col-md-auto d-flex flex-row-reverse align-items-center"></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="bg-base-1">
            <div class="container py-3 my-3">
                <h4 class="mb-3"><?php echo e(__('Overview')); ?></h4>

                <div class="row m-n2">
                    <?php
                        $cards = [
                            'users' =>
                            [
                                'title' => 'Users',
                                'value' => $stats['users'],
                                'route' => 'admin.users',
                                'icon' => 'people-alt'
                            ],
                            [
                                'title' => 'Plans',
                                'value' => $stats['plans'],
                                'route' => 'admin.plans',
                                'icon' => 'package'
                            ],
                            [
                                'title' => 'Payments',
                                'value' => $stats['payments'],
                                'route' => 'admin.payments',
                                'icon' => 'credit-card'
                            ],
                            [
                                'title' => 'Reports',
                                'value' => $stats['reports'],
                                'route' => 'admin.reports',
                                'icon' => 'list-alt'
                            ]
                        ];
                    ?>

                    <?php $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-12 col-md-6 col-xl-3 p-2">
                            <div class="card border-0 shadow-sm h-100 overflow-hidden">
                                <div class="card-body d-flex">
                                    <div class="d-flex position-relative text-primary width-10 height-10 align-items-center justify-content-center flex-shrink-0">
                                        <div class="position-absolute bg-primary opacity-10 top-0 right-0 bottom-0 left-0 border-radius-xl"></div>
                                        <?php echo $__env->make('icons.' . $card['icon'], ['class' => 'fill-current width-5 height-5'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>

                                    <div class="flex-grow-1"></div>

                                    <div class="d-flex align-items-center h2 font-weight-bold mb-0 text-truncate">
                                        <?php echo e(number_format($card['value'], 0, __('.'), __(','))); ?>

                                    </div>
                                </div>
                                <div class="card-footer bg-base-2 border-0">
                                    <a href="<?php echo e(route($card['route'])); ?>" class="text-muted font-weight-medium d-inline-flex align-items-baseline"><?php echo e(__($card['title'])); ?> <?php echo $__env->make((__('lang_dir') == 'rtl' ? 'icons.chevron-left' : 'icons.chevron-right'), ['class' => 'width-3 height-3 fill-current '.(__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <h4 class="mb-3 mt-5"><?php echo e(__('Activity')); ?></h4>

                <div class="row m-n2">
                    <div class="col-12 col-xl-6 p-2">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="card-header align-items-center">
                                <div class="row">
                                    <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Latest users')); ?></div></div>
                                </div>
                            </div>
                            <div class="card-body">
                                <?php if(count($users) == 0): ?>
                                    <?php echo e(__('No data')); ?>.
                                <?php else: ?>
                                    <div class="list-group list-group-flush my-n3">
                                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="list-group-item px-0">
                                                <div class="row align-items-center">
                                                    <div class="col text-truncate">
                                                        <div class="text-truncate">
                                                            <div class="d-flex align-items-center">
                                                                <img src="<?php echo e(gravatar($user->email, 48)); ?>" class="rounded-circle width-4 height-4 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">

                                                                <div class="text-truncate">
                                                                    <a href="<?php echo e(route('admin.users.edit', $user->id)); ?>" class="text-truncate"><?php echo e($user->name); ?></a>
                                                                </div>
                                                            </div>
                                                            <div class="d-flex align-items-center">
                                                                <div class="width-4 flex-shrink-0 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>"></div>
                                                                <div class="text-muted text-truncate small">
                                                                    <?php echo e($user->email); ?>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-auto">
                                                        <div class="form-row">
                                                            <div class="col">
                                                                <?php echo $__env->make('admin.users.partials.menu', ['user' => $user], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <?php if(count($users) > 0): ?>
                                <div class="card-footer bg-base-2 border-0">
                                    <a href="<?php echo e(route('admin.users')); ?>" class="text-muted font-weight-medium d-flex align-items-center justify-content-center"><?php echo e(__('View all')); ?> <?php echo $__env->make((__('lang_dir') == 'rtl' ? 'icons.chevron-left' : 'icons.chevron-right'), ['class' => 'width-3 height-3 fill-current '.(__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <?php if(paymentProcessors()): ?>
                        <div class="col-12 col-xl-6 p-2">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-header align-items-center">
                                    <div class="row">
                                        <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Latest payments')); ?></div></div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <?php if(count($payments) == 0): ?>
                                        <?php echo e(__('No data')); ?>.
                                    <?php else: ?>
                                        <div class="list-group list-group-flush my-n3">
                                            <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="list-group-item px-0">
                                                    <div class="row align-items-center">
                                                        <div class="col text-truncate">
                                                            <div class="text-truncate">
                                                                <div class="d-flex align-items-center">
                                                                    <img src="<?php echo e(url('/')); ?>/images/icons/payments/<?php echo e($payment->processor); ?>.svg" class="width-4 rounded-sm <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">

                                                                    <div class="text-truncate d-flex align-items-center">
                                                                        <div class="text-truncate <?php echo e((__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')); ?>">
                                                                            <a href="<?php echo e(route('admin.payments.edit', $payment->id)); ?>"><?php echo e(formatMoney($payment->amount, $payment->currency)); ?></a> <span class="text-muted"><?php echo e($payment->currency); ?></span>
                                                                        </div>

                                                                        <?php if($payment->status == 'completed'): ?>
                                                                            <span class="badge badge-success text-truncate"><?php echo e(__('Completed')); ?></span>
                                                                        <?php elseif($payment->status == 'pending'): ?>
                                                                            <span class="badge badge-secondary text-truncate"><?php echo e(__('Pending')); ?></span>
                                                                        <?php else: ?>
                                                                            <span class="badge badge-danger text-truncate"><?php echo e(__('Cancelled')); ?></span>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </div>
                                                                <div class="d-flex align-items-center">
                                                                    <div class="width-4 flex-shrink-0 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>"></div>
                                                                    <div class="text-muted text-truncate small">
                                                                        <?php echo e($payment->plan->name); ?>

                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-auto">
                                                            <div class="form-row">
                                                                <div class="col">
                                                                    <?php echo $__env->make('account.payments.partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <?php if(count($payments) > 0): ?>
                                    <div class="card-footer bg-base-2 border-0">
                                        <a href="<?php echo e(route('admin.payments')); ?>" class="text-muted font-weight-medium d-flex align-items-center justify-content-center"><?php echo e(__('View all')); ?> <?php echo $__env->make((__('lang_dir') == 'rtl' ? 'icons.chevron-left' : 'icons.chevron-right'), ['class' => 'width-3 height-3 fill-current '.(__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="col-12 col-xl-6 p-2">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-header align-items-center">
                                    <div class="row">
                                        <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Latest reports')); ?></div></div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <?php if(count($reports) == 0): ?>
                                        <?php echo e(__('No data')); ?>.
                                    <?php else: ?>
                                        <div class="list-group list-group-flush my-n3">
                                            <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="list-group-item px-0">
                                                    <div class="row align-items-center">
                                                        <div class="col text-truncate">
                                                            <div class="text-truncate">
                                                                <div class="d-flex align-items-center">
                                                                    <img src="https://icons.duckduckgo.com/ip3/<?php echo e(parse_url($report->fullUrl, PHP_URL_HOST)); ?>.ico" rel="noreferrer" class="width-4 height-4 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">

                                                                    <div class="text-truncate" data-tooltip="true" title="<?php echo e($report->url); ?>">
                                                                        <a href="<?php echo e(route('reports.show', $report->id)); ?>" dir="ltr"><?php echo e($report->url); ?></a>
                                                                    </div>
                                                                </div>
                                                                <div class="d-flex align-items-center">
                                                                    <div class="width-4 flex-shrink-0 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>"></div>
                                                                    <div class="text-muted text-truncate small">
                                                                        <span class="text-muted" data-tooltip="true" title="<?php echo e($report->updated_at->tz(Auth::user()->timezone ?? config('app.timezone'))->format(__('Y-m-d') . ' H:i:s')); ?>"><?php echo e($report->updated_at->diffForHumans()); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-auto">
                                                            <div class="form-row">
                                                                <div class="col">
                                                                    <?php echo $__env->make('reports.partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <?php if(count($reports) > 0): ?>
                                    <div class="card-footer bg-base-2 border-0">
                                        <a href="<?php echo e(route('admin.reports')); ?>" class="text-muted font-weight-medium d-flex align-items-center justify-content-center"><?php echo e(__('View all')); ?> <?php echo $__env->make((__('lang_dir') == 'rtl' ? 'icons.chevron-left' : 'icons.chevron-right'), ['class' => 'width-3 height-3 fill-current '.(__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <h4 class="mb-3 mt-5"><?php echo e(__('More')); ?></h4>

                <div class="row m-n2">
                    <div class="col-12 col-xl-4 p-2">
                        <div class="card border-0 h-100 shadow-sm">
                            <div class="card-body d-flex">
                                <div class="d-flex position-relative text-primary width-12 height-12 align-items-center justify-content-center flex-shrink-0 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">
                                    <div class="position-absolute bg-primary opacity-10 top-0 right-0 bottom-0 left-0 border-radius-2xl"></div>
                                    <?php echo $__env->make('icons.website', ['class' => 'fill-current width-6 height-6'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="d-flex flex-column justify-content-center">
                                    <a href="<?php echo e(config('info.software.url')); ?>/<?php echo e(mb_strtolower(config('info.software.name'))); ?>" class="text-dark font-weight-medium text-decoration-none stretched-link"><?php echo e(__('Website')); ?></a>

                                    <div class="text-muted">
                                        <?php echo e(__('Visit the official website.')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-12 col-xl-4 p-2">
                        <div class="card border-0 h-100 shadow-sm">
                            <div class="card-body d-flex">
                                <div class="d-flex position-relative text-primary width-12 height-12 align-items-center justify-content-center flex-shrink-0 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">
                                    <div class="position-absolute bg-primary opacity-10 top-0 right-0 bottom-0 left-0 border-radius-2xl"></div>
                                    <?php echo $__env->make('icons.book', ['class' => 'fill-current width-6 height-6'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="d-flex flex-column justify-content-center">
                                    <a href="<?php echo e(config('info.software.url')); ?>/<?php echo e(mb_strtolower(config('info.software.name'))); ?>/documentation" class="text-dark font-weight-medium text-decoration-none stretched-link"><?php echo e(__('Documentation')); ?></a>

                                    <div class="text-muted">
                                        <?php echo e(__('Read the documentation.')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-12 col-xl-4 p-2">
                        <div class="card border-0 h-100 shadow-sm">
                            <div class="card-body d-flex">
                                <div class="d-flex position-relative text-primary width-12 height-12 align-items-center justify-content-center flex-shrink-0 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">
                                    <div class="position-absolute bg-primary opacity-10 top-0 right-0 bottom-0 left-0 border-radius-2xl"></div>
                                    <?php echo $__env->make('icons.history', ['class' => 'fill-current width-6 height-6'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="d-flex flex-column justify-content-center">
                                    <a href="<?php echo e(config('info.software.url')); ?>/<?php echo e(mb_strtolower(config('info.software.name'))); ?>/changelog" class="text-dark font-weight-medium text-decoration-none stretched-link"><?php echo e(__('Changelog')); ?></a>

                                    <div class="text-muted">
                                        <?php echo e(__('See what\'s new.')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/admin/dashboard/index.blade.php ENDPATH**/ ?>