<?php echo $__env->make('reports.partials.toast', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="card border-0 shadow-sm mt-3">
    <div class="card-body">
        <form action="<?php echo e(route('reports.new')); ?>" method="post" enctype="multipart/form-data" autocomplete="off">
            <?php echo csrf_field(); ?>

            <div class="row">
                <div class="col-12">
                    <div class="form-row">
                        <div class="col-12 col-md">
                            <div>
                                <div class="input-group input-group-lg">
                                    <input type="text" dir="ltr" name="url" class="form-control<?php echo e($errors->has('url') ? ' is-invalid' : ''); ?> font-size-lg" autocapitalize="none" spellcheck="false" id="i-url" value="<?php echo e(old('url')); ?>" placeholder="<?php echo e(old('sitemap') ? 'https://example.com/sitemap.xml' : 'https://example.com'); ?>" data-placeholder-sitemap="<?php echo e('https://example.com/sitemap.xml'); ?>" data-placeholder-webpage="<?php echo e('https://example.com'); ?>" autofocus>
                                </div>
                                <?php if($errors->has('url')): ?>
                                    <span class="invalid-feedback d-block" role="alert">
                                        <strong><?php echo e($errors->first('url')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if(config('settings.sitemap_links')): ?>
                            <div class="col-12 col-md-auto mt-3 mt-md-0">
                                <div class="form-row">
                                    <div class="col">
                                        <div class="d-flex flex-wrap">
                                            <div class="btn-group btn-group-toggle d-flex flex-fill" data-toggle="buttons">
                                                <label class="btn btn-lg font-size-lg btn-outline-primary w-100 d-flex align-items-center justify-content-center <?php if(old('sitemap') == 0): ?> active <?php endif; ?>" data-tooltip="true" title="<?php echo e(__('Webpage')); ?>" id="toggle-webpage">
                                                    <input type="radio" name="sitemap" value="0" <?php if(old('sitemap') == 0 || old('sitemap') == null): ?> checked <?php endif; ?>>
                                                    <?php echo $__env->make('icons.list-alt', ['class' => 'width-4 height-4 fill-current'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;
                                                </label>
                                                <label class="btn btn-lg font-size-lg btn-outline-primary w-100 d-flex align-items-center justify-content-center <?php if(old('sitemap') == 1): ?> active <?php endif; ?>" data-tooltip="true" title="<?php echo e(__('Sitemap')); ?>" id="toggle-sitemap">
                                                    <input type="radio" name="sitemap" value="1" <?php if(old('sitemap') == 1): ?> checked <?php endif; ?>>
                                                    <?php echo $__env->make('icons.account-tree', ['class' => 'width-4 height-4 fill-current'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col">
                                        <a href="#" class="btn btn-lg btn-outline-primary font-size-lg d-flex align-items-center justify-content-center" data-toggle="collapse" data-target="#advanced-options" aria-expanded="false" data-tooltip="true" title="<?php echo e(__('Advanced')); ?>"><?php echo $__env->make('icons.settings', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;</a>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="col-12 col-md-auto mt-3 mt-md-0">
                            <button class="btn btn-primary btn-lg btn-block font-size-lg position-relative" type="submit" data-button-loader>
                                <div class="position-absolute top-0 right-0 bottom-0 left-0 d-flex align-items-center justify-content-center">
                                    <span class="d-none spinner-border spinner-border-sm width-4 height-4" role="status"></span>
                                </div>
                                <span class="spinner-text"><?php echo e(__('Analyze')); ?></span>&#8203;
                            </button>
                        </div>
                    </div>
                </div>

                <div class="col-12 collapse<?php echo e(($errors->has('privacy') || $errors->has('password')) ? ' show' : ''); ?>" id="advanced-options">
                    <div class="form-group mb-0 mt-3">
                        <label><?php echo e(__('Privacy')); ?></label>
                        <div class="form-group mb-0">
                            <div class="row mx-n2">
                                <div class="col-12 col-lg-4 px-2">
                                    <div class="custom-control custom-radio">
                                        <input type="radio" id="i-privacy1" name="privacy" class="custom-control-input<?php echo e($errors->has('privacy') ? ' is-invalid' : ''); ?>" value="1" <?php if(old('privacy') == null || old('privacy') == 1): ?> checked <?php elseif(Auth::user()->default_privacy == 1 && old('privacy') == null): ?> checked <?php endif; ?>>
                                        <label class="custom-control-label cursor-pointer w-100 d-flex flex-column" for="i-privacy1">
                                            <span><?php echo e(__('Private')); ?></span>
                                            <span class="small text-muted"><?php echo e(__('Stats accessible only by you.')); ?></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="col-12 col-lg-4 px-2">
                                    <div class="custom-control custom-radio">
                                        <input type="radio" id="i-privacy0" name="privacy" class="custom-control-input<?php echo e($errors->has('privacy') ? ' is-invalid' : ''); ?>" value="0" <?php if(old('privacy') == 0 && old('privacy') != null): ?> checked <?php elseif(Auth::user()->default_privacy == 0 && old('privacy') == null): ?> checked <?php endif; ?>>
                                        <label class="custom-control-label cursor-pointer w-100 d-flex flex-column" for="i-privacy0">
                                            <span><?php echo e(__('Public')); ?></span>
                                            <span class="small text-muted"><?php echo e(__('Stats accessible by anyone.')); ?></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="col-12 col-lg-4 px-2">
                                    <div class="custom-control custom-radio">
                                        <input type="radio" id="i-privacy2" name="privacy" class="custom-control-input<?php echo e($errors->has('privacy') ? ' is-invalid' : ''); ?>" value="2" <?php if(old('privacy') == 2): ?> checked <?php endif; ?>>
                                        <label class="custom-control-label cursor-pointer w-100 d-flex flex-column" for="i-privacy2">
                                            <span><?php echo e(__('Password')); ?></span>
                                            <span class="small text-muted"><?php echo e(__('Stats accessible by password.')); ?></span>
                                        </label>
                                        <div id="input-password" class="<?php echo e((old('privacy') != 2 ? 'd-none' : '')); ?>">
                                            <div class="input-group mt-2">
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text cursor-pointer" data-tooltip="true" data-title="<?php echo e(__('Show password')); ?>" data-password="i-password" data-password-show="<?php echo e(__('Show password')); ?>" data-password-hide="<?php echo e(__('Hide password')); ?>"><?php echo $__env->make('icons.lock', ['class' => 'width-4 height-4 fill-current text-muted'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></div>
                                                </div>
                                                <input id="i-password" type="password" class="form-control<?php echo e($errors->has('password') ? ' is-invalid' : ''); ?>" name="password" value="<?php echo e(old('password')); ?>" autocomplete="new-password">
                                            </div>
                                            <?php if($errors->has('password')): ?>
                                                <span class="invalid-feedback d-block" role="alert">
                                                    <strong><?php echo e($errors->first('password')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php if($errors->has('privacy')): ?>
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong><?php echo e($errors->first('privacy')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/reports/new.blade.php ENDPATH**/ ?>