<?php if(isset($report['results'][$name])): ?>
    <div class="border-top">
        <div class="card-body">
            <div class="row">
                <div class="col">
                    <div class="row">
                        <div class="col-12 col-lg-4">
                            <div class="d-flex align-items-center">
                                <?php echo $__env->make('reports.partials.status', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                <div class="text-truncate font-weight-medium"><?php echo e(__('Deprecated HTML')); ?></div>
                            </div>
                        </div>

                        <div class="col-12 col-lg-8">
                            <?php if($report['results'][$name]['passed']): ?>
                                <div>
                                    <?php echo e(__('There are no deprecated HTML tags on the webpage.')); ?>

                                </div>
                            <?php else: ?>
                                <?php $__currentLoopData = $report['results'][$name]['errors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error => $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="<?php echo e((!$loop->first) ? 'mt-3' : ''); ?>">
                                        <?php if($error == 'bad_tags'): ?>
                                            <?php echo e(__('The webpage has deprecated HTML tags.')); ?>


                                            <div class="list-group mt-2">
                                                <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="list-group-item p-0">
                                                        <div class="d-flex text-secondary justify-content-between align-items-center text-decoration-none px-3 py-2">
                                                            <div class="font-weight-medium"><code>&lt;<?php echo e($key); ?>&gt;</code></div>
                                                            <span class="badge badge-secondary badge-pill"><?php echo e(number_format($value, 0, __('.'), __(','))); ?></span>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="col-auto">
                    <a href="#collapse<?php echo e($name); ?>" class="text-secondary" data-toggle="collapse" role="button" aria-expanded="false" aria-controls="collapse<?php echo e($name); ?>" data-tooltip="true" title="<?php echo e(__('More')); ?>">
                        <?php echo $__env->make('icons.info', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="collapse<?php echo e(Auth::check() && Auth::user()->default_export_detailed ? ' d-print-block' : ''); ?>" id="collapse<?php echo e($name); ?>">
        <div class="card-body pt-0">
            <div class="alert alert-secondary mb-0">
                <?php echo e(__('The deprecated tags represents the tags that are not supported HTML5 standard anymore, and could cause the webpage to be rendered incorrectly.')); ?>


                <hr>

                <div class="row">
                    <div class="col-12 col-md">
                        <?php echo e(__('Learn more')); ?>

                    </div>
                    <div class="col-12 col-md-auto">
                        <a href="https://dev.w3.org/html5/pf-summary/obsolete.html#non-conforming-features" class="alert-link font-weight-medium d-flex align-items-center" target="_blank" rel="nofollow">W3C <?php echo $__env->make('icons.external', ['class' => 'fill-current width-3 height-3 ' . (__('lang_dir') == 'rtl' ? 'mr-1' : 'ml-1')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/reports/partials/deprecated-html-tags.blade.php ENDPATH**/ ?>