<?php $__env->startSection('site_title', formatTitle([__('Legal'), __('Settings'), config('settings.title')])); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('admin.dashboard'), 'title' => __('Admin')],
    ['title' => __('Settings')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<h1 class="h2 mb-3 d-inline-block"><?php echo e(__('Legal')); ?></h1>

<div class="card border-0 shadow-sm">
    <div class="card-header"><div class="font-weight-medium py-1"><?php echo e(__('Legal')); ?></div></div>
    <div class="card-body">

        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('admin.settings', 'legal')); ?>" method="post" enctype="multipart/form-data">

            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-legal-terms-url"><?php echo e(__(':name URL', ['name' => __('Terms of service')])); ?></label>
                <input type="text" dir="ltr" name="legal_terms_url" id="i-legal-terms-url" class="form-control<?php echo e($errors->has('legal_terms_url') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('legal_terms_url') ?? config('settings.legal_terms_url')); ?>">
                <?php if($errors->has('legal_terms_url')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('legal_terms_url')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-privacy-url"><?php echo e(__(':name URL', ['name' => __('Privacy policy')])); ?></label>
                <input type="text" dir="ltr" name="legal_privacy_url" id="i-privacy-url" class="form-control<?php echo e($errors->has('legal_privacy_url') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('legal_privacy_url') ?? config('settings.legal_privacy_url')); ?>">
                <?php if($errors->has('legal_privacy_url')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('legal_privacy_url')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-cookie-url"><?php echo e(__(':name URL', ['name' => __('Cookie policy')])); ?></label>
                <input type="text" dir="ltr" name="legal_cookie_url" id="i-cookie-url" class="form-control<?php echo e($errors->has('legal_cookie_url') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('legal_cookie_url') ?? config('settings.legal_cookie_url')); ?>">
                <?php if($errors->has('legal_cookie_url')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('legal_cookie_url')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
        </form>

    </div>
</div><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/admin/settings/legal.blade.php ENDPATH**/ ?>