<?php $__env->startSection('site_title', formatTitle([__('Payment processors'), __('Settings'), config('settings.title')])); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('admin.dashboard'), 'title' => __('Admin')],
    ['title' => __('Settings')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<h1 class="h2 mb-3 d-inline-block"><?php echo e(__('Payment processors')); ?></h1>

<div class="card border-0 shadow-sm">
    <div class="card-header"><div class="font-weight-medium py-1"><?php echo e(__('Payment processors')); ?></div></div>
    <div class="card-body">
        <ul class="nav nav-pills d-flex flex-fill flex-column flex-lg-row mb-3" id="pills-tab" role="tablist">
            <li class="nav-item flex-grow-1 text-center">
                <a class="nav-link active" id="pills-vakifbank-tab" data-toggle="pill" href="#pills-vakifbank" role="tab" aria-controls="pills-vakifbank" aria-selected="true"><?php echo e(__('VakifBank')); ?></a>
            </li>
            <li class="nav-item flex-grow-1 text-center">
                <a class="nav-link" id="pills-paypal-tab" data-toggle="pill" href="#pills-paypal" role="tab" aria-controls="pills-paypal" aria-selected="true"><?php echo e(__('PayPal')); ?></a>
            </li>

            <li class="nav-item flex-grow-1 text-center">
                <a class="nav-link" id="pills-stripe-tab" data-toggle="pill" href="#pills-stripe" role="tab" aria-controls="pills-stripe" aria-selected="false"><?php echo e(__('Stripe')); ?></a>
            </li>

            <li class="nav-item flex-grow-1 text-center">
                <a class="nav-link" id="pills-razorpay-tab" data-toggle="pill" href="#pills-razorpay" role="tab" aria-controls="pills-razorpay" aria-selected="false"><?php echo e(__('Razorpay')); ?></a>
            </li>

            <li class="nav-item flex-grow-1 text-center">
                <a class="nav-link" id="pills-paystack-tab" data-toggle="pill" href="#pills-paystack" role="tab" aria-controls="pills-paystack" aria-selected="false"><?php echo e(__('Paystack')); ?></a>
            </li>

            <li class="nav-item flex-grow-1 text-center">
                <a class="nav-link" id="pills-coinbase-tab" data-toggle="pill" href="#pills-coinbase" role="tab" aria-controls="pills-coinbase" aria-selected="false"><?php echo e(__('Coinbase')); ?></a>
            </li>

            <li class="nav-item flex-grow-1 text-center">
                <a class="nav-link" id="pills-cryptocom-tab" data-toggle="pill" href="#pills-cryptocom" role="tab" aria-controls="pills-cryptocom" aria-selected="false"><?php echo e(__('Crypto.com')); ?></a>
            </li>

            <li class="nav-item flex-grow-1 text-center">
                <a class="nav-link" id="pills-bank-tab" data-toggle="pill" href="#pills-bank" role="tab" aria-controls="pills-bank" aria-selected="false"><?php echo e(__('Bank')); ?></a>
            </li>
        </ul>

        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('admin.settings', 'payment-processors')); ?>" method="post" enctype="multipart/form-data">

            <?php echo csrf_field(); ?>

            <div class="tab-content" id="pills-tabContent">

                <div class="tab-pane fade show active" id="pills-vakifbank" role="tabpanel" aria-labelledby="pills-vakifbank-tab">
                    <div class="form-group">
                        <label for="i-vakifbank"><?php echo e(__('Enabled')); ?></label>
                        <select name="vakifbank" id="i-vakifbank" class="custom-select<?php echo e($errors->has('vakifbank') ? ' is-invalid' : ''); ?>">
                            <?php $__currentLoopData = [1 => __('Yes'), 0 => __('No')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php if((old('vakifbank') !== null && old('vakifbank') == $key) || (config('settings.vakifbank') == $key && old('vakifbank') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('vakifbank')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('vakifbank')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-vakifbank-mode"><?php echo e(__('Mode')); ?></label>
                        <select name="vakifbank_mode" id="i-vakifbank-mode" class="custom-select<?php echo e($errors->has('vakifbank_mode') ? ' is-invalid' : ''); ?>">
                            <?php $__currentLoopData = ['live' => __('Live'), 'sandbox' => __('Sandbox')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php if((old('vakifbank_mode') !== null && old('vakifbank_mode') == $key) || (config('settings.vakifbank_mode') == $key && old('vakifbank_mode') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('vakifbank_mode')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('vakifbank_mode')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-vakifbank-merchant-id"><?php echo e(__('Merchant ID')); ?></label>
                        <input type="text" name="vakifbank_merchant_id" id="i-vakifbank-merchant-id" class="form-control<?php echo e($errors->has('vakifbank_merchant_id') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('vakifbank_merchant_id') ?? config('settings.vakifbank_merchant_id')); ?>">
                        <?php if($errors->has('vakifbank_client_id')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('vakifbank_client_id')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="i-vakifbank-terminal-id"><?php echo e(__('Terminal ID')); ?></label>
                        <input type="text" name="vakifbank_terminal_id" id="i-vakifbank-terminal-id" class="form-control<?php echo e($errors->has('vakifbank_terminal_id') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('vakifbank_terminal_id') ?? config('settings.vakifbank_terminal_id')); ?>">
                        <?php if($errors->has('vakifbank_terminal_id')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('vakifbank_terminal_id')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-vakifbank-password"><?php echo e(__('Password')); ?></label>
                        <input type="password" name="vakifbank_password" id="i-vakifbank-password" class="form-control<?php echo e($errors->has('vakifbank_password') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('vakifbank_password') ?? config('settings.vakifbank_password')); ?>">
                        <?php if($errors->has('vakifbank_password')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('vakifbank_password')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-vakifbank-currency"><?php echo e(__('Currency (Auto Choose)')); ?></label>
                        <input type="text" name="vakifbank_currency" id="i-vakifbank-currency" class="form-control<?php echo e($errors->has('vakifbank_currency') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('vakifbank_currency') ?? config('settings.vakifbank_currency')); ?>" placeholder="TL: 949, USD: 840">
                        <?php if($errors->has('vakifbank_currency')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('vakifbank_currency')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>


                    <div class="form-group">
                        <label for="i-vakifbank-wh-url"><?php echo e(__('Webhook URL')); ?></label>
                        <div class="input-group">
                            <input type="text" dir="ltr" name="vakifbank_wh_url" id="i-vakifbank-wh-url" class="form-control" value="<?php echo e(route('webhooks.vakifbank')); ?>" readonly>
                            <div class="input-group-append">
                                <div class="btn btn-primary" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-vakifbank-wh-url"><?php echo e(__('Copy')); ?></div>
                            </div>
                        </div>
                    </div>
                </div>






                <div class="tab-pane fade show" id="pills-paypal" role="tabpanel" aria-labelledby="pills-paypal-tab">
                    <div class="form-group">
                        <label for="i-paypal"><?php echo e(__('Enabled')); ?></label>
                        <select name="paypal" id="i-paypal" class="custom-select<?php echo e($errors->has('paypal') ? ' is-invalid' : ''); ?>">
                            <?php $__currentLoopData = [1 => __('Yes'), 0 => __('No')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php if((old('paypal') !== null && old('paypal') == $key) || (config('settings.paypal') == $key && old('paypal') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('paypal')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('paypal')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-paypal-mode"><?php echo e(__('Mode')); ?></label>
                        <select name="paypal_mode" id="i-paypal-mode" class="custom-select<?php echo e($errors->has('paypal_mode') ? ' is-invalid' : ''); ?>">
                            <?php $__currentLoopData = ['live' => __('Live'), 'sandbox' => __('Sandbox')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php if((old('paypal_mode') !== null && old('paypal_mode') == $key) || (config('settings.paypal_mode') == $key && old('paypal_mode') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('paypal_mode')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('paypal_mode')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-paypal-client-id"><?php echo e(__('Client ID')); ?></label>
                        <input type="text" name="paypal_client_id" id="i-paypal-client-id" class="form-control<?php echo e($errors->has('paypal_client_id') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('paypal_client_id') ?? config('settings.paypal_client_id')); ?>">
                        <?php if($errors->has('paypal_client_id')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('paypal_client_id')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-paypal-secret"><?php echo e(__('Secret')); ?></label>
                        <input type="password" name="paypal_secret" id="i-paypal-secret" class="form-control<?php echo e($errors->has('paypal_secret') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('paypal_secret') ?? config('settings.paypal_secret')); ?>">
                        <?php if($errors->has('paypal_secret')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('paypal_secret')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-paypal-webhook-id"><?php echo e(__('Webhook ID')); ?></label>
                        <input type="text" name="paypal_webhook_id" id="i-paypal-webhook-id" class="form-control<?php echo e($errors->has('paypal_webhook_id') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('paypal_webhook_id') ?? config('settings.paypal_webhook_id')); ?>">
                        <?php if($errors->has('paypal_webhook_id')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('paypal_webhook_id')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-paypal-wh-url"><?php echo e(__('Webhook URL')); ?></label>
                        <div class="input-group">
                            <input type="text" dir="ltr" name="paypal_wh_url" id="i-paypal-wh-url" class="form-control" value="<?php echo e(route('webhooks.paypal')); ?>" readonly>
                            <div class="input-group-append">
                                <div class="btn btn-primary" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-paypal-wh-url"><?php echo e(__('Copy')); ?></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tab-pane fade" id="pills-stripe" role="tabpanel" aria-labelledby="pills-stripe-tab">
                    <div class="form-group">
                        <label for="i-stripe"><?php echo e(__('Enabled')); ?></label>
                        <select name="stripe" id="i-stripe" class="custom-select<?php echo e($errors->has('stripe') ? ' is-invalid' : ''); ?>">
                            <?php $__currentLoopData = [1 => __('Yes'), 0 => __('No')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php if((old('stripe') !== null && old('stripe') == $key) || (config('settings.stripe') == $key && old('stripe') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('stripe')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('stripe')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-stripe-key"><?php echo e(__('Publishable key')); ?></label>
                        <input type="text" name="stripe_key" id="i-stripe-key" class="form-control<?php echo e($errors->has('stripe_key') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('stripe_key') ?? config('settings.stripe_key')); ?>">
                        <?php if($errors->has('stripe_key')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('stripe_key')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-stripe-secret"><?php echo e(__('Secret key')); ?></label>
                        <input type="password" name="stripe_secret" id="i-stripe-secret" class="form-control<?php echo e($errors->has('stripe_secret') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('stripe_secret') ?? config('settings.stripe_secret')); ?>">
                        <?php if($errors->has('stripe_secret')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('stripe_secret')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-stripe-wh-secret"><?php echo e(__('Signing secret')); ?></label>
                        <input type="password" name="stripe_wh_secret" id="i-stripe-wh-secret" class="form-control<?php echo e($errors->has('stripe_wh_secret') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('stripe_wh_secret') ?? config('settings.stripe_wh_secret')); ?>">
                        <?php if($errors->has('stripe_wh_secret')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('stripe_wh_secret')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-stripe-wh-url"><?php echo e(__('Webhook URL')); ?></label>
                        <div class="input-group">
                            <input type="text" dir="ltr" name="stripe_wh_url" id="i-stripe-wh-url" class="form-control" value="<?php echo e(route('webhooks.stripe')); ?>" readonly>
                            <div class="input-group-append">
                                <div class="btn btn-primary" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-stripe-wh-url"><?php echo e(__('Copy')); ?></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tab-pane fade" id="pills-razorpay" role="tabpanel" aria-labelledby="pills-razorpay-tab">
                    <div class="form-group">
                        <label for="i-razorpay"><?php echo e(__('Enabled')); ?></label>
                        <select name="razorpay" id="i-razorpay" class="custom-select<?php echo e($errors->has('razorpay') ? ' is-invalid' : ''); ?>">
                            <?php $__currentLoopData = [1 => __('Yes'), 0 => __('No')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php if((old('razorpay') !== null && old('razorpay') == $key) || (config('settings.razorpay') == $key && old('razorpay') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('razorpay')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('razorpay')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-razorpay-key"><?php echo e(__('Key ID')); ?></label>
                        <input type="text" name="razorpay_key" id="i-razorpay-key" class="form-control<?php echo e($errors->has('razorpay_key') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('razorpay_key') ?? config('settings.razorpay_key')); ?>">
                        <?php if($errors->has('razorpay_key')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('razorpay_key')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-razorpay-secret"><?php echo e(__('Key secret')); ?></label>
                        <input type="password" name="razorpay_secret" id="i-razorpay-secret" class="form-control<?php echo e($errors->has('razorpay_secret') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('razorpay_secret') ?? config('settings.razorpay_secret')); ?>">
                        <?php if($errors->has('razorpay_secret')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('razorpay_secret')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-razorpay-wh-secret"><?php echo e(__('Webhook secret')); ?></label>
                        <input type="password" name="razorpay_wh_secret" id="i-razorpay-wh-secret" class="form-control<?php echo e($errors->has('razorpay_wh_secret') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('razorpay_wh_secret') ?? config('settings.razorpay_wh_secret')); ?>">
                        <?php if($errors->has('razorpay_wh_secret')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('razorpay_wh_secret')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-razorpay-wh-url"><?php echo e(__('Webhook URL')); ?></label>
                        <div class="input-group">
                            <input type="text" dir="ltr" name="razorpay_wh_url" id="i-razorpay-wh-url" class="form-control" value="<?php echo e(route('webhooks.razorpay')); ?>" readonly>
                            <div class="input-group-append">
                                <div class="btn btn-primary" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-razorpay-wh-url"><?php echo e(__('Copy')); ?></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tab-pane fade" id="pills-paystack" role="tabpanel" aria-labelledby="pills-paystack-tab">
                    <div class="form-group">
                        <label for="i-paystack"><?php echo e(__('Enabled')); ?></label>
                        <select name="paystack" id="i-paystack" class="custom-select<?php echo e($errors->has('paystack') ? ' is-invalid' : ''); ?>">
                            <?php $__currentLoopData = [1 => __('Yes'), 0 => __('No')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php if((old('paystack') !== null && old('paystack') == $key) || (config('settings.paystack') == $key && old('paystack') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('paystack')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('paystack')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-paystack-key"><?php echo e(__('Publishable key')); ?></label>
                        <input type="text" name="paystack_key" id="i-paystack-key" class="form-control<?php echo e($errors->has('paystack_key') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('paystack_key') ?? config('settings.paystack_key')); ?>">
                        <?php if($errors->has('paystack_key')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('paystack_key')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-paystack-secret"><?php echo e(__('Secret key')); ?></label>
                        <input type="password" name="paystack_secret" id="i-paystack-secret" class="form-control<?php echo e($errors->has('paystack_secret') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('paystack_secret') ?? config('settings.paystack_secret')); ?>">
                        <?php if($errors->has('paystack_secret')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('paystack_secret')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-paystack-wh-url"><?php echo e(__('Webhook URL')); ?></label>
                        <div class="input-group">
                            <input type="text" dir="ltr" name="paystack_wh_url" id="i-paystack-wh-url" class="form-control" value="<?php echo e(route('webhooks.paystack')); ?>" readonly>
                            <div class="input-group-append">
                                <div class="btn btn-primary" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-paystack-wh-url"><?php echo e(__('Copy')); ?></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tab-pane fade" id="pills-coinbase" role="tabpanel" aria-labelledby="pills-coinbase-tab">
                    <div class="form-group">
                        <label for="i-coinbase"><?php echo e(__('Enabled')); ?></label>
                        <select name="coinbase" id="i-coinbase" class="custom-select<?php echo e($errors->has('coinbase') ? ' is-invalid' : ''); ?>">
                            <?php $__currentLoopData = [1 => __('Yes'), 0 => __('No')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php if((old('coinbase') !== null && old('coinbase') == $key) || (config('settings.coinbase') == $key && old('coinbase') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('coinbase')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('coinbase')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-coinbase-key"><?php echo e(__('Client ID')); ?></label>
                        <input type="text" name="coinbase_key" id="i-coinbase-key" class="form-control<?php echo e($errors->has('coinbase_key') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('coinbase_key') ?? config('settings.coinbase_key')); ?>">
                        <?php if($errors->has('coinbase_key')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('coinbase_key')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-coinbase-wh-secret"><?php echo e(__('Webhook shared secret')); ?></label>
                        <input type="password" name="coinbase_wh_secret" id="i-coinbase-wh-secret" class="form-control<?php echo e($errors->has('coinbase_wh_secret') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('coinbase_wh_secret') ?? config('settings.coinbase_wh_secret')); ?>">
                        <?php if($errors->has('coinbase_wh_secret')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('coinbase_wh_secret')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-coinbase-wh-url"><?php echo e(__('Webhook URL')); ?></label>
                        <div class="input-group">
                            <input type="text" dir="ltr" name="coinbase_wh_url" id="i-coinbase-wh-url" class="form-control" value="<?php echo e(route('webhooks.coinbase')); ?>" readonly>
                            <div class="input-group-append">
                                <div class="btn btn-primary" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-coinbase-wh-url"><?php echo e(__('Copy')); ?></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tab-pane fade" id="pills-cryptocom" role="tabpanel" aria-labelledby="pills-cryptocom-tab">
                    <div class="form-group">
                        <label for="i-cryptocom"><?php echo e(__('Enabled')); ?></label>
                        <select name="cryptocom" id="i-cryptocom" class="custom-select<?php echo e($errors->has('cryptocom') ? ' is-invalid' : ''); ?>">
                            <?php $__currentLoopData = [1 => __('Yes'), 0 => __('No')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php if((old('cryptocom') !== null && old('cryptocom') == $key) || (config('settings.cryptocom') == $key && old('cryptocom') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('cryptocom')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('cryptocom')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-cryptocom-key"><?php echo e(__('Publishable key')); ?></label>
                        <input type="text" name="cryptocom_key" id="i-cryptocom-key" class="form-control<?php echo e($errors->has('cryptocom_key') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('cryptocom_key') ?? config('settings.cryptocom_key')); ?>">
                        <?php if($errors->has('cryptocom_key')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('cryptocom_key')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-cryptocom-secret"><?php echo e(__('Secret key')); ?></label>
                        <input type="password" name="cryptocom_secret" id="i-cryptocom-secret" class="form-control<?php echo e($errors->has('cryptocom_secret') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('cryptocom_secret') ?? config('settings.cryptocom_secret')); ?>">
                        <?php if($errors->has('cryptocom_secret')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('cryptocom_secret')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-cryptocom-wh-secret"><?php echo e(__('Signing secret')); ?></label>
                        <input type="password" name="cryptocom_wh_secret" id="i-cryptocom-wh-secret" class="form-control<?php echo e($errors->has('cryptocom_wh_secret') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('cryptocom_wh_secret') ?? config('settings.cryptocom_wh_secret')); ?>">
                        <?php if($errors->has('cryptocom_wh_secret')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('cryptocom_wh_secret')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-cryptocom-wh-url"><?php echo e(__('Webhook URL')); ?></label>
                        <div class="input-group">
                            <input type="text" dir="ltr" name="cryptocom_wh_url" id="i-cryptocom-wh-url" class="form-control" value="<?php echo e(route('webhooks.cryptocom')); ?>" readonly>
                            <div class="input-group-append">
                                <div class="btn btn-primary" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-cryptocom-wh-url"><?php echo e(__('Copy')); ?></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tab-pane fade" id="pills-bank" role="tabpanel" aria-labelledby="pills-bank-tab">
                    <div class="form-group">
                        <label for="i-bank"><?php echo e(__('Enabled')); ?></label>
                        <select name="bank" id="i-bank" class="custom-select<?php echo e($errors->has('bank') ? ' is-invalid' : ''); ?>">
                            <?php $__currentLoopData = [1 => __('Yes'), 0 => __('No')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php if((old('bank') !== null && old('bank') == $key) || (config('settings.bank') == $key && old('bank') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('bank')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('bank')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-bank-account-owner"><?php echo e(__('Account owner')); ?></label>
                        <input type="text" name="bank_account_owner" id="i-bank-account-owner" class="form-control<?php echo e($errors->has('bank_account_owner') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('bank_account_owner') ?? config('settings.bank_account_owner')); ?>">
                        <?php if($errors->has('bank_account_owner')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('bank_account_owner')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-bank-account-number"><?php echo e(__('Account number')); ?></label>
                        <input type="text" name="bank_account_number" id="i-bank-account-number" class="form-control<?php echo e($errors->has('bank_account_number') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('bank_account_number') ?? config('settings.bank_account_number')); ?>">
                        <?php if($errors->has('bank_account_number')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('bank_account_number')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-bank-name"><?php echo e(__('Bank name')); ?></label>
                        <input type="text" name="bank_name" id="i-bank-name" class="form-control<?php echo e($errors->has('bank_name') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('bank_name') ?? config('settings.bank_name')); ?>">
                        <?php if($errors->has('bank_name')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('bank_name')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-bank-routing-number"><?php echo e(__('Routing number')); ?></label>
                        <input type="text" name="bank_routing_number" id="i-bank-routing-number" class="form-control<?php echo e($errors->has('bank_routing_number') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('bank_routing_number') ?? config('settings.bank_routing_number')); ?>">
                        <?php if($errors->has('bank_routing_number')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('bank_routing_number')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-bank-iban"><?php echo e(__('IBAN')); ?></label>
                        <input type="text" name="bank_iban" id="i-bank-iban" class="form-control<?php echo e($errors->has('bank_iban') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('bank_iban') ?? config('settings.bank_iban')); ?>">
                        <?php if($errors->has('bank_iban')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('bank_iban')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-bank-bic-swift"><?php echo e(__('BIC')); ?> / <?php echo e(__('SWIFT')); ?></label>
                        <input type="text" name="bank_bic_swift" id="i-bank-bic-swift" class="form-control<?php echo e($errors->has('bank_bic_swift') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('bank_bic_swift') ?? config('settings.bank_bic_swift')); ?>">
                        <?php if($errors->has('bank_bic_swift')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('bank_bic_swift')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
        </form>
    </div>
</div><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/admin/settings/payment-processors.blade.php ENDPATH**/ ?>