<?php $__env->startSection('site_title', formatTitle([__('Reports'), config('settings.title')])); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('admin.dashboard'), 'title' => __('Admin')],
    ['title' => __('Reports')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex">
    <div class="flex-grow-1">
        <h1 class="h2 mb-3 d-inline-block"><?php echo e(__('Reports')); ?></h1>
    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-header">
        <div class="row">
            <div class="col-12 col-md"><div class="font-weight-medium py-1"><?php echo e(__('Reports')); ?></div></div>
            <div class="col-12 col-md-auto">
                <form method="GET" action="<?php echo e(route('admin.reports')); ?>" class="d-md-flex">
                    <?php echo $__env->make('shared.filter-tags', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <div class="input-group input-group-sm">
                        <input class="form-control" name="search" placeholder="<?php echo e(__('Search')); ?>" value="<?php echo e(app('request')->input('search')); ?>">
                        <div class="input-group-append">
                            <button type="button" class="btn btn-outline-primary d-flex align-items-center dropdown-toggle dropdown-toggle-split reset-after" data-tooltip="true" title="<?php echo e(__('Filters')); ?>" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><?php echo $__env->make('icons.filter', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;</button>
                            <div class="dropdown-menu <?php echo e((__('lang_dir') == 'rtl' ? 'dropdown-menu' : 'dropdown-menu-right')); ?> border-0 shadow width-64 p-0" id="search-filters">
                                <div class="dropdown-header py-3">
                                    <div class="row">
                                        <div class="col"><div class="font-weight-medium m-0 text-body"><?php echo e(__('Filters')); ?></div></div>
                                        <div class="col-auto"><a href="<?php echo e(route('admin.reports')); ?>" class="text-secondary"><?php echo e(__('Reset')); ?></a></div>
                                    </div>
                                </div>

                                <div class="dropdown-divider my-0"></div>

                                <input name="user_id" type="hidden" value="<?php echo e(request()->input('user_id')); ?>">

                                <div class="max-height-96 overflow-auto pt-3">
                                    <div class="form-group px-4">
                                        <label for="i-search-by" class="small"><?php echo e(__('Search by')); ?></label>
                                        <select name="search_by" id="i-search-by" class="custom-select custom-select-sm">
                                            <?php $__currentLoopData = ['url' => __('URL')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>" <?php if(request()->input('search_by') == $key || !request()->input('search_by') && $key == 'name'): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group px-4">
                                        <label for="i-sort-by" class="small"><?php echo e(__('Sort by')); ?></label>
                                        <select name="sort_by" id="i-sort-by" class="custom-select custom-select-sm">
                                            <?php $__currentLoopData = ['id' => __('Date created'), 'url' => __('URL')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>" <?php if(request()->input('sort_by') == $key): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group px-4">
                                        <label for="i-sort" class="small"><?php echo e(__('Sort')); ?></label>
                                        <select name="sort" id="i-sort" class="custom-select custom-select-sm">
                                            <?php $__currentLoopData = ['desc' => __('Descending'), 'asc' => __('Ascending')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>" <?php if(request()->input('sort') == $key): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group px-4">
                                        <label for="i-per-page" class="small"><?php echo e(__('Results per page')); ?></label>
                                        <select name="per_page" id="i-per-page" class="custom-select custom-select-sm">
                                            <?php $__currentLoopData = [10, 25, 50, 100]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($value); ?>" <?php if(request()->input('per_page') == $value || request()->input('per_page') == null && $value == config('settings.paginate')): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="dropdown-divider my-0"></div>

                                <div class="px-4 py-3">
                                    <button type="submit" class="btn btn-primary btn-sm btn-block"><?php echo e(__('Search')); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php if(count($reports) == 0): ?>
            <?php echo e(__('No data')); ?>.
        <?php else: ?>
            <div class="list-group list-group-flush my-n3">
                <div class="list-group-item px-0 text-muted">
                    <div class="row d-flex align-items-center">
                        <div class="col">
                            <div class="row align-items-center">
                                <div class="col-12 col-lg-6 text-truncate">
                                    <?php echo e(__('URL')); ?>

                                </div>

                                <div class="col-12 col-lg-6 text-truncate">
                                    <?php echo e(__('User')); ?>

                                </div>
                            </div>
                        </div>
                        <div class="col-auto">
                            <div class="form-row">
                                <div class="col">
                                    <div class="invisible btn d-flex align-items-center btn-sm text-primary"><?php echo $__env->make('icons.more-horiz', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="list-group-item px-0">
                        <div class="row d-flex align-items-center">
                            <div class="col text-truncate">
                                <div class="row text-truncate">
                                    <div class="col-12 col-lg-6 d-flex align-items-center text-truncate">
                                        <img src="https://icons.duckduckgo.com/ip3/<?php echo e(parse_url($report->fullUrl, PHP_URL_HOST)); ?>.ico" rel="noreferrer" class="width-4 height-4 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>"> <div class="text-truncate" dir="ltr"><div class="text-truncate" data-tooltip="true" title="<?php echo e($report->url); ?>"><a href="<?php echo e(route('admin.reports.edit', $report->id)); ?>" dir="ltr"><?php echo e($report->url); ?></a></div></div>
                                    </div>

                                    <div class="col-12 col-lg-5 d-flex align-items-center">
                                        <div class="d-inline-block <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">
                                            <img src="<?php echo e(gravatar($report->user->email, 48)); ?>" class="rounded-circle width-6 height-6">
                                        </div>
                                        <a href="<?php echo e(route('admin.users.edit', $report->user->id)); ?>"><?php echo e($report->user->name); ?></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-auto">
                                <div class="form-row">
                                    <div class="col">
                                        <?php echo $__env->make('reports.partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <div class="mt-3 align-items-center">
                    <div class="row">
                        <div class="col">
                            <div class="mt-2 mb-3"><?php echo e(__('Showing :from-:to of :total', ['from' => $reports->firstItem(), 'to' => $reports->lastItem(), 'total' => $reports->total()])); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <?php echo e($reports->onEachSide(1)->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/admin/reports/list.blade.php ENDPATH**/ ?>