<?php $__env->startSection('site_title', formatTitle([__('Authentication'), __('Settings'), config('settings.title')])); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('admin.dashboard'), 'title' => __('Admin')],
    ['title' => __('Settings')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<h1 class="h2 mb-3 d-inline-block"><?php echo e(__('Authentication')); ?></h1>

<div class="card border-0 shadow-sm">
    <div class="card-header"><div class="font-weight-medium py-1"><?php echo e(__('Authentication')); ?></div></div>
    <div class="card-body">
        <ul class="nav nav-pills d-flex flex-fill flex-column flex-md-row mb-3" id="pills-tab" role="tablist">
            <li class="nav-item flex-grow-1 text-center">
                <a class="nav-link active" id="pills-registration-tab" data-toggle="pill" href="#pills-registration" role="tab" aria-controls="pills-registration" aria-selected="true"><?php echo e(__('Registration')); ?></a>
            </li>

            <li class="nav-item flex-grow-1 text-center">
                <a class="nav-link" id="pills-login-tab" data-toggle="pill" href="#pills-login" role="tab" aria-controls="pills-login" aria-selected="false"><?php echo e(__('Login')); ?></a>
            </li>
        </ul>

        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('admin.settings', 'authentication')); ?>" method="post" enctype="multipart/form-data">

            <?php echo csrf_field(); ?>

            <div class="tab-content" id="pills-tabContent">
                <div class="tab-pane fade show active" id="pills-registration" role="tabpanel" aria-labelledby="pills-registration-tab">
                    <div class="form-group">
                        <label for="i-registration"><?php echo e(__('Registration')); ?></label>
                        <select name="registration" id="i-registration" class="custom-select<?php echo e($errors->has('registration') ? ' is-invalid' : ''); ?>">
                            <?php $__currentLoopData = [0 => __('Disabled'), 1 => __('Enabled')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php if((old('registration') !== null && old('registration') == $key) || (config('settings.registration') == $key && old('registration') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('registration')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('registration')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-registration-verification"><?php echo e(__('Email verification')); ?></label>
                        <select name="registration_verification" id="i-registration-verification" class="custom-select<?php echo e($errors->has('registration_verification') ? ' is-invalid' : ''); ?>">
                            <?php $__currentLoopData = [0 => __('Disabled'), 1 => __('Enabled')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php if((old('registration_verification') !== null && old('registration_verification') == $key) || (config('settings.registration_verification') == $key && old('registration_verification') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('registration_verification')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('registration_verification')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="i-registration-tfa" class="d-inline-flex align-items-center"><span class="<?php echo e((__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')); ?>"><?php echo e(__('Two-factor authentication')); ?></span><span class="badge badge-secondary"><?php echo e(__('Default')); ?></span></label>
                        <select name="registration_tfa" id="i-registration-tfa" class="custom-select<?php echo e($errors->has('registration_tfa') ? ' is-invalid' : ''); ?>">
                            <?php $__currentLoopData = [0 => __('Disabled'), 1 => __('Enabled')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php if((old('registration_tfa') !== null && old('registration_tfa') == $key) || (config('settings.registration_tfa') == $key && old('registration_tfa') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('registration_tfa')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('registration_tfa')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="tab-pane fade" id="pills-login" role="tabpanel" aria-labelledby="pills-login-tab">
                    <div class="form-group">
                        <label for="i-login-tfa"><?php echo e(__('Two-factor authentication')); ?></label>
                        <select name="login_tfa" id="i-login-tfa" class="custom-select<?php echo e($errors->has('login_tfa') ? ' is-invalid' : ''); ?>">
                            <?php $__currentLoopData = [0 => __('Disabled'), 1 => __('Enabled')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php if((old('login_tfa') !== null && old('login_tfa') == $key) || (config('settings.login_tfa') == $key && old('login_tfa') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('login_tfa')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('login_tfa')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
        </form>

    </div>
</div><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/admin/settings/authentication.blade.php ENDPATH**/ ?>