<footer id="footer" class="footer bg-base-0 <?php echo e(isset($lightweight) || (request()->is('reports/*') && !request()->is('reports/*/edit')) ? 'd-print-none' : ''); ?>">
    <div class="container py-5">
        <?php if(isset($lightweight) == false): ?>
            <div class="row">
                <div class="col-12 col-lg">
                    <ul class="nav p-0 mx-n3 mb-3 mb-lg-0 d-flex flex-column flex-lg-row">
                        <li class="nav-item d-flex">
                            <a href="<?php echo e(route('contact')); ?>" class="nav-link py-1"><?php echo e(__('Contact')); ?></a>
                        </li>

                        <li class="nav-item d-flex">
                            <a href="<?php echo e(config('settings.legal_terms_url')); ?>" class="nav-link py-1"><?php echo e(__('Terms')); ?></a>
                        </li>

                        <li class="nav-item d-flex">
                            <a href="<?php echo e(config('settings.legal_privacy_url')); ?>" class="nav-link py-1"><?php echo e(__('Privacy')); ?></a>
                        </li>

                        <li class="nav-item">
                            <a href="<?php echo e(route('developers')); ?>" class="nav-link py-1"><?php echo e(__('Developers')); ?></a>
                        </li>

                        <?php $__currentLoopData = $footerPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="nav-item d-flex">
                                <a href="<?php echo e(route('pages.show', $page['slug'])); ?>" class="nav-link py-1"><?php echo e(__($page['name'])); ?></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <div class="col-12 col-lg-auto">
                    <div class="mt-auto py-1 d-flex align-items-center">
                        <?php $__currentLoopData = ['social_facebook' => __('Facebook'), 'social_twitter' => 'Twitter', 'social_instagram' => 'Instagram', 'social_youtube' => 'YouTube']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $url => $title): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(config('settings.'.$url)): ?>
                                <a href="<?php echo e(config('settings.'.$url)); ?>" class="text-secondary text-decoration-none d-flex align-items-center<?php echo e((__('lang_dir') == 'rtl' ? ' ml-3 ml-lg-0 mr-lg-3' : ' mr-3 mr-lg-0 ml-lg-3')); ?>" data-tooltip="true" title="<?php echo e($title); ?>" rel="nofollow">
                                    <?php echo $__env->make('icons.share.'.strtolower($title), ['class' => 'fill-current width-5 height-5'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            <hr>
        <?php endif; ?>
        <div class="row">
            <div class="col-12 col-lg order-2 order-lg-1">
                <div class="text-muted py-1"><?php echo e(__('© :year :name.', ['year' => now()->year, 'name' => config('settings.title')])); ?> <?php echo e(__('All rights reserved.')); ?></div>
            </div>
            <div class="col-12 col-lg-auto order-1 order-lg-2 d-flex flex-column flex-lg-row">
                <div class="nav p-0 mx-n3 mb-3 mb-lg-0 d-flex flex-column flex-lg-row">
                    <div class="nav-item d-flex">
                        <a href="#" class="nav-link py-1 d-flex align-items-center text-secondary" id="dark-mode" data-tooltip="true" title="<?php echo e(__('Change theme')); ?>">
                            <?php echo $__env->make('icons.contrast', ['class' => 'width-4 height-4 fill-current ' . (__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <span class="text-muted" data-text-light="<?php echo e(__('Light')); ?>" data-text-dark="<?php echo e(__('Dark')); ?>"><?php echo e((config('settings.dark_mode') == 1 ? __('Dark') : __('Light'))); ?></span>
                        </a>
                    </div>

                    <?php if(count(config('app.locales')) > 1): ?>
                        <div class="nav-item d-flex">
                            <a href="#" class="nav-link py-1 d-flex align-items-center text-secondary" data-toggle="modal" data-target="#change-language-modal" data-tooltip="true" title="<?php echo e(__('Change language')); ?>">
                                <?php echo $__env->make('icons.language', ['class' => 'width-4 height-4 fill-current ' . (__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <span class="text-muted"><?php echo e(config('app.locales')[config('app.locale')]['name']); ?></span>
                            </a>
                        </div>

                        <div class="modal fade" id="change-language-modal" tabindex="-1" role="dialog" aria-labelledby="change-language-modal-label" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content border-0 shadow">
                                    <div class="modal-header">
                                        <h6 class="modal-title" id="change-language-modal-label"><?php echo e(__('Change language')); ?></h6>
                                        <button type="button" class="close d-flex align-items-center justify-content-center width-12 height-14" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true" class="d-flex align-items-center"><?php echo $__env->make('icons.close', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                                        </button>
                                    </div>
                                    <form action="<?php echo e(route('locale')); ?>" method="post" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <div class="modal-body">
                                            <div class="row">
                                                <?php $__currentLoopData = config('app.locales'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-6">
                                                        <div class="custom-control custom-radio">
                                                            <input type="radio" id="i-language-<?php echo e($code); ?>" name="locale" class="custom-control-input" value="<?php echo e($code); ?>" <?php if(config('app.locale') == $code): ?> checked <?php endif; ?>>
                                                            <label class="custom-control-label" for="i-language-<?php echo e($code); ?>" lang="<?php echo e($code); ?>"><?php echo e($language['name']); ?></label>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                                            <button type="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <?php echo $__env->make('shared.cookie-law', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</footer>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/shared/footer.blade.php ENDPATH**/ ?>