<?php $__env->startSection('site_title', formatTitle([__('Appearance'), __('Settings'), config('settings.title')])); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('admin.dashboard'), 'title' => __('Admin')],
    ['title' => __('Settings')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<h1 class="h2 mb-3 d-inline-block"><?php echo e(__('Appearance')); ?></h1>

<div class="card border-0 shadow-sm">
    <div class="card-header"><div class="font-weight-medium py-1"><?php echo e(__('Appearance')); ?></div></div>
    <div class="card-body">

        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('admin.settings', 'appearance')); ?>" method="post" enctype="multipart/form-data">

            <?php echo csrf_field(); ?>

            <div class="row mx-n2">
                <div class="col-12 col-md-6 px-2">
                    <div class="form-group">
                        <label for="i-logo" class="d-inline-flex align-items-center"><span class="<?php echo e((__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')); ?>"><?php echo e(__('Logo')); ?></span><span class="badge badge-secondary"><?php echo e(__('Light')); ?></span></label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text py-1 px-2"><img src="<?php echo e(url('/')); ?>/uploads/brand/<?php echo e(config('settings.logo')); ?>" style="max-height: 1.625rem"></span>
                            </div>
                            <div class="custom-file">
                                <input type="file" name="logo" id="i-logo" class="custom-file-input<?php echo e($errors->has('logo') ? ' is-invalid' : ''); ?>" accept="jpeg,png,bmp,gif,svg,webp">
                                <label class="custom-file-label" for="i-logo" data-browse="<?php echo e(__('Browse')); ?>"><?php echo e(__('Choose file')); ?></label>
                            </div>
                        </div>
                        <?php if($errors->has('logo')): ?>
                            <span class="invalid-feedback d-block" role="alert">
                                <strong><?php echo e($errors->first('logo')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-12 col-md-6 px-2">
                    <div class="form-group">
                        <label for="i-logo-dark" class="d-inline-flex align-items-center"><span class="<?php echo e((__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')); ?>"><?php echo e(__('Logo')); ?></span><span class="badge badge-secondary"><?php echo e(__('Dark')); ?></span></label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text py-1 px-2"><img src="<?php echo e(url('/')); ?>/uploads/brand/<?php echo e(config('settings.logo_dark')); ?>" style="max-height: 1.625rem"></span>
                            </div>
                            <div class="custom-file">
                                <input type="file" name="logo_dark" id="i-logo-dark" class="custom-file-input<?php echo e($errors->has('logo_dark') ? ' is-invalid' : ''); ?>" accept="jpeg,png,bmp,gif,svg,webp">
                                <label class="custom-file-label" for="i-logo-dark" data-browse="<?php echo e(__('Browse')); ?>"><?php echo e(__('Choose file')); ?></label>
                            </div>
                        </div>
                        <?php if($errors->has('logo_dark')): ?>
                            <span class="invalid-feedback d-block" role="alert">
                                <strong><?php echo e($errors->first('logo_dark')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="i-favicon"><?php echo e(__('Favicon')); ?></label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text py-1 px-2"><img src="<?php echo e(url('/')); ?>/uploads/brand/<?php echo e(config('settings.favicon')); ?>" style="max-height: 1.625rem;"></span>
                    </div>
                    <div class="custom-file">
                        <input type="file" name="favicon" id="i-favicon" class="custom-file-input<?php echo e($errors->has('favicon') ? ' is-invalid' : ''); ?>" accept="jpeg,png,bmp,gif,svg,webp">
                        <label class="custom-file-label" for="i-favicon" data-browse="<?php echo e(__('Browse')); ?>"><?php echo e(__('Choose file')); ?></label>
                    </div>
                </div>
                <?php if($errors->has('favicon')): ?>
                    <span class="invalid-feedback d-block" role="alert">
                        <strong><?php echo e($errors->first('favicon')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-theme" class="d-inline-flex align-items-center"><span class="<?php echo e((__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')); ?>"><?php echo e(__('Theme')); ?></span><span class="badge badge-secondary"><?php echo e(__('Default')); ?></span></label>
                <select name="theme" id="i-theme" class="custom-select<?php echo e($errors->has('theme') ? ' is-invalid' : ''); ?>">
                    <?php $__currentLoopData = [0 => __('Light'), 1 => __('Dark')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php if((old('theme') !== null && old('theme') == $key) || (config('settings.theme') == $key && old('theme') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('theme')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('theme')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-custom-css"><?php echo e(__('Custom CSS')); ?></label>
                <textarea name="custom_css" id="i-custom-css" class="form-control<?php echo e($errors->has('custom_css') ? ' is-invalid' : ''); ?>"><?php echo e(old('custom_css') ?? config('settings.custom_css')); ?></textarea>
                <?php if($errors->has('custom_css')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('custom_css')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
        </form>

    </div>
</div><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/admin/settings/appearance.blade.php ENDPATH**/ ?>