

<?php $__env->startSection('site_title', formatTitle([__('Checkout'), config('settings.title')])); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-base-1 flex-fill">
        <div class="container py-3 my-3">

            <?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
                ['url' => route('dashboard'), 'title' => __('Home')],
                ['url' => route('pricing'), 'title' => __('Pricing')],
                ['title' => __('Checkout')],
            ]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <h1 class="h2 mb-3 d-inline-block"><?php echo e(__('Checkout')); ?></h1>

            <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <form method="post" enctype="multipart/form-data" id="form-payment">
                <?php echo csrf_field(); ?>
                <div class="row m-n2">
                    <div class="col-12 col-lg-8 p-2">
                        <div class="card border-0 shadow-sm mb-3 overflow-hidden <?php if(($plan->trial_days && !$user->plan_trial_ends_at) || ($coupon && $coupon->type)): ?> d-none <?php endif; ?>">
                            <div class="card-header">
                                <div class="font-weight-medium py-1"><?php echo e(__('Payment method')); ?></div>
                            </div>
                            <div class="card-body p-0">
                                <ul class="list-group list-group-flush">
                                    <?php $__currentLoopData = paymentProcessors(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="list-group-item">
                                            <div class="custom-control custom-radio">
                                                <input type="radio" id="payment-method-<?php echo e($key); ?>" name="payment_processor" class="custom-control-input<?php echo e($errors->has('payment_processor') ? ' is-invalid' : ''); ?>" value="<?php echo e($key); ?>" <?php if(request()->input('payment') == $key && old('payment_processor') == null || old('payment_processor') == $key || $loop->first && old('payment_processor') == null): ?>) checked <?php endif; ?>>
                                                <label class="custom-control-label cursor-pointer d-block" for="payment-method-<?php echo e($key); ?>">
                                                    <div class="row">
                                                        <div class="col-12 col-lg d-flex align-items-center">
                                                            <img src="<?php echo e(url('/')); ?>/images/icons/payments/<?php echo e($key); ?>.svg" class="width-6 rounded-sm"><span class="font-weight-bold <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e($value['name'] == 'Bank' ? __('Bank') : $value['name']); ?></span>
                                                        </div>
                                                        <div class="col-12 col-lg-auto mt-1 mt-lg-0">
                                                            <div class="text-muted"><?php echo e(__($value['type'])); ?></div>
                                                        </div>
                                                    </div>
                                                </label>

                                                <?php if($key == 'bank'): ?>
                                                    <div class="d-none" id="bank-instructions">
                                                        <div class="alert alert-info my-3">
                                                            <?php echo __('When issuing the bank payment, please make sure to include the value of the :id field in the reference field of the payment.', ['id' => '<strong>' . __('Payment ID') . '</strong>']); ?>

                                                        </div>

                                                        <?php if(config('settings.bank_account_owner')): ?>
                                                            <div class="form-group mb-2">
                                                                <label for="i-bank-account-owner"><?php echo e(__('Account owner')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text" name="bank_account_owner" id="i-bank-account-owner" class="form-control form-control-sm<?php echo e($errors->has('bank_account_owner') ? ' is-invalid' : ''); ?>" value="<?php echo e(config('settings.bank_account_owner')); ?>" readonly>
                                                                    <div class="input-group-append">
                                                                        <div class="btn btn-sm btn-primary" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-bank-account-owner"><?php echo e(__('Copy')); ?></div>
                                                                    </div>
                                                                </div>
                                                                <?php if($errors->has('bank_account_owner')): ?>
                                                                    <span class="invalid-feedback d-block" role="alert">
                                                                        <strong><?php echo e($errors->first('bank_account_owner')); ?></strong>
                                                                    </span>
                                                                <?php endif; ?>
                                                            </div>
                                                        <?php endif; ?>

                                                        <?php if(config('settings.bank_account_number')): ?>
                                                            <div class="form-group mb-2">
                                                                <label for="i-bank-account-number"><?php echo e(__('Account number')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text" name="bank_account_number" id="i-bank-account-number" class="form-control form-control-sm<?php echo e($errors->has('bank_account_number') ? ' is-invalid' : ''); ?>" value="<?php echo e(config('settings.bank_account_number')); ?>" readonly>
                                                                    <div class="input-group-append">
                                                                        <div class="btn btn-sm btn-primary" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-bank-account-number"><?php echo e(__('Copy')); ?></div>
                                                                    </div>
                                                                </div>
                                                                <?php if($errors->has('bank_account_number')): ?>
                                                                    <span class="invalid-feedback d-block" role="alert">
                                                                        <strong><?php echo e($errors->first('bank_account_number')); ?></strong>
                                                                    </span>
                                                                <?php endif; ?>
                                                            </div>
                                                        <?php endif; ?>

                                                        <?php if(config('settings.bank_name')): ?>
                                                            <div class="form-group mb-2">
                                                                <label for="i-bank-name"><?php echo e(__('Bank name')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text" name="bank_name" id="i-bank-name" class="form-control form-control-sm<?php echo e($errors->has('bank_name') ? ' is-invalid' : ''); ?>" value="<?php echo e(config('settings.bank_name')); ?>" readonly>
                                                                    <div class="input-group-append">
                                                                        <div class="btn btn-sm btn-primary" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-bank-name"><?php echo e(__('Copy')); ?></div>
                                                                    </div>
                                                                </div>
                                                                <?php if($errors->has('bank_name')): ?>
                                                                    <span class="invalid-feedback d-block" role="alert">
                                                                        <strong><?php echo e($errors->first('bank_name')); ?></strong>
                                                                    </span>
                                                                <?php endif; ?>
                                                            </div>
                                                        <?php endif; ?>

                                                        <?php if(config('settings.bank_routing_number')): ?>
                                                            <div class="form-group mb-2">
                                                                <label for="i-bank-routing-number"><?php echo e(__('Routing number')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text" name="bank_routing_number" id="i-bank-routing-number" class="form-control form-control-sm<?php echo e($errors->has('bank_routing_number') ? ' is-invalid' : ''); ?>" value="<?php echo e(config('settings.bank_routing_number')); ?>" readonly>
                                                                    <div class="input-group-append">
                                                                        <div class="btn btn-sm btn-primary" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-bank-routing-number"><?php echo e(__('Copy')); ?></div>
                                                                    </div>
                                                                </div>
                                                                <?php if($errors->has('bank_routing_number')): ?>
                                                                    <span class="invalid-feedback d-block" role="alert">
                                                                        <strong><?php echo e($errors->first('bank_routing_number')); ?></strong>
                                                                    </span>
                                                                <?php endif; ?>
                                                            </div>
                                                        <?php endif; ?>

                                                        <?php if(config('settings.bank_iban')): ?>
                                                            <div class="form-group mb-2">
                                                                <label for="i-bank-iban"><?php echo e(__('IBAN')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text" name="bank_iban" id="i-bank-iban" class="form-control form-control-sm<?php echo e($errors->has('bank_iban') ? ' is-invalid' : ''); ?>" value="<?php echo e(config('settings.bank_iban')); ?>" readonly>
                                                                    <div class="input-group-append">
                                                                        <div class="btn btn-sm btn-primary" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-bank-iban"><?php echo e(__('Copy')); ?></div>
                                                                    </div>
                                                                </div>
                                                                <?php if($errors->has('bank_iban')): ?>
                                                                    <span class="invalid-feedback d-block" role="alert">
                                                                        <strong><?php echo e($errors->first('bank_iban')); ?></strong>
                                                                    </span>
                                                                <?php endif; ?>
                                                            </div>
                                                        <?php endif; ?>

                                                        <?php if(config('settings.bank_bic_swift')): ?>
                                                            <div class="form-group mb-2">
                                                                <label for="i-bank-bic-swift"><?php echo e(__('BIC')); ?> / <?php echo e(__('SWIFT')); ?></label>
                                                                <div class="input-group">
                                                                    <input type="text" name="bank_bic_swift" id="i-bank-bic-swift" class="form-control form-control-sm<?php echo e($errors->has('bank_bic_swift') ? ' is-invalid' : ''); ?>" value="<?php echo e(config('settings.bank_bic_swift')); ?>" readonly>
                                                                    <div class="input-group-append">
                                                                        <div class="btn btn-sm btn-primary" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-bank-bic-swift"><?php echo e(__('Copy')); ?></div>
                                                                    </div>
                                                                </div>
                                                                <?php if($errors->has('bank_bic_swift')): ?>
                                                                    <span class="invalid-feedback d-block" role="alert">
                                                                        <strong><?php echo e($errors->first('bank_bic_swift')); ?></strong>
                                                                    </span>
                                                                <?php endif; ?>
                                                            </div>
                                                        <?php endif; ?>

                                                        <div class="form-group mb-2">
                                                            <label for="i-payment-id"><?php echo e(__('Payment ID')); ?></label>
                                                            <div class="input-group">
                                                                <input type="text" name="payment_id" id="i-payment-id" class="form-control form-control-sm<?php echo e($errors->has('payment_id') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('payment_id') ?? Str::random(16)); ?>" readonly>
                                                                <div class="input-group-append">
                                                                    <div class="btn btn-sm btn-primary" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-payment-id"><?php echo e(__('Copy')); ?></div>
                                                                </div>
                                                            </div>
                                                            <?php if($errors->has('payment_id')): ?>
                                                                <span class="invalid-feedback d-block" role="alert">
                                                                    <strong><?php echo e($errors->first('payment_id')); ?></strong>
                                                                </span>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if($key == 'vakifbank'): ?>
                                                    <div class="checkout" id="bank-card-payment">
                                                        <div class="credit-card-box">
                                                            <div class="flip">
                                                                <div class="front">
                                                                    <div class="chip"></div>
                                                                    <div class="logo">
                                                                        <svg version="1.1" id="visa" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                                                             width="47.834px" height="47.834px" viewBox="0 0 47.834 47.834" style="enable-background:new 0 0 47.834 47.834;">
                                                                            <g>
                                                                                <g>
                                                                                    <path d="M44.688,16.814h-3.004c-0.933,0-1.627,0.254-2.037,1.184l-5.773,13.074h4.083c0,0,0.666-1.758,0.817-2.143
                         c0.447,0,4.414,0.006,4.979,0.006c0.116,0.498,0.474,2.137,0.474,2.137h3.607L44.688,16.814z M39.893,26.01
                         c0.32-0.819,1.549-3.987,1.549-3.987c-0.021,0.039,0.317-0.825,0.518-1.362l0.262,1.23c0,0,0.745,3.406,0.901,4.119H39.893z
                         M34.146,26.404c-0.028,2.963-2.684,4.875-6.771,4.875c-1.743-0.018-3.422-0.361-4.332-0.76l0.547-3.193l0.501,0.228
                         c1.277,0.532,2.104,0.747,3.661,0.747c1.117,0,2.313-0.438,2.325-1.393c0.007-0.625-0.501-1.07-2.016-1.77
                         c-1.476-0.683-3.43-1.827-3.405-3.876c0.021-2.773,2.729-4.708,6.571-4.708c1.506,0,2.713,0.31,3.483,0.599l-0.526,3.092
                         l-0.351-0.165c-0.716-0.288-1.638-0.566-2.91-0.546c-1.522,0-2.228,0.634-2.228,1.227c-0.008,0.668,0.824,1.108,2.184,1.77
                         C33.126,23.546,34.163,24.783,34.146,26.404z M0,16.962l0.05-0.286h6.028c0.813,0.031,1.468,0.29,1.694,1.159l1.311,6.304
                         C7.795,20.842,4.691,18.099,0,16.962z M17.581,16.812l-6.123,14.239l-4.114,0.007L3.862,19.161
                         c2.503,1.602,4.635,4.144,5.386,5.914l0.406,1.469l3.808-9.729L17.581,16.812L17.581,16.812z M19.153,16.8h3.89L20.61,31.066
                         h-3.888L19.153,16.8z"/>
                                                                                </g>
                                                                            </g>
                                                                        </svg>
                                                                    </div>
                                                                    <div class="number"></div>
                                                                    <div class="card-holder">
                                                                        <label>Card holder</label>
                                                                        <div></div>
                                                                    </div>
                                                                    <div class="card-expiration-date">
                                                                        <label>Expires</label>
                                                                        <div></div>
                                                                    </div>
                                                                </div>
                                                                <div class="back">
                                                                    <div class="strip"></div>
                                                                    <div class="logo">
                                                                        <svg version="1.1" id="visa" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                                                             width="47.834px" height="47.834px" viewBox="0 0 47.834 47.834" style="enable-background:new 0 0 47.834 47.834;">
                                                                            <g>
                                                                                <g>
                                                                                    <path d="M44.688,16.814h-3.004c-0.933,0-1.627,0.254-2.037,1.184l-5.773,13.074h4.083c0,0,0.666-1.758,0.817-2.143
                         c0.447,0,4.414,0.006,4.979,0.006c0.116,0.498,0.474,2.137,0.474,2.137h3.607L44.688,16.814z M39.893,26.01
                         c0.32-0.819,1.549-3.987,1.549-3.987c-0.021,0.039,0.317-0.825,0.518-1.362l0.262,1.23c0,0,0.745,3.406,0.901,4.119H39.893z
                         M34.146,26.404c-0.028,2.963-2.684,4.875-6.771,4.875c-1.743-0.018-3.422-0.361-4.332-0.76l0.547-3.193l0.501,0.228
                         c1.277,0.532,2.104,0.747,3.661,0.747c1.117,0,2.313-0.438,2.325-1.393c0.007-0.625-0.501-1.07-2.016-1.77
                         c-1.476-0.683-3.43-1.827-3.405-3.876c0.021-2.773,2.729-4.708,6.571-4.708c1.506,0,2.713,0.31,3.483,0.599l-0.526,3.092
                         l-0.351-0.165c-0.716-0.288-1.638-0.566-2.91-0.546c-1.522,0-2.228,0.634-2.228,1.227c-0.008,0.668,0.824,1.108,2.184,1.77
                         C33.126,23.546,34.163,24.783,34.146,26.404z M0,16.962l0.05-0.286h6.028c0.813,0.031,1.468,0.29,1.694,1.159l1.311,6.304
                         C7.795,20.842,4.691,18.099,0,16.962z M17.581,16.812l-6.123,14.239l-4.114,0.007L3.862,19.161
                         c2.503,1.602,4.635,4.144,5.386,5.914l0.406,1.469l3.808-9.729L17.581,16.812L17.581,16.812z M19.153,16.8h3.89L20.61,31.066
                         h-3.888L19.153,16.8z"/>
                                                                                </g>
                                                                            </g>
                                                                        </svg>

                                                                    </div>
                                                                    <div class="ccv">
                                                                        <label>CCV</label>
                                                                        <div></div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="form" autocomplete="off" novalidate>
                                                            <fieldset>
                                                                <label for="card-number">Card Number</label>
                                                                <input type="num" id="card-number" class="input-cart-number" maxlength="4" />
                                                                <input type="num" id="card-number-1" class="input-cart-number" maxlength="4" />
                                                                <input type="num" id="card-number-2" class="input-cart-number" maxlength="4" />
                                                                <input type="num" id="card-number-3" class="input-cart-number" maxlength="4" />
                                                            </fieldset>
                                                            <fieldset>
                                                                <label for="card-holder">Card holder</label>
                                                                <input type="text" id="card-holder" />
                                                            </fieldset>
                                                            <fieldset class="fieldset-expiration">
                                                                <label for="card-expiration-month">Expiration date</label>
                                                                <div class="select">
                                                                    <select id="card-expiration-month">
                                                                        <option></option>
                                                                        <option>01</option>
                                                                        <option>02</option>
                                                                        <option>03</option>
                                                                        <option>04</option>
                                                                        <option>05</option>
                                                                        <option>06</option>
                                                                        <option>07</option>
                                                                        <option>08</option>
                                                                        <option>09</option>
                                                                        <option>10</option>
                                                                        <option>11</option>
                                                                        <option>12</option>
                                                                    </select>
                                                                </div>
                                                                <div class="select">
                                                                    <select id="card-expiration-year">
                                                                        <option></option>
                                                                        <option>2016</option>
                                                                        <option>2017</option>
                                                                        <option>2018</option>
                                                                        <option>2019</option>
                                                                        <option>2020</option>
                                                                        <option>2021</option>
                                                                        <option>2022</option>
                                                                        <option>2023</option>
                                                                        <option>2024</option>
                                                                        <option>2025</option>
                                                                    </select>
                                                                </div>
                                                            </fieldset>
                                                            <fieldset class="fieldset-ccv">
                                                                <label for="card-ccv">CCV</label>
                                                                <input type="text" id="card-ccv" maxlength="3" />
                                                            </fieldset>
                                                            <button class="btn"><i class="fa fa-lock"></i> submit</button>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>

                            <?php if($errors->has('payment_processor')): ?>
                                <div class="card-footer">
                                    <span class="invalid-feedback d-block mt-0" role="alert">
                                        <strong><?php echo e($errors->first('payment_processor')); ?></strong>
                                    </span>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="card border-0 shadow-sm">
                            <div class="card-header">
                                <div class="font-weight-medium py-1"><?php echo e(__('Billing information')); ?></div>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="i-name"><?php echo e(__('Name')); ?></label>
                                    <input type="text" name="name" id="i-name" class="form-control<?php echo e($errors->has('name') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('name') ?? ($user->billing_information->name ?? null)); ?>">
                                    <?php if($errors->has('name')): ?>
                                        <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('name')); ?></strong>
                                    </span>
                                    <?php endif; ?>
                                </div>

                                <div class="form-group">
                                    <label for="i-address"><?php echo e(__('Address')); ?></label>
                                    <input type="text" name="address" id="i-address" class="form-control<?php echo e($errors->has('address') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('address') ?? ($user->billing_information->address ?? null)); ?>">
                                    <?php if($errors->has('address')): ?>
                                        <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('address')); ?></strong>
                                    </span>
                                    <?php endif; ?>
                                </div>

                                <div class="row mx-n2">
                                    <div class="col-12 col-md-6 px-2">
                                        <div class="form-group">
                                            <label for="i-city"><?php echo e(__('City')); ?></label>
                                            <input type="text" name="city" id="i-city" class="form-control<?php echo e($errors->has('city') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('city') ?? ($user->billing_information->city ?? null)); ?>">
                                            <?php if($errors->has('city')): ?>
                                                <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e($errors->first('city')); ?></strong>
                                            </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-3 px-2">
                                        <div class="form-group">
                                            <label for="i-state"><?php echo e(__('State')); ?></label>
                                            <input type="text" name="state" id="i-state" class="form-control<?php echo e($errors->has('state') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('state') ?? ($user->billing_information->state ?? null)); ?>">
                                            <?php if($errors->has('state')): ?>
                                                <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e($errors->first('state')); ?></strong>
                                            </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-3 px-2">
                                        <div class="form-group">
                                            <label for="i-postal-code"><?php echo e(__('Postal code')); ?></label>
                                            <input type="text" name="postal_code" id="i-postal-code" class="form-control<?php echo e($errors->has('postal_code') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('postal_code') ?? ($user->billing_information->postal_code ?? null)); ?>">
                                            <?php if($errors->has('postal_code')): ?>
                                                <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e($errors->first('postal_code')); ?></strong>
                                            </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="i-country"><?php echo e(__('Country')); ?></label>
                                    <select name="country" id="i-country" class="custom-select<?php echo e($errors->has('country') ? ' is-invalid' : ''); ?>">
                                        <option value="" hidden disabled selected><?php echo e(__('Country')); ?></option>
                                        <?php $__currentLoopData = config('countries'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>" <?php if((old('country') !== null && $key == old('country')) || (isset($user->billing_information->country) && $key == $user->billing_information->country) && old('country') == null): ?> selected <?php endif; ?>><?php echo e(__($value)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php if($errors->has('country')): ?>
                                        <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('country')); ?></strong>
                                    </span>
                                    <?php endif; ?>
                                </div>

                                <div class="form-group mb-0">
                                    <label for="i-phone"><?php echo e(__('Phone')); ?></label>
                                    <input type="text" name="phone" id="i-phone" class="form-control<?php echo e($errors->has('phone') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('phone') ?? ($user->billing_information->phone ?? null)); ?>">
                                    <?php if($errors->has('phone')): ?>
                                        <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('phone')); ?></strong>
                                    </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-12 col-lg-4 p-2 d-flex flex-column justify-content-start">
                        <?php if(($plan->trial_days && !$user->plan_trial_ends_at) || ($coupon && $coupon->type)): ?>
                            <div class="card border-0 shadow-sm">
                                <div class="card-header"><div class="font-weight-medium py-1"><?php echo e(__('Order summary')); ?></div></div>
                                <div class="card-body p-0">
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item">
                                            <div class="row">
                                                <div class="col">
                                                    <div><?php echo e(__(':name plan', ['name' => $plan->name])); ?></div>

                                                    <div>
                                                        <div class="small text-muted"><?php echo e(__('Not billed.')); ?></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>

                                <div class="card-footer">
                                    <div class="row">
                                        <div class="col">
                                            <div>
                                                <?php if($plan->trial_days && !$user->plan_trial_ends_at): ?>
                                                    <?php echo e(__('Trial days')); ?>

                                                <?php else: ?>
                                                    <?php echo e(__('Days')); ?>

                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <?php if($plan->trial_days && !$user->plan_trial_ends_at): ?>
                                                <?php echo e($plan->trial_days); ?>

                                            <?php else: ?>
                                                <?php echo e($coupon->days < 0 ? __('Unlimited') : $coupon->days); ?>

                                                <input type="hidden" name="coupon" value="<?php echo e($coupon->code); ?>">
                                                <input type="hidden" name="coupon_set" value="true">
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <input type="hidden" name="interval" value="month">

                            <div class="mt-3">
                                <div class="small text-muted"><?php echo __('By continuing, you agree with the :terms.', ['terms' => mb_strtolower('<a href="'.config('settings.legal_terms_url').'" target="_blank">'. __('Terms of service') .'</a>')]); ?></div>
                            </div>

                            <button type="submit" name="submit" class="btn btn-success btn-block mt-3">
                                <?php echo e(__('Start')); ?>

                            </button>

                            <?php if($plan->trial_days && !$user->plan_trial_ends_at): ?>
                                <button type="submit" name="skip_trial" class="btn btn-secondary btn-block my-3" value="1">
                                    <?php echo e(__('Skip trial')); ?>

                                </button>
                            <?php endif; ?>
                        <?php else: ?>
                            <div class="card border-0 shadow-sm">
                                <div class="card-header"><div class="font-weight-medium py-1"><?php echo e(__('Order summary')); ?></div></div>
                                <div class="card-body">
                                    <div class="btn-group btn-group-toggle d-flex" data-toggle="buttons">
                                        <label class="btn <?php echo e($errors->has('interval') ? 'btn-outline-danger' : 'btn-outline-dark'); ?> w-100<?php echo e(request()->input('interval') == 'month' ? ' active' : ''); ?>" id="plan-month">
                                            <input type="radio" name="interval" value="month" <?php if(request()->input('interval') == 'month'): ?> checked="checked" <?php endif; ?>><?php echo e(__('Monthly')); ?>

                                        </label>
                                        <label class="btn <?php echo e($errors->has('interval') ? 'btn-outline-danger' : 'btn-outline-dark'); ?> w-100<?php echo e(request()->input('interval') == 'year' ? ' active' : ''); ?>" id="plan-year">
                                            <input type="radio" name="interval" value="year" <?php if(request()->input('interval') == 'year'): ?> checked="checked" <?php endif; ?>><?php echo e(__('Yearly')); ?>


                                            <?php if(($plan->amount_month * 12) > $plan->amount_year): ?>
                                                <span class="badge bg-success text-white">-<?php echo e(number_format(((($plan->amount_month * 12) - $plan->amount_year)/($plan->amount_month * 12) * 100), 0)); ?>%</span>
                                            <?php endif; ?>
                                        </label>
                                    </div>
                                    <?php if($errors->has('interval')): ?>
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong><?php echo e($errors->first('interval')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>

                                <div class="card-body p-0">
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item pt-0">
                                            <div class="row">
                                                <div class="col">
                                                    <div><?php echo e(__(':name plan', ['name' => $plan->name])); ?></div>

                                                    <div class="d-none checkout-month">
                                                        <div class="small text-muted">
                                                            <span class="d-none checkout-subscription"><?php echo ($plan->trial_days && !$user->plan_trial_ends_at) ? __('Billed :interval, after trial ends.', ['interval' => mb_strtolower(__('Monthly'))]) :__('Billed :interval.', ['interval' => mb_strtolower(__('Monthly'))]); ?></span>
                                                            <span class="d-none checkout-one-time"><?php echo __('Billed once.'); ?></span>
                                                        </div>
                                                    </div>
                                                    <div class="d-none checkout-year">
                                                        <div class="small text-muted">
                                                            <span class="d-none checkout-subscription"><?php echo ($plan->trial_days && !$user->plan_trial_ends_at) ? __('Billed :interval, after trial ends.', ['interval' => mb_strtolower(__('Yearly'))]) :__('Billed :interval.', ['interval' => mb_strtolower(__('Yearly'))]); ?></span>
                                                            <span class="d-none checkout-one-time"><?php echo __('Billed once.'); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-auto">
                                                    <div class="d-none checkout-month">
                                                        <?php echo e(formatMoney($plan->amount_month, $plan->currency)); ?> <span class="text-muted"><?php echo e($plan->currency); ?></span>
                                                    </div>
                                                    <div class="d-none checkout-year">
                                                        <?php echo e(formatMoney($plan->amount_year, $plan->currency)); ?> <span class="text-muted"><?php echo e($plan->currency); ?></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>

                                        <?php if(!$coupon || $coupon->type == 0): ?>
                                            <?php $__currentLoopData = $taxRates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $taxRate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="list-group-item">
                                                    <div class="row">
                                                        <div class="col">
                                                            <div><?php echo e($taxRate->name); ?> (<?php echo e($taxRate->percentage); ?>% <?php echo e($taxRate->type ? __('excl.') : __('incl.')); ?>)</div>
                                                        </div>
                                                        <div class="col-auto">
                                                            <?php if($taxRate->type): ?>
                                                                <span class="d-none checkout-month">
                                                            <?php echo e(formatMoney(checkoutExclusiveTax($plan->amount_month, $coupon->percentage ?? null, $taxRate->percentage, $inclTaxRatesPercentage), $plan->currency)); ?>

                                                        </span>
                                                                <span class="d-none checkout-year">
                                                            <?php echo e(formatMoney(checkoutExclusiveTax($plan->amount_year, $coupon->percentage ?? null, $taxRate->percentage, $inclTaxRatesPercentage), $plan->currency)); ?>

                                                        </span>
                                                            <?php else: ?>
                                                                <span class="d-none checkout-month">
                                                            <?php echo e(formatMoney(calculateInclusiveTax($plan->amount_month, $coupon->percentage ?? null, $taxRate->percentage, $inclTaxRatesPercentage), $plan->currency)); ?>

                                                        </span>
                                                                <span class="d-none checkout-year">
                                                            <?php echo e(formatMoney(calculateInclusiveTax($plan->amount_year, $coupon->percentage ?? null, $taxRate->percentage, $inclTaxRatesPercentage), $plan->currency)); ?>

                                                        </span>
                                                            <?php endif; ?>

                                                            <span class="text-muted"><?php echo e($plan->currency); ?></span>
                                                        </div>
                                                    </div>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>

                                        <?php if($coupon): ?>
                                            <li class="list-group-item text-success">
                                                <div class="row">
                                                    <div class="col">
                                                        <div><?php echo e(__('Discount')); ?> (<?php echo e($coupon->percentage); ?>%)</div>
                                                    </div>
                                                    <div class="col-auto">
                                                    <span class="d-none checkout-month">
                                                        -<?php echo e(formatMoney(calculateDiscount($plan->amount_month, $coupon->percentage), $plan->currency)); ?>

                                                    </span>
                                                        <span class="d-none checkout-year">
                                                        -<?php echo e(formatMoney(calculateDiscount($plan->amount_year, $coupon->percentage), $plan->currency)); ?>

                                                    </span>
                                                        <span class="text-muted"><?php echo e($plan->currency); ?></span>
                                                    </div>
                                                </div>
                                                <input type="hidden" name="coupon" value="<?php echo e($coupon->code); ?>">
                                                <input type="hidden" name="coupon_set" value="true">
                                            </li>
                                        <?php endif; ?>

                                        <?php if($plan->coupons && !$coupon): ?>
                                            <li class="list-group-item">
                                                <a href="#" id="coupon" class="<?php echo e($errors->has('coupon') || old('coupon') ? 'd-none' : ''); ?>"><?php echo e(__('Have a coupon code?')); ?></a>

                                                <div class="form-row <?php echo e($errors->has('coupon') || old('coupon') ? '' : 'd-none'); ?>" id="coupon-input">
                                                    <div class="col">
                                                        <div class="form-group mb-0">
                                                            <input type="text" name="coupon" id="i-coupon" class="form-control form-control-sm<?php echo e($errors->has('coupon') || old('coupon') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('coupon')); ?>" placeholder="<?php echo e(__('Coupon code')); ?>"<?php echo e($errors->has('coupon') || old('coupon') ? '' : ' disabled'); ?>>
                                                        </div>
                                                    </div>

                                                    <div class="col-auto">
                                                        <a href="#" id="coupon-cancel" class="btn btn-sm btn-secondary"><?php echo e(__('Cancel')); ?></a>
                                                    </div>

                                                    <div class="col-auto">
                                                        <button type="submit" class="btn btn-primary btn-sm"><?php echo e(__('Apply')); ?></button>
                                                    </div>

                                                    <?php if($errors->has('coupon')): ?>
                                                        <div class="col-12">
                                                            <span class="invalid-feedback d-block" role="alert">
                                                                <strong><?php echo e($errors->first('coupon')); ?></strong>
                                                            </span>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>

                                <div class="card-footer font-weight-bold">
                                    <div class="row">
                                        <div class="col">
                                            <span><?php echo e(__('Total')); ?></span>
                                        </div>
                                        <div class="col-auto">
                                            <span class="d-none checkout-month">
                                                <?php echo e(formatMoney(checkoutTotal($plan->amount_month, $coupon->percentage ?? null, $exclTaxRatesPercentage, $inclTaxRatesPercentage), $plan->currency)); ?>

                                            </span>
                                            <span class="d-none checkout-year">
                                                <?php echo e(formatMoney(checkoutTotal($plan->amount_year, $coupon->percentage ?? null, $exclTaxRatesPercentage, $inclTaxRatesPercentage), $plan->currency)); ?>

                                            </span>
                                            <span><?php echo e($plan->currency); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="mt-3">
                                <span class="small text-muted">
                                    <span class="checkout-subscription">
                                        <?php echo __('By continuing, you agree with the :terms and authorize :title to charge your payment method on a recurring basis.', ['terms' => mb_strtolower('<a href="'.config('settings.legal_terms_url').'" target="_blank">'. __('Terms of service') .'</a>'), 'title' => '<strong>'.e(config(('settings.title'))).'</strong>']); ?> <?php echo e(__('You can cancel your subscription at any time.')); ?>

                                    </span>
                                    <span class="checkout-one-time">
                                        <?php echo __('By continuing, you agree with the :terms.', ['terms' => mb_strtolower('<a href="'.config('settings.legal_terms_url').'" target="_blank">'. __('Terms of service') .'</a>')]); ?>

                                    </span>
                                </span>
                            </div>

                            <button type="submit" name="submit" class="btn btn-success btn-block my-3">
                                <span class="d-none checkout-month">
                                    <?php echo e(__('Pay :amount :currency', ['amount' => formatMoney(checkoutTotal($plan->amount_month, $coupon->percentage ?? null, $exclTaxRatesPercentage, $inclTaxRatesPercentage), $plan->currency), 'currency' => e($plan->currency)])); ?>

                                </span>
                                <span class="d-none checkout-year">
                                    <?php echo e(__('Pay :amount :currency', ['amount' => formatMoney(checkoutTotal($plan->amount_year, $coupon->percentage ?? null, $exclTaxRatesPercentage, $inclTaxRatesPercentage), $plan->currency), 'currency' => e($plan->currency)])); ?>

                                </span>
                            </button>
                        <?php endif; ?>

                        <div class="d-block mt-lg-auto">
                            <div class="card border-0 h-100 shadow-sm">
                                <div class="card-body d-flex">
                                    <div class="d-flex position-relative text-primary width-12 height-12 align-items-center justify-content-center flex-shrink-0 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">
                                        <div class="position-absolute bg-primary opacity-10 top-0 right-0 bottom-0 left-0 border-radius-2xl"></div>
                                        <?php echo $__env->make('icons.email', ['class' => 'fill-current width-6 height-6'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                    <div class="d-flex flex-column justify-content-center">
                                        <a href="<?php echo e(route('contact')); ?>" class="text-dark font-weight-medium text-decoration-none stretched-link"><?php echo e(__('Need help?')); ?></a>

                                        <div class="text-muted">
                                            <?php echo e(__('Get in touch with us.')); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.sidebars.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/checkout/index.blade.php ENDPATH**/ ?>