<?php $__env->startSection('site_title', formatTitle([__('Password generator'), __('Tool'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('dashboard'), 'title' => __('Home')],
    ['url' => route('tools'), 'title' => __('Tools')],
    ['title' => __('Tool')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex">
    <h1 class="h2 mb-3 text-break"><?php echo e(__('Password generator')); ?></h1>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-header align-items-center">
        <div class="row">
            <div class="col">
                <div class="font-weight-medium py-1"><?php echo e(__('Password generator')); ?></div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('tools.password_generator')); ?>" method="post" enctype="multipart/form-data" <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('developerTools', ['App\Models\User'])): ?> class="position-absolute left-5 right-5 opacity-20" <?php endif; ?>>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('developerTools', ['App\Models\User'])): ?>
                <div class="position-absolute top-0 right-0 bottom-0 left-0 z-1 more-gradient"></div>
            <?php endif; ?>

            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-length"><?php echo e(__('Length')); ?></label>
                <input type="number" name="length" id="i-length" class="form-control<?php echo e($errors->has('length') ? ' is-invalid' : ''); ?>" value="<?php echo e($length ?? (old('length') ?? '6')); ?>">
                <?php if($errors->has('length')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('length')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <div class="custom-control custom-checkbox">
                    <input type="checkbox" class="custom-control-input<?php echo e($errors->has('lower_case') ? ' is-invalid' : ''); ?>" name="lower_case" id="i-lower-case" value="1" <?php if(old('lower_case') || !isset($lowerCase) || $lowerCase): ?> checked <?php endif; ?>>
                    <label class="custom-control-label" for="i-lower-case"><?php echo e(__('Lower case')); ?></label>
                    <?php if($errors->has('lower_case')): ?>
                        <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($errors->first('lower_case')); ?></strong>
                        </span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="form-group">
                <div class="custom-control custom-checkbox">
                    <input type="checkbox" class="custom-control-input<?php echo e($errors->has('upper_case') ? ' is-invalid' : ''); ?>" name="upper_case" id="i-upper-case" value="1" <?php if(old('upper_case') || !isset($upperCase) || $upperCase): ?> checked <?php endif; ?>>
                    <label class="custom-control-label" for="i-upper-case"><?php echo e(__('Upper case')); ?></label>
                    <?php if($errors->has('upper_case')): ?>
                        <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($errors->first('upper_case')); ?></strong>
                        </span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="form-group">
                <div class="custom-control custom-checkbox">
                    <input type="checkbox" class="custom-control-input<?php echo e($errors->has('digits') ? ' is-invalid' : ''); ?>" name="digits" id="i-digits" value="1" <?php if(old('digits') || !isset($digits) || $digits): ?> checked <?php endif; ?>>
                    <label class="custom-control-label" for="i-digits"><?php echo e(__('Digits')); ?></label>
                    <?php if($errors->has('digits')): ?>
                        <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($errors->first('digits')); ?></strong>
                        </span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="form-group">
                <div class="custom-control custom-checkbox">
                    <input type="checkbox" class="custom-control-input<?php echo e($errors->has('symbols') ? ' is-invalid' : ''); ?>" name="symbols" id="i-symbols" value="1" <?php if(old('symbols') || !isset($symbols) || $symbols): ?> checked <?php endif; ?>>
                    <label class="custom-control-label" for="i-symbols"><?php echo e(__('Symbols')); ?></label>
                    <?php if($errors->has('symbols')): ?>
                        <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($errors->first('symbols')); ?></strong>
                        </span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="row mx-n2">
                <div class="col px-2">
                    <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Generate')); ?></button>
                </div>
                <div class="col-auto px-2">
                    <a href="<?php echo e(route('tools.password_generator')); ?>" class="btn btn-outline-secondary ml-auto"><?php echo e(__('Reset')); ?></a>
                </div>
            </div>
        </form>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('developerTools', ['App\Models\User'])): ?>
            <?php if(paymentProcessors()): ?>
                <?php echo $__env->make('shared.features.locked', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make('shared.features.unavailable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php if(isset($result)): ?>
    <div class="card border-0 shadow-sm mt-3">
        <div class="card-header align-items-center">
            <div class="row">
                <div class="col">
                    <div class="font-weight-medium py-1"><?php echo e(__('Result')); ?></div>
                </div>
            </div>
        </div>
        <div class="card-body mb-n3">
            <div class="form-group">
                <label for="i-result-content"><?php echo e(__('Content')); ?></label>

                <div class="position-relative">
                    <textarea id="i-result-content" class="form-control" onclick="this.select();" readonly><?php echo e($result); ?></textarea>

                    <div class="position-absolute top-0 right-0">
                        <div class="btn btn-sm btn-primary m-2" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-result-content"><?php echo e(__('Copy')); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php echo $__env->make('tools.related', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/tools/tool/password-generator.blade.php ENDPATH**/ ?>