<?php $__env->startSection('menu'); ?>
    <?php
        $menu = [
            route('admin.dashboard') => [
                'icon' => 'grid-view',
                'title' => __('Dashboard')
            ],
            'settings' => [
                'icon' => 'settings',
                'title' => __('Settings'),
                'menu' => [
                    route('admin.settings', 'general') => [
                        'icon' => 'general',
                        'title' => __('General')
                    ],
                    route('admin.settings', 'advanced') => [
                        'icon' => 'tune',
                        'title' => __('Advanced')
                    ],
                    route('admin.settings', 'appearance') => [
                        'icon' => 'design-services',
                        'title' => __('Appearance')
                    ],
                    route('admin.settings', 'email') => [
                        'icon' => 'email',
                        'title' => __('Email')
                    ],
                    route('admin.settings', 'social') => [
                        'icon' => 'share',
                        'title' => __('Social')
                    ],
                    route('admin.settings', 'authentication') => [
                        'icon' => 'assignment-ind',
                        'title' => __('Authentication')
                    ],
                    route('admin.settings', 'announcements') => [
                        'icon' => 'campaign',
                        'title' => __('Announcements')
                    ],
                    route('admin.settings', 'payment-processors') => [
                        'icon' => 'memory',
                        'title' => __('Payment processors')
                    ],
                    route('admin.settings', 'billing-information') => [
                        'icon' => 'featured-play-list',
                        'title' => __('Billing information')
                    ],
                    route('admin.settings', 'legal') => [
                        'icon' => 'assignment',
                        'title' => __('Legal')
                    ],
                    route('admin.settings', 'captcha') => [
                        'icon' => 'pin',
                        'title' => __('Captcha')
                    ],
                    route('admin.settings', 'webhooks') => [
                        'icon' => 'webhook',
                        'title' => __('Webhooks')
                    ],
                    route('admin.settings', 'cronjob') => [
                        'icon' => 'schedule',
                        'title' => __('Cron job')
                    ],
                    route('admin.settings', 'ads') => [
                        'icon' => 'featured-video',
                        'title' => __('Ads')
                    ],
                    route('admin.settings', 'license') => [
                        'icon' => 'vpn-key',
                        'title' => __('License')
                    ],
                ]
            ],
            route('admin.users') => [
                'icon' => 'people-alt',
                'title' => __('Users')
            ],
            route('admin.pages') => [
                'icon' => 'menu-book',
                'title' => __('Pages')
            ],
            route('admin.payments') => [
                'icon' => 'credit-card',
                'title' => __('Payments')
            ],
            route('admin.plans') => [
                'icon' => 'package',
                'title' => __('Plans')
            ],
            route('admin.coupons') => [
                'icon' => 'confirmation-number',
                'title' => __('Coupons')
            ],
            route('admin.tax_rates') => [
                'icon' => 'price-change',
                'title' => __('Tax rates')
            ],
            route('admin.reports') => [
                'icon' => 'list-alt',
                'title' => __('Reports')
            ]
        ];
    ?>

    <div class="nav d-block text-truncate">
        <?php $__currentLoopData = $menu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li class="nav-item">
                <a class="nav-link d-flex px-4 <?php if(str_starts_with(request()->url(), $key) && !isset($value['menu'])): ?> active <?php endif; ?>" <?php if(isset($value['menu'])): ?> data-toggle="collapse" href="#sub-menu-<?php echo e($key); ?>" role="button" <?php if(array_filter(array_keys($value['menu']), function ($url) { return str_starts_with(request()->url(), $url); })): ?> aria-expanded="true" <?php else: ?> aria-expanded="false" <?php endif; ?> aria-controls="collapse-<?php echo e($key); ?>" <?php else: ?> href="<?php echo e($key); ?>" <?php endif; ?>>
                    <span class="sidebar-icon d-flex align-items-center"><?php echo $__env->make('icons.' . $value['icon'], ['class' => 'fill-current width-4 height-4 '.(__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                    <span class="flex-grow-1 text-truncate"><?php echo e($value['title']); ?></span>
                    <?php if(isset($value['menu'])): ?> <span class="d-flex align-items-center ml-auto sidebar-expand"><?php echo $__env->make('icons.expand-more', ['class' => 'fill-current text-muted width-3 height-3'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span> <?php endif; ?>
                </a>
            </li>

            <?php if(isset($value['menu'])): ?>
                <div class="collapse sub-menu <?php if(array_filter(array_keys($menu[$key]['menu']), function ($url) { return str_starts_with(request()->url(), $url); })): ?> show <?php endif; ?>" id="sub-menu-<?php echo e($key); ?>">
                    <?php $__currentLoopData = $value['menu']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subKey => $subValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e($subKey); ?>" class="nav-link px-4 d-flex text-truncate <?php if(str_starts_with(request()->url(), $subKey)): ?> active <?php endif; ?>">
                            <span class="sidebar-icon d-flex align-items-center"><?php echo $__env->make('icons.' . $subValue['icon'], ['class' => 'fill-current width-4 height-4 '.(__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                            <span class="flex-grow-1 text-truncate"><?php echo e($subValue['title']); ?></span>
                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php $__env->stopSection(); ?>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/admin/sidebar.blade.php ENDPATH**/ ?>