

<?php $__env->startSection('site_title', formatTitle(request()->input('project') ? [e(request()->input('project')), __('Reports'), config('settings.title')] : [__('Reports'), config('settings.title')])); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-base-1 flex-fill">
    <div class="container py-3 my-3">
        <div class="row">
            <div class="col-12">
                <?php if(config('settings.ad_reports_top')): ?>
                    <div class="d-print-none mb-1"><?php echo config('settings.ad_reports_top'); ?></div>
                <?php endif; ?>

                <?php if(request()->input('project')): ?>
                    <?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
                        ['url' => route('dashboard'), 'title' => __('Home')],
                        ['url' => route('reports'), 'title' => __('Reports')],
                        ['title' => __('Project')],
                    ]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php else: ?>
                    <?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
                        ['url' => route('dashboard'), 'title' => __('Home')],
                        ['title' => __('Reports')],
                    ]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <div class="d-flex align-items-end">
                    <h1 class="h2 mb-0 flex-grow-1 text-truncate"><?php echo e(request()->input('project') ? request()->input('project') : __('Reports')); ?></h1>

                    <div class="d-flex align-items-center flex-grow-0 d-print-none">
                        <div class="form-row flex-nowrap">
                            <div class="col">
                                <?php if(request()->input('project')): ?>
                                    <?php echo $__env->make('projects.partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <?php echo $__env->make('reports.new', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="card border-0 shadow-sm mt-3">
                    <div class="card-header align-items-center">
                        <div class="row">
                            <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Reports')); ?></div></div>
                            <div class="col-auto">
                                <div class="form-row">
                                    <div class="col">
                                        <form method="GET" action="<?php echo e(route('reports')); ?>" class="d-md-flex">
                                            <div class="input-group input-group-sm">
                                                <input class="form-control" name="search" placeholder="<?php echo e(__('Search')); ?>" value="<?php echo e(app('request')->input('search')); ?>">
                                                <div class="input-group-append">
                                                    <button type="button" class="btn btn-outline-primary d-flex align-items-center dropdown-toggle dropdown-toggle-split reset-after" data-tooltip="true" title="<?php echo e(__('Filters')); ?>" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><?php echo $__env->make('icons.filter', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;</button>
                                                    <div class="dropdown-menu <?php echo e((__('lang_dir') == 'rtl' ? 'dropdown-menu' : 'dropdown-menu-right')); ?> border-0 shadow width-64 p-0" id="search-filters">
                                                        <div class="dropdown-header py-3">
                                                            <div class="row">
                                                                <div class="col"><div class="font-weight-medium m-0 text-body"><?php echo e(__('Filters')); ?></div></div>
                                                                <div class="col-auto">
                                                                    <?php if(request()->input('per_page')): ?>
                                                                        <a href="<?php echo e(route('reports')); ?>" class="text-secondary"><?php echo e(__('Reset')); ?></a>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="dropdown-divider my-0"></div>

                                                        <div class="max-height-96 overflow-auto pt-3">
                                                            <div class="form-group px-4">
                                                                <label for="i-search-by" class="small"><?php echo e(__('Search by')); ?></label>
                                                                <select name="search_by" id="i-search-by" class="custom-select custom-select-sm">
                                                                    <?php $__currentLoopData = ['url' => __('URL')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($key); ?>" <?php if(request()->input('search_by') == $key || !request()->input('search_by') && $key == 'name'): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group px-4">
                                                                <label for="i-project" class="small"><?php echo e(__('Project')); ?></label>
                                                                <select name="project" id="i-project" class="custom-select custom-select-sm">
                                                                    <option value=""><?php echo e(__('All')); ?></option>
                                                                    <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($project->project); ?>" <?php if(request()->input('project') == $project->project && request()->input('project') !== null): ?> selected <?php endif; ?>><?php echo e($project->project); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group px-4">
                                                                <label for="i-result" class="small"><?php echo e(__('Result')); ?></label>
                                                                <select name="result" id="i-result" class="custom-select custom-select-sm">
                                                                    <option value=""><?php echo e(__('All')); ?></option>
                                                                    <?php $__currentLoopData = ['good' => __('Good'), 'decent' => __('Decent'), 'bad' => __('Bad')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($key); ?>" <?php if(request()->input('result') == $key && request()->input('result') !== null): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group px-4">
                                                                <label for="i-sort-by" class="small"><?php echo e(__('Sort by')); ?></label>
                                                                <select name="sort_by" id="i-sort-by" class="custom-select custom-select-sm">
                                                                    <?php $__currentLoopData = ['id' => __('Date created'), 'generated_at' => __('Date generated'), 'url' => __('URL'), 'result' => __('Result')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($key); ?>" <?php if(request()->input('sort_by') == $key): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group px-4">
                                                                <label for="i-sort" class="small"><?php echo e(__('Sort')); ?></label>
                                                                <select name="sort" id="i-sort" class="custom-select custom-select-sm">
                                                                    <?php $__currentLoopData = ['desc' => __('Descending'), 'asc' => __('Ascending')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($key); ?>" <?php if(request()->input('sort') == $key): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group px-4">
                                                                <label for="i-per-page" class="small"><?php echo e(__('Results per page')); ?></label>
                                                                <select name="per_page" id="i-per-page" class="custom-select custom-select-sm">
                                                                    <?php $__currentLoopData = [10, 25, 50, 100]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($value); ?>" <?php if(request()->input('per_page') == $value || request()->input('per_page') == null && $value == config('settings.paginate')): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>
                                                        </div>

                                                        <div class="dropdown-divider my-0"></div>

                                                        <div class="px-4 py-3">
                                                            <button type="submit" class="btn btn-primary btn-sm btn-block"><?php echo e(__('Search')); ?></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="col-auto">
                                        <button type="button" class="btn btn-sm btn-outline-primary d-flex align-items-center" data-toggle="modal" data-target="#export-modal" data-tooltip="true" title="<?php echo e(__('Export')); ?>"><?php echo $__env->make('icons.export', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">
                        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <?php if(count($reports) == 0): ?>
                            <?php echo e(__('No results found.')); ?>

                        <?php else: ?>
                            <div class="list-group list-group-flush my-n3">
                                <div class="list-group-item px-0 text-muted">
                                    <div class="row align-items-center">
                                        <div class="col">
                                            <div class="row align-items-center">
                                                <div class="col-12 col-md-8 col-lg-5 d-block text-truncate">
                                                    <?php echo e(__('URL')); ?>

                                                </div>

                                                <div class="col-md-4 col-lg-5 d-none d-md-block text-truncate">
                                                    <?php echo e(__('Result')); ?>

                                                </div>

                                                <div class="col-lg-2 d-none d-lg-block text-truncate">
                                                    <?php echo e(__('Generated at')); ?>

                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <div class="form-row">
                                                <div class="col">
                                                    <div class="invisible btn d-flex align-items-center btn-sm text-primary"><?php echo $__env->make('icons.more-horiz', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="list-group-item px-0">
                                        <div class="row align-items-center">
                                            <div class="col text-truncate">
                                                <div class="row">
                                                    <div class="col-12 col-md-8 col-lg-5 d-flex">
                                                        <div class="d-flex align-items-center text-truncate">
                                                            <img src="https://icons.duckduckgo.com/ip3/<?php echo e(parse_url($report->fullUrl, PHP_URL_HOST)); ?>.ico" rel="noreferrer" class="width-4 height-4 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">

                                                            <div class="text-truncate" data-tooltip="true" title="<?php echo e($report->url); ?>"><a href="<?php echo e(route('reports.show', $report->id)); ?>" dir="ltr"><?php echo e($report->url); ?></a></div>

                                                            <?php if($report->result > 79): ?>
                                                                <div class="d-md-none badge badge-success <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e(__('Good')); ?></div>
                                                            <?php elseif($report->result > 49): ?>
                                                                <div class="d-md-none badge badge-warning <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e(__('Decent')); ?></div>
                                                            <?php else: ?>
                                                                <div class="d-md-none badge badge-danger <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e(__('Bad')); ?></div>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>

                                                    <div class="d-none d-md-flex col-12 col-md-4 col-lg-5">
                                                        <div class="row no-gutters w-100 align-items-center">
                                                            <div class="col-6 d-none d-lg-flex">
                                                                <div class="progress height-1.25 w-100">
                                                                    <div class="progress-bar rounded <?php echo e(($report->result > 79 ? 'bg-success' : ($report->result > 49 ? 'bg-warning' : 'bg-danger'))); ?>" role="progressbar" style="width: <?php echo e(number_format($report->result)); ?>%" aria-valuenow="<?php echo e(number_format($report->result)); ?>" aria-valuemin="0" aria-valuemax="100"></div>
                                                                </div>
                                                            </div>
                                                            <div class="col-3 d-none d-lg-flex small text-center px-2">
                                                                <span class="font-weight-bold"><?php echo e(number_format($report->result)); ?></span><span class="text-muted">/100</span>
                                                            </div>
                                                            <div class="col-12 col-lg-3 d-none d-md-flex align-items-center">
                                                                <?php echo $__env->make('reports.partials.badge', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="d-none d-lg-flex col-lg-2">
                                                        <div class="text-truncate" data-tooltip="true" title="<?php echo e($report->generated_at->tz(Auth::user()->timezone ?? config('app.timezone'))->format(__('Y-m-d') . ' H:i:s')); ?>"><?php echo e($report->generated_at->diffForHumans()); ?></div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-auto d-flex">
                                                <div class="form-row">
                                                    <div class="col">
                                                        <?php echo $__env->make('reports.partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <div class="mt-3 align-items-center">
                                    <div class="row">
                                        <div class="col">
                                            <div class="mt-2 mb-3"><?php echo e(__('Showing :from-:to of :total', ['from' => $reports->firstItem(), 'to' => $reports->lastItem(), 'total' => $reports->total()])); ?>

                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <?php echo e($reports->onEachSide(1)->links()); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <?php if(config('settings.ad_reports_bottom')): ?>
            <div class="d-print-none mt-3"><?php echo config('settings.ad_reports_bottom'); ?></div>
        <?php endif; ?>
    </div>
</div>

<div class="modal fade" id="export-modal" tabindex="-1" role="dialog" aria-labelledby="export-modal-label" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content border-0 shadow">
            <div class="modal-header">
                <h6 class="modal-title" id="export-modal-label"><?php echo e(__('Export')); ?></h6>
                <button type="button" class="close d-flex align-items-center justify-content-center width-12 height-14" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true" class="d-flex align-items-center"><?php echo $__env->make('icons.close', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                </button>
            </div>
            <div class="modal-body">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dataExport', ['App\Models\User'])): ?>
                    <?php echo e(__('Are you sure you want to export this table?')); ?>

                <?php else: ?>
                    <?php if(paymentProcessors()): ?>
                        <?php echo $__env->make('shared.features.locked', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <?php echo $__env->make('shared.features.unavailable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dataExport', ['App\Models\User'])): ?>
                    <a href="<?php echo e(route('reports.export', Request::query())); ?>" target="_self" class="btn btn-primary" id="exportButton"><?php echo e(__('Export')); ?></a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<script>
    'use strict';

    window.addEventListener('DOMContentLoaded', function () {
        jQuery('#exportButton').on('click', function () {
            jQuery('#export-modal').modal('hide');
        });
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('shared.sidebars.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/reports/list.blade.php ENDPATH**/ ?>