<?php $__env->startSection('site_title', formatTitle([__('Cron job'), __('Settings'), config('settings.title')])); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('admin.dashboard'), 'title' => __('Admin')],
    ['title' => __('Settings')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<h1 class="h2 mb-3 d-inline-block"><?php echo e(__('Cron job')); ?></h1>

<div class="card border-0 shadow-sm">
    <div class="card-header align-items-center">
        <div class="row">
            <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Cron job')); ?></div></div>
        </div>
    </div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="form-group">
            <label for="i-cronjob"><?php echo e(__('Command')); ?></label>
            <div class="input-group">
                <div class="input-group-prepend">
                    <code class="input-group-text">* * * * *</code>
                </div>
                <input type="text" dir="ltr" name="cronjob" id="i-cronjob" class="form-control" value="wget -q -O /dev/null <?php echo e(route('cronjob', ['key' => config('settings.cronjob_key')])); ?>" readonly>
                <div class="input-group-append">
                    <button type="button" class="btn btn-primary" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-cronjob"><?php echo e(__('Copy')); ?></button>
                </div>
            </div>
            <small class="form-text text-muted">
                <?php echo e(__('The cron job command must be set to run every minute.')); ?> <?php if(config('settings.cronjob_executed_at')): ?> <?php echo e(__('Last executed at: :date.', ['date' => Carbon\Carbon::createFromTimestamp(config('settings.cronjob_executed_at'))->tz(Auth::user()->timezone ?? config('app.timezone'))->format(__('Y-m-d') . ' H:i:s')])); ?> <?php endif; ?>
            </small>
        </div>

        <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#modal" data-button-name="cronjob_key" data-action="<?php echo e(route('admin.settings', 'cronjob')); ?>" data-button="btn btn-danger" data-title="<?php echo e(__('Regenerate')); ?>" data-text="<?php echo e(__('If you regenerate the cron job key, you will need to update the cron job task with the new command.')); ?>"><?php echo e(__('Regenerate')); ?></button>
    </div>
</div>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/admin/settings/cronjob.blade.php ENDPATH**/ ?>