

<?php $__env->startSection('site_title', formatTitle([__('Projects'), config('settings.title')])); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-base-1 flex-fill">
    <div class="container py-3 my-3">
        <div class="row">
            <div class="col-12">
                <?php if(config('settings.ad_projects_top')): ?>
                    <div class="d-print-none mb-1"><?php echo config('settings.ad_projects_top'); ?></div>
                <?php endif; ?>

                <?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
                    ['url' => route('dashboard'), 'title' => __('Home')],
                    ['title' => __('Projects')],
                ]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="d-flex align-items-end">
                    <h1 class="h2 mb-0 flex-grow-1 text-truncate"><?php echo e(__('Projects')); ?></h1>
                </div>

                <div class="card border-0 shadow-sm mt-3">
                    <div class="card-header align-items-center">
                        <div class="row">
                            <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Projects')); ?></div></div>
                            <div class="col-auto">
                                <div class="form-row">
                                    <div class="col">
                                        <form method="GET" action="<?php echo e(route('projects')); ?>" class="d-md-flex">
                                            <div class="input-group input-group-sm">
                                                <input class="form-control" name="search" placeholder="<?php echo e(__('Search')); ?>" value="<?php echo e(app('request')->input('search')); ?>">
                                                <div class="input-group-append">
                                                    <button type="button" class="btn btn-outline-primary d-flex align-items-center dropdown-toggle dropdown-toggle-split reset-after" data-tooltip="true" title="<?php echo e(__('Filters')); ?>" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><?php echo $__env->make('icons.filter', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;</button>
                                                    <div class="dropdown-menu <?php echo e((__('lang_dir') == 'rtl' ? 'dropdown-menu' : 'dropdown-menu-right')); ?> border-0 shadow width-64 p-0" id="search-filters">
                                                        <div class="dropdown-header py-3">
                                                            <div class="row">
                                                                <div class="col"><div class="font-weight-medium m-0 text-body"><?php echo e(__('Filters')); ?></div></div>
                                                                <div class="col-auto">
                                                                    <?php if(request()->input('per_page')): ?>
                                                                        <a href="<?php echo e(route('reports')); ?>" class="text-secondary"><?php echo e(__('Reset')); ?></a>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="dropdown-divider my-0"></div>

                                                        <div class="max-height-96 overflow-auto pt-3">
                                                            <div class="form-group px-4">
                                                                <label for="i-search-by" class="small"><?php echo e(__('Search by')); ?></label>
                                                                <select name="search_by" id="i-search-by" class="custom-select custom-select-sm">
                                                                    <?php $__currentLoopData = ['project' => __('Name')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($key); ?>" <?php if(request()->input('search_by') == $key || !request()->input('search_by') && $key == 'name'): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group px-4">
                                                                <label for="i-sort-by" class="small"><?php echo e(__('Sort by')); ?></label>
                                                                <select name="sort_by" id="i-sort-by" class="custom-select custom-select-sm">
                                                                    <?php $__currentLoopData = ['created_at' => __('Date created'), 'project' => __('Name')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($key); ?>" <?php if(request()->input('sort_by') == $key): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group px-4">
                                                                <label for="i-sort" class="small"><?php echo e(__('Sort')); ?></label>
                                                                <select name="sort" id="i-sort" class="custom-select custom-select-sm">
                                                                    <?php $__currentLoopData = ['desc' => __('Descending'), 'asc' => __('Ascending')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($key); ?>" <?php if(request()->input('sort') == $key): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="form-group px-4">
                                                                <label for="i-per-page" class="small"><?php echo e(__('Results per page')); ?></label>
                                                                <select name="per_page" id="i-per-page" class="custom-select custom-select-sm">
                                                                    <?php $__currentLoopData = [10, 25, 50, 100]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($value); ?>" <?php if(request()->input('per_page') == $value || request()->input('per_page') == null && $value == config('settings.paginate')): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>
                                                        </div>

                                                        <div class="dropdown-divider my-0"></div>

                                                        <div class="px-4 py-3">
                                                            <button type="submit" class="btn btn-primary btn-sm btn-block"><?php echo e(__('Search')); ?></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="col-auto">
                                        <button type="button" class="btn btn-sm btn-outline-primary d-flex align-items-center" data-toggle="modal" data-target="#export-modal" data-tooltip="true" title="<?php echo e(__('Export')); ?>"><?php echo $__env->make('icons.export', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">
                        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <?php if(count($projects) == 0): ?>
                            <?php echo e(__('No results found.')); ?>

                        <?php else: ?>
                            <div class="list-group list-group-flush my-n3">
                                <div class="list-group-item px-0 text-muted">
                                    <div class="row align-items-center">
                                        <div class="col">
                                            <div class="row align-items-center">
                                                <div class="col-12 col-md-8 col-lg-6 d-block text-truncate">
                                                    <?php echo e(__('Name')); ?>

                                                </div>

                                                <div class="col-md-4 col-lg-2 d-none d-md-block text-truncate">
                                                    <?php echo e(__('Result')); ?>

                                                </div>

                                                <div class="col-lg-2 d-none d-lg-block text-truncate">
                                                    <?php echo e(__('Reports')); ?>

                                                </div>

                                                <div class="col-lg-2 d-none d-lg-block text-truncate">
                                                    <?php echo e(__('Created at')); ?>

                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <div class="form-row">
                                                <div class="col">
                                                    <div class="invisible btn d-flex align-items-center btn-sm text-primary"><?php echo $__env->make('icons.more-horiz', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="list-group-item px-0">
                                        <div class="row align-items-center">
                                            <div class="col text-truncate">
                                                <div class="row">
                                                    <div class="col-12 col-md-8 col-lg-6 d-flex">
                                                        <div class="d-flex align-items-center text-truncate">
                                                            <img src="https://icons.duckduckgo.com/ip3/<?php echo e($project->project); ?>.ico" rel="noreferrer" class="width-4 height-4 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">

                                                            <a href="<?php echo e(route('reports', ['project' => $project->project])); ?>" dir="ltr" class="text-truncate"><?php echo e($project->project); ?></a>
                                                        </div>
                                                    </div>

                                                    <div class="d-none d-md-flex align-items-center col-md-4 col-lg-2 text-truncate">
                                                        <a href="<?php echo e(route('reports', ['project' => $project->project])); ?>" class="badge <?php echo e((($project->result / $project->reports) > 79 ? 'badge-success' : (($project->result / $project->reports) > 49 ? 'badge-warning' : 'badge-danger'))); ?> text-truncate"><?php echo e((($project->result / $project->reports) > 79 ? __('Good') : (($project->result / $project->reports) > 49 ? __('Decent') : __('Bad')))); ?></a>
                                                    </div>

                                                    <div class="col-lg-2 d-none d-lg-block text-truncate">
                                                        <a href="<?php echo e(route('reports', ['project' => $project->project])); ?>" class="text-dark text-truncate"><?php echo e(number_format($project->reports, 0, __('.'), __(','))); ?></a>
                                                    </div>

                                                    <div class="d-none d-lg-flex col-lg-2">
                                                        <div class="text-truncate" data-tooltip="true" title="<?php echo e($project->created_at->tz(Auth::user()->timezone ?? config('app.timezone'))->format(__('Y-m-d') . ' H:i:s')); ?>"><?php echo e($project->created_at->diffForHumans()); ?></div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-auto d-flex">
                                                <div class="form-row">
                                                    <div class="col">
                                                        <?php echo $__env->make('projects.partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <div class="mt-3 align-items-center">
                                    <div class="row">
                                        <div class="col">
                                            <div class="mt-2 mb-3"><?php echo e(__('Showing :from-:to of :total', ['from' => $projects->firstItem(), 'to' => $projects->lastItem(), 'total' => $projects->total()])); ?>

                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <?php echo e($projects->onEachSide(1)->links()); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <?php if(config('settings.ad_projects_bottom')): ?>
            <div class="d-print-none mt-3"><?php echo config('settings.ad_projects_bottom'); ?></div>
        <?php endif; ?>
    </div>
</div>

<div class="modal fade" id="export-modal" tabindex="-1" role="dialog" aria-labelledby="export-modal-label" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content border-0 shadow">
            <div class="modal-header">
                <h6 class="modal-title" id="export-modal-label"><?php echo e(__('Export')); ?></h6>
                <button type="button" class="close d-flex align-items-center justify-content-center width-12 height-14" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true" class="d-flex align-items-center"><?php echo $__env->make('icons.close', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                </button>
            </div>
            <div class="modal-body">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dataExport', ['App\Models\User'])): ?>
                    <?php echo e(__('Are you sure you want to export this table?')); ?>

                <?php else: ?>
                    <?php if(paymentProcessors()): ?>
                        <?php echo $__env->make('shared.features.locked', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <?php echo $__env->make('shared.features.unavailable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dataExport', ['App\Models\User'])): ?>
                    <a href="<?php echo e(route('projects.export', Request::query())); ?>" target="_self" class="btn btn-primary" id="exportButton"><?php echo e(__('Export')); ?></a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<script>
    'use strict';

    window.addEventListener('DOMContentLoaded', function () {
        jQuery('#exportButton').on('click', function () {
            jQuery('#export-modal').modal('hide');
        });
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('shared.sidebars.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/projects/list.blade.php ENDPATH**/ ?>